/*
 * IPRPC - Inter Process Remote Procedure Call
 *
 * Copyright (C) 2012-2013 by Hiroyuki KAJIURA. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 *     1:Redistributions of source code must retain the above copyright notice, 
 *       this list of conditions and the following disclaimer.
 *     2:Redistributions in binary form must reproduce the above copyright notice, 
 *       this list of conditions and the following disclaimer in the documentation 
 *       and/or other materials provided with the distribution.
 *     3:Neither the name of copyright owner nor the names of its contributors 
 *       may be used to endorse or promote products derived from this software 
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef IPCLIB_H_
#define IPCLIB_H_

#ifdef	IPC_LIB_MAIN
#define	extern
#endif	/* IPC_LIB_MAIN */

#include	"ipcConf.h"
#include	"ipcType.h"
#include	"ipcSyscall.h"
#include	"ipcShm.h"

typedef struct {
	void *entry;
	RpcBool_t usedFlag;
} RpcHashEntry_t;

typedef struct {
#ifndef	USE_SEMAPHORE
	RpcMutexID_t mutexId;
	RpcMutexAttribute_t mutexAttr;
	RpcCondID_t condId;
	RpcCondAttribute_t condAttr;
#else	/* USE_SEMAPHORE */
	RpcSem_t semId;
#endif	/* USE_SEMAPHORE */
} RpcTaskControl_t;

typedef RpcBool_t (*RPC_CompareHashVal_t)(void *entry, uint8_t *val, uint32_t valSize);
typedef void* (*RPC_AllocFunc_t)(uint32_t allocId,uint32_t size);
typedef void (*RPC_FreeFunc_t)(uint32_t allocId,void *area);
typedef RpcBool_t (*RPC_CompareFunc)(RpcList_t *list,uint32_t id);
typedef RpcBool_t (*RPC_compareFuncByIds)(RpcList_t *list,uint32_t id1,uint32_t id2);

extern RpcResult_t RPC_CreateTaskControl(RpcBool_t IpcFlag,RpcTaskControl_t *tskCntl);
extern void RPC_DestroyTaskControl(RpcTaskControl_t *tskCntl);
extern RpcResult_t RPC_TaskControlWait(RpcTaskControl_t *taskCntl);
extern RpcResult_t RPC_TaskControlTimedWait(RpcTaskControl_t *tskCntl, struct timespec *specTime);
extern RpcResult_t RPC_TaskControlSignal(RpcTaskControl_t *tskCntl);
extern void IPC_ResetTaskControl(RpcTaskControl_t *tskCntl);

extern void RPC_RegisterHashTable(uint32_t *hashRandTable);

extern RpcResult_t RPC_AddHashEntry(RpcHashEntry_t *hashTblTop,void *entry,uint8_t *val, uint32_t valSize,uint32_t tblSize);
extern RpcResult_t RPC_DeleteHashEntry(RpcHashEntry_t *hashTblTop,uint8_t *val, uint32_t valSize,uint32_t tblSize,RPC_CompareHashVal_t compareHashVal);
extern void *RPC_SearchEntryByHash(RpcHashEntry_t *hashTblTop, uint8_t *val, uint32_t valSize, uint32_t tlbSize, RPC_CompareHashVal_t compareHashVal);

extern void *RPC_AllocListData(RpcList_t **listTop,uint32_t entitySize,uint32_t allocId,RPC_AllocFunc_t allocFunc,RPC_FreeFunc_t freeFunc);
extern void RPC_FreeListData(RpcList_t **listTop,void *delEntry,uint32_t allocId,RPC_FreeFunc_t freeFunc);
extern RpcList_t *RPC_RemoveListEntry(RpcList_t **listTop,void *remEntry);
extern void RPC_SearchAndFreeListData(RpcList_t **ListTop,uint32_t id,uint32_t allocId,RPC_CompareFunc compareFunc,RPC_FreeFunc_t freeFunc);
extern void *RPC_ShmAllocMemWrapper(uint32_t allocId,uint32_t size);
extern void RPC_ShmFreeMemWrapper(uint32_t allocId,void *area);
extern void *RPC_LclAllocMemWrapper(uint32_t allocId,uint32_t size);
extern void RPC_LclFreeMemWrapper(uint32_t allocId,void *area);
extern void *RPC_SearchListEntryById(RpcList_t *listTop, uint32_t id, RPC_CompareFunc compareFunc);
extern void *RPC_SearchListEntryByIds(RpcList_t *listTop,uint32_t id1,uint32_t id2,RPC_compareFuncByIds compareFunc);
extern uint32_t RPC_CountNumOfListEntry(RpcList_t *listTop);

extern RpcBool_t RPC_SetTimeout(uint32_t timeout, struct timeval *absTime);
extern RpcBool_t RPC_CheckTimeout(struct timeval *timeout);
extern RpcBool_t RPC_GetRestTimeout(struct timeval *absTime,uint32_t *restTimeout);
extern void RPC_ConvertTime(struct timeval *timeVal,struct timespec *timeSpec);
extern void RPC_ConvertTimeoutToTimeval(uint32_t timeout,struct timeval *tiemVal);
extern void RPC_ConvertTimevalToTimeout(struct timeval *timeVal,uint32_t *timeout);

#endif /* IPCLIB_H_ */
