<?php class DBException extends Exception { private $msgLabel; public function __construct($dbmessage,$msgLabel,$code) { parent::__construct($dbmessage,$code); $this->msgLabel=$msgLabel; } public function msgLabel() { return $this->msgLabel; } } class DBConnection extends mysqli { private $DBConfWritable; private $DBConfReadonly; private $CHARSET; private $mysqli; private $cur_conf_type; private $connected; private $locking; private $autolockforupdate; public $last_sql; public function __construct($DBConfWritable,$DBConfReadonly=array(),$charset='UTF8') { $this->DBConfWritable=$DBConfWritable; $this->DBConfReadonly=$DBConfReadonly; $this->CHARSET=$charset; $this->mysqli=mysqli_init(); $this->cur_conf_type=false; $this->connected=false; $this->locking=false; $this->autolockforupdate=false; $this->last_sql=null; } public function connect($readonly=false) { if ($this->connected) { if ($readonly && $this->cur_conf_type=='R') return; if (!$readonly && $this->cur_conf_type=='W') return; $this->mysqli->close(); $this->mysqli=mysqli_init(); $this->connected=false; } $conf=false; if ($readonly) { if (is_array($this->DBConfReadonly) && sizeof($this->DBConfReadonly)>0) { $conf=$this->DBConfReadonly[rand(0,sizeof($this->DBConfReadonly)-1)%sizeof($this->DBConfReadonly)]; $this->cur_conf_type='R'; } } if (!$conf) { if (is_array($this->DBConfWritable) && sizeof($this->DBConfWritable)>0) { $conf=$this->DBConfWritable[rand(0,sizeof($this->DBConfWritable)-1)%sizeof($this->DBConfWritable)]; $this->cur_conf_type='W'; } } if (!$conf) throw new DBException("No configuration found!","error.db.connectfail",null); if (!$this->mysqli->real_connect($conf['DBHost'],$conf['DBUser'],$conf['DBPass'],$conf['DBName'],$conf['DBPort'])) throw new DBException(mysqli_connect_error(),"error.db.connectfail",mysqli_connect_errno()); $this->mysqli->set_charset($this->CHARSET); $this->connected=true; } public function connected() { return $this->connected; } public function escape($str,$insert_quotes=false) { if (is_array($str)) { $es=""; foreach ($str as $s) { if ($es) $es.=","; if ($insert_quotes) $es.="'".$this->mysqli->escape_string($s)."'"; else $es.=$this->mysqli->escape_string($s); } return $es; } else if ($insert_quotes) return "'".$this->mysqli->escape_string($str)."'"; else return $this->mysqli->escape_string($str); } public function query($sql,$error_label) { if ($this->locking && substr($sql,0,7)=='SELECT ') { if (stripos($sql,'LOCK IN SHARE MODE')===false && stripos($sql,'FOR UPDATE')===false) if ($this->autolockforupdate) $sql.=' FOR UPDATE'; else $sql.=' LOCK IN SHARE MODE'; } $this->last_sql=$sql; $result=$this->mysqli->query($sql); if (!$result) throw new DBException($this->mysqli->error,$error_label,$this->mysqli->errno); return $result; } public function real_query($sql,$error_label) { $this->last_sql=$sql; if ($this->cur_conf_type!='W') throw new DBException("Write to non-writable connection!","error.db.connectfail",null); $result=$this->mysqli->real_query($sql); if (!$result) throw new DBException($this->mysqli->error,$error_label,$this->mysqli->errno); return $result; } public function multi_query($sql,$error_label) { $this->last_sql=$sql; $result=$this->mysqli->multi_query($sql); if (!$result) throw new DBException($this->mysqli->error,$error_label,$this->mysqli->errno); return $result; } public function query_allrows_assoc($sql,$error_label="error.db.queryfail") { $this->last_sql=$sql; $result=$this->query($sql,$error_label); $rows=array(); while ($assoc=$result->fetch_assoc()) array_push($rows,$assoc); $result->free(); return $rows; } public function query_row_assoc($sql,$error_label="error.db.queryfail") { $this->last_sql=$sql; $result=$this->query($sql,$error_label); $assoc=$result->fetch_assoc(); $result->free(); return (array)$assoc; } public function query_value($sql,$error_label="error.db.queryfail") { $this->last_sql=$sql; $result=$this->query($sql,$error_label); $row=$result->fetch_row(); $result->free(); return @$row[0]; } public function query_value_array($sql,$error_label="error.db.queryfail") { $this->last_sql=$sql; $result=$this->query($sql,$error_label); $values=array(); while ($row=$result->fetch_row()) array_push($values,$row[0]); $result->free(); return $values; } public function begin($autolockforupdate=false) { $this->locking=true; $this->autolockforupdate=$autolockforupdate; if (!$this->mysqli->autocommit(false)) throw new DBException($this->mysqli->error,"error.db.beginfail",$dberr); } public function commit() { if (!$this->mysqli->commit()) throw new DBException($this->mysqli->error,"error.db.commitfail",$this->mysqli->errno); $this->locking=false; } public function rollback() { if (!$this->mysqli->rollback()) throw new DBException($this->mysqli->error,"error.db.rollbackfail",$this->mysqli->errno); $this->locking=false; } public function affected_rows() { return $this->mysqli->affected_rows; } public function num_rows() { return $this->mysqli->num_rows; } public function errno() { return $this->mysqli->errno; } public function error() { return $this->mysqli->error; } public function insert_id() { return $this->mysqli->insert_id; } public function store_result() { return $this->mysqli->store_result(); } public function next_result() { return $this->mysqli->next_result(); } public function free_result($result) { return $this->mysqli->free_result($result); } } function db_init_connection($Config) { global $Config; $dbconn=new DBConnection($Config->DBConfWritable,$Config->DBConfReadonly); return $dbconn; } function db_init_log_connection($Config) { global $Config; $dbconn=new DBConnection($Config->LogDBConfWritable,$Config->LogDBConfReadonly); return $dbconn; } function db_date($uniwits_time=false) { if ($uniwits_time) return seconds_to_datetime($uniwits_time); return seconds_to_datetime(); } function _db_limit($limit=null,$offset=null) { if (!$offset && !$limit) return ''; if ($offset && $limit) return 'LIMIT '.$offset.','.$limit; if ($offset) return 'LIMIT '.$offset.',60000'; return 'LIMIT '.$limit; } function _db_data_strings_insert($dbconn,$key2value,$allowedkeys=array(),$include_empty_values=true) { $fieldstr=""; $valuestr=""; foreach ($key2value as $key=>$value) { if (!in_array($key,$allowedkeys)) continue; if ($value || $include_empty_values) { if ($fieldstr) { $fieldstr.=", "; $valuestr.=", "; } $fieldstr.='`'.$dbconn->escape($key).'`'; $valuestr.=$dbconn->escape($value,true); } } return array($fieldstr,$valuestr); } function _db_data_string_update($dbconn,$key2value,$allowedkeys=array(),$include_empty_values=false) { $assignstr=""; foreach ($key2value as $key=>$value) { if (!in_array($key,$allowedkeys)) continue; if ($value || $include_empty_values) { if ($assignstr) $assignstr.=", "; $assignstr.='`'.$dbconn->escape($key).'`='.$dbconn->escape($value,true); } } return $assignstr; } ?>