<?php function db_load_admininfo($dbconn) { global $Config; $sql="SELECT `entry`,`value`" ."FROM `{$Config->TableMap['admin']}`"; $result=$dbconn->query($sql,"error.db.deletefail"); $admininfo=array(); while ($assoc=$result->fetch_assoc()) $admininfo[$assoc['entry']]=$assoc['value']; $result->free(); return $admininfo; } function db_save_admininfo($dbconn,$admininfo) { global $Config; if (!$admininfo) return; $valuestr=""; foreach ($admininfo as $entry=>$value) { if ($valuestr) $valuestr.=","; $valuestr.="('".$dbconn->escape($entry)."','".$dbconn->escape($value)."')"; } $sql="REPLACE INTO `{$Config->TableMap['admin']}` (`entry`,`value`) VALUES ".$valuestr; $dbconn->real_query($sql,"error.db.insertfail"); } function db_load_staff_of_lectures($dbconn,$lctr_ids) { if (!$lctr_ids) return array(); global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['compere']}` " ."NATURAL JOIN `{$Config->TableMap['lecture_staff']}` " ."WHERE `lctr_id` IN (".$dbconn->escape($lctr_ids).")"; return $dbconn->query_allrows_assoc($sql); } function _db_member_basic_query_prefix() { global $Config; $sql="SELECT " ."IF(ISNULL(`c`.`mb_id`),0,1) `cp_once`, " ."`cp_name`, `cp_timezone`,`cp_status` " ."FROM `{$Config->TableMap['compere']}` `c` " ."WHERE 1 "; return $sql; } function db_member_basic_by_auth($dbconn,$login,$pswdhash) { $sql=_db_member_basic_query_prefix() ."AND " ."`mb_login`='".$dbconn->escape($login)."' AND " ."`mb_pswdhash`='".$pswdhash."' AND " ."`mb_status`='VALID' " ."LIMIT 1 "; return $dbconn->query_row_assoc($sql); } function db_member_basic_by_id($dbconn,$mb_id) { $sql=_db_member_basic_query_prefix() ."AND " ."`mb_id`='".$dbconn->escape($mb_id)."' " ."LIMIT 1 "; return $dbconn->query_row_assoc($sql); } function db_load_compere($dbconn,$mb_id) { global $Config; $sql="SELECT * FROM `{$Config->TableMap['compere']}` " ."WHERE `mb_id`='".$dbconn->escape($mb_id)."'"; return $dbconn->query_row_assoc($sql); } function db_load_comperes($dbconn,$mb_ids) { if (!$mb_ids) return array(); global $Config; $sql="SELECT * FROM `{$Config->TableMap['compere']}` " ."WHERE `mb_id` IN (".$dbconn->escape($mb_ids).")"; return $dbconn->query_allrows_assoc($sql); } function db_set_compere($dbconn,$mb_id,$comperebasic) { global $Config; $sql="INSERT IGNORE INTO `{$Config->TableMap['compere']}` (" ."`mb_id`, `cp_name`, `cp_timezone`, `cp_timestamp`" .") VALUES (" .$dbconn->escape($mb_id).',' .$dbconn->escape($comperebasic['cp_name'],true).',' .$dbconn->escape($comperebasic['cp_timezone'])."," ."UTC_TIMESTAMP())"; $dbconn->real_query($sql,"error.db.insertfail"); if (!$dbconn->affected_rows()) { $sql="UPDATE `{$Config->TableMap['compere']}` " ."SET " ."`cp_name`=".$dbconn->escape($comperebasic['cp_name'],true).", " ."`cp_timezone`=".$dbconn->escape($comperebasic['cp_timezone'])." " ."WHERE " ."`mb_id`=".$dbconn->escape($mb_id); $dbconn->real_query($sql,"error.db.updatefail"); } } function db_load_new_comperes($dbconn,$country_code,$limit=10,$offset=null) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['compere']}` " ."WHERE " ."`mb_id` NOT IN (" ."SELECT `mb_id_alias` " ."FROM `{$Config->TableMap['login_alias']}` " .") " .($country_code?"AND `mb_id` IN (" ."SELECT `mb_id` " ."FROM `{$Config->TableMap['member_info']}` " ."WHERE " ."`mb_country`=".$dbconn->escape($country_code,true)." " .")":"") ."ORDER BY `cp_timestamp` DESC " ._db_limit($limit,$offset); return $dbconn->query_allrows_assoc($sql); } function db_load_compere_info($dbconn,$mb_id) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['compere_info']}` " ."WHERE `cp_id`='".$dbconn->escape($mb_id)."'"; return $dbconn->query_allrows_assoc($sql); } function db_save_compere_info($dbconn,$mb_id,$compereinfo) { global $Config; $sql="DELETE FROM `{$Config->TableMap['compere_info']}` WHERE `cp_id`='".$dbconn->escape($mb_id)."'"; $dbconn->real_query($sql,"error.db.deletefail"); if (!$compereinfo) return; $sql="REPLACE INTO `{$Config->TableMap['compere_info']}` (" ."`cp_id`, `cpi_key`, `cpi_value`" .") VALUES "; $count=0; foreach ($compereinfo as $key=>$value) { if ($count) $sql.=","; $sql.="(" .$dbconn->escape($mb_id).',' .$dbconn->escape($key,true).',' .$dbconn->escape($value,true).")"; $count++; } $dbconn->real_query($sql,"error.db.insertfail"); } function db_insert_course($dbconn,$csinfo) { global $Config; $sql="INSERT INTO `{$Config->TableMap['course']}` " ."(`cs_member_min`, `cs_member_max`, `cs_minutes_min`, `cs_minutes_max`, `cs_minutes_step`, `cs_minutes_nonwork`, `cs_currency`, `cs_price_base`, `cs_price_step`, `cs_price_taxrate`, `cs_lecture_cost`, `mb_id_owner`, `cs_since`, `cs_expire`, `cs_visibleto`, `cs_initby`, `cs_autoconfirm`, `cs_status`, `cs_timestamp`, `cs_timestamp_initial`) " ."VALUES (" ."'".$dbconn->escape($csinfo['cs_member_min'])."'," ."'".$dbconn->escape($csinfo['cs_member_max'])."'," ."'".$dbconn->escape($csinfo['cs_minutes_min'])."'," ."'".$dbconn->escape($csinfo['cs_minutes_max'])."'," ."'".$dbconn->escape($csinfo['cs_minutes_step'])."'," ."'".$dbconn->escape($csinfo['cs_minutes_nonwork'])."'," ."'".$dbconn->escape($csinfo['cs_currency'])."'," ."'".$dbconn->escape($csinfo['cs_price_base'])."'," ."'".$dbconn->escape($csinfo['cs_price_step'])."'," ."'".$dbconn->escape($csinfo['cs_price_taxrate'])."'," ."'".$dbconn->escape($csinfo['cs_lecture_cost'])."'," ."'".$dbconn->escape($csinfo['mb_id_owner'])."'," ."'".$dbconn->escape($csinfo['cs_since'])."'," ."'".$dbconn->escape($csinfo['cs_expire'])."'," ."'".$dbconn->escape($csinfo['cs_visibleto'])."'," ."'".$dbconn->escape($csinfo['cs_initby'])."'," ."'".$dbconn->escape($csinfo['cs_autoconfirm'])."'," ."'".$dbconn->escape($csinfo['cs_status'])."'," ."UTC_TIMESTAMP()," ."UTC_TIMESTAMP())"; $dbconn->real_query($sql,"error.db.insertfail"); $cs_id=$dbconn->insert_id(); $sql="INSERT INTO `{$Config->TableMap['course_desc']}` " ."(`cs_id`,`cs_name`, `cs_desc`, `cs_desc_type`, `cs_thumbnail_url`) " ."VALUES (" ."'".$cs_id."'," ."'".$dbconn->escape($csinfo['cs_name'])."'," ."'".$dbconn->escape($csinfo['cs_desc'])."'," ."'".$dbconn->escape($csinfo['cs_desc_type'])."'," .($csinfo['cs_thumbnail_url']?$dbconn->escape($csinfo['cs_thumbnail_url'],true):'NULL') .")"; $dbconn->real_query($sql,"error.db.insertfail"); return $cs_id; } function db_update_course($dbconn,$csinfo) { global $Config; $updatefields=array('cs_id','cs_member_min', 'cs_member_max', 'cs_minutes_min', 'cs_minutes_max', 'cs_minutes_step', 'cs_minutes_nonwork', 'cs_currency', 'cs_price_base', 'cs_price_step', 'cs_price_taxrate', 'cs_lecture_cost', 'cs_since', 'cs_expire', 'cs_visibleto', 'cs_initby', 'cs_autoconfirm', 'cs_status'); $csinfo=array_intersect_key($csinfo,array_combine($updatefields,$updatefields)); $sql="UPDATE `{$Config->TableMap['course']}` " ."SET "; foreach ($csinfo as $key=>$val) { if ($key=='cs_id') continue; $sql.="`".$key."`='".$dbconn->escape($val)."', "; } $sql.="`cs_timestamp`=UTC_TIMESTAMP() WHERE `cs_id`='".$dbconn->escape($csinfo['cs_id'])."'"; $dbconn->real_query($sql,"error.db.insertfail"); } function db_load_course_by_id($dbconn,$cs_id) { if (!$cs_id) return array(); global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['course']}` " ."NATURAL LEFT JOIN `{$Config->TableMap['course_desc']}` " ."LEFT JOIN `{$Config->TableMap['member']}` ON (`mb_id_owner`=`mb_id`) " ."WHERE `cs_id`=".$dbconn->escape($cs_id); return $dbconn->query_row_assoc($sql); } function db_load_course($dbconn,$cs_ids,$withdesc=true) { if (!$cs_ids) return array(); global $Config; $sql="SELECT `c`.*, `cd`.`cs_name`".($withdesc?", `cd`.`cs_desc`, `cd`.`cs_desc_type`":"").", `cd`.`cs_thumbnail_url` " ."FROM `{$Config->TableMap['course']}` `c` " ."NATURAL LEFT JOIN `{$Config->TableMap['course_desc']}` `cd` " ."WHERE `cs_id` IN (".$dbconn->escape($cs_ids).")"; return $dbconn->query_allrows_assoc($sql); } function db_load_course_by_owner($dbconn,$mb_id_owner,$withdesc=true,$validonly=true) { if (!$mb_id_owner) return array(); global $Config; $sql="SELECT `c`.*, `cd`.`cs_name`".($withdesc?", `cd`.`cs_desc`, `cd`.`cs_desc_type`":"").", `cd`.`cs_thumbnail_url` " ."FROM `{$Config->TableMap['course']}` `c` " ."NATURAL LEFT JOIN `{$Config->TableMap['course_desc']}` `cd` " ."WHERE `mb_id_owner` IN (".$dbconn->escape($mb_id_owner).") " .($validonly?" AND `cs_status`='VALID' ":'') ."ORDER BY `cs_timestamp` DESC "; return $dbconn->query_allrows_assoc($sql); } function db_load_course_by_staff($dbconn,$mb_id_staff,$validonly=true) { global $Config; $sql="SELECT `d`.`cs_name`, `s`.*, `cp`.`mb_id` `cp_id`, `cp`.`cp_name` " ."FROM `{$Config->TableMap['course']}` `c` " ."NATURAL LEFT JOIN `{$Config->TableMap['course_desc']}` `d` " ."NATURAL LEFT JOIN `{$Config->TableMap['course_staff']}` `s` " ."JOIN `{$Config->TableMap['compere']}` `cp` ON (`c`.`mb_id_owner`=`cp`.`mb_id`) " ."WHERE " ."`s`.`mb_id` IN (".$dbconn->escape($mb_id_staff).") " .($validonly?" AND `cs_status`='VALID' ":'') ."GROUP BY `cs_id` " ."ORDER BY `cs_timestamp` DESC "; return $dbconn->query_allrows_assoc($sql); } function db_load_course_staff($dbconn,$cs_id) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['course_staff']}` " ."WHERE `cs_id`=".$dbconn->escape($cs_id); return $dbconn->query_allrows_assoc($sql); } function db_load_course_classroom_id($dbconn,$cs_id) { global $Config; $sql="SELECT `clsr_id` " ."FROM `{$Config->TableMap['course_classroom']}` " ."WHERE `cs_id`=".$dbconn->escape($cs_id); return $dbconn->query_value_array($sql); } function db_load_course_places($dbconn,$cs_ids) { if (!$cs_ids) return array(); if (!is_array($cs_ids)) $cs_ids=array($cs_ids); global $Config; $sql="SELECT `cs_id`, `p`.* " ."FROM `{$Config->TableMap['course_classroom']}` " ."NATURAL JOIN `{$Config->TableMap['classroom_seat']}` " ."NATURAL JOIN `{$Config->TableMap['seat']}` " ."NATURAL JOIN `{$Config->TableMap['place']}` `p` " ."WHERE `cs_id` IN (".$dbconn->escape($cs_ids).") " ."GROUP BY `cs_id`, `p`.`plc_id` "; return $dbconn->query_allrows_assoc($sql); } function db_add_classroom_to_course($dbconn,$cs_id,$clsr_ids) { if (!$clsr_ids) return array(); if (!is_array($clsr_ids)) $clsr_ids=array($clsr_ids); $cs_id=$dbconn->escape($cs_id); global $Config; $sql="INSERT IGNORE `{$Config->TableMap['course_classroom']}` (" ."`cs_id`, `clsr_id`" .") VALUES "; $first=true; foreach ($clsr_ids as $clsr_id) { if ($first) $first=false; else $sql.=","; $sql.="(".$cs_id.",".$dbconn->escape($clsr_id).")"; } $dbconn->real_query($sql,"error.db.insertfail"); } function db_delete_classroom_from_course($dbconn,$cs_id,$clsr_ids) { if (!$clsr_ids) return array(); $cs_id=$dbconn->escape($cs_id); global $Config; $sql="DELETE FROM `{$Config->TableMap['course_classroom']}` " ."WHERE " ."`cs_id`=".$dbconn->escape($cs_id)." AND " ."`clsr_id` IN (".$dbconn->escape($clsr_ids).")"; $dbconn->real_query($sql,"error.db.deletefail"); } function db_count_participants($dbconn,$compere_record_ids) { if (!$compere_record_ids) return array(); global $Config; $sql="SELECT `cr_id`, `cs_id`, COUNT(*) `count` " ."FROM `{$Config->TableMap['record']}` " ."NATURAL JOIN `{$Config->TableMap['member_record']}` " ."WHERE " ."`cr_id` IN (".$dbconn->escape($compere_record_ids).") " ."GROUP BY `cr_id`, `cs_id` " ."ORDER BY `cr_id` "; return $dbconn->query_allrows_assoc($sql); } function db_set_course_keywords($dbconn,$cs_id,$wordcounts,$limit=999) { global $Config; $cs_id=$dbconn->escape($cs_id); $sql="DELETE FROM `{$Config->TableMap['course_keyword']}` " ."WHERE `cs_id`=".$cs_id; $dbconn->real_query($sql,"error.db.deletefail"); if (!$wordcounts) return; $sql="REPLACE INTO `{$Config->TableMap['course_keyword']}` " ."(`cs_id`, `ck_word`, `ck_count`) VALUES "; $kwcount=0; foreach ($wordcounts as $w=>$c) { if ($kwcount) $sql.=","; $sql.="(".$cs_id.",'".$dbconn->escape($w)."',".$dbconn->escape($c).")"; $kwcount++; if ($kwcount>=$limit) break; } $dbconn->real_query($sql,"error.db.insertfail"); } function _db_period_intersect($col_since,$col_expire,$since_utc,$since_bias_utc,$upto_utc,$upto_bias_utc) { $cond_1=$col_since."<=CAST('".$upto_bias_utc."' AS DATETIME)"; $cond_2="CAST('".$since_utc."' AS DATETIME)<=".$col_expire; $cond_3="CAST('".$since_bias_utc."' AS DATETIME)<=".$col_expire; $cond_4=$col_since."<=CAST('".$since_utc."' AS DATETIME)"; return "( ( ".$cond_1." AND ".$cond_2.") OR (".$cond_3." AND ".$cond_4." ) )"; } function db_compute_search_result($dbconn,$keywords,$since_utc,$upto_utc,$minutes,$offset,$rowlimit,$addon_condmap_eq=array(),$options=array('TAKE-CS','TAKE-LCTR')) { if (!$since_utc) $since_utc=seconds_to_datetime(); if (!$upto_utc) $upto_utc='9000-12-31 23:59:59'; $since_utc=$dbconn->escape($since_utc); $upto_utc=$dbconn->escape($upto_utc); $since_bias_utc=bias_datetime($since_utc,$minutes*60); $upto_bias_utc=bias_datetime($upto_utc,-$minutes*60); global $Config; $keyword_joins=''; $keyword_matches=''; $keyword_score='0'; if (is_array($keywords)) { $kwidx=0; foreach ($keywords as $word) { $kwidx++; $keyword_joins.="JOIN `{$Config->TableMap['course_keyword']}` `ck_$kwidx` USING (`cs_id`) "; $keyword_matches.="`ck_$kwidx`.`ck_word`='".$dbconn->escape($word)."' AND "; $keyword_score.="+`ck_$kwidx`.`ck_count`"; } } $keyword_score.=' `ck_score` '; $addon_cond_suffix=''; if ($addon_condmap_eq['zc_country']/* &&
		(
			$addon_condmap_eq['zc_prefecture'] ||
			$addon_condmap_eq['zc_city'] ||
			$addon_condmap_eq['zc_district']
		)*/) { $addon_cond_suffix.=" AND `cr`.`clsr_id` IN ( " ."SELECT `clsr_id` " ."FROM `{$Config->TableMap['classroom']}` " ."NATURAL JOIN `{$Config->TableMap['place']}` " ."WHERE " .($addon_condmap_eq['zc_country']?"`plc_country`=".$dbconn->escape($addon_condmap_eq['zc_country'],true)." AND ":'') .($addon_condmap_eq['zc_prefecture']?"`plc_state`=".$dbconn->escape($addon_condmap_eq['zc_prefecture'],true)." AND ":'') .($addon_condmap_eq['zc_city']?"`plc_city` LIKE '".$dbconn->escape($addon_condmap_eq['zc_city'])."%' AND ":'') .($addon_condmap_eq['zc_district']?"`plc_address` LIKE '".$dbconn->escape($addon_condmap_eq['zc_district'])."%' AND ":'') ."1 " .") "; } unset($addon_condmap_eq['zc_country'],$addon_condmap_eq['zc_prefecture'],$addon_condmap_eq['zc_city'],$addon_condmap_eq['zc_district']); if ($addon_condmap_eq['mb_id']) { $addon_cond_suffix.="AND ( " ."`cs_visibleto`='PUBLIC' OR " ."`c`.`mb_id_owner`=".$dbconn->escape($addon_condmap_eq['mb_id'],true)." OR " ."`cs_visibleto`='CIRCLE' AND `cs_id` IN (" ."SELECT `cs_id` " ."FROM `{$Config->TableMap['course_circle']}` `ccir` " ."WHERE " ."`ccir`.`mb_id`=".$dbconn->escape($addon_condmap_eq['mb_id'],true)." " .") " .") "; } else { $addon_cond_suffix.="AND `cs_visibleto`='PUBLIC' "; } unset($addon_condmap_eq['mb_id']); foreach ($addon_condmap_eq as $field=>$value) { if (is_array($value)) $addon_cond_suffix.="AND ".$field." IN (".$dbconn->escape($value,true).") "; else $addon_cond_suffix.="AND ".$field."=".$dbconn->escape($value,true)." "; } if (in_array('TAKE-CS',$options)) { $sql_course ="SELECT " ."NULL `lctr_id`, `cs_id`, `cs_name`, `cs_desc_type`, `cs_thumbnail_url`, `cs_currency`, `cs_price_base`, `cs_minutes_min`, " ."`cs_since` `since_1`, `cs_expire` `expire_1`, " ."'1000-01-01 00:00:00' `since_2`, '9999-12-31 23:59:59' `expire_2`, " ."'1000-01-01 00:00:00' `since_3`, '9999-12-31 23:59:59' `expire_3`, " ."'1000-01-01 00:00:00' `since_4`, '9999-12-31 23:59:59' `expire_4`, " .(in_array('SORT-BY-LR',$options)?"COALESCE(`rsv_timestamp_last`) ":"GREATEST(UTC_TIMESTAMP(),`cs_since`) ")."`sort_date`, " ."NULL `lctr_deadline`, " ."`cp`.`cp_name`, `cp`.`mb_id` `mb_id_compere`, `cs_member_max`, `cs_initby`, " ."COALESCE(`crct`.`crct_count`,0) `crct_count`, " .$keyword_score ."FROM `{$Config->TableMap['course']}` `c` " ."NATURAL JOIN `{$Config->TableMap['course_desc']}` `cd` " ."NATURAL LEFT JOIN `{$Config->TableMap['course_reservation_count_thisyear']}` `crct` " ."NATURAL LEFT JOIN `{$Config->TableMap['course_last_reservation']}` `clr` " ."JOIN `{$Config->TableMap['compere']}` `cp` ON (`c`.`mb_id_owner`=`cp`.`mb_id`) " .$keyword_joins ."JOIN `{$Config->TableMap['course_staff']}` `cs` USING(`cs_id`) " ."JOIN `{$Config->TableMap['course_classroom']}` `cc` USING(`cs_id`) " ."JOIN `{$Config->TableMap['classroom']}` `cr` USING(`clsr_id`) " ."LEFT JOIN `{$Config->TableMap['compere_qualified']}` `cq` ON(`cq`.`mb_id`=`cp`.`mb_id`) " ."WHERE " .$keyword_matches ."`cs_status`='VALID' AND " ."`clsr_status`='VALID' AND " ."`cp_status`='VALID' AND " ."`cs_expire`>UTC_TIMESTAMP() AND " .(in_array('OWNER-INIT-ALSO',$options)?'':"`cs_initby`='PARTICIPANT' AND ") .(in_array('SUPPRESS-NA-CS',$options)?"( " ."`cs_initby`='PARTICIPANT' AND " ."`cs_id` IN (" ."SELECT `cs_id` " ."FROM `{$Config->TableMap['course_timeavail']}` " ."NATURAL JOIN `{$Config->TableMap['timeavail']}` " ."WHERE " ."`ta_status`='VALID' AND " ."`ta_end`>=UTC_TIMESTAMP() " .") OR " ."`cs_id` IN (" ."SELECT `cs_id` " ."FROM `{$Config->TableMap['lecture']}` `lctr` " ."WHERE " ."`lctr`.`lctr_status`='OPEN' AND " ."`lctr`.`lctr_deadline`>UTC_TIMESTAMP() " .") " .") AND ":'') ._db_period_intersect('`cs_since`','`cs_expire`',$since_utc,$since_bias_utc,$upto_utc,$upto_bias_utc)." " .$addon_cond_suffix ."GROUP BY `cs_id` "; } if (in_array('TAKE-LCTR',$options)) { $sql_lecture ="SELECT " ."`lctr_id`, `cs_id`, `cs_name`, `cs_desc_type`, `cs_thumbnail_url`, `cs_currency`, `cs_price_base`, `cs_minutes_min`, " ."`lctr_since` `since_1`, `lctr_expire` `expire_1`, " ."'1000-01-01 00:00:00' `since_2`, '9999-12-31 23:59:59' `expire_2`, " ."'1000-01-01 00:00:00' `since_3`, '9999-12-31 23:59:59' `expire_3`, " ."'1000-01-01 00:00:00' `since_4`, '9999-12-31 23:59:59' `expire_4`, " ."`lctr_since` `sort_date`, " ."`lctr_deadline`, " ."`cp`.`cp_name`, `cp`.`mb_id` `mb_id_compere`, `cs_member_max`, `cs_initby`, " ."COALESCE(`crct`.`crct_count`,0) `crct_count`, " .$keyword_score ."FROM `{$Config->TableMap['course']}` `c` " ."NATURAL JOIN `{$Config->TableMap['course_desc']}` `cd` " ."NATURAL LEFT JOIN `{$Config->TableMap['course_reservation_count_thisyear']}` `crct` " ."JOIN `{$Config->TableMap['compere']}` `cp` ON (`c`.`mb_id_owner`=`cp`.`mb_id`) " .$keyword_joins ."JOIN `{$Config->TableMap['lecture']}` `ct` USING(`cs_id`) " ."NATURAL JOIN `{$Config->TableMap['classroom_size']}` `cs` " ."NATURAL JOIN `{$Config->TableMap['lecture_size']}` `ls` " ."LEFT JOIN `{$Config->TableMap['compere_qualified']}` `cq` ON(`cq`.`mb_id`=`cp`.`mb_id`) " ."WHERE " .$keyword_matches ."`cs_status`='VALID' AND " ."`lctr_status`='OPEN' AND " ."`cp_status`='VALID' AND " ."`lctr_size`<LEAST(`cs_member_max`,`clsr_size`) AND " ._db_period_intersect('`lctr_since`','`lctr_expire`',$since_utc,$since_bias_utc,$upto_utc,$upto_bias_utc)." " .$addon_cond_suffix ."GROUP BY `lctr_id` "; } if ($sql_course && $sql_lecture) $sql="(".$sql_course.") UNION (".$sql_lecture.") "; else if ($sql_course) $sql=$sql_course; else if ($sql_lecture) $sql=$sql_lecture; else return array(); $sql.="ORDER BY " ."`ck_score` DESC, " .(in_array('SORT-BY-LR',$options)?"`sort_date` DESC ":"`sort_date` ").", " ."`lctr_id` DESC, " ."`cs_id` DESC "; if ($offset || $rowlimit) { $sql.="LIMIT "; if ($offset) { $sql.=$dbconn->escape($offset); if ($rowlimit) $sql.=","; } if ($rowlimit) $sql.=$rowlimit; } return $dbconn->query_allrows_assoc($sql); } function db_get_course_desc($dbconn,$cs_id) { global $Config; $sql="SELECT * FROM `{$Config->TableMap['course_desc']}` " ."WHERE `cs_id`=".$dbconn->escape($cs_id); return $dbconn->query_row_assoc($sql); } function db_set_course_desc($dbconn,$cs_desc_info) { global $Config; $sql="REPLACE INTO `{$Config->TableMap['course_desc']}` " ."(`cs_id`, `cs_name`, `cs_desc`, `cs_desc_type`, `cs_thumbnail_url`)" ." VALUES " ."(" ."'".$dbconn->escape($cs_desc_info['cs_id'])."'," ."'".$dbconn->escape($cs_desc_info['cs_name'])."'," ."'".$dbconn->escape($cs_desc_info['cs_desc'])."'," ."'".$dbconn->escape($cs_desc_info['cs_desc_type'])."'," .($cs_desc_info['cs_thumbnail_url']?$dbconn->escape($cs_desc_info['cs_thumbnail_url'],true):'NULL') .")"; $dbconn->real_query($sql,"error.db.insertfail"); $sql="UPDATE `{$Config->TableMap['course']}` " ."SET `cs_timestamp`=UTC_TIMESTAMP() " ."WHERE `cs_id`=".$dbconn->escape($cs_desc_info['cs_id']); $dbconn->real_query($sql,"error.db.updatefail"); } function db_delete_course($dbconn,$cs_id) { global $Config; $sql="UPDATE `{$Config->TableMap['course']}` " ."SET `cs_status`='DELETED' " ."WHERE `cs_id`=".$dbconn->escape($cs_id); $dbconn->real_query($sql,"error.db.updatefail"); } function db_delete_seats_from_classroom($dbconn,$clsr_id,$st_ids) { if (!$st_ids) return; global $Config; $sql="DELETE FROM `{$Config->TableMap['classroom_seat']}` " ."WHERE " ."`clsr_id`=".$dbconn->escape($clsr_id)." AND " ."`st_id` IN (".$dbconn->escape($st_ids).")"; $dbconn->real_query($sql,"error.db.deletefail"); } function db_delete_staff_from_course($dbconn,$cs_id,$mb_ids) { if (!$mb_ids) return; global $Config; $sql="DELETE FROM `{$Config->TableMap['course_staff']}` WHERE `cs_id`='".$dbconn->escape($cs_id)."' AND `mb_id` IN (".$dbconn->escape($mb_ids).")"; $dbconn->real_query($sql,"error.db.deletefail"); } function db_add_staff_to_course($dbconn,$cs_id,$mb_ids) { if (!$mb_ids) return; if (!is_array($mb_ids)) $mb_ids=array($mb_ids); global $Config; $sql="REPLACE INTO `{$Config->TableMap['course_staff']}` (`cs_id`,`mb_id`) VALUES "; $first=true; foreach ($mb_ids as $mb_id) { if ($first) $first=false; else $sql.=","; $sql.="('".$dbconn->escape($cs_id)."','".$dbconn->escape($mb_id)."')"; } $dbconn->real_query($sql,"error.db.insertfail"); } function db_insert_place($dbconn,$placeinfo) { global $Config; $sql="INSERT INTO `{$Config->TableMap['place']}` (" ."`mb_id_owner`, `plc_name`, `plc_country`, `plc_zipcode`, `plc_state`, `plc_city`, `plc_address`, `plc_room`, `plc_phone`, `plc_timestamp`, `plc_timestamp_initial`, `plc_status`" .") VALUES (" ."'".$dbconn->escape($placeinfo['mb_id_owner'])."'," ."'".$dbconn->escape($placeinfo['plc_name'])."'," ."'".$dbconn->escape($placeinfo['plc_country'])."'," ."'".$dbconn->escape($placeinfo['plc_zipcode'])."'," ."'".$dbconn->escape($placeinfo['plc_state'])."'," ."'".$dbconn->escape($placeinfo['plc_city'])."'," ."'".$dbconn->escape($placeinfo['plc_address'])."'," ."'".$dbconn->escape($placeinfo['plc_room'])."'," ."'".$dbconn->escape($placeinfo['plc_phone'])."'," ."UTC_TIMESTAMP()," ."UTC_TIMESTAMP()," ."'".$dbconn->escape($placeinfo['plc_status'])."'" .")"; $dbconn->real_query($sql,"error.db.queryfail"); return $dbconn->insert_id(); } function db_update_place($dbconn,$placeinfo) { global $Config; $sql="UPDATE `{$Config->TableMap['place']}` " ."SET " ."`plc_name`='".$dbconn->escape($placeinfo['plc_name'])."'," ."`plc_country`='".$dbconn->escape($placeinfo['plc_country'])."'," ."`plc_zipcode`='".$dbconn->escape($placeinfo['plc_zipcode'])."'," ."`plc_state`='".$dbconn->escape($placeinfo['plc_state'])."'," ."`plc_city`='".$dbconn->escape($placeinfo['plc_city'])."'," ."`plc_address`='".$dbconn->escape($placeinfo['plc_address'])."'," ."`plc_room`='".$dbconn->escape($placeinfo['plc_room'])."'," ."`plc_phone`='".$dbconn->escape($placeinfo['plc_phone'])."'," ."`plc_timestamp`=UTC_TIMESTAMP(), " ."`plc_status`='".$dbconn->escape($placeinfo['plc_status'])."' " ."WHERE " ."`plc_id`=".$dbconn->escape($placeinfo['plc_id']); $dbconn->real_query($sql,"error.db.updatefail"); } function db_delete_place($dbconn,$plc_id) { global $Config; $sql="UPDATE `{$Config->TableMap['place']}` " ."SET " ."`plc_status`='DELETED' " ."WHERE " ."`plc_id`=".$dbconn->escape($plc_id); $dbconn->real_query($sql,"error.db.deletefail"); } function db_load_place($dbconn,$plc_id) { global $Config; $sql="SELECT * FROM `{$Config->TableMap['place']}` " ."WHERE " ."`plc_id`=".$dbconn->escape($plc_id); return $dbconn->query_row_assoc($sql); } function db_load_places($dbconn,$plc_ids) { if (!$plc_ids) return array(); global $Config; $sql="SELECT * FROM `{$Config->TableMap['place']}` " ."WHERE " ."`plc_id` IN (".$dbconn->escape($plc_ids).")"; return $dbconn->query_allrows_assoc($sql); } function db_load_places_with_unassigned_seats($dbconn,$mb_id_owner,$validonly=true) { global $Config; $sql="SELECT `{$Config->TableMap['place']}`.*, COUNT(*) `seat_count` " ."FROM `{$Config->TableMap['place']}` " ."NATURAL JOIN `{$Config->TableMap['seat']}` " ."WHERE " ."`mb_id_owner`='".$dbconn->escape($mb_id_owner)."' " .($validonly?"AND `st_status`='VALID' AND `plc_status`='VALID' ":'') ."AND `st_id` NOT IN (" ."SELECT `st_id` " ."FROM `{$Config->TableMap['classroom_seat']}`" .")" ."GROUP BY `plc_id` " ."ORDER BY `plc_id` "; return $dbconn->query_allrows_assoc($sql); } function db_load_place_by_owner($dbconn,$mb_id,$include_deleted=false) { global $Config; $sql="SELECT `p`.* " ."FROM `{$Config->TableMap['place']}` `p` " ."WHERE " ."`mb_id_owner`=".$dbconn->escape($mb_id)." "; if (!$include_deleted) $sql.=" AND `plc_status`='VALID' "; $sql.="ORDER BY `plc_timestamp`"; return $dbconn->query_allrows_assoc($sql); } function db_load_seat($dbconn,$st_id) { global $Config; $sql="SELECT * FROM `{$Config->TableMap['seat']}` " ."WHERE " ."`st_id`=".$dbconn->escape($st_id); return $dbconn->query_row_assoc($sql); } function db_load_seats($dbconn,$st_ids) { if (!$st_ids) return array(); global $Config; $sql="SELECT * FROM `{$Config->TableMap['seat']}` " ."WHERE " ."`st_id` IN (".$dbconn->escape($st_ids).")"; return $dbconn->query_allrows_assoc($sql); } function db_load_seats_at_place($dbconn,$plc_id,$validonly=true) { global $Config; $sql="SELECT * FROM `{$Config->TableMap['seat']}` " ."WHERE " ."`plc_id`=".$dbconn->escape($plc_id)." "; if ($validonly) $sql.="AND `st_status`='VALID' "; $sql.="ORDER BY `st_no`,`st_id`"; return $dbconn->query_allrows_assoc($sql); } function db_load_unassigned_seats_at_place($dbconn,$plc_id,$validonly=true) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['seat']}` " ."WHERE " ."`plc_id`=".$dbconn->escape($plc_id)." AND " .($validonly?"`st_status`='VALID' AND ":'') ."`st_id` NOT IN (" ."SELECT `st_id` " ."FROM `{$Config->TableMap['classroom_seat']}` " .")"; $sql.="ORDER BY `st_no`,`st_id`"; return $dbconn->query_allrows_assoc($sql); } function db_load_unreserved_seats_of_classroom($dbconn,$clsr_id,$validonly=true) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['classroom_seat']}` " ."NATURAL JOIN `{$Config->TableMap['seat']}` " ."WHERE " ."`clsr_id`=".$dbconn->escape($clsr_id)." AND " .($validonly?"`st_status`='VALID' AND ":'') ."`st_id` NOT IN (" ."SELECT `st_id` " ."FROM `{$Config->TableMap['seat_reservation']}` " ."WHERE " ."`lctr_expire`>UTC_TIMESTAMP() AND " ."`clsr_id`=".$dbconn->escape($clsr_id) .")"; $sql.="ORDER BY `st_no`,`st_id`"; return $dbconn->query_allrows_assoc($sql); } function db_load_lectures_of_place($dbconn,$plc_id,$lctr_status=array('OPEN','HIDDEN','CLOSED'),$unexpiredonly=true) { global $Config; $sql="SELECT `l`.*, `d`.cs_name " ."FROM `{$Config->TableMap['lecture']}` `l` " ."NATURAL JOIN `{$Config->TableMap['course_desc']}` `d` " ."NATURAL JOIN `{$Config->TableMap['classroom_seat']}` " ."NATURAL JOIN `{$Config->TableMap['seat']}` " ."WHERE " ."`lctr_status`!='DELETED' AND " ."`plc_id`=".$dbconn->escape($plc_id)." AND " ."`lctr_status` IN (".$dbconn->escape($lctr_status,true).") " .($unexpiredonly?" AND UTC_TIMESTAMP()<`lctr_expire` ":' ') ."GROUP BY `lctr_id` "; return $dbconn->query_allrows_assoc($sql); } function db_load_lectures_of_classroom($dbconn,$clsr_id,$lctr_status=array('OPEN','HIDDEN','CLOSED'),$unexpiredonly=true) { global $Config; $sql="SELECT `l`.*, `d`.cs_name " ."FROM `{$Config->TableMap['lecture']}` `l` " ."NATURAL JOIN `{$Config->TableMap['course_desc']}` `d` " ."WHERE " ."`lctr_status`!='DELETED' AND " ."`clsr_id`=".$dbconn->escape($clsr_id)." AND " ."`lctr_status` IN (".$dbconn->escape($lctr_status,true).") " .($unexpiredonly?" AND UTC_TIMESTAMP()<`lctr_expire`":''); return $dbconn->query_allrows_assoc($sql); } function db_load_reserved_seats_of_classroom($dbconn,$clsr_id,$validonly=true) { global $Config; $sql="SELECT `r`.* " ."FROM `{$Config->TableMap['seat_reservation']}` `r` " ."NATURAL JOIN `{$Config->TableMap['seat']}` `s` " ."WHERE " ."`clsr_id`=".$dbconn->escape($clsr_id).' AND ' .($validonly?"AND `st_status`='VALID' ":'') ."`lctr_expire`>UTC_TIMESTAMP() " ."ORDER BY `clsr_id`, `st_no`,`st_id`"; return $dbconn->query_allrows_assoc($sql); } function db_load_seats_of_classroom($dbconn,$clsr_id,$validonly=true) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['classroom_seat']}` " ."NATURAL JOIN `{$Config->TableMap['seat']}` " ."NATURAL JOIN `{$Config->TableMap['place']}` " ."WHERE " ."`clsr_id`=".$dbconn->escape($clsr_id)." " .($validonly?"AND `st_status`='VALID' AND `plc_status`='VALID' ":'') ."ORDER BY `st_id`"; return $dbconn->query_allrows_assoc($sql); } function db_count_seats_of_lecture($dbconn,$lctr_id) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['seat_reservation']}` " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id); return $dbconn->query_value($sql); } function db_count_seats_by_place($dbconn,$plc_ids) { if (!$plc_ids) return array(); global $Config; $sql="SELECT `plc_id`,COUNT(*) `count` " ."FROM `{$Config->TableMap['seat']}` " ."WHERE " ."`st_status`='VALID' AND " ."`plc_id` IN (".$dbconn->escape($plc_ids).") " ."GROUP BY `plc_id` "; return $dbconn->query_allrows_assoc($sql); } function db_count_seats_by_classroom($dbconn,$clsr_ids) { if (!$clsr_ids) return array(); global $Config; $sql="SELECT `clsr_id`,`clsr_size` `count` " ."FROM `{$Config->TableMap['classroom_size']}` " ."WHERE " ."`clsr_id` IN (".$dbconn->escape($clsr_ids).") "; return $dbconn->query_allrows_assoc($sql); } function db_load_seats_of_lecture($dbconn,$lctr_id) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['seat_reservation']}` " ."NATURAL JOIN `{$Config->TableMap['seat']}` " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id)." " ."ORDER BY `clsr_id`, `plc_id`, `st_no`"; return $dbconn->query_allrows_assoc($sql); } function db_add_seats_to_classroom($dbconn,$clsr_id,$st_ids) { if (!$st_ids) return; global $Config; $sql="REPLACE INTO `{$Config->TableMap['classroom_seat']}` (" ."`clsr_id`, `st_id`" .") VALUES "; $first=true; foreach ($st_ids as $st_id) { if ($first) $first=false; else $sql.=","; $sql.="(".$dbconn->escape($clsr_id).",".$dbconn->escape($st_id).")"; } $dbconn->real_query($sql,"error.db.insertfail"); } function db_add_seats_at_place($dbconn,$plc_id,$number_of_seats) { if (!$number_of_seats) return; global $Config; $sql="SELECT MAX(st_no) FROM `{$Config->TableMap['seat']}` " ."WHERE " ."`plc_id`=".$dbconn->escape($plc_id)." AND " ."`st_status`='VALID' "; $max_st_no=$dbconn->query_value($sql); $sql="INSERT INTO `{$Config->TableMap['seat']}` (" ."`plc_id`, `st_no`, `st_status`, `st_timestamp_initial`" .") VALUES "; for ($si=0,$st_no=$max_st_no+1;$si<$number_of_seats;$si++,$st_no++) { if ($si) $sql.=","; $sql.="(".$dbconn->escape($plc_id).",".$st_no.",'VALID',UTC_TIMESTAMP())"; } $dbconn->real_query($sql,"error.db.insertfail"); } function db_delete_seats($dbconn,$st_ids) { if (!$st_ids) return; global $Config; $sql="DELETE FROM `{$Config->TableMap['classroom_seat']}` " ."WHERE " ."`st_id` NOT IN (" ."SELECT `st_id` FROM `{$Config->TableMap['seat']}` " .")"; $dbconn->real_query($sql,"error.db.deletefail"); $sql="UPDATE `{$Config->TableMap['seat']}` " ."SET `st_status`='DELETED' " ."WHERE `st_id` IN (".$dbconn->escape($st_ids).")"; $dbconn->real_query($sql,"error.db.deletefail"); } function db_count_seats_reservation($dbconn,$st_ids) { if (!$st_ids) return array(); global $Config; $sql="SELECT `st_id`, `st_no`, COUNT(*) `count`, MAX(`lctr_expire`) `expire` " ."FROM `{$Config->TableMap['seat_reservation']}` " ."NATURAL JOIN `{$Config->TableMap['seat']}` " ."WHERE " ."`st_id` IN (".$dbconn->escape($st_ids).") AND " ."`lctr_expire`>UTC_TIMESTAMP() " ."GROUP BY `st_id` " ."ORDER BY `st_id` "; return $dbconn->query_allrows_assoc($sql); } function db_insert_classroom($dbconn,$classroominfo) { global $Config; $sql="INSERT INTO `{$Config->TableMap['classroom']}` (" ."`clsr_name`, `clsr_desc`, `mb_id_owner`, `clsr_status`, `clsr_timestamp`, `clsr_timestamp_initial`" .") VALUES (" ."'".$dbconn->escape($classroominfo['clsr_name'])."'," ."'".$dbconn->escape($classroominfo['clsr_desc'])."'," .$dbconn->escape($classroominfo['mb_id_owner'])."," ."'".$dbconn->escape($classroominfo['clsr_status'])."'," ."UTC_TIMESTAMP()," ."UTC_TIMESTAMP()" .")"; $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function db_update_classroom($dbconn,$classroominfo) { global $Config; $sql="UPDATE `{$Config->TableMap['classroom']}` " ."SET " ."`clsr_name`='".$dbconn->escape($classroominfo['clsr_name'])."', " ."`clsr_desc`='".$dbconn->escape($classroominfo['clsr_desc'])."', " ."`clsr_timestamp`=UTC_TIMESTAMP() " ."WHERE " ."`clsr_id`=".$dbconn->escape($classroominfo['clsr_id']); $dbconn->real_query($sql,"error.db.updatefail"); } function db_load_classroom($dbconn,$clsr_id) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['classroom']}` " ."WHERE " ."`clsr_id`=".$dbconn->escape($clsr_id); return $dbconn->query_row_assoc($sql); } function db_load_classrooms($dbconn,$clsr_ids) { if (!$clsr_ids) return array(); global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['classroom']}` " ."WHERE " ."`clsr_id` IN (".$dbconn->escape($clsr_ids).") "; return $dbconn->query_allrows_assoc($sql); } function db_load_classroom_of_compere($dbconn,$cp_id,$cs_id=false) { global $Config; $sql="SELECT `clsr_id`, `clsr_name`, `plc_id`, `plc_name` " ."FROM `{$Config->TableMap['seat']}` " ."NATURAL JOIN `{$Config->TableMap['place']}` `p` " ."NATURAL JOIN `{$Config->TableMap['classroom_seat']}` " ."NATURAL JOIN `{$Config->TableMap['classroom']}` " .($cs_id?"NATURAL JOIN `{$Config->TableMap['course_classroom']}` ":'') ."WHERE " ."`p`.`mb_id_owner`=".$dbconn->escape($cp_id)." " .($cs_id?"AND `cs_id`=".$dbconn->escape($cs_id)." ":'') ."AND `plc_status`='VALID' " ."AND `clsr_status`='VALID' " ."GROUP BY `plc_id`, `clsr_id` " ."ORDER BY `plc_id`"; return $dbconn->query_allrows_assoc($sql); } function db_delete_classroom($dbconn,$clsr_id) { global $Config; $sql="UPDATE `{$Config->TableMap['classroom']}` " ."SET " ."`clsr_status`='DELETED' " ."WHERE " ."`clsr_id`=".$dbconn->escape($clsr_id); $dbconn->real_query($sql,"error.db.deletefail"); } function db_count_empty_classroom($dbconn,$mb_id_owner) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['classroom_size']}` " ."NATURAL JOIN `{$Config->TableMap['classroom']}` " ."WHERE " ."`clsr_size` =0 AND " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner); return $dbconn->query_value($sql); } function db_list_classroom_summaries_by_compere($dbconn,$mb_id_owner,$validonly=true) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['classroom']}` `clsr` " ."NATURAL LEFT JOIN `{$Config->TableMap['classroom_size_by_place']}` " ."LEFT JOIN `{$Config->TableMap['place']}` USING (`plc_id`) " ."WHERE " ."`clsr`.`mb_id_owner`=".$dbconn->escape($mb_id_owner)." "; if ($validonly) $sql.="AND `clsr_status`='VALID' "; $sql.="GROUP BY `clsr_id`, `plc_id` " ."ORDER BY `clsr_id`, `plc_id` "; return $dbconn->query_allrows_assoc($sql); } function db_list_classroom_summaries_by_course($dbconn,$cs_id) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['course_classroom']}` " ."NATURAL JOIN `{$Config->TableMap['classroom']}` `clsr` " ."NATURAL LEFT JOIN `{$Config->TableMap['classroom_size_by_place']}` " ."LEFT JOIN `{$Config->TableMap['place']}` USING (`plc_id`) " ."WHERE " ."`cs_id`=".$dbconn->escape($cs_id)." "; $sql.="GROUP BY `clsr_id`, `plc_id` " ."ORDER BY `clsr_id`, `plc_id` "; return $dbconn->query_allrows_assoc($sql); } function db_list_available_classroom_summaries_by_staff($dbconn,$cs_id,$mb_id_staff,$since,$expire,$validonly=true) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['course_staff']}` `cs_s` " ."NATURAL JOIN `{$Config->TableMap['course_classroom']}` `cs_clsr` " ."NATURAL JOIN `{$Config->TableMap['classroom']}` `clsr` " ."NATURAL JOIN `{$Config->TableMap['classroom_vacancy']}` " ."NATURAL LEFT JOIN `{$Config->TableMap['classroom_size_by_place']}` " ."LEFT JOIN `{$Config->TableMap['place']}` USING (`plc_id`) " ."WHERE " ."`cs_s`.`mb_id`=".$dbconn->escape($mb_id_staff)." AND " ."`cs_s`.`cs_id`=".$dbconn->escape($cs_id)." AND " ."`clsrv_since`<=".$dbconn->escape($since,true)." AND " .$dbconn->escape($expire,true)."<=`clsrv_expire` "; if ($validonly) $sql.="AND `clsr_status`='VALID' AND `plc_status`='VALID' "; $sql.="GROUP BY `clsr_id`, `plc_id` " ."ORDER BY `clsr_id`, `plc_id` "; return $dbconn->query_allrows_assoc($sql); } function db_count_course_classroom($dbconn,$cs_ids) { if (!$cs_ids) return array(); global $Config; $sql="SELECT `cs_id`, COUNT(`clsr_id`) `count` " ."FROM `{$Config->TableMap['course']}` " ."NATURAL LEFT JOIN `{$Config->TableMap['course_classroom']}` " ."WHERE " ."`cs_id` IN (".$dbconn->escape($cs_ids).")" ."GROUP BY `cs_id` "; return $dbconn->query_allrows_assoc($sql); } function db_count_course_staff($dbconn,$cs_ids) { if (!$cs_ids) return array(); global $Config; $sql="SELECT `cs_id`, COUNT(`mb_id`) `count` " ."FROM `{$Config->TableMap['course']}` " ."NATURAL LEFT JOIN `{$Config->TableMap['course_staff']}` " ."WHERE " ."`cs_id` IN (".$dbconn->escape($cs_ids).")" ."GROUP BY `cs_id` "; return $dbconn->query_allrows_assoc($sql); } function db_list_classroom_seats($dbconn,$clsr_id,$validonly=true) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['classroom']}` `clsr` " ."NATURAL LEFT JOIN `{$Config->TableMap['classroom_size']}` " ."NATURAL LEFT JOIN `{$Config->TableMap['classroom_seat']}` " ."NATURAL LEFT JOIN `{$Config->TableMap['seat']}` " ."LEFT JOIN `{$Config->TableMap['place']}` USING (`plc_id`) " ."WHERE " ."`clsr`.`clsr_id`=".$dbconn->escape($clsr_id)." "; if ($validonly) $sql.="AND `clsr_status`='VALID' "; $sql.="GROUP BY `clsr_id`, `plc_id` " ."ORDER BY `clsr_id`, `plc_id` "; return $dbconn->query_allrows_assoc($sql); } function db_count_classroom_seats($dbconn,$clsr_id,$validonly=true) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['classroom']}` " ."NATURAL LEFT JOIN `{$Config->TableMap['classroom_seat']}` " ."NATURAL LEFT JOIN `{$Config->TableMap['seat']}` " ."WHERE " ."`clsr_id`=".$dbconn->escape($clsr_id)." "; if ($validonly) $sql.="AND `clsr_status`='VALID' AND `st_status`='VALID' "; $sql.="GROUP BY `clsr_id`, `plc_id` " ."ORDER BY `clsr_id`, `plc_id` "; return $dbconn->query_value($sql); } function db_insert_reservation($dbconn,$lctr_id,$st_id,$mb_id,$mb_id_reserver) { global $Config; $sql="INSERT INTO `{$Config->TableMap['reservation']}` (" ."`lctr_id`, `st_id`, `mb_id`, `rsv_timestamp_provisional`, `mb_id_reserver`" .") VALUES (" .$dbconn->escape($lctr_id).", " .$dbconn->escape($st_id).", " .$dbconn->escape($mb_id).", " ."UTC_TIMESTAMP()," .$dbconn->escape($mb_id_reserver).")"; $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function db_confirm_reservation($dbconn,$lctr_id,$st_id,$mb_id) { global $Config; $sql="UPDATE `{$Config->TableMap['reservation']}` " ."SET `rsv_timestamp_confirmed`=UTC_TIMESTAMP() " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id)." AND " ."`st_id`=".$dbconn->escape($st_id)." AND " ."`mb_id`=".$dbconn->escape($mb_id); $dbconn->real_query($sql,"error.db.updatefail"); } function db_confirm_lecture_reservations($dbconn,$lctr_id) { global $Config; $sql="UPDATE `{$Config->TableMap['reservation']}` " ."SET `rsv_timestamp_confirmed`=UTC_TIMESTAMP() " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id)." AND " ."`rsv_timestamp_confirmed` IS NULL"; $dbconn->real_query($sql,"error.db.updatefail"); } function db_insert_timeavail($dbconn,$timeavail) { global $Config; $sql="INSERT INTO `{$Config->TableMap['timeavail']}` (" ."`mb_id`, `ta_begin`, `ta_end`, `ta_status`" .") VALUES (" .$dbconn->escape($timeavail['mb_id'])."," .$dbconn->escape($timeavail['ta_begin'],true)."," .$dbconn->escape($timeavail['ta_end'],true)."," .$dbconn->escape($timeavail['ta_status'],true) .")"; $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function db_clear_timeavail($dbconn,$mb_id) { global $Config; $sql="DELETE FROM `{$Config->TableMap['timeavail']}` " ."WHERE `mb_id`=".$dbconn->escape($mb_id); $dbconn->real_query($sql,"error.db.deletefail"); } function db_delete_timeavail($dbconn,$ta_ids) { if (!$ta_ids) return; global $Config; $sql="DELETE FROM `{$Config->TableMap['timeavail']}` " ."WHERE `ta_id` IN (".$dbconn->escape($ta_ids).")"; $dbconn->real_query($sql,"error.db.deletefail"); } function db_load_timeavail($dbconn,$ta_id) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['timeavail']}` " ."WHERE " ."`ta_id`=".$dbconn->escape($ta_id); return $dbconn->query_row_assoc($sql); } function db_load_timeavails($dbconn,$ta_ids) { if (!$ta_ids) return array(); global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['timeavail']}` " ."WHERE " ."`ta_id` IN (".$dbconn->escape($ta_ids).") " ."ORDER BY `ta_begin`, `ta_end` "; return $dbconn->query_allrows_assoc($sql); } function db_update_timeavail($dbconn,$timeavail) { global $Config; $sql="UPDATE `{$Config->TableMap['timeavail']}` " ."SET " ."`mb_id`=".$dbconn->escape($timeavail['mb_id'])."," ."`ta_begin`=".$dbconn->escape($timeavail['ta_begin'],true)."," ."`ta_end`=".$dbconn->escape($timeavail['ta_end'],true)."," ."`ta_status`=".$dbconn->escape($timeavail['ta_status'],true) ."WHERE " ."`ta_id`=".$dbconn->escape($timeavail['ta_id']); $dbconn->real_query($sql,"error.db.updatefail"); } function db_update_timeavail_status($dbconn,$ta_ids,$ta_status) { if (!$ta_ids) return; global $Config; $sql="UPDATE `{$Config->TableMap['timeavail']}` " ."SET `ta_status`=".$dbconn->escape($ta_status,true)." " ."WHERE `ta_id` IN (".$dbconn->escape($ta_ids).")"; $dbconn->real_query($sql,"error.db.updatefail"); } function db_count_timeavail($dbconn,$mb_id,$unexpiredonly=true) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['timeavail']}` " ."WHERE " ."`mb_id`=".$dbconn->escape($mb_id)." " .($unexpiredonly?"AND `ta_end`>UTC_TIMESTAMP() ":''); return $dbconn->query_value($sql); } function db_count_timeavail_by_course($dbconn,$mb_id,$cs_ids=false,$unexpiredonly=true,$validonly=false) { global $Config; $sql="SELECT `cs_id`, COUNT(*) `count` " ."FROM `{$Config->TableMap['timeavail']}` " ."NATURAL JOIN `{$Config->TableMap['course_timeavail']}` " ."WHERE " ."`mb_id`=".$dbconn->escape($mb_id)." " .($cs_ids?"AND `cs_id` IN (".$dbconn->escape($cs_ids).") ":'') .($unexpiredonly?"AND `ta_end`>UTC_TIMESTAMP() ":'') .($validonly?"AND `ta_status`='VALID' ":'') ."GROUP BY `cs_id`"; return $dbconn->query_allrows_assoc($sql); } function db_save_timeavail_course($dbconn,$ta_id,$mb_id,$cs_ids) { global $Config; $sql="DELETE FROM `{$Config->TableMap['course_timeavail']}` " ."WHERE `ta_id`=".$dbconn->escape($ta_id); $dbconn->real_query($sql,"error.db.deletefail"); if ($cs_ids) { $sql="INSERT INTO `{$Config->TableMap['course_timeavail']}` (" ."`ta_id`, `cs_id`" .") " ."SELECT DISTINCT ".$dbconn->escape($ta_id).", cs_id " ."FROM `{$Config->TableMap['course_staff']}` `st` " ."NATURAL JOIN `{$Config->TableMap['course']}` " ."WHERE " ."( " ."`st`.`mb_id`=".$dbconn->escape($mb_id)." OR " ."`st`.`mb_id` IN (" ."SELECT `mb_id_member` " ."FROM `{$Config->TableMap['team']}` " ."WHERE " ."`mb_id_leader`=".$dbconn->escape($mb_id)." AND " ."`tm_is_alias` " .") " .") AND " ."`cs_id` IN (".$dbconn->escape($cs_ids).") AND " ."`cs_status`='VALID' "; $dbconn->real_query($sql,"error.db.insertfail"); } } function db_add_timeavail_course($dbconn,$ta_id,$mb_id,$cs_ids) { global $Config; if ($cs_ids) { $sql="INSERT IGNORE INTO `{$Config->TableMap['course_timeavail']}` (" ."`ta_id`, `cs_id`" .") " ."SELECT DISTINCT ".$dbconn->escape($ta_id).", cs_id " ."FROM `{$Config->TableMap['course_staff']}` `st` " ."NATURAL JOIN `{$Config->TableMap['course']}` " ."WHERE " ."( " ."`st`.`mb_id`=".$dbconn->escape($mb_id)." OR " ."`st`.`mb_id` IN (" ."SELECT `mb_id_member` " ."FROM `{$Config->TableMap['team']}` " ."WHERE " ."`mb_id_leader`=".$dbconn->escape($mb_id)." AND " ."`tm_is_alias` " .") " .") AND " ."`cs_id` IN (".$dbconn->escape($cs_ids).") AND " ."`cs_status`='VALID' "; $dbconn->real_query($sql,"error.db.insertfail"); } } function db_del_timeavail_course($dbconn,$ta_ids,$mb_id,$cs_ids) { global $Config; if ($cs_ids && $ta_ids) { $sql="DELETE FROM `{$Config->TableMap['course_timeavail']}` " ."WHERE " ."`ta_id` IN (" ."SELECT `ta_id` " ."FROM `{$Config->TableMap['timeavail']}` " ."WHERE " ."`mb_id`=".$dbconn->escape($mb_id) .") AND " ."`ta_id` IN (".$dbconn->escape($ta_ids).") AND " ."`cs_id` IN (".$dbconn->escape($cs_ids).") "; $dbconn->real_query($sql,"error.db.deletefail"); } } function db_load_timeavail_by_course($dbconn,$cs_id,$sincetime,$uptotime='9999-12-31 23:59:59') { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['timeavail']}` " ."NATURAL JOIN `{$Config->TableMap['course_timeavail']}` " ."WHERE " ."`cs_id`=".$dbconn->escape($mb_id); if ($sincetime) $sql.=" AND '".$dbconn->escape($sincetime)."'<`ta_end`"; if ($uptotime) $sql.=" AND `ta_begin`<'".$dbconn->escape($sincetime)."'"; $sql.=" ORDER BY `ta_begin`,`ta_end`"; return $dbconn->query_allrows_assoc($sql); } function db_load_timeavail_of_compere($dbconn,$mb_id,$sincetime=false,$uptotime='9999-12-31 23:59:59',$validonly=true) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['timeavail']}` " ."WHERE " ."`mb_id`=".$dbconn->escape($mb_id)." AND " ."`ta_begin`<".$dbconn->escape($uptotime,true)." AND " .($sincetime?$dbconn->escape($sincetime,true):'UTC_TIMESTAMP()')."<`ta_end` " .($validonly?" AND `ta_status`='VALID' ":"") ."ORDER BY `ta_begin`, `ta_end` "; return $dbconn->query_allrows_assoc($sql); } function db_load_timeavail_course_ids($dbconn,$ta_ids,$validonly=true) { if (!$ta_ids) return array(); global $Config; $sql="SELECT `ct`.* " ."FROM `{$Config->TableMap['course_timeavail']}` `ct` " ."NATURAL JOIN `{$Config->TableMap['course']}` " ."WHERE " ."`ta_id` IN (".$dbconn->escape($ta_ids).") " .($validonly?"AND `cs_status`='VALID' ":''); return $dbconn->query_allrows_assoc($sql); } function db_team_invite_members($dbconn,$mb_id_leader,$mb_id_members) { if (!$mb_id_members) return array(); global $Config; $sql="SELECT `mb_id` " ."FROM `{$Config->TableMap['compere']}` " ."WHERE " ."`cp_status`='VALID' AND " ."`mb_id` IN (".$dbconn->escape($mb_id_members).") AND " ."`mb_id` NOT IN (" ."SELECT `mb_id_member` " ."FROM `{$Config->TableMap['team']}` " ."WHERE " ."`mb_id_leader`=".$dbconn->escape($mb_id_leader)." AND " ."(`tm_status`='INVITED' OR `tm_status`='VALID')" .")"; $ids=$dbconn->query_value_array($sql); if ($ids) { $sql=""; foreach ($ids as $id) { if ($sql) $sql.=","; $sql.="(".$dbconn->escape($mb_id_leader).",".$dbconn->escape($id).",'INVITED')"; } $sql="REPLACE INTO `{$Config->TableMap['team']}` (" ."`mb_id_leader`, `mb_id_member`, `tm_status`" .") VALUES ".$sql; $dbconn->real_query($sql,"error.db.insertfail"); } return $ids; } function db_create_team($dbconn,$mb_id_leader,$tm_status='VALID') { global $Config; $sql="DELETE FROM `{$Config->TableMap['team']}` WHERE `mb_id_leader`=".$dbconn->escape($mb_id_leader); $dbconn->real_query($sql,"error.db.deletefail"); $sql="INSERT INTO `{$Config->TableMap['team']}` " ."(`mb_id_leader`, `mb_id_member`, `tm_status`) VALUES (" .$dbconn->escape($mb_id_leader).", " .$dbconn->escape($mb_id_leader).", " .$dbconn->escape($tm_status,true).") "; $dbconn->real_query($sql,"error.db.insertfail"); } function db_team_insert_alias_members($dbconn,$mb_id_leader,$mb_id_aliases) { if (!$mb_id_aliases) return; global $Config; $sql="REPLACE INTO `{$Config->TableMap['team']}` (" ."`mb_id_leader`, `mb_id_member`, `tm_status`, `tm_is_alias`" .") " ."SELECT ".$dbconn->escape($mb_id_leader).", `mb_id_alias`, 'VALID', 1 " ."FROM `{$Config->TableMap['login_alias']}` `l` " ."WHERE " ."`l`.`mb_id`=".$dbconn->escape($mb_id_leader)." AND " ."`l`.`mb_id_alias` IN (".$dbconn->escape($mb_id_aliases).")"; $dbconn->real_query($sql,"error.db.insertfail"); } function db_load_team($dbconn,$mb_id_leader,$tm_status=array('INVITED','VALID'),$aliases=array('ALIAS','ORIGINAL')) { if (!is_array($aliases)) $aliases=array($aliases); global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['team']}` " ."JOIN `{$Config->TableMap['compere']}` ON (`mb_id_member`=`mb_id`) " ."WHERE `mb_id_leader`=".$dbconn->escape($mb_id_leader)." " .($tm_status?"AND `tm_status` IN (".$dbconn->escape($tm_status,true).") ":' ')."AND " ."( " .(in_array('ALIAS',$aliases)?'`tm_is_alias` OR ':'') .(in_array('ORIGINAL',$aliases)?'NOT `tm_is_alias` OR ':'') ."0 ) "; return $dbconn->query_allrows_assoc($sql); } function db_filter_for_available_compere($dbconn,$mb_ids,$cs_id,$since,$expire) { if (!$mb_ids) return array(); global $Config; $sql="SELECT `mb_id` " ."FROM `{$Config->TableMap['compere_vacancy']}` " ."NATURAL JOIN `{$Config->TableMap['timeavail']}` " ."NATURAL JOIN `{$Config->TableMap['course_timeavail']}` " ."WHERE " ."`mb_id` IN (".$dbconn->escape($mb_ids).") AND " ."`cpv_since`<='".$dbconn->escape($since)."' AND " ."'".$dbconn->escape($expire)."'<=`cpv_expire` AND " ."`cs_id`=".$dbconn->escape($cs_id)." AND " ."`ta_status`='VALID' AND " ."`ta_begin`<='".$dbconn->escape($since)."' AND " ."'".$dbconn->escape($expire)."'<=`ta_end`"; return $dbconn->query_value_array($sql); } function db_filter_for_available_compere_grant($dbconn,$mb_ids,$cs_id,$since,$expire,$lctr_id_granted) { if (!$mb_ids) return array(); global $Config; $sql="SELECT b.`mb_id` `mb_id` " ."FROM `reserv_compere_occupation` b " ."WHERE " ."b.`mb_id` IN (".$dbconn->escape($mb_ids).") AND " ."b.`lctr_id` != ".$dbconn->escape($lctr_id_granted)." AND " ."b.`lctr_since`>UTC_TIMESTAMP() AND " .$dbconn->escape($expire,true)."<=b.`lctr_since` AND " ." ( " ."SELECT MAX(a.`lctr_expire`) " ."FROM `reserv_compere_occupation` `a` " ."WHERE " ."a.`lctr_id` != ".$dbconn->escape($lctr_id_granted)." AND " ."a.`mb_id` = b.`mb_id` AND " ."a.`lctr_expire` <= b.`lctr_since` " .") <= ".$dbconn->escape($since,true)." " ."GROUP BY b.`mb_id` " ."ORDER BY `mb_id` "; return $dbconn->query_value_array($sql); } function db_filter_for_available_classroom($dbconn,$clsr_ids,$since,$expire) { if (!$clsr_ids) return array(); global $Config; $sql="SELECT `clsr_id` " ."FROM `{$Config->TableMap['classroom_vacancy']}` " ."WHERE " ."`clsr_id` IN (".$dbconn->escape($clsr_ids).") AND " ."`clsrv_since`<='".$dbconn->escape($since)."' AND " ."'".$dbconn->escape($expire)."'<=`clsrv_expire`"; return $dbconn->query_value_array($sql); } function db_filter_for_available_classroom_grant($dbconn,$clsr_ids,$since,$expire,$lctr_id_granted) { if (!$clsr_ids) return array(); global $Config; $sql="SELECT b.`clsr_id` `clsr_id` " ."FROM `reserv_classroom_occupation` b " ."WHERE " ."b.`clsr_id` IN (".$dbconn->escape($clsr_ids).") AND " ."b.`lctr_id` != ".$dbconn->escape($lctr_id_granted)." AND " ."b.`lctr_since`>UTC_TIMESTAMP() AND " .$dbconn->escape($expire,true)."<=b.`lctr_since` AND " ."( " ."SELECT MAX(a.`lctr_expire`) " ."FROM `reserv_classroom_occupation` a " ."WHERE " ."a.`lctr_id` != ".$dbconn->escape($lctr_id_granted)." AND " ."a.`clsr_id` = b.`clsr_id` AND " ."a.`lctr_expire` <= b.`lctr_since` " .") <=".$dbconn->escape($since,true)." " ."GROUP BY b.`clsr_id` " ."ORDER BY b.`clsr_id` "; return $dbconn->query_value_array($sql); } function db_load_invitation_for_member($dbconn,$mb_id_invited) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['team']}` " ."JOIN `{$Config->TableMap['compere']}` ON (`mb_id_leader`=`mb_id`) " ."NATURAL LEFT JOIN `{$Config->TableMap['file']}` " ."NATURAL LEFT JOIN `{$Config->TableMap['file_history']}` " ."WHERE " ."`mb_id_member`=".$dbconn->escape($mb_id_invited)." AND " ."`tm_status`='INVITED' "; return $dbconn->query_allrows_assoc($sql); } function db_team_is_inviting($dbconn,$mb_id_leader,$mb_id_member) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['team']}` " ."WHERE " ."`mb_id_leader`=".$dbconn->escape($mb_id_leader)." AND " ."`mb_id_member`=".$dbconn->escape($mb_id_member)." AND " ."`tm_status`='INVITED' "; return $dbconn->query_value($sql); } function db_update_team_member($dbconn,$mb_id_leader,$mb_id_member,$tm_status) { global $Config; $sql="UPDATE `{$Config->TableMap['team']}` " ."SET `tm_status`='".$dbconn->escape($tm_status)."' " ."WHERE " ."`mb_id_leader`=".$dbconn->escape($mb_id_leader)." AND " ."`mb_id_member`=".$dbconn->escape($mb_id_member); $dbconn->real_query($sql,"error.db.updatefail"); } function db_delete_team_invitation($dbconn,$mb_id_leader,$mb_id_member) { global $Config; $sql="DELETE FROM `{$Config->TableMap['team']}` " ."WHERE " ."`mb_id_leader`=".$dbconn->escape($mb_id_leader)." AND " ."`mb_id_member`=".$dbconn->escape($mb_id_member)." AND " ."`tm_status`='INVITED'"; $dbconn->real_query($sql,"error.db.deletefail"); } function db_delete_team_member($dbconn,$mb_id_leader,$mb_id_member) { global $Config; $sql="DELETE FROM `{$Config->TableMap['team']}` " ."WHERE " ."`mb_id_leader`=".$dbconn->escape($mb_id_leader)." AND " ."`mb_id_member`=".$dbconn->escape($mb_id_member); $dbconn->real_query($sql,"error.db.deletefail"); } function db_load_lecture_by_id($dbconn,$lctr_id) { if (!$lctr_id) return array(); global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['lecture']}` " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id); return $dbconn->query_row_assoc($sql); } function db_count_lectures_of_compere($dbconn,$mb_id,$unexpiredonly=true) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['lecture']}` " ."NATURAL JOIN `{$Config->TableMap['course']}` " ."WHERE " ."`lctr_status`!='DELETED' AND " ."`mb_id_owner`=".$dbconn->escape($mb_id) .($unexpiredonly?" AND UTC_TIMESTAMP()<`lctr_expire` ":' '); return $dbconn->query_value($sql); } function db_count_lectures_of_course($dbconn,$cs_id,$unexpiredonly=true) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['lecture']}` " ."WHERE " ."`lctr_status`!='DELETED' AND " ."`cs_id`=".$dbconn->escape($cs_id) .($unexpiredonly?" AND UTC_TIMESTAMP()<`lctr_expire` ":' '); return $dbconn->query_value($sql); } function db_load_lectures_of_course($dbconn,$cs_ids,$unexpired=true,$expired=false,$ascending=true,$limit=null,$offset=null) { if (!$cs_ids) return array(); global $Config; $ODIR=$ascending?"ASC":"DESC"; $sql="SELECT * " ."FROM `{$Config->TableMap['lecture']}` " ."NATURAL JOIN `{$Config->TableMap['classroom']}` " ."NATURAL JOIN `{$Config->TableMap['classroom_size']}` " ."NATURAL JOIN `{$Config->TableMap['lecture_size']}` " ."WHERE " ."`lctr_status`!='DELETED' AND " ."`cs_id` IN (".$dbconn->escape($cs_ids).") AND " ."(0 " .($unexpired?"OR UTC_TIMESTAMP()<`lctr_expire` ":' ') .($expired?"OR UTC_TIMESTAMP()>`lctr_since` ":' ') .") " ."ORDER BY `lctr_since` $ODIR, `lctr_expire` $ODIR, `lctr_id` $ODIR " ._db_limit($limit,$offset); return $dbconn->query_allrows_assoc($sql); } function db_load_lectures_of_team_member($dbconn,$mb_id_leader,$mb_id_member,$unexpiredonly=true) { global $Config; $sql="SELECT `c`.*, `cd`.`cs_name`, `sr`.*, `lctr_id`, COUNT(`ls`.`mb_id`) `staffcount` " ."FROM `{$Config->TableMap['seat_reservation']}` `sr` " ."JOIN `{$Config->TableMap['course']}` `c` USING (`cs_id`) " ."JOIN `{$Config->TableMap['course_desc']}` `cd` USING (`cs_id`) " ."JOIN `{$Config->TableMap['lecture_staff']}` `ls` USING (`lctr_id`) " ."WHERE " ."`mb_id_owner`=".$dbconn->escape($mb_id_leader)." AND " ."`ls`.`mb_id`=".$dbconn->escape($mb_id_member) .($unexpiredonly?" AND UTC_TIMESTAMP()<`lctr_expire` ":' ') ."GROUP BY `lctr_id` "; return $dbconn->query_allrows_assoc($sql); } function db_classroom_at_place($dbconn,$plc_id,$validonly=true) { global $Config; $sql="SELECT `{$Config->TableMap['classroom']}`.* " ."FROM `{$Config->TableMap['seat']}` " ."NATURAL JOIN `{$Config->TableMap['classroom_seat']}` " ."NATURAL JOIN `{$Config->TableMap['classroom']}` " ."WHERE " ."`clsr_status`='VALID' AND " ."`plc_id`=".$dbconn->escape($plc_id)." " ."GROUP BY `clsr_id` " ."ORDER BY `clsr_name`, `clsr_id` DESC"; return $dbconn->query_allrows_assoc($sql); } function db_count_reservations_at_place($dbconn,$plc_id,$unexpiredonly=true) { global $Config; $sql="SELECT COUNT(*) `count`, MAX(`lctr_expire`) `expire` " ."FROM `{$Config->TableMap['reservation']}` " ."NATURAL JOIN `{$Config->TableMap['lecture']}` " ."NATURAL JOIN `{$Config->TableMap['seat']}` " ."WHERE " ."`lctr_status`!='DELETED' AND " ."`plc_id`=".$dbconn->escape($plc_id); if ($unexpiredonly) $sql.=" AND UTC_TIMESTAMP()<`lctr_expire` "; return $dbconn->query_row_assoc($sql); } function db_count_reservations_of_compere($dbconn,$mb_id_compere,$unexpiredonly=true) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['seat_reservation']}` " ."NATURAL LEFT JOIN `{$Config->TableMap['course']}` " ."WHERE " ."`lctr_status`!='DELETED' AND " ."`mb_id_owner`=".$mb_id_compere .($unexpiredonly?" AND UTC_TIMESTAMP()<`lctr_expire` ":''); return $dbconn->query_value($sql); } function db_count_reservations_of_course_owner($dbconn,$mb_id_compere,$unexpiredonly=true) { global $Config; $sql="SELECT COUNT(*) `count`, MAX('lctr_expire') `expire` " ."FROM `{$Config->TableMap['lecture']}` " ."NATURAL LEFT JOIN `{$Config->TableMap['seat_reservation']}` " ."NATURAL LEFT JOIN `{$Config->TableMap['course']}` " ."WHERE " ."`lctr_status`!='DELETED' AND " ."`mb_id_owner`=".$mb_id_compere .($unexpiredonly?" AND UTC_TIMESTAMP()<`lctr_expire` ":''); return $dbconn->query_row_assoc($sql); } function db_count_reservations_of_course($dbconn,$cs_id,$unexpiredonly=true) { global $Config; $sql="SELECT COUNT(*) `count`, MAX(`lctr_expire`) `expire` " ."FROM `{$Config->TableMap['reservation']}` " ."NATURAL JOIN `{$Config->TableMap['lecture']}` " ."NATURAL JOIN `{$Config->TableMap['seat']}` " ."WHERE " ."`lctr_status`!='DELETED' AND " ."`cs_id`=".$dbconn->escape($cs_id); if ($unexpiredonly) $sql.=" AND UTC_TIMESTAMP()<`lctr_expire` "; return $dbconn->query_row_assoc($sql); } function db_load_supported_currency($dbconn) { global $Config; $sql="SELECT `crny_name` FROM `{$Config->TableMap['supported_currency']}` "; return $dbconn->query_value_array($sql); } function db_query_deadline($dbconn,$cs_id,$lctr_since_utc) { global $Config; $sql="SELECT reserv_compute_reserve_deadline(" ."`cp_timezone`, " ."'".$dbconn->escape($lctr_since_utc)."', " ."`crd_days_ago`, " ."`crd_hours_ago`, " ."`crd_minutes_ago`, " ."`crd_weekday`, " ."`crd_hour`, " ."`crd_minute`, " ."0" .") `deadline` " ."FROM `{$Config->TableMap['course_reserve_deadline']}` " ."NATURAL JOIN `{$Config->TableMap['course']}` `cs` " ."JOIN `{$Config->TableMap['compere']}` `cp` ON (`cs`.`mb_id_owner`=`cp`.`mb_id`) " ."WHERE " ."`cs_id`=".$dbconn->escape($cs_id); $row=$dbconn->query_row_assoc($sql); if (!$row) return $lctr_since_utc; return $row['deadline']; } function db_insert_lecture($dbconn,$lecture) { global $Config; if (!$lecture['lctr_deadline']) $lecture['lctr_deadline']=db_query_deadline($dbconn,$lecture['cs_id'],$lecture['lctr_since']); $sql="INSERT INTO `{$Config->TableMap['lecture']}` (" ."`cs_id`, `clsr_id`, `lctr_since`, `lctr_expire`, `lctr_deadline`, `lctr_status`" .") VALUES (" .$dbconn->escape($lecture['cs_id'])."," .$dbconn->escape($lecture['clsr_id'])."," .$dbconn->escape($lecture['lctr_since'],true)."," .$dbconn->escape($lecture['lctr_expire'],true)."," .$dbconn->escape($lecture['lctr_deadline'],true)."," .$dbconn->escape($lecture['lctr_status'],true) .")"; $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function db_update_lecture($dbconn,$lecture) { global $Config; $sql="UPDATE `{$Config->TableMap['lecture']}` " ."SET " ."`clsr_id`=".$dbconn->escape($lecture['clsr_id']).", " ."`lctr_since`=".$dbconn->escape($lecture['lctr_since'],true).", " ."`lctr_expire`=".$dbconn->escape($lecture['lctr_expire'],true).", " ."`lctr_status`=".$dbconn->escape($lecture['lctr_status'],true)." " ."WHERE " ."`lctr_status`!='DELETED' AND " ."`lctr_id`=".$dbconn->escape($lecture['lctr_id']); $dbconn->real_query($sql,"error.db.updatefail"); } function db_cancel_lecture($dbconn,$lctr_id,$mb_id_cancelby) { global $Config; $sql="DELETE FROM `{$Config->TableMap['lecture_staff']}` " ."WHERE `lctr_id`=".$dbconn->escape($lctr_id); $dbconn->real_query($sql,"error.db.deletefail"); $sql="INSERT INTO `{$Config->TableMap['reservation_cancel']}` (" ."`rsv_id`,`mb_id_cancelby`, `rsvc_timestamp`, `lctr_id`, `st_id`, `mb_id`, `rsv_timestamp_provisional`, `rsv_timestamp_confirmed`, `mb_id_reserver`" .") " ."SELECT " ."`rsv_id`, ".$dbconn->escape($mb_id_cancelby).", UTC_TIMESTAMP(), " ."`lctr_id`, `st_id`, `mb_id`, `rsv_timestamp_provisional`, `rsv_timestamp_confirmed`, `mb_id_reserver` " ."FROM `{$Config->TableMap['reservation']}` " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id); $dbconn->real_query($sql,"error.db.insertfail"); $sql="DELETE FROM `{$Config->TableMap['reservation']}` " ."WHERE `lctr_id`=".$dbconn->escape($lctr_id); $dbconn->real_query($sql,"error.db.deletefail"); $sql="UPDATE `{$Config->TableMap['lecture']}` " ."SET `lctr_status`='DELETED' " ."WHERE `lctr_id`=".$dbconn->escape($lctr_id); $dbconn->real_query($sql,"error.db.deletefail"); } function db_cancel_reservation($dbconn,$lctr_id,$mb_id,$st_id,$mb_id_cancelby) { global $Config; $sql="SELECT `rsv_id` " ."FROM `{$Config->TableMap['reservation']}` " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id)." AND " ."`mb_id`=".$dbconn->escape($mb_id)." AND " ."`st_id`=".$dbconn->escape($st_id)." "; $rsv_id=$dbconn->query_value($sql); $sql="INSERT INTO `{$Config->TableMap['reservation_cancel']}` (" ."`rsv_id`, `mb_id_cancelby`, `rsvc_timestamp`, `lctr_id`, `st_id`, `mb_id`, `rsv_timestamp_provisional`, `rsv_timestamp_confirmed`, `mb_id_reserver`" .") " ."SELECT " ."`rsv_id`, ".$dbconn->escape($mb_id_cancelby).", UTC_TIMESTAMP(), " ."`lctr_id`, `st_id`, `mb_id`, `rsv_timestamp_provisional`, `rsv_timestamp_confirmed`, `mb_id_reserver` " ."FROM `{$Config->TableMap['reservation']}` " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id)." AND " ."`mb_id`=".$dbconn->escape($mb_id)." AND " ."`st_id`=".$dbconn->escape($st_id)." "; $dbconn->real_query($sql,"error.db.insertfail"); $sql="DELETE FROM `{$Config->TableMap['reservation']}` " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id)." AND " ."`mb_id`=".$dbconn->escape($mb_id)." AND " ."`st_id`=".$dbconn->escape($st_id)." "; $dbconn->real_query($sql,"error.db.deletefail"); return $rsv_id; } function db_load_lecture_staff_ids($dbconn,$lctr_id) { global $Config; $sql="SELECT `mb_id` " ."FROM `{$Config->TableMap['lecture_staff']}` " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id); return $dbconn->query_value_array($sql); } function db_load_lectures_staff_ids($dbconn,$lctr_ids) { if (!$lctr_ids) return array(); global $Config; $sql="SELECT `lctr_id`, `mb_id` " ."FROM `{$Config->TableMap['lecture_staff']}` " ."WHERE " ."`lctr_id` IN (".$dbconn->escape($lctr_ids).") " ."ORDER BY `lctr_id`,`mb_id` "; return $dbconn->query_allrows_assoc($sql); } function db_save_lecture_staff($dbconn,$lctr_id,$mb_ids) { global $Config; $sql="DELETE FROM `{$Config->TableMap['lecture_staff']}` " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id) .($mb_ids?" AND `mb_id` NOT IN (".$dbconn->escape($mb_ids).")":''); $dbconn->real_query($sql,"error.db.deletefail"); $sql="REPLACE INTO `{$Config->TableMap['lecture_staff']}` (`lctr_id`, `mb_id`) VALUES "; if ($mb_ids) { $rows=array(); foreach ($mb_ids as $mb_id) array_push($rows,"(".$dbconn->escape($lctr_id).",".$dbconn->escape($mb_id).")"); $sql.=implode(',',$rows); $dbconn->real_query($sql,"error.db.insertfail"); } } function db_load_lecture_participant_ids($dbconn,$lctr_id,$confirmedness=false) { global $Config; $sql="SELECT `mb_id` " ."FROM `{$Config->TableMap['seat_reservation']}` " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id).' ' .($confirmedness=='CONFIRMED'?'AND `rsv_timestamp_confirmed` IS NOT NULL ':'') .($confirmedness=='UNCONFIRMED'?'AND `rsv_timestamp_confirmed` IS NULL ':''); return $dbconn->query_value_array($sql); } function db_load_lecture_participants($dbconn,$lctr_ids) { if (!$lctr_ids) return array(); global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['seat_reservation']}` " ."NATURAL JOIN `{$Config->TableMap['member']}` " ."WHERE " ."`lctr_id` IN (".$dbconn->escape($lctr_ids).")"; return $dbconn->query_allrows_assoc($sql); } function db_load_lecture_participant_by_id($dbconn,$lctr_ids,$mb_id) { if (!$lctr_ids) return array(); global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['seat_reservation']}` " ."NATURAL JOIN `{$Config->TableMap['member']}` " ."WHERE " ."`lctr_id` IN (".$dbconn->escape($lctr_ids).") AND " ."`mb_id`=".$dbconn->escape($mb_id); return $dbconn->query_allrows_assoc($sql); } function db_insert_message($dbconn,$msg_type,$mb_id_from,$msg_from_as,$mb_id_tos,$msg_to_ases,$file_id,$related_info=array()) { if (!is_array($mb_id_tos)) $mb_id_tos=array($mb_id_tos); global $Config; $sql="INSERT INTO `{$Config->TableMap['message']}` (" ."`mb_id_from`, `msg_from_as`, `mb_id_to`, `msg_to_as`, `msg_type`, `msg_decision`, `msg_cs_id`, `msg_lctr_id`, `msg_st_id`, `msg_id_replyto`, `file_id`" .") VALUES "; $first=true; foreach ($mb_id_tos as $id_to) { if ($first) $first=false; else $sql.=","; if (is_array($msg_to_ases)) $to_as=$msg_to_ases[$id_to]; else $to_as=$msg_to_ases; $sql.="(" .($mb_id_from?$dbconn->escape($mb_id_from):'NULL')."," .$dbconn->escape($msg_from_as,true)."," .($id_to?$dbconn->escape($id_to):'NULL')."," .$dbconn->escape($to_as,true)."," .$dbconn->escape($msg_type,true)."," .($related_info['msg_decision']?$dbconn->escape($related_info['msg_decision'],true):'NULL')."," .($related_info['msg_cs_id']?$dbconn->escape($related_info['msg_cs_id']):'NULL')."," .($related_info['msg_lctr_id']?$dbconn->escape($related_info['msg_lctr_id']):'NULL')."," .($related_info['msg_st_id']?$dbconn->escape($related_info['msg_st_id']):'NULL')."," .($related_info['msg_id_replyto']?$dbconn->escape($related_info['msg_id_replyto']):'NULL')."," .$dbconn->escape($file_id).")"; } $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function db_load_message_ids($dbconn,$msg_id_least,$file_id) { global $Config; $sql="SELECT `msg_id` " ."FROM `{$Config->TableMap['message']}` " ."WHERE " ."`msg_id`>=".$dbconn->escape($msg_id_least)." AND " ."`file_id`=".$dbconn->escape($file_id); return $dbconn->query_value_array($sql); } function db_list_messages($dbconn,$params=array(),$limit=null,$offset=null,$mb_id_unreadonly=false) { global $Config; $sql="SELECT " ."`msg`.*, `fh`.*, " ."`cp1`.`cp_name` `cp_name_from`, " ."`cp2`.`cp_name` `cp_name_to`, " ."`mb1`.`mb_nickname` `mb_nickname_from`, " ."`mb2`.`mb_nickname` `mb_nickname_to`, " ."IFNULL( `r1`.`msg_read` , 0 ) `msg_read_from`, " ."IFNULL( `r2`.`msg_read` , 0 ) `msg_read_to`, " ."`cs`.* " ."FROM `{$Config->TableMap['message']}` `msg` " ."NATURAL JOIN `{$Config->TableMap['file']}` `f` " ."NATURAL JOIN `{$Config->TableMap['file_history']}` `fh` " ."LEFT JOIN `{$Config->TableMap['message_read']}` `r1` ON (`msg`.`msg_id`=`r1`.`msg_id` AND `msg`.`mb_id_from`=`r1`.`mb_id`) " ."LEFT JOIN `{$Config->TableMap['message_read']}` `r2` ON (`msg`.`msg_id`=`r2`.`msg_id` AND `msg`.`mb_id_to`=`r2`.`mb_id`) " ."LEFT JOIN `{$Config->TableMap['compere']}` `cp1` ON (`msg`.`mb_id_from`=`cp1`.`mb_id`) " ."LEFT JOIN `{$Config->TableMap['compere']}` `cp2` ON (`msg`.`mb_id_to`=`cp2`.`mb_id`) " ."LEFT JOIN `{$Config->TableMap['member']}` `mb1` ON (`msg`.`mb_id_from`=`mb1`.`mb_id`) " ."LEFT JOIN `{$Config->TableMap['member']}` `mb2` ON (`msg`.`mb_id_to`=`mb2`.`mb_id`) " ."LEFT JOIN `{$Config->TableMap['course']}` `cs` ON (`msg`.`msg_cs_id`=`cs`.`cs_id`) " ."WHERE 1 " .($params['msg_id_replyto']?" AND `msg_id_replyto`=".$dbconn->escape($params['msg_id_replyto'])." ":'') .($params['mb_id_from']?" AND `mb_id_from`=".$dbconn->escape($params['mb_id_from'])." ":'') .($params['mb_id_to']?" AND `mb_id_to`=".$dbconn->escape($params['mb_id_to'])." ":'') .($params['msg_type']?" AND `msg_type`=".$dbconn->escape($params['msg_type'],true)." ":'') .($mb_id_unreadonly?"AND (" ."`msg`.`mb_id_from`=".$dbconn->escape($mb_id_unreadonly)." AND `r1`.`mb_id` IS NULL " ." OR " ."`msg`.`mb_id_to`=".$dbconn->escape($mb_id_unreadonly)." AND `r2`.`mb_id` IS NULL " .") ":'') ."ORDER BY `msg_id` DESC " ._db_limit($limit,$offset); return $dbconn->query_allrows_assoc($sql); } function db_count_message_replies($dbconn,$msg_id) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['message']}` " ."WHERE " ."`msg_id_replyto`=".$dbconn->escape($msg_id); return $dbconn->query_value($sql); } function db_count_messages($dbconn,$mb_id_from,$mb_id_to,$unreadonly=true) { global $Config; $sql="SELECT "; if ($unreadonly) { $fields=array(); if ($mb_id_from && $mb_id_to) $sql.="COUNT(*)-COUNT(`r1`.`msg_id` AND `r2`.`msg_id`) "; else if ($mb_id_from) $sql.="COUNT(*)-COUNT(`r1`.`msg_id`) "; else if ($mb_id_to) $sql.="COUNT(*)-COUNT(`r2`.`msg_id`) "; else return 0; } else $sql.="COUNT(*) "; $sql.="FROM `{$Config->TableMap['message']}` `msg` " .($unreadonly && $mb_id_from?"LEFT JOIN `{$Config->TableMap['message_read']}` `r1` ON (`msg`.`msg_id`=`r1`.`msg_id` AND `msg`.`mb_id_from`=`r1`.`mb_id`) ":'') .($unreadonly && $mb_id_to?"LEFT JOIN `{$Config->TableMap['message_read']}` `r2` ON (`msg`.`msg_id`=`r2`.`msg_id` AND `msg`.`mb_id_to`=`r2`.`mb_id`) ":'') ."WHERE 1 " .($mb_id_from?" AND `mb_id_from`=".$dbconn->escape($mb_id_from):'') .($mb_id_to?" AND `mb_id_to`=".$dbconn->escape($mb_id_to):''); return $dbconn->query_value($sql); } function db_load_messages($dbconn,$msg_ids) { if (!$msg_ids) return array(); if (!is_array($msg_ids)) $msg_ids=array($msg_ids); global $Config; $sql="SELECT " ."`msg`.*, `fh`.*, MAX(`msg2`.`msg_id`) `msg_id_repliedby`, " ."`cp1`.`cp_name` `cp_name_from`, " ."`cp2`.`cp_name` `cp_name_to`, " ."`mb1`.`mb_nickname` `mb_nickname_from`, " ."`mb2`.`mb_nickname` `mb_nickname_to`, " ."IFNULL( `r1`.`msg_read` , 0 ) `msg_read_from`, " ."IFNULL( `r2`.`msg_read` , 0 ) `msg_read_to`, " ."`cs`.* " ."FROM `{$Config->TableMap['message']}` `msg` " ."NATURAL JOIN `{$Config->TableMap['file']}` `f` " ."NATURAL JOIN `{$Config->TableMap['file_history']}` `fh` " ."LEFT JOIN `{$Config->TableMap['message_read']}` `r1` ON (`msg`.`msg_id`=`r1`.`msg_id` AND `msg`.`mb_id_from`=`r1`.`mb_id`) " ."LEFT JOIN `{$Config->TableMap['message_read']}` `r2` ON (`msg`.`msg_id`=`r2`.`msg_id` AND `msg`.`mb_id_to`=`r2`.`mb_id`) " ."LEFT JOIN `{$Config->TableMap['compere']}` `cp1` ON (`msg`.`mb_id_from`=`cp1`.`mb_id`) " ."LEFT JOIN `{$Config->TableMap['compere']}` `cp2` ON (`msg`.`mb_id_to`=`cp2`.`mb_id`) " ."LEFT JOIN `{$Config->TableMap['member']}` `mb1` ON (`msg`.`mb_id_from`=`mb1`.`mb_id`) " ."LEFT JOIN `{$Config->TableMap['member']}` `mb2` ON (`msg`.`mb_id_to`=`mb2`.`mb_id`) " ."LEFT JOIN `{$Config->TableMap['message']}` `msg2` ON (`msg`.`msg_id`=`msg2`.`msg_id_replyto`) " ."LEFT JOIN `{$Config->TableMap['course']}` `cs` ON (`msg`.`msg_cs_id`=`cs`.`cs_id`) " ."WHERE " ."`msg`.`msg_id` IN (".$dbconn->escape($msg_ids).") " ."GROUP BY `msg`.`msg_id` " ."ORDER BY `msg`.`msg_id` "; return $dbconn->query_allrows_assoc($sql); } function db_load_messages_filtered($dbconn,$options_and,$options_or=array()) { global $Config; $cond_and="" .($options_and['msg_lctr_id']?"`msg_lctr_id` IN (".$dbconn->escape($options_and['msg_lctr_id']).") AND ":"") .($options_and['msg_cs_id']?"`msg_cs_id` IN (".$dbconn->escape($options_and['msg_cs_id']).") AND ":"") .($options_and['mb_id_to']?"`mb_id_to` IN (".$dbconn->escape($options_and['mb_id_to']).") AND ":"") .($options_and['mb_id_from']?"`mb_id_from` IN (".$dbconn->escape($options_and['mb_id_from']).") AND ":"") .($options_and['msg_st_id']?"`msg_st_id` IN (".$dbconn->escape($options_and['msg_st_id']).") AND ":""); $cond_or="" .($options_and['msg_lctr_id']?"`msg_lctr_id` IN (".$dbconn->escape($options_and['msg_lctr_id']).") OR ":"") .($options_and['msg_cs_id']?"`msg_cs_id` IN (".$dbconn->escape($options_and['msg_cs_id']).") OR ":"") .($options_and['mb_id_to']?"`mb_id_to` IN (".$dbconn->escape($options_and['mb_id_to']).") OR ":"") .($options_and['mb_id_from']?"`mb_id_from` IN (".$dbconn->escape($options_and['mb_id_from']).") OR ":"") .($options_and['msg_st_id']?"`msg_st_id` IN (".$dbconn->escape($options_and['msg_st_id']).") OR ":""); if (!$cond_and && !$cond_or) return; $sql="SELECT * " ."FROM `{$Config->TableMap['message']}` " ."NATURAL JOIN `{$Config->TableMap['file']}` `f` " ."NATURAL JOIN `{$Config->TableMap['file_history']}` `fh` " ."WHERE " .($cond_and?$cond_and:"") .($cond_or?"( ".$cond_or." 0 ) AND ":"") ."1 "; return $dbconn->query_allrows_assoc($sql); } function db_load_lecture_messages_of_peers($dbconn,$lctr_id,$mb_id_1,$mb_id_2) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['message']}` " ."NATURAL JOIN `{$Config->TableMap['file']}` `f` " ."NATURAL JOIN `{$Config->TableMap['file_history']}` `fh` " ."WHERE " ."`msg_lctr_id`=".$dbconn->escape($lctr_id)." AND " ."( " ."`mb_id_from`=".$dbconn->escape($mb_id_1)." AND `mb_id_to`=".$dbconn->escape($mb_id_2)." OR " ."`mb_id_from`=".$dbconn->escape($mb_id_2)." AND `mb_id_to`=".$dbconn->escape($mb_id_1) .") " ."ORDER BY `msg_id` "; return $dbconn->query_allrows_assoc($sql); } function db_load_message($dbconn,$msg_id) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['message']}` " ."WHERE " ."`msg_id`=".$dbconn->escape($msg_id); return $dbconn->query_row_assoc($sql); } function db_set_message_attrib($dbconn,$msg_ids,$msga_prop,$msga_value) { if (!$msg_ids) return; if (!is_array($msg_ids)) $msg_ids=array($msg_ids); global $Config; $sql="REPLACE INTO `{$Config->TableMap['message_attrib']}` (" ."`msg_id`, `msga_prop`, `msga_value`" .") VALUES "; $prefix="("; $suffix=",".$dbconn->escape($msga_prop,true).",".$dbconn->escape($msga_value,true).")"; $first=true; foreach ($msg_ids as $msg_id) { if ($first) $first=false; else $sql.=","; $sql.=$prefix.$dbconn->escape($msg_id).$suffix; } $dbconn->real_query($sql,"error.db.insertfail"); } function db_get_message_attrib($dbconn,$msg_ids) { if (!$msg_ids) return array(); if (!is_array($msg_ids)) $msg_ids=array($msg_ids); global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['message_attrib']}` " ."WHERE " ."`msg_id` IN (".$dbconn->escape($msg_ids).") " ."ORDER BY `msg_id` "; return $dbconn->query_allrows_assoc($sql); } function db_load_message_neighbour_id($dbconn,$msg_id_cur,$next,$mb_id_to=null,$mb_id_from=null) { global $Config; $sql="SELECT `msg_id` " ."FROM `{$Config->TableMap['message']}` " ."WHERE 1 " .($mb_id_to?" AND `mb_id_to`=".$dbconn->escape($mb_id_to)." ":"") .($mb_id_from?" AND `mb_id_from`=".$dbconn->escape($mb_id_from)." ":"") .($next?" AND `msg_id`>".$dbconn->escape($msg_id_cur)." ":"") .(!$next?" AND `msg_id`<".$dbconn->escape($msg_id_cur)." ":"") .($next?"ORDER BY `msg_id` ASC LIMIT 1 ":"") .(!$next?"ORDER BY `msg_id` DESC LIMIT 1 ":""); return $dbconn->query_value($sql); } function db_load_unread_message_neighbour_id($dbconn,$mb_id_reader,$msg_id_cur,$next,$mb_id_to=null,$mb_id_from=null) { global $Config; $sql="SELECT `msg_id` " ."FROM `{$Config->TableMap['message']}` " ."WHERE " ."`msg_id` NOT IN (" ."SELECT `msg_id` " ."FROM `{$Config->TableMap['message_read']}` " ."WHERE " ."`msg_read` AND " ."`mb_id`=".$dbconn->escape($mb_id_reader) .") " .($mb_id_to?" AND `mb_id_to`=".$dbconn->escape($mb_id_to)." ":"") .($mb_id_from?" AND `mb_id_from`=".$dbconn->escape($mb_id_from)." ":"") .($next?" AND `msg_id`>".$dbconn->escape($msg_id_cur)." ":"") .(!$next?" AND `msg_id`<".$dbconn->escape($msg_id_cur)." ":"") .($next?"ORDER BY `msg_id` ASC LIMIT 1 ":"") .(!$next?"ORDER BY `msg_id` DESC LIMIT 1 ":""); return $dbconn->query_value($sql); } function db_set_message_read($dbconn,$msg_id,$mb_id,$read=true) { global $Config; $sql="INSERT IGNORE `{$Config->TableMap['message_read']}` (" ."`msg_id`, `mb_id`, `msg_read`, `msgr_timestamp`" .") VALUES (" .$dbconn->escape($msg_id).", " .$dbconn->escape($mb_id).", " .($read?'1':'0').", " ."UTC_TIMESTAMP()) "; $dbconn->real_query($sql,"error.db.updatefail"); } function db_load_lecture_size($dbconn,$lctr_id) { global $Config; $sql="SELECT lctr_size " ."FROM `{$Config->TableMap['lecture_size']}` " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id); return $dbconn->query_value($sql); } function db_load_lecture_size_by_place_classroom($dbconn,$lctr_id,$plc_id=null,$clsr_id=null,$available_only=false) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['lecture_size_by_place_classroom']}` " ."NATURAL JOIN `{$Config->TableMap['classroom']}` " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id)." " .($plc_id?"AND `plc_id`=".$dbconn->escape($plc_id)." ":' ') .($clsr_id?"AND `clsr_id`=".$dbconn->escape($clsr_id)." ":' ') .($available_only?"AND `lctr_size`<`clsr_size` ":' '); return $dbconn->query_allrows_assoc($sql); } function db_load_classroom_size_by_place($dbconn,$clsr_id,$plc_id=null) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['classroom_size_by_place']}` `csp` " ."WHERE " ."`clsr_id`=".$dbconn->escape($clsr_id)." " .($plc_id?"AND `csp`.`plc_id`=".$dbconn->escape($plc_id)." ":' '); return $dbconn->query_allrows_assoc($sql); } function db_list_places_of_lecture($dbconn,$lctr_id) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['lecture']}` `l` " ."NATURAL JOIN `{$Config->TableMap['course_classroom']}` `cc` " ."NATURAL JOIN `{$Config->TableMap['classroom_size_by_place']}` `csbp` " ."NATURAL JOIN `{$Config->TableMap['place']}` `p` " ."NATURAL LEFT JOIN `{$Config->TableMap['lecture_size_by_place_classroom']}` `lsbp` " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id)." " ."GROUP BY `plc_id` " ."ORDER BY `plc_name` "; return $dbconn->query_allrows_assoc($sql); } function db_pick_seat_available_for_lecture($dbconn,$lctr_id,$plc_id,$clsr_id,$num_seats=1) { global $Config; $sql="SELECT `st_id` " ."FROM `{$Config->TableMap['lecture']}` " ."NATURAL JOIN {$Config->TableMap['classroom_seat']} " ."NATURAL JOIN {$Config->TableMap['seat']} " ."NATURAL JOIN {$Config->TableMap['seat_vacancy']} " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id)." AND " ."`plc_id`=".$dbconn->escape($plc_id)." AND " ."`clsr_id`=".$dbconn->escape($clsr_id)." AND " ."`stv_since`<=`lctr_since` AND " ."`lctr_expire`<=`stv_expire` " ."ORDER BY `st_no` " ."LIMIT ".$num_seats; return $dbconn->query_value_array($sql); } function db_load_reservation($dbconn,$lctr_id,$st_id,$mb_id) { if (!$lctr_id || !$st_id || !$mb_id) return array(0); global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['reservation']}` " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id)." AND " ."`st_id`=".$dbconn->escape($st_id)." AND " ."`mb_id`=".$dbconn->escape($mb_id); return $dbconn->query_row_assoc($sql); } function db_load_reservation2($dbconn,$lctr_id,$st_id) { if (!$lctr_id || !$st_id) return array(0); global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['reservation']}` " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id)." AND " ."`st_id`=".$dbconn->escape($st_id); return $dbconn->query_row_assoc($sql); } function db_load_reservation_by_id($dbconn,$rsv_id) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['reservation']}` " ."WHERE " ."`rsv_id`=".$dbconn->escape($rsv_id); return $dbconn->query_row_assoc($sql); } function db_list_reservation_summary($dbconn,$mb_ids,$lctr_ids=false,$unexpired=true,$offset=false,$limit=false) { global $Config; $sql="SELECT " ."`lctr`.`lctr_id`, `r`.`mb_id` `mb_id_participant`, " ."`cd`.*, `s`.*, `plc_name`, `clsr_name`, `lctr_since`, `lctr_expire`, `lctr_deadline`, " ."MAX(`rsv_timestamp_confirmed`) `rsv_timestamp_confirmed`, " ."COUNT(`rsv_timestamp_confirmed`)=COUNT(*) `rsv_all_confirmed`, " ."`ls`.`mb_id` IN (".$dbconn->escape($mb_ids).") `is_staff`, " ."`c`.`mb_id_owner` IN (".$dbconn->escape($mb_ids).") `is_cs_owner`, " ."NOT ISNULL(`cc`.`mb_id`) `is_in_course_circle`, " ."COUNT(`st_id`) `lctr_size`, `c`.`cs_currency` " ."FROM `{$Config->TableMap['lecture']}` `lctr` " ."LEFT JOIN `{$Config->TableMap['reservation']}` `r` USING (`lctr_id`) " ."LEFT JOIN `{$Config->TableMap['seat']}` `s` USING (`st_id`) " ."LEFT JOIN `{$Config->TableMap['classroom']}` `clsr` USING (`clsr_id`) " ."LEFT JOIN `{$Config->TableMap['place']}` `p` USING (`plc_id`) " ."LEFT JOIN `{$Config->TableMap['course']}` `c` USING (`cs_id`) " ."LEFT JOIN `{$Config->TableMap['course_desc']}` `cd` USING (`cs_id`) " ."LEFT JOIN `{$Config->TableMap['lecture_staff']}` `ls` USING (`lctr_id`) " ."LEFT JOIN `{$Config->TableMap['course_circle']}` `cc` ON (`cc`.`cs_id`=`c`.`cs_id` AND `cc`.`mb_id`=`r`.`mb_id`) " ."WHERE 1 " ." AND `lctr_status`!='DELETED' " .($unexpired?"AND UTC_TIMESTAMP()<=`lctr_expire` ":"AND UTC_TIMESTAMP()>=`lctr_since` ") .($lctr_ids?"AND `lctr_id` IN (".$dbconn->escape($lctr_ids).") ":'') .($mb_ids?"AND (`r`.`mb_id` IN (".$dbconn->escape($mb_ids).") OR `ls`.`mb_id` IN (".$dbconn->escape($mb_ids).")) ":'') ."GROUP BY `lctr_id` " ."ORDER BY " .($unexpired?"`lctr_since`, `lctr_expire` ":"`lctr_expire` DESC, `lctr_since` DESC ") ._db_limit($limit,$offset); return $dbconn->query_allrows_assoc($sql); } function _db_group_compare($dbconn,$operator,$left_fields,$right_fields) { $clause=''; foreach ($left_fields as $lf) foreach ($right_fields as $rf) { if ($clause) $clause.=' AND '; $clause.=$lf.$operator.$rf; } return $clause; } function _db_group_min_timediff($dbconn,$lb_fields,$ub_fields,$minimum) { $clause=''; foreach ($lb_fields as $lb) foreach ($ub_fields as $ub) { if ($clause) $clause.=' AND '; $clause.='DATE_ADD('.$lb.','.$minimum.')<'.$ub; } return $clause; } function db_list_reservable_time_of_courses_sql($dbconn) { global $Config; $lb_fields=array('`cv`.`cpv_since`','`clv`.`clsrv_since`'); $ub_fields=array('`cv`.`cpv_expire`','`clv`.`clsrv_expire`'); $sql="SELECT " ."`cs_id`, `mb_id`, " ."GREATEST(".implode(',',$lb_fields).") `cat_since`, " ."LEAST(".implode(',',$ub_fields).") `cat_expire` " ."FROM `{$Config->TableMap['course_staff']}` `cs` " ."NATURAL JOIN `{$Config->TableMap['course']}` `c` " ."NATURAL JOIN `{$Config->TableMap['course_classroom']}` `cc` " ."NATURAL JOIN `{$Config->TableMap['compere_vacancy']}` `cv` " ."NATURAL JOIN `{$Config->TableMap['classroom_vacancy']}` `clv` " ."WHERE " ._db_group_compare($dbconn,'<',$lb_fields,$ub_fields)." AND " ._db_group_min_timediff($dbconn,$lb_fields,$ub_fields,' INTERVAL `c`.`cs_minutes_min` MINUTE')." " ."ORDER BY `cs_id`, `cat_since`, `mb_id` "; return $sql; } function db_list_vacant_time($dbconn,$mb_id,$utc_from,$utc_to) { global $Config; $sql="SELECT `mb_id`, GREATEST(`la_since`, UTC_TIMESTAMP()) `la_since`, `la_expire` " ."FROM `{$Config->TableMap['lecture_addable']}` " ."WHERE " ."`mb_id`=".$dbconn->escape($mb_id)." AND " ."`la_since`<=".$dbconn->escape($utc_to,true)." AND " ."`la_expire`>".$dbconn->escape($utc_from,true)." " ."GROUP BY `la_since`, `la_expire`" ."HAVING `la_since`<=`la_expire`"; return $dbconn->query_allrows_assoc($sql); } function db_list_joinable_lecture_time($dbconn,$cs_id=null,$mb_id=null,$limit=null,$offset=null,$selector=array('VACANCY','LECTURE')) { global $Config; $sql_vacancy="SELECT " ."`cs_id`, `mb_id`, " ."GREATEST(`la_since`,reserv_compute_reserve_starttime(`cp`.`cp_timezone`, ".$Config->ReservMinutesMargin.", `crd`.`crd_days_ago`, `crd`.`crd_hours_ago`, `crd`.`crd_minutes_ago`, `crd`.`crd_weekday`, `crd`.`crd_hour`, `crd`.`crd_minute`, 0)) `la_since`, " ."`la_expire`, `lctr_id`, `la_deadline` `deadline`, " ."LEAST(`cs_member_max`, `clsr_size`) `vacant_seats`, " ."UTC_TIMESTAMP()<DATE_SUB(`la_deadline`, INTERVAL ".$Config->ReservMinutesMargin." MINUTE) `cancatchup` " ."FROM `{$Config->TableMap['lecture_addable_with_deadline']}` `lawd` " ."NATURAL JOIN `{$Config->TableMap['course']}` `cs` " ."NATURAL JOIN `{$Config->TableMap['course_classroom']}` " ."NATURAL JOIN `{$Config->TableMap['classroom_size']}` " ."NATURAL JOIN `{$Config->TableMap['compere']}` `cp` " ."NATURAL LEFT JOIN `{$Config->TableMap['course_reserve_deadline']}` `crd` " ."NATURAL LEFT JOIN `{$Config->TableMap['course_weekly_minutes_max']}` `cwmm` " ."WHERE " ."UTC_TIMESTAMP()<`la_expire` AND " ."DATE_ADD(`la_deadline`, INTERVAL `cs`.`cs_minutes_min` MINUTE)<=`la_expire` AND " ."( " ."`cwmm`.`cgl_limit_max` IS NULL OR " ."`cs`.`cs_minutes_min`<=`cwmm`.`cgl_limit_max` AND " ."NOT EXISTS (" ."SELECT * " ."FROM `{$Config->TableMap['course_weekly_minutes_avail']}` `cwma` " ."WHERE " ."`cwma`.`cs_id`=`lawd`.`cs_id` AND " ."( " ."`cgv_yearweek0`=YEARWEEK(`lawd`.`la_since`,0) OR " ."`cgv_yearweek1`=YEARWEEK(`lawd`.`la_since`,1) " .") AND " ."`cs`.`cs_minutes_min`>`cgv_minutes_avail` " .") " .") " .($cs_id?"AND `cs_id`=".$dbconn->escape($cs_id)." ":'') .($mb_id?"AND `mb_id`=".$dbconn->escape($mb_id)." ":'') ."HAVING `cancatchup` "; $sql_lecture="SELECT " ."`cs_id`, `mb_id_owner` `mb_id`, `lctr_since` `la_since`, `lctr_expire` `la_expire`, `lctr_id`, `lctr_deadline` `deadline`, " ."LEAST(`cs_member_max`, `clsr_size`)-`lctr_size` `vacant_seats`, " ."1 `cancatchup` " ."FROM `{$Config->TableMap['lecture']}` `l` " ."NATURAL JOIN `{$Config->TableMap['course']}` " ."NATURAL JOIN `{$Config->TableMap['lecture_size']}` " ."NATURAL JOIN `{$Config->TableMap['classroom_size']}` " ."WHERE " ."`lctr_status`='OPEN' AND " ."`lctr_deadline`>UTC_TIMESTAMP() AND " ."`lctr_size`<`clsr_size` AND " ."`lctr_size`<`cs_member_max` " .($cs_id?"AND `cs_id`=".$dbconn->escape($cs_id)." ":'') .($mb_id?"AND ".$dbconn->escape($mb_id)." IN (" ."SELECT `mb_id` " ."FROM `{$Config->TableMap['lecture_staff']}` `ls` " ."WHERE " ."`l`.`lctr_id`=`ls`.`lctr_id` " .") ":''); if (in_array('VACANCY',$selector) && in_array('LECTURE',$selector)) $sql="( ".$sql_vacancy." ) UNION ( ".$sql_lecture." ) "; else if (in_array('VACANCY',$selector)) $sql=$sql_vacancy; else if (in_array('LECTURE',$selector)) $sql=$sql_lecture; if ($sql) { $sql.="ORDER BY `la_since`, `la_expire` " ._db_limit($limit,$offset); return $dbconn->query_allrows_assoc($sql); } return array(); } function db_load_course_reserve_deadline($dbconn,$cs_id) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['course_reserve_deadline']}` " ."WHERE " ."`cs_id`=".$dbconn->escape($cs_id); return $dbconn->query_row_assoc($sql); } function db_set_course_reserve_deadline($dbconn,$cs_id,$deadline) { global $Config; $sql="REPLACE INTO `{$Config->TableMap['course_reserve_deadline']}` (" ."`cs_id`, `crd_days_ago`, `crd_hours_ago`, `crd_minutes_ago`, `crd_weekday`, `crd_hour`, `crd_minute`" .") VALUES (" .$dbconn->escape($cs_id)."," .($deadline['crd_days_ago']!=''?$dbconn->escape($deadline['crd_days_ago']):'NULL')."," .($deadline['crd_hours_ago']!=''?$dbconn->escape($deadline['crd_hours_ago']):'NULL')."," .($deadline['crd_minutes_ago']!=''?$dbconn->escape($deadline['crd_minutes_ago']):'NULL')."," .($deadline['crd_weekday']!=''?$dbconn->escape($deadline['crd_weekday']):'NULL')."," .($deadline['crd_hour']!=''?$dbconn->escape($deadline['crd_hour']):'NULL')."," .($deadline['crd_minute']!=''?$dbconn->escape($deadline['crd_minute']):'NULL').")"; $dbconn->real_query($sql,"error.db.insertfail"); } function db_load_similar_lectures_by_time($dbconn,$cs_id,$time_since,$time_expire,$availonly=true,$limit=10) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['lecture']}` " ."NATURAL JOIN `{$Config->TableMap['course']}` " ."NATURAL JOIN `{$Config->TableMap['lecture_size']}` " ."NATURAL JOIN `{$Config->TableMap['classroom_size']}` " ."WHERE " ."`lctr_status`!='DELETED' " .($cs_id?"AND `cs_id`=".$dbconn->escape($cs_id)." ":'') .($availonly?"AND `lctr_size`<`clsr_size` AND `lctr_size`<`cs_member_max` AND `lctr_deadline`>UTC_TIMESTAMP() ":'') ."ORDER BY " ."POW(TIMESTAMPDIFF(MINUTE,`lctr_since`,".$dbconn->escape($time_since,true)."),2)+" ."POW(TIMESTAMPDIFF(MINUTE,`lctr_expire`,".$dbconn->escape($time_expire,true)."),2) " ._db_limit($limit); return $dbconn->query_allrows_assoc($sql); } function db_list_participants($dbconn,$lctr_id,$confirmedonly=false,$recindex=false) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['seat_reservation']}` " ."NATURAL JOIN `{$Config->TableMap['member']}` " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id)." " .($confirmedonly?"AND `rsv_timestamp_confirmed` IS NOT NULL ":"") ."ORDER BY `rsv_timestamp_provisional` DESC " .($recindex===false?'':'LIMIT '.$dbconn->escape($recindex).',1 '); return $dbconn->query_allrows_assoc($sql); } function db_list_participants_fullinfo($dbconn,$lctr_id,$confirmedonly=false,$recindex=false) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['seat_reservation']}` " ."NATURAL JOIN `{$Config->TableMap['member']}` " ."NATURAL JOIN `{$Config->TableMap['member_info']}` " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id)." " .($confirmedonly?"AND `rsv_timestamp_confirmed` IS NOT NULL ":"") ."ORDER BY `rsv_timestamp_provisional` DESC " .($recindex===false?'':'LIMIT '.$dbconn->escape($recindex).',1 '); return $dbconn->query_allrows_assoc($sql); } function db_count_reservations_of_lecture($dbconn,$lctr_id,$mb_id_participant=false,$confirmedonly=false) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['seat_reservation']}` " ."WHERE " ."`lctr_id`=".$dbconn->escape($lctr_id)." " .($mb_id_participant?"AND `mb_id`=".$dbconn->escape($mb_id_participant)." ":'') .($confirmedonly?"AND `rsv_timestamp_confirmed` IS NOT NULL ":'') ."ORDER BY `rsv_timestamp_provisional` DESC "; return $dbconn->query_value($sql); } function db_load_course_circle($dbconn,$cs_ids=false,$mb_ids=false) { if (!$cs_ids && !$mb_ids) return array(); global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['course_circle']}` " ."WHERE 1 " .($cs_ids?"AND `cs_id` IN (".$dbconn->escape($cs_ids).")":"") .($mb_ids?"AND `mb_id` IN (".$dbconn->escape($mb_ids).")":""); return $dbconn->query_allrows_assoc($sql); } function db_delete_circle_member($dbconn,$cs_ids=false,$mb_ids=false) { if (!$cs_ids && !$mb_ids) return; global $Config; $sql="DELETE FROM `{$Config->TableMap['course_circle']}` " ."WHERE 1 " .($cs_ids?"AND `cs_id` IN (".$dbconn->escape($cs_ids).")":"") .($mb_ids?"AND `mb_id` IN (".$dbconn->escape($mb_ids).")":""); $dbconn->real_query($sql,"error.db.deletefail"); } function db_load_notifying_emails($dbconn,$mb_ids) { if (!$cs_ids && !$mb_ids) return array(); global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['member_email']}` " ."WHERE " ."`mb_id` IN (".$dbconn->escape($mb_ids).") AND " ."`me_notify`"; return $dbconn->query_allrows_assoc($sql); } function db_insert_validation_code($dbconn,$vc_code) { global $Config; $sql="DELETE FROM `{$Config->TableMap['validation_code']}` " ."WHERE " ."`vc_timestamp`<DATE_SUB(UTC_TIMESTAMP(),INTERVAL ".$Config->VALIDATION_LIFE_DAYS." DAY) "; $dbconn->real_query($sql,"error.db.deletefail"); $sql="INSERT INTO `{$Config->TableMap['validation_code']}` (" ."`vc_code`, `vc_timestamp`" .") VALUES (" .$vc_code.", " ."UTC_TIMESTAMP()" .") "; $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function db_delete_validation_code($dbconn,$vc_id,$vc_code) { global $Config; $sql="DELETE FROM `{$Config->TableMap['validation_code']}` " ."WHERE " ."`vc_timestamp`<DATE_SUB(UTC_TIMESTAMP(),INTERVAL ".$Config->VALIDATION_LIFE_DAYS." DAY) "; $dbconn->real_query($sql,"error.db.deletefail"); $sql="DELETE FROM `{$Config->TableMap['validation_code']}` " ."WHERE " ."`vc_id`=".$dbconn->escape($vc_id)." AND " ."`vc_code`=".$dbconn->escape($vc_code); $dbconn->real_query($sql,"error.db.deletefail"); return $dbconn->affected_rows(); } function db_count_member_email($dbconn,$mb_id,$email=false,$validatedonly=false) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['member_email']}` " ."WHERE " ."`mb_id`=".$dbconn->escape($mb_id)." " .($email?"AND `mb_email`=".$dbconn->escape($email,true):'')." " .($validatedonly?"AND `me_status`='VALIDATED' ":''); return $dbconn->query_value($sql); } function db_count_member_phone($dbconn,$mb_id,$phone=false) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['member_phone']}` " ."WHERE " ."`mb_id`=".$dbconn->escape($mb_id)." " .($phone?"AND `mb_phone`=".$dbconn->escape($phone,true):''); return $dbconn->query_value($sql); } function db_set_course_info_requests($dbconn,$cs_id,$id_fields) { global $Config; $sql="DELETE FROM `{$Config->TableMap['course_info_request']}` " ."WHERE " ."`cs_id`=".$dbconn->escape($cs_id)." " .($id_fields?"AND `id_field` NOT IN (".$dbconn->escape($id_fields,true).")":""); $dbconn->real_query($sql,"error.db.deletefail"); if (!$id_fields) return; if (!is_array($id_fields)) $id_fields=array($id_fields); $sql="INSERT IGNORE INTO `{$Config->TableMap['course_info_request']}` (" ."`cs_id`, `id_field`" .") VALUES "; $first=true; foreach ($id_fields as $field) { if ($first) $first=false; else $sql.=", "; $sql.="(".$dbconn->escape($cs_id).", ".$dbconn->escape($field,true).")"; } $dbconn->real_query($sql,"error.db.insertfail"); } function db_get_course_info_requests($dbconn,$cs_id) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['course_info_request']}` " ."WHERE " ."`cs_id`=".$dbconn->escape($cs_id); return $dbconn->query_allrows_assoc($sql); } function db_add_info_disclose($dbconn,$mb_id_from,$mb_id_team_leader,$id_fields) { if (!$id_fields) return; if (!is_array($id_fields)) $id_fields=array($id_fields); global $Config; $sql="INSERT IGNORE INTO `{$Config->TableMap['info_disclose']}` (" ."`mb_id_from`, `mb_id_team_leader`, `id_field`" .") VALUES "; $first=true; foreach ($id_fields as $field) { if ($first) $first=false; else $sql.=", "; $sql.="(" .$dbconn->escape($mb_id_from).", " .$dbconn->escape($mb_id_team_leader).", " .$dbconn->escape($field,true) .")"; } $dbconn->real_query($sql,"error.db.insertfail"); } function db_set_info_disclose($dbconn,$mb_id_from,$mb_id_team_leader,$id_fields) { global $Config; $sql="DELETE FROM `{$Config->TableMap['info_disclose']}` " ."WHERE " ."`mb_id_from`=".$dbconn->escape($mb_id_from)." AND " ."`mb_id_team_leader`=".$dbconn->escape($mb_id_team_leader)." AND " .($id_fields?"`id_field` NOT IN (".$dbconn->escape($id_fields,true).")":"1 "); $dbconn->real_query($sql,"error.db.deletefail"); db_add_info_disclose($dbconn,$mb_id_from,$mb_id_team_leader,$id_fields); } function db_get_info_disclose($dbconn,$mb_id_from,$mb_id_staff=false) { global $Config; $sql="SELECT DISTINCT `id`.* " ."FROM `{$Config->TableMap['info_disclose']}` `id` " ."JOIN `{$Config->TableMap['course']}` `c` ON (`id`.`mb_id_team_leader`=`c`.`mb_id_owner`) " ."JOIN `{$Config->TableMap['lecture']}` `l` ON (`c`.`cs_id`=`l`.`cs_id`) " ."JOIN `{$Config->TableMap['lecture_staff']}` `ls` ON (`ls`.`lctr_id`=`l`.`lctr_id`) " ."WHERE " ."`mb_id_from`=".$dbconn->escape($mb_id_from)." AND " .($mb_id_staff?"(`ls`.`mb_id`=".$dbconn->escape($mb_id_staff)." OR `c`.`mb_id_owner`=".$dbconn->escape($mb_id_staff)." )AND ":"") ."1"; return $dbconn->query_allrows_assoc($sql); } function db_insert_billboard($dbconn,$mb_id_author,$file_id,$bb_id_head=false,$bb_id_replyto=false) { global $Config; $sql="INSERT INTO `{$Config->TableMap['billboard']}` (" ."`mb_id_author`, `bb_id_head`, `bb_id_replyto`, `file_id`, `bb_timestamp`" .") VALUES (" .$dbconn->escape($mb_id_author,true).", " .($bb_id_head?$dbconn->escape($bb_id_head,true):'0').", " .($bb_id_replyto?$dbconn->escape($bb_id_replyto,true):'NULL').", " .$dbconn->escape($file_id,true).", UTC_TIMESTAMP()) "; $dbconn->real_query($sql,"error.db.insertfail"); $bb_id=$dbconn->insert_id(); if (!$bb_id_head) { $sql="UPDATE `{$Config->TableMap['billboard']}` " ."SET `bb_id_head`=".$dbconn->escape($bb_id,true)." " ."WHERE `bb_id`=".$dbconn->escape($bb_id,true); $dbconn->real_query($sql,"error.db.updatefail"); } return $bb_id; } function db_add_billboard_reader_and($dbconn,$bb_id,$reader_scope=array()) { global $Config; $sql="INSERT IGNORE `{$Config->TableMap['billboard_reader']}` (" ."`bb_id`, `cs_id`, `lctr_id`, `mb_id_reader`" .") VALUES (" .$dbconn->escape($bb_id).", " .($reader_scope['cs_id']?$dbconn->escape($reader_scope['cs_id']):'NULL').", " .($reader_scope['lctr_id']?$dbconn->escape($reader_scope['lctr_id']):'NULL').", " .($reader_scope['mb_id_reader']?$dbconn->escape($reader_scope['mb_id_reader']):'NULL').")"; $dbconn->real_query($sql,"error.db.insertail"); } function db_load_billboard($dbconn,$mb_id_current=false,$reader_scope=array(),$ignorable_fields=array(),$offset=false,$limit=false) { global $Config; $condition=""; $relate=array(); $relate_lecture=false; foreach ($reader_scope as $key=>$scope) { if ($scope) { switch ($key) { case 'cs_id': $condition.="AND `br`.`cs_id`=".$dbconn->escape($scope)." "; break; case 'lctr_id': $condition.="AND ( " ."`ls`.`lctr_id`=".$dbconn->escape($scope)." OR " ."`rsv`.`lctr_id`=".$dbconn->escape($scope)." " .") "; if ($mb_id_current) { $condition.="AND ( " ."`c`.`mb_id_owner`=".$dbconn->escape($mb_id_current)." OR " ."`ls`.`mb_id`=".$dbconn->escape($mb_id_current)." OR " ."`rsv`.`mb_id`=".$dbconn->escape($mb_id_current)." " .") "; } $condition.="AND ( " ."`br`.`mb_id_reader` IS NULL " .($mb_id_current?"OR `br`.`mb_id_reader`=".$dbconn->escape($mb_id_current)." ":'') .($mb_id_current?"OR `b`.`mb_id_author`=".$dbconn->escape($mb_id_current)." ":'') .") "; $relate_lecture=true; break; case 'mb_id_reader': $condition.="AND ("; $condition.="`br`.`mb_id_reader` IN (".$dbconn->escape($scope).($mb_id_current?",".$dbconn->escape($mb_id_current):"").") "; if ($mb_id_current) $condition.="AND `mb_id_author` IN (".$dbconn->escape($mb_id_current).",".$dbconn->escape($scope).") "; $condition.="OR `mb_id_reader` IS NULL) "; break; default: trigger_error("Unsupported reader_scope key: ".$key,E_USER_ERROR); } } } if ($ignorable_fields) { $condition.="AND ("; $first=true; foreach ($ignorable_fields as $field) { if ($first) $first=false; else $condition.="OR "; $condition.="`".$key."` IS NULL "; } $condition.=") "; } $sql="SELECT " ."`b`.*, `fh`.*, " ."`mba`.`mb_nickname` `mb_nickname_author`, `mbc`.`cp_name` `cp_name_author` " ."FROM `{$Config->TableMap['billboard']}` `b` " ."NATURAL JOIN `{$Config->TableMap['billboard_reader']}` `br` " ."NATURAL JOIN `{$Config->TableMap['file']}` `f` " ."NATURAL JOIN `{$Config->TableMap['file_history']}` `fh` " ."JOIN `{$Config->TableMap['member']}` `mba` ON (`mba`.`mb_id`=`b`.`mb_id_author`) " ."LEFT JOIN `{$Config->TableMap['compere']}` `mbc` ON (`mbc`.`mb_id`=`b`.`mb_id_author`) "; if ($relate_lecture) $sql.="LEFT JOIN `{$Config->TableMap['reservation']}` `rsv` ON (`br`.`lctr_id`=`rsv`.`lctr_id`) " ."LEFT JOIN `{$Config->TableMap['lecture_staff']}` `ls` ON (`br`.`lctr_id`=`ls`.`lctr_id`) " ."LEFT JOIN `{$Config->TableMap['lecture']}` `l` ON (`br`.`lctr_id`=`l`.`lctr_id`) " ."LEFT JOIN `{$Config->TableMap['course']}` `c` ON (`c`.`cs_id`=`l`.`cs_id`) "; $sql.="WHERE 1 ".$condition ."GROUP BY `bb_id` " ."ORDER BY `bb_id` DESC " ._db_limit($limit,$offset); return $dbconn->query_allrows_assoc($sql); } function db_load_billboard_reader($dbconn,$bb_ids) { if (!$bb_ids) return array(); global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['billboard_reader']}` " ."WHERE " ."`bb_id` IN (".$dbconn->escape($bb_ids).")"; return $dbconn->query_allrows_assoc($sql); } function db_load_billboard_lecture_history($dbconn,$mb_id_reader,$cs_id,$lctr_id,$mb_id_peer,$offset=false,$limit=false) { global $Config; $sql="SELECT `fh`.*, `m`.`mb_nickname`, `b`.*, `l`.`lctr_since`, `l`.`lctr_id`, `r`.`mb_id` `mb_id_to` " ."FROM `{$Config->TableMap['billboard']}` `b` " ."NATURAL JOIN `{$Config->TableMap['file']}` `f` " ."NATURAL JOIN `{$Config->TableMap['file_history']}` `fh` " ."NATURAL JOIN `{$Config->TableMap['billboard_reader']}` `br` " ."JOIN `{$Config->TableMap['member']}` `m` ON (`m`.`mb_id`=`b`.`mb_id_author`) " ."JOIN `{$Config->TableMap['lecture']}` `l` ON (`l`.`lctr_id`=`br`.`lctr_id`) " ."JOIN `{$Config->TableMap['lecture_staff']}` `ls` ON (`l`.`lctr_id`=`ls`.`lctr_id`) " ."JOIN `{$Config->TableMap['course']}` `c` ON (`c`.`cs_id`=`l`.`cs_id`) " ."JOIN `{$Config->TableMap['reservation']}` `r` ON (`r`.`lctr_id`=`br`.`lctr_id`) " ."WHERE " .($mb_id_reader?"(" ."`mb_id_reader`=".$dbconn->escape($mb_id_reader)." OR " ."`mb_id_author`=".$dbconn->escape($mb_id_reader)." OR " ."( " ."`br`.`lctr_id` IS NOT NULL AND " ."`br`.`mb_id_reader` IS NULL AND " ."( " ."`c`.`mb_id_owner`=".$dbconn->escape($mb_id_reader)." OR " ."`ls`.`mb_id`=".$dbconn->escape($mb_id_reader)." OR " ."`r`.`mb_id`=".$dbconn->escape($mb_id_reader)." " .") " .") " .") AND ":'') .($mb_id_peer?"(" ."`mb_id_reader`=".$dbconn->escape($mb_id_peer)." OR " ."`mb_id_author`=".$dbconn->escape($mb_id_peer)." OR " ."( " ."`br`.`lctr_id` IS NOT NULL AND " ."`br`.`mb_id_reader` IS NULL AND " ."( " ."`c`.`mb_id_owner`=".$dbconn->escape($mb_id_peer)." OR " ."`ls`.`mb_id`=".$dbconn->escape($mb_id_peer)." OR " ."`r`.`mb_id`=".$dbconn->escape($mb_id_peer)." " .") " .") " .") AND ":'') .($lctr_id?"`br`.`lctr_id`=".$dbconn->escape($lctr_id)." AND ":'') .($cs_id?"`l`.`cs_id`=".$dbconn->escape($cs_id)." AND ":'') ."1 " ."GROUP BY `bb_id` " ."ORDER BY `bb_id` DESC " ._db_limit($limit,$offset); return $dbconn->query_allrows_assoc($sql); } function db_load_billboard_by_id($dbconn,$bb_id) { global $Config; $sql="SELECT `fh`.*, `b`.* " ."FROM `{$Config->TableMap['billboard']}` `b` " ."NATURAL JOIN `{$Config->TableMap['file']}` `f` " ."NATURAL JOIN `{$Config->TableMap['file_history']}` `fh` " ."WHERE " ."`bb_id`=".$bb_id; return $dbconn->query_row_assoc($sql); } function _db_insert_file_history($dbconn,$fh_id_updates,$text,$brief) { global $Config; $sql="INSERT INTO `{$Config->TableMap['file_history']}` (" ."`fh_id_updates`, `fh_brief`, `fh_text`, `fh_timestamp`" .") VALUES (" .($fh_id_updates?$dbconn->escape($fh_id_updates):'NULL')."," .($brief?$dbconn->escape($brief,true):'NULL')."," .$dbconn->escape($text,true)."," ."UTC_TIMESTAMP())"; $dbconn->real_query($sql,"error.db.queryfail"); return $dbconn->insert_id(); } function db_insert_file($dbconn,$text,$brief=false) { global $Config; $fh_id=_db_insert_file_history($dbconn,false,$text,$brief); $sql="INSERT INTO `{$Config->TableMap['file']}` (" ."`fh_id`" .") VALUES (" .$fh_id .")"; $dbconn->real_query($sql,"error.db.queryfail"); return $dbconn->insert_id(); } function db_update_file($dbconn,$file_id,$text,$brief=false) { global $Config; $sql="SELECT `fh_id` " ."FROM `{$Config->TableMap['file']}` " ."WHERE `file_id`=".$dbconn->escape($file_id); $fh_id_updates=$dbconn->query_value($sql); $fh_id=_db_insert_file_history($dbconn,$fh_id_updates,$text,$brief); $sql="UPDATE `{$Config->TableMap['file']}` " ."SET `fh_id`=".$fh_id." " ."WHERE `file_id`=".$dbconn->escape($file_id); $dbconn->real_query($sql,"error.db.queryfail"); } function db_join_coursecircle($dbconn,$cs_id,$mb_id) { global $Config; $sql="INSERT IGNORE INTO `{$Config->TableMap['course_circle']}` (" ."`cs_id`, `mb_id`, `cc_timestamp`" .") VALUES (" .$dbconn->escape($cs_id).", " .$dbconn->escape($mb_id).", " ."UTC_TIMESTAMP())"; $dbconn->real_query($sql,"error.db.insertfail"); } function db_count_course($dbconn,$mb_id,$validonly=true) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['course']}` " ."WHERE 1 " .($mb_id?"AND `mb_id_owner`=".$dbconn->escape($mb_id)." ":'') .($validonly?"AND `cs_status`='VALID' ":''); return $dbconn->query_value($sql); } function db_count_place($dbconn,$mb_id,$validonly=true) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['place']}` " ."WHERE 1 " .($mb_id?"AND `mb_id_owner`=".$dbconn->escape($mb_id)." ":'') .($validonly?"AND `plc_status`='VALID' ":''); return $dbconn->query_value($sql); } function db_count_classroom($dbconn,$mb_id,$validonly=true) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['classroom']}` " ."WHERE 1 " .($mb_id?"AND `mb_id_owner`=".$dbconn->escape($mb_id)." ":'') .($validonly?"AND `clsr_status`='VALID' ":''); return $dbconn->query_value($sql); } function db_count_seat($dbconn,$mb_id,$validonly=true) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['seat']}` " ."NATURAL JOIN `{$Config->TableMap['place']}` " ."WHERE 1 " .($mb_id?"AND `mb_id_owner`=".$dbconn->escape($mb_id)." ":'') .($validonly?"AND `st_status`='VALID' ":''); return $dbconn->query_value($sql); } function db_count_team_member($dbconn,$mb_id_leader) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['team']}` " ."WHERE 1 " .($mb_id_leader?"AND `mb_id_leader`=".$dbconn->escape($mb_id_leader)." ":''); return $dbconn->query_value($sql); } function db_sum_monthly_profit($dbconn,$mb_id,$since,$upto,$doneonly=true) { global $Config; $sql="SELECT " ."`mb_id_owner` `mb_id`, YEAR(`lctr_expire`) `year`, MONTH(`lctr_expire`) `month`, " ."SUM(`lui_revenue`*`lctr_size`)-SUM(`lui_expense`) `total_profit`, " ."SUM(`lui_tax`*`lctr_size`) `total_tax`, " ."SUM(`lui_expense`) `total_lecture_expense`," ."SUM(`lctr_size`) `num_reservations`, " ."SUM(IF(`lui_revenue`>0,`lctr_size`,0)) `num_nonfree_reservations`, " ."`cs_currency` " ."FROM `{$Config->TableMap['lecture']}` " ."NATURAL JOIN `{$Config->TableMap['course']}` " ."NATURAL JOIN `{$Config->TableMap['lecture_unit_income']}` " ."NATURAL JOIN `{$Config->TableMap['lecture_size']}` " ."WHERE " ."`lctr_expire`>=".$dbconn->escape($since,true)." AND " ."`lctr_expire`<".$dbconn->escape($upto,true)." AND " .($doneonly?"`lctr_expire`<UTC_TIMESTAMP() AND ":'') ."`mb_id_owner`=".$dbconn->escape($mb_id)." " ."GROUP BY YEAR(`lctr_expire`), MONTH(`lctr_expire`), `cs_currency` " ."ORDER BY YEAR(`lctr_expire`) DESC, MONTH(`lctr_expire`) DESC "; return $dbconn->query_allrows_assoc($sql); } function db_insert_course_group($dbconn,$mb_id_owner,$cg_name,$cg_brief) { global $Config; $sql="INSERT INTO `{$Config->TableMap['course_group']}` (" ."`mb_id_owner`, `cg_name`, `cg_brief`, `cg_create_time`, `cg_modify_time`, `cg_status`" .") VALUES (" .$dbconn->escape($mb_id_owner).", " .$dbconn->escape($cg_name,true).", " .$dbconn->escape($cg_brief,true).", " ."UTC_TIMESTAMP(), " ."UTC_TIMESTAMP(), " ."'VALID') "; $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function db_delete_course_group($dbconn,$cg_id,$mb_id_owner) { global $Config; $sql="UPDATE `{$Config->TableMap['course_group']}` " ."SET" ."`cg_status`='DELETED', " ."`cg_modify_time`=UTC_TIMESTAMP() " ."WHERE " ."`cg_id`=".$dbconn->escape($cg_id)." AND " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner); $dbconn->real_query($sql,"error.db.updatefail"); } function db_update_course_group($dbconn,$cg_id,$mb_id_owner,$cg_name,$cg_brief) { global $Config; $sql="UPDATE `{$Config->TableMap['course_group']}` " ."SET" ."`cg_name`=".$dbconn->escape($cg_name,true).", " ."`cg_brief`=".$dbconn->escape($cg_brief,true).", " ."`cg_modify_time`=UTC_TIMESTAMP() " ."WHERE " ."`cg_id`=".$dbconn->escape($cg_id)." AND " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner); $dbconn->real_query($sql,"error.db.updatefail"); } function db_update_course_group_time($dbconn,$cg_id,$mb_id_owner) { global $Config; $sql="UPDATE `{$Config->TableMap['course_group']}` " ."SET" ."`cg_modify_time`=UTC_TIMESTAMP() " ."WHERE " ."`cg_id`=".$dbconn->escape($cg_id)." AND " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner); $dbconn->real_query($sql,"error.db.updatefail"); } function db_count_course_group($dbconn,$mb_id,$validonly=true) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['course_group']}` `cg` " ."WHERE " ."`mb_id_owner`=".$dbconn->escape($mb_id)." AND " ."`cg_status`='VALID' "; return $dbconn->query_value($sql); } function db_load_course_group($dbconn,$cg_id,$mb_id_owner) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['course_group']}` `cg` " ."WHERE " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner)." AND " ."`cg_id`=".$dbconn->escape($cg_id)." AND " ."`cg_status`='VALID' "; return $dbconn->query_row_assoc($sql); } function db_load_course_groups($dbconn,$mb_id_owner,$limit=null,$offset=null) { global $Config; $sql="SELECT *,(" ."SELECT COUNT(*) " ."FROM `{$Config->TableMap['course_group_course']}` `cgc` " ."WHERE " ."`cg`.`cg_id`=`cgc`.`cg_id`" .") `cg_course_count` " ."FROM `{$Config->TableMap['course_group']}` `cg` " ."WHERE " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner)." AND " ."`cg_status`='VALID' " ."ORDER BY 'cg_name' " ._db_limit($limit,$offset); return $dbconn->query_allrows_assoc($sql); } function db_load_course_group_course_ids($dbconn,$cg_id) { global $Config; $sql="SELECT `cs_id` " ."FROM `{$Config->TableMap['course_group_course']}` " ."WHERE " ."`cg_id`=".$dbconn->escape($cg_id); return $dbconn->query_value_array($sql); } function db_save_course_group_course_ids($dbconn,$cg_id,$cs_ids) { global $Config; if ($cs_ids) { $sql="REPLACE INTO `{$Config->TableMap['course_group_course']}` (" ."`cg_id`, `cs_id`" .") VALUES "; $sqlpart=""; foreach ($cs_ids as $cs_id) { if ($sqlpart) $sqlpart.=","; $sqlpart.="(".$dbconn->escape($cg_id).",".$dbconn->escape($cs_id).")"; } $sql.=$sqlpart; $dbconn->real_query($sql,"error.db.insertfail"); } $sql="DELETE FROM `{$Config->TableMap['course_group_course']}` " ."WHERE " ."`cg_id`=".$dbconn->escape($cg_id) .($cs_ids?" AND NOT `cs_id` IN (".$dbconn->escape($cs_ids).") ":""); $dbconn->real_query($sql,"error.db.deletefail"); } function db_load_course_group_limits($dbconn,$cg_id,$mb_id_owner,$limit=null,$offset=null) { global $Config; $sql="SELECT `cgl`.* " ."FROM `{$Config->TableMap['course_group_limit']}` `cgl` " ."NATURAL JOIN `{$Config->TableMap['course_group']}` `cg` " ."WHERE " ."`cgl_status`='VALID' AND " ."`cg_id`=".$dbconn->escape($cg_id)." AND " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner)." " ."ORDER BY `cgl_view` "; return $dbconn->query_allrows_assoc($sql); } function db_set_course_group_limit($dbconn,$mb_id_owner,$cg_id,$cgl_view,$cgl_limit) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['course_group']}` " ."WHERE " ."`cg_id`=".$dbconn->escape($cg_id)." AND " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner); $belonging=$dbconn->query_value($sql); if (!$belonging) return false; $sql="UPDATE `{$Config->TableMap['course_group_limit']}` " ."SET " ."`cgl_status`='DELETED', " ."`cgl_timestamp`=UTC_TIMESTAMP() " ."WHERE " ."`cg_id`=".$dbconn->escape($cg_id)." AND " ."`cgl_view`=".$dbconn->escape($cgl_view,true); $dbconn->real_query($sql,"error.db.updatefail"); if ($cgl_limit) { $sql="INSERT INTO `{$Config->TableMap['course_group_limit']}` (" ."`cg_id`, `cgl_view`, `cgl_limit`, `cgl_status`, `cgl_timestamp`" .") VALUES (" .$dbconn->escape($cg_id).", " .$dbconn->escape($cgl_view,true).", " .$dbconn->escape($cgl_limit).", " ."'VALID'," ."UTC_TIMESTAMP()" .")"; $dbconn->real_query($sql,"error.db.updatefail"); } return $dbconn->insert_id(); } function db_delete_course_group_limits($dbconn,$cgl_id,$mb_id_owner) { if (!($cgl_id && $mb_id_owner)) return; global $Config; $sql="UPDATE `{$Config->TableMap['course_group_limit']}` " ."SET `cgl_status`='DELETED' " ."WHERE " ."`cgl_id` IN (".$dbconn->escape($cgl_id).") AND " ."`cg_id` IN (" ."SELECT `cg_id` " ."FROM `{$Config->TableMap['course_group']}` " ."WHERE " ."`cg_status`='VALID' AND " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner)." " .") "; $dbconn->real_query($sql,"error.db.updatefail"); } function db_filter_for_joinable_course_by_limits($dbconn,$cs_ids,$la_since) { if (!$cs_ids) return array(); global $Config; $sql="SElECT DISTINCT `cs_id` " ."FROM `{$Config->TableMap['course']}` " ."NATURAL JOIN `{$Config->TableMap['course_weekly_minutes_avail']}` " ."WHERE " ."`cs_status`='VALID' AND " ."`cs_id` IN (".$dbconn->escape($cs_ids).") AND " ."( " ."`cgv_minutes_avail` IS NULL OR " ."( " ."`cgv_yearweek0`=YEARWEEK(".$dbconn->escape($la_since,true).",0) OR " ."`cgv_yearweek1`=YEARWEEK(".$dbconn->escape($la_since,true).",1) " .") AND " ."`cs_minutes_min`<=`cgv_minutes_avail`" .") "; return $dbconn->query_value_array($sql); } function db_filter_for_valid_compere_ids($dbconn,$mb_ids) { if (!$mb_ids) return array(); global $Config; $sql="SELECT `mb_id` " ."FROM `{$Config->TableMap['compere']}` " ."WHERE " ."`mb_id` IN (".$dbconn->escape($mb_ids,true).") AND " ."`cp_status` != 'INVALID' "; return $dbconn->query_value_array($sql); } function db_load_course_minutes_limit($dbconn,$cs_id,$la_since) { global $Config; $sql="SElECT MIN(`cgv_minutes_avail`) `cgv_minutes_avail` " ."FROM `{$Config->TableMap['course_weekly_minutes_avail']}` " ."WHERE " ."`cs_id`=".$dbconn->escape($cs_id)." AND " ."( " ."`cgv_minutes_avail` IS NULL OR " ."( " ."`cgv_yearweek0`=YEARWEEK(".$dbconn->escape($la_since,true).",0) OR " ."`cgv_yearweek1`=YEARWEEK(".$dbconn->escape($la_since,true).",1) " .") " .") "; $limit=$dbconn->query_value($sql); return $limit===null?99999:$limit; } function db_insert_compere_limit($dbconn,$cp_id,$limits,$cl_priority,$lifeunitcount,$lifeunit,$lifestarttime=false) { global $Config; $allcols=array('timeavail.count', 'seat.count', 'place.count', 'classroom.seat.count', 'classroom.count', 'lecture.count', 'course.count', 'coursegroup.count', 'reservation.count', 'option.count', 'team.size','question.count','questionnaire.count'); $collist=array('`cp_id`'); $vallist=array($dbconn->escape($cp_id)); foreach ($allcols as $col) if (ctype_digit((string)$limits[$col])) { array_push($collist,'`'.$col.'`'); array_push($vallist,$dbconn->escape($limits[$col])); } print_r($limits); array_push($collist,"`cl_priority`", "`cl_expire`", "`cl_timestamp_enter`"); array_push($vallist, 0+$cl_priority, 'DATE_ADD('.($lifestarttime?$dbconn->escape($lifestarttime,true):'UTC_TIMESTAMP()').', INTERVAL '.$dbconn->escape($lifeunitcount).' '.$dbconn->escape($lifeunit).')', 'UTC_TIMESTAMP()'); $sql="INSERT INTO `{$Config->TableMap['compere_limit']}` (".implode(', ',$collist).") VALUES (".implode(', ',$vallist).") "; $dbconn->real_query($sql,'error.db.insertfail'); return $dbconn->insert_id(); } function db_load_compere_current_limit($dbconn,$cp_id,$validonly=true) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['compere_limit']}` " ."WHERE " ."`cp_id`=".$dbconn->escape($cp_id)." AND " ."UTC_TIMESTAMP()<=`cl_expire` AND " .($validonly?"`cl_status`='VALID' AND ":'') .'1 ' ."ORDER BY `cl_priority`, `cl_expire` " ."LIMIT 1"; return $dbconn->query_row_assoc($sql); } function db_load_compere_priority_last_limit($dbconn,$cp_id,$cl_priority,$validonly=true) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['compere_limit']}` " ."WHERE " ."`cp_id`=".$dbconn->escape($cp_id)." AND " ."UTC_TIMESTAMP()<=`cl_expire` AND " ."`cl_priority`=".$dbconn->escape($cl_priority)." AND " .($validonly?"`cl_status`='VALID' AND ":'') .'1 ' ."ORDER BY `cl_expire` DESC " ."LIMIT 1"; return $dbconn->query_row_assoc($sql); } function db_load_compere_current_limits($dbconn,$cp_id,$limit=null,$offset=null,$unexpired=true,$validonly=true) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['compere_limit']}` " ."WHERE " ."`cp_id`=".$dbconn->escape($cp_id)." AND " .($unexpired?"UTC_TIMESTAMP()<=`cl_expire` AND ":'') .($validonly?"`cl_status`='VALID' AND ":'') ."1 " ."ORDER BY `cl_expire` " ._db_limit($limit,$offset); return $dbconn->query_allrows_assoc($sql); } function db_update_compere_limit_expire($dbconn,$cp_ids,$cl_expire) { if (!$cp_ids) return; global $Config; $sql="UPDATE `{$Config->TableMap['compere_limit']}` " ."SET `cl_expire`=".$dbconn->escape($cl_expire,true)." " ."WHERE " ."`cp_id` IN (".$dbconn->escape($cp_ids).")"; $dbconn->real_query($sql,"error.db.updatefail"); } function db_update_compere_name($dbconn,$mb_id,$cp_name) { global $Config; $sql="UPDATE `{$Config->TableMap['compere']}` " ."SET `cp_name`=".$dbconn->escape($cp_name,true)." " ."WHERE " ."`mb_id`=".$dbconn->escape($mb_id); $dbconn->real_query($sql,"error.db.updatefail"); } function db_query_compere_id_by_email($dbconn,$email) { global $Config; $sql="SELECT `mb_id` " ."FROM `{$Config->TableMap['compere']}` " ."NATURAL JOIN `{$Config->TableMap['member_email']}` " ."WHERE " ."`cp_status`='VALID' AND " ."`me_status`='VALIDATED' AND " ."`me_notify` AND " ."`mb_email`='".$dbconn->escape($email)."' " ."LIMIT 1"; return $dbconn->query_value($sql); } function db_set_lecture_unit_income($dbconn,$lctr_id,$lui_revenue,$lui_expense,$lui_tax) { global $Config; $sql="REPLACE INTO `{$Config->TableMap['lecture_unit_income']}` " ."(`lctr_id`, `lui_revenue`, `lui_expense`, `lui_tax`) VALUES (" .$dbconn->escape($lctr_id).", " .$dbconn->escape($lui_revenue).", " .$dbconn->escape($lui_expense).", " .$dbconn->escape($lui_tax).") "; $dbconn->real_query($sql,"error.db.insertfail"); } function db_delete_lecture_unit_income($dbconn,$lctr_id) { global $Config; $sql="DELETE FROM `{$Config->TableMap['lecture_unit_income']}` " ."WHERE `lctr_id`=".$dbconn->escape($lctr_id); $dbconn->real_query($sql,"error.db.deletefail"); } function db_insert_option($dbconn,$mb_id_owner,$o_ordinal,$o_price_base,$o_price_step,$o_num_min,$o_num_max,$o_thumbnail_url) { global $Config; $sql="INSERT INTO `{$Config->TableMap['option']}` " ."(`mb_id_owner`, `o_ordinal`, `o_price_base`, `o_price_step`, `o_num_min`, `o_num_max`, `o_thumbnail_url`, `o_status`) VALUES (" .$dbconn->escape($mb_id_owner).", " .$dbconn->escape($o_ordinal).", " .$dbconn->escape($o_price_base).", " .$dbconn->escape($o_price_step).", " .$dbconn->escape($o_num_min).", " .$dbconn->escape($o_num_max).", " .$dbconn->escape($o_thumbnail_url,true).", " ."'VALID') "; $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function db_update_option($dbconn,$mb_id_owner,$o_id,$o_price_base,$o_price_step,$o_num_min,$o_num_max,$o_thumbnail_url) { global $Config; $sql="UPDATE `{$Config->TableMap['option']}` SET " ."`o_price_base`=".$dbconn->escape($o_price_base).", " ."`o_price_step`=".$dbconn->escape($o_price_step).", " ."`o_num_min`=".$dbconn->escape($o_num_min).", " ."`o_num_max`=".$dbconn->escape($o_num_max).", " ."`o_thumbnail_url`=".$dbconn->escape($o_thumbnail_url,true)." " ."WHERE " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner)." AND " ."`o_id`=".$dbconn->escape($o_id); $dbconn->real_query($sql,"error.db.updatefail"); } function db_set_option_desc($dbconn,$o_id,$o_name,$o_desc) { global $Config; $sql="REPLACE INTO `{$Config->TableMap['option_desc']}` " ."(`o_id`, `o_name`, `o_desc`) VALUES (" .$dbconn->escape($o_id).", " .$dbconn->escape($o_name,true).", " .$dbconn->escape($o_desc,true).") "; $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function db_load_options($dbconn,$cs_ids=null,$mb_id_owner=null,$o_ids=null,$withname=true,$withdesc=false,$validonly=true) { global $Config; $sql="SELECT `o`.* ".($withname?", `o_name` ":'').($withdesc?", `o_desc` ":'') ."FROM `{$Config->TableMap['option']}` `o` " .($cs_ids?"NATURAL JOIN `{$Config->TableMap['course_option']}` `co` ":"") .($withname || $withdesc?"NATURAL JOIN `{$Config->TableMap['option_desc']}` `od` ":"") ."WHERE 1 " .($cs_ids?"AND `cs_id` IN (".$dbconn->escape($cs_ids).") ":"") .($o_ids?"AND `o_id` IN (".$dbconn->escape($o_ids).") ":"") .($mb_id_owner?"AND `mb_id_owner` IN (".$dbconn->escape($mb_id_owner).") ":"") .($validonly?"AND `o_status`='VALID' ":"") ."ORDER BY `o_status`, `o_ordinal`, `o_id` "; return $dbconn->query_allrows_assoc($sql); } function db_load_option_by_id($dbconn,$o_id,$withname=true,$withdesc=false,$validonly=true) { global $Config; $sql="SELECT `o`.* ".($withname?", `o_name` ":'').($withdesc?", `o_desc` ":'') ."FROM `{$Config->TableMap['option']}` `o` " .($withname || $withdesc?"NATURAL JOIN `{$Config->TableMap['option_desc']}` `od` ":"") ."WHERE " ."`o_id`=".$dbconn->escape($o_id)." " .($validonly?"AND `o_status`='VALID' ":""); return $dbconn->query_row_assoc($sql); } function db_load_option_ordinal($dbconn,$cs_id,$validonly=true) { global $Config; $sql="SELECT `cs_id`, `o_ordinal` " ."FROM `{$Config->TableMap['option']}` " ."WHERE " ."`cs_id`=".$dbconn->escape($cs_id)." " .($validonly?"AND `o_status`='VALID' ":"") ."ORDER BY `o_status`, `o_ordinal`, `o_id` "; return $dbconn->query_allrows_assoc($sql); } function db_count_course_option($dbconn,$cs_id,$validonly=true) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['course_option']}` " ."NATURAL JOIN `{$Config->TableMap['option']}` " ."WHERE " ."`cs_id`=".$dbconn->escape($cs_id)." " .($validonly?"AND `o_status`='VALID' ":""); return $dbconn->query_value($sql); } function db_set_option_ordinal($dbconn,$cs_id,$o_id_ordinal_map) { global $Config; foreach ($o_id_ordinal_map as $o_id=>$o_ordinal) { $sql="UPDATE `{$Config->TableMap['option']}` " ."SET `o_ordinal`=".$dbconn->escape($o_ordinal)." " ."WHERE `o_id`=".$dbconn->escape($o_id); $dbconn->real_query($sql,"error.db.updatefail"); } } function db_load_option_ordinal_max($dbconn,$mb_id_owner) { global $Config; $sql="SELECT MAX(`o_ordinal`) " ."FROM `{$Config->TableMap['option']}` " ."WHERE " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner)." AND " ."`o_status`='VALID' "; return $dbconn->query_value($sql); } function db_load_course_option($dbconn,$cs_ids,$o_ids) { global $Config; if (!$cs_ids && !$o_ids) return; $sql="SELECT * " ."FROM `{$Config->TableMap['course_option']}` " ."WHERE 1 " .($cs_ids?"AND `cs_id` IN (".$dbconn->escape($cs_ids).") ":"") .($o_ids?"AND `cs_id` IN (".$dbconn->escape($o_ids).") ":""); return $dbconn->query_allrows_assoc($sql); } function db_filter_for_compere_course($dbconn,$mb_id_owner,$cs_ids) { global $Config; if (!$cs_ids) return array(); $sql="SELECT `cs_id` " ."FROM `{$Config->TableMap['course']}` " ."WHERE " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner)." AND " ."`cs_id` IN (".$dbconn->escape($cs_ids).") "; return $dbconn->query_value_array($sql); } function db_filter_for_compere_option($dbconn,$mb_id_owner,$o_ids) { global $Config; if (!$o_ids) return array(); $sql="SELECT `o_id` " ."FROM `{$Config->TableMap['option']}` " ."WHERE " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner)." AND " ."`o_id` IN (".$dbconn->escape($o_ids).") "; return $dbconn->query_value_array($sql); } function db_set_course_option_association($dbconn,$mb_id_owner,$cs_ids,$o_ids,$cs_ids_ref,$o_ids_ref) { global $Config; if (!$cs_ids) $cs_ids=array(); if (!$o_ids) $o_ids=array(); $cs_ids=db_filter_for_compere_course($dbconn,$mb_id_owner,$cs_ids); $cs_ids_ref=db_filter_for_compere_course($dbconn,$mb_id_owner,$cs_ids_ref); $o_ids=db_filter_for_compere_option($dbconn,$mb_id_owner,$o_ids); $o_ids_ref=db_filter_for_compere_option($dbconn,$mb_id_owner,$o_ids_ref); if ($cs_ids_ref && $o_ids_ref) { $sql="DELETE FROM `{$Config->TableMap['course_option']}` " ."WHERE " ."`cs_id` IN (".$dbconn->escape($cs_ids_ref).") AND " ."`o_id` IN (".$dbconn->escape($o_ids_ref).") "; $dbconn->real_query($sql,"error.db.deletefail"); } if ($cs_ids && $o_ids) { $sql="REPLACE INTO `{$Config->TableMap['course_option']}` (`cs_id`, `o_id`) VALUES "; $first=true; foreach ($cs_ids as $cs_id) { foreach ($o_ids as $o_id) { if ($first) $first=false; else $sql.=","; $sql.="(".$cs_id.",".$o_id.")"; } } $dbconn->real_query($sql,"error.db.insertfail"); } } function db_set_reservation_option($dbconn,$rsv_id,$optrec) { global $Config; $sql="DELETE FROM `{$Config->TableMap['reservation_option']}` WHERE `rsv_id`=".$dbconn->escape($rsv_id); $dbconn->real_query($sql,"error.db.deletefail"); if ($optrec) { $sql="REPLACE INTO `{$Config->TableMap['reservation_option']}` (`rsv_id`, `o_id`, `ro_count`, `ro_unit_price`, `ro_unit_tax`) VALUES "; $first=true; foreach ($optrec as $op) { if ($first) $first=false; else $sql.=", "; $sql.="(" .$dbconn->escape($rsv_id).", " .$dbconn->escape($op['o_id']).", " .$dbconn->escape($op['ro_count']).", " .$dbconn->escape($op['ro_unit_price']).", " .$dbconn->escape($op['ro_unit_tax']) .") "; } $dbconn->real_query($sql,"error.db.insertfail"); } } function db_load_reservation_options($dbconn,$rsv_ids,$withname=true,$withdesc=false) { if (!$rsv_ids) return array(); global $Config; $sql="SELECT `ro`.*, `o`.*".($withname?", `od`.`o_name`":"").($withdesc?", `od`.`o_desc`":"")." " ."FROM `{$Config->TableMap['reservation_option']}` `ro` " ."NATURAL JOIN `{$Config->TableMap['option']}` `o` " ."NATURAL JOIN `{$Config->TableMap['option_desc']}` `od` " ."WHERE " ."`rsv_id` IN (".$dbconn->escape($rsv_ids).") "; return $dbconn->query_allrows_assoc($sql); } function db_load_seat_reservation_by_id($dbconn,$rsv_ids) { if (!$rsv_ids) return array(); global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['seat_reservation']}` " ."WHERE " ."`rsv_id` IN (".$dbconn->escape($rsv_ids).")"; return $dbconn->query_allrows_assoc($sql); } function db_load_lecture_income($dbconn,$lctr_ids) { if (!$lctr_ids) return array(); global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['lecture_income']}` " ."WHERE " ."`lctr_id` IN (".$dbconn->escape($lctr_ids).")"; return $dbconn->query_allrows_assoc($sql); } function db_is_compere_qualified($dbconn,$mb_id) { global $Config; $sql="SELECT 1 " ."FROM `{$Config->TableMap['compere_qualified']}` " ."WHERE " ."`mb_id`=".$dbconn->escape($mb_id); return $dbconn->query_value($sql); } function db_count_compere_option($dbconn,$mb_id) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['option']}` " ."WHERE " ."`mb_id_owner`=".$dbconn->escape($mb_id); return $dbconn->query_value($sql); } function db_load_recent_reservation($dbconn,$country_code=null,$limit=null,$offset=null) { global $Config; if (!$limit) $limit=10; $sql="SELECT `sr`.*, `cd`.`cs_name` " ."FROM `{$Config->TableMap['seat_reservation']}` `sr` " ."NATURAL JOIN `{$Config->TableMap['course_desc']}` `cd` " ."NATURAL JOIN `{$Config->TableMap['course']}` `cs` " ."WHERE " ."`cs_visibleto`='PUBLIC' " .($country_code?" AND `cs_id` IN (" ."SELECT `cs_id` " ."FROM `{$Config->TableMap['course_classroom']}` " ."NATURAL JOIN `{$Config->TableMap['classroom_seat']}` " ."NATURAL JOIN `{$Config->TableMap['seat']}` " ."NATURAL JOIN `{$Config->TableMap['place']}` " ."WHERE " ."`st_status`='VALID' AND " ."`plc_status`='VALID' AND " ."`plc_country`=".$dbconn->escape($country_code,true)." " .")":"") ."ORDER BY `rsv_timestamp_provisional` DESC, `rsv_timestamp_confirmed` DESC " ._db_limit($limit,$offset); return $dbconn->query_allrows_assoc($sql); } function db_delete_option($dbconn,$o_id) { global $Config; $sql="UPDATE `{$Config->TableMap['option']}` SET `o_status`='DELETED' WHERE `o_id`=".$dbconn->escape($o_id)." LIMIT 1"; $dbconn->real_query($sql,"error.db.updatefail"); } function db_load_recent_courses($dbconn,$country_code=null,$limit=null,$offset=null) { global $Config; if (!$limit) $limit=10; $sql="SELECT `cs_id`,`cs_name` " ."FROM `{$Config->TableMap['course']}` " ."NATURAL JOIN `{$Config->TableMap['course_desc']}` `cd` " ."WHERE " ."`cs_status`='VALID' AND " ."`cs_visibleto`='PUBLIC' AND " ."`cs_id` IN (" ."SELECT `cs_id` " ."FROM `{$Config->TableMap['course_timeavail']}` " ."NATURAL JOIN `{$Config->TableMap['timeavail_effective']}` " .") " .($country_code?" AND `cs_id` IN (" ."SELECT `cs_id` " ."FROM `{$Config->TableMap['course_classroom']}` " ."NATURAL JOIN `{$Config->TableMap['classroom_seat']}` " ."NATURAL JOIN `{$Config->TableMap['seat']}` " ."NATURAL JOIN `{$Config->TableMap['place']}` " ."WHERE " ."`st_status`='VALID' AND " ."`plc_status`='VALID' AND " ."`plc_country`=".$dbconn->escape($country_code,true)." " .")":"") ."ORDER BY `cs_timestamp_initial` DESC, `cs_timestamp` DESC " ._db_limit($limit,$offset); return $dbconn->query_allrows_assoc($sql); } function db_set_course_info_value($dbconn,$cs_id,$ci_property,$ci_value=null) { global $Config; if (!$ci_value) { $sql="DELETE FROM `{$Config->TableMap['course_info']}` " ."WHERE " ."`cs_id`=".$dbconn->escape($cs_id)." AND " ."`ci_property`=".$dbconn->escape($ci_property,true); $dbconn->real_query($sql,"error.db.deletefail"); } else { $sql="REPLACE INTO `{$Config->TableMap['course_info']}` (" ."`cs_id`, `ci_property`, `ci_value`" .") VALUE (" .$dbconn->escape($cs_id).", " .$dbconn->escape($ci_property,true).", " .$dbconn->escape($ci_value,true).") "; $dbconn->real_query($sql,"error.db.insertfail"); } } function db_load_course_info_by_course_id($dbconn,$cs_id) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['course_info']}` " ."WHERE " ."`cs_id`=".$dbconn->escape($cs_id); return $dbconn->query_allrows_assoc($sql); } function db_load_course_info_value($dbconn,$cs_id,$ci_property) { global $Config; $sql="SELECT `ci_value` " ."FROM `{$Config->TableMap['course_info']}` " ."WHERE " ."`cs_id`=".$dbconn->escape($cs_id)." AND " ."`ci_property`=".$dbconn->escape($ci_property,true); return $dbconn->query_value($sql); } function db_insert_question($dbconn,$mb_id_owner,$q_type,$q_text) { global $Config; $sql="INSERT INTO `{$Config->TableMap['question']}` ( " ."`mb_id_owner`, `q_type`, `q_text`, `q_status` " .") VALUE ( " .$dbconn->escape($mb_id_owner).", " .$dbconn->escape($q_type,true).", " .($q_text?$dbconn->escape($q_text,true):"NULL").", " ."'VALID') "; $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function db_update_question($dbconn,$q_id,$mb_id_owner,$q_text) { global $Config; $sql="UPDATE `{$Config->TableMap['question']}` " ."SET `q_text`=".$dbconn->escape($q_text,true)." " ."WHERE " ."`q_id`=".$dbconn->escape($q_id)." AND " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner); $dbconn->real_query($sql,"error.db.updatefail"); } function db_delete_question($dbconn,$q_id,$mb_id_owner) { global $Config; if (!$q_id) return; $sql="UPDATE `{$Config->TableMap['question']}` " ."SET `q_status`='DELETED' " ."WHERE " ."`q_id` IN (".$dbconn->escape($q_id).") AND " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner); $dbconn->real_query($sql,"error.db.updatefail"); if ($dbconn->affected_rows()>0) { $sql="DELETE FROM `{$Config->TableMap['questionnaire_question']}` " ."WHERE " ."`q_id` IN (" ."SELECT `q_id` " ."FROM `{$Config->TableMap['question']}` " ."`q_id` IN (".$dbconn->escape($q_id).") AND " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner)." " .")"; $dbconn->real_query($sql,"error.db.deletefail"); $sql="UPDATE `{$Config->TableMap['question_choice']}` " ."SET `qc_status`='DELETED' " ."WHERE " ."`q_id` IN (" ."SELECT `q_id` " ."FROM `{$Config->TableMap['question']}` " ."`q_id` IN (".$dbconn->escape($q_id).") AND " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner)." " .")"; $dbconn->real_query($sql,"error.db.updatefail"); } } function db_load_questions($dbconn,$mb_id_owner,$validonly=true) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['question']}` " ."WHERE " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner)." " .($validonly?"AND `q_status`='VALID' ":"") ."ORDER BY `q_id` DESC"; return $dbconn->query_allrows_assoc($sql); } function db_load_question_by_id($dbconn,$q_id,$validonly=true) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['question']}` " ."WHERE " ."`q_id`=".$dbconn->escape($q_id)." " .($validonly?"AND `q_status`='VALID' ":""); return $dbconn->query_row_assoc($sql); } function db_load_questions_by_id($dbconn,$q_ids,$validonly=true) { if (!$q_ids) return array(); global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['question']}` " ."WHERE " ."`q_id` IN (".$dbconn->escape($q_ids).") " .($validonly?"AND `q_status`='VALID' ":""); return $dbconn->query_allrows_assoc($sql); } function db_insert_question_choice($dbconn,$q_id,$qc_ordinal,$qc_text) { global $Config; $sql="INSERT INTO `{$Config->TableMap['question_choice']}` ( " ."`q_id`, `qc_ordinal`, `qc_text`, `qc_status` " .") VALUES ( " .$dbconn->escape($q_id).", " .$dbconn->escape($qc_ordinal).", " .$dbconn->escape($qc_text,true).", " ."'VALID') "; $dbconn->real_query($sql,"error.db.insertfail"); } function db_update_question_choice($dbconn,$mb_id_owner,$qc_id,$qc_ordinal,$qc_text) { global $Config; $sql="UPDATE `{$Config->TableMap['question_choice']}` " ."SET " ."`qc_ordinal`=".$dbconn->escape($qc_id).", " ."`qc_text`=".$dbconn->escape($qc_text,true)." " ."WHERE " ."`qc_id`=".$dbconn->escape($qc_id); $dbconn->real_query($sql,"error.db.updatefail"); } function db_filter_question_choices_for_qc_id($dbconn,$q_id,$qc_text,$validonly=true) { $sql="SELECT `qc_id` " ."FROM `{$Config->TableMap['question_choice']}` " ."WHERE " ."`q_id`=".$dbconn->escape($q_id)." AND " ."`qc_text` IN (".$dbconn->escape($qc_text,true).") " .($validonly?"AND `qc_status`='VALID' ":""); $dbconn->query_value_array($sql); } function db_load_question_choices($dbconn,$q_id,$validonly=true) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['question_choice']}` " ."WHERE " ."`q_id`=".$dbconn->escape($q_id)." " .($validonly?"AND `qc_status`='VALID' ":""); return $dbconn->query_allrows_assoc($sql); } function db_load_questions_choices($dbconn,$q_ids,$validonly=true) { if (!$q_ids) return; global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['question_choice']}` " ."WHERE " ."`q_id` IN (".$dbconn->escape($q_ids).") " .($validonly?"AND `qc_status`='VALID' ":"") ."ORDER BY `q_id`, `qc_ordinal` "; return $dbconn->query_allrows_assoc($sql); } function db_delete_question_choice($dbconn,$qc_ids) { global $Config; if (!$qc_ids) return; $sql="UPDATE `{$Config->TableMap['question_choice']}` " ."SET " ."`qc_status`='DELETED' " ."WHERE " ."`qc_id` IN (".$dbconn->escape($qc_ids).") "; $dbconn->real_query($sql,"error.db.deletefail"); } function db_load_questionnaires($dbconn,$mb_id_owner,$validonly=true) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['questionnaire']}` " ."WHERE " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner)." " .($validonly?"AND `qn_status`='VALID' ":"") ."ORDER BY `qn_id` DESC "; return $dbconn->query_allrows_assoc($sql); } function db_load_questionnaire_by_id($dbconn,$qn_id,$mb_id_owner=null,$validonly=true) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['questionnaire']}` " ."WHERE " ."`qn_id`=".$dbconn->escape($qn_id)." " .($mb_id_owner?" AND`mb_id_owner`=".$dbconn->escape($mb_id_owner)." ":"") .($validonly?"AND `qn_status`='VALID' ":"") ."ORDER BY `qn_id` DESC "; return $dbconn->query_row_assoc($sql); } function db_load_questionnaires_by_id($dbconn,$qn_ids,$mb_id_owner=null,$validonly=true) { if (!$qn_ids) return array(); global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['questionnaire']}` " ."WHERE " ."`qn_id` IN (".$dbconn->escape($qn_ids).") " .($mb_id_owner?" AND`mb_id_owner`=".$dbconn->escape($mb_id_owner)." ":"") .($validonly?"AND `qn_status`='VALID' ":"") ."ORDER BY `qn_id` DESC "; return $dbconn->query_allrows_assoc($sql); } function db_insert_questionnaire($dbconn,$mb_id_owner,$qn_name,$qn_desc) { global $Config; $sql="INSERT INTO `{$Config->TableMap['questionnaire']}` ( " ."`mb_id_owner`, `qn_name`, `qn_desc`, `qn_status` " .") VALUE ( " .$dbconn->escape($mb_id_owner).", " .$dbconn->escape($qn_name,true).", " .$dbconn->escape($qn_desc,true).", " ."'VALID') "; $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function db_update_questionnaire($dbconn,$qn_id,$mb_id_owner,$qn_name,$qn_desc) { global $Config; $sql="UPDATE `{$Config->TableMap['questionnaire']}` " ."SET " ."`qn_name`=".$dbconn->escape($qn_name,true).", " ."`qn_desc`=".$dbconn->escape($qn_desc,true)." " ."WHERE " ."`qn_id`=".$dbconn->escape($qn_id)." AND " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner); $dbconn->real_query($sql,"error.db.updatefail"); } function db_load_questionnaire_question_ids($dbconn,$qn_id) { global $Config; $sql="SELECT `q_id` " ."FROM `{$Config->TableMap['questionnaire_question']}` " ."WHERE " ."`qn_id`=".$dbconn->escape($qn_id); return $dbconn->query_value_array($sql); } function db_load_questionnaires_questions($dbconn,$qn_ids) { if (!$qn_ids) return array(); global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['questionnaire_question']}` " ."WHERE " ."`qn_id` IN (".$dbconn->escape($qn_ids).") " ."ORDER BY `qn_id`, `qnq_ordinal`, `q_id` "; return $dbconn->query_allrows_assoc($sql); } function db_filter_for_compere_questionnaire($dbconn,$mb_id_owner,$qn_ids) { if (!$qn_ids) return array(); global $Config; $sql="SELECT `qn_id` " ."FROM `{$Config->TableMap['questionnaire']}` " ."WHERE " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner)." AND " ."`qn_id` IN (".$dbconn->escape($qn_ids).") "; return $dbconn->query_value_array($sql); } function db_filter_for_compere_question($dbconn,$mb_id_owner,$q_ids) { if (!$q_ids) return array(); global $Config; $sql="SELECT `q_id` " ."FROM `{$Config->TableMap['question']}` " ."WHERE " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner)." AND " ."`q_id` IN (".$dbconn->escape($q_ids).") "; return $dbconn->query_value_array($sql); } function db_set_questionnaire_question($dbconn,$mb_id_owner,$qn_id,$qnqlist) { global $Config; $qn_id=db_filter_for_compere_questionnaire($dbconn,$mb_id_owner,$qn_id); if (!$qn_id) return; $qn_id=$qn_id[0]; $q_ids=array_projection($qnqlist,'q_id'); $q_ids=db_filter_for_compere_question($dbconn,$mb_id_owner,$q_ids); $sql="DELETE FROM `{$Config->TableMap['questionnaire_question']}` " ."WHERE " ."`qn_id` IN (" ."SELECT `qn_id` " ."FROM `{$Config->TableMap['questionnaire']}` " ."WHERE " ."`qn_id`=".$qn_id." AND " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner) .") "; $dbconn->real_query($sql,"error.db.deletefail"); if ($q_ids) { $sql="REPLACE INTO `{$Config->TableMap['questionnaire_question']}` (" ."`qn_id`, `q_id`, `qnq_required`, `qnq_ordinal`" .") VALUES "; $sep=""; foreach ($qnqlist as $qnq) { $sql.=$sep."(".$qn_id.", ".$qnq['q_id'].", ".$qnq['qnq_required'].", ".$qnq['qnq_ordinal'].")"; if (!$sep) $sep=","; } $dbconn->real_query($sql,"error.db.insertfail"); } } function db_count_questionnaire_questions($dbconn,$qn_ids) { if (!$qn_ids) return; global $Config; $sql="SELECT `qn_id`, COUNT(`q_id`) `count` " ."FROM `{$Config->TableMap['questionnaire_question']}` " ."WHERE " ."`qn_id` IN (".$dbconn->escape($qn_ids).") " ."GROUP BY `qn_id` "; return $dbconn->query_allrows_assoc($sql); } function db_delete_questionnaire($dbconn,$qn_ids,$mb_id_owner,$validonly=true) { if (!$qn_ids) return array(); global $Config; $sql="UPDATE `{$Config->TableMap['questionnaire']}` " ."SET `qn_status`='DELETED' " ."WHERE " ."`qn_id` IN ( " ."SELECT `qn_id` " ."FROM `{$Config->TableMap['question']}` " ."WHERE " ."`qn_id` IN (".$dbconn->escape($qn_ids).") AND " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner)." " .") "; $dbconn->real_query($sql,"error.db.updatefail"); $sql="DELETE FROM `{$Config->TableMap['questionnaire_question']}` " ."WHERE " ."`qn_id` IN (" ."SELECT `qn_id` " ."FROM `{$Config->TableMap['questionnaire']}` " ."WHERE " ."`qn_id` IN (".$dbconn->escape($qn_ids).") AND " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner)." " .")"; $dbconn->real_query($sql,"error.db.deletefail"); $sql="DELETE FROM `{$Config->TableMap['course_questionnaire']}` " ."WHERE " ."`qn_id` IN (" ."SELECT `qn_id` " ."FROM `{$Config->TableMap['questionnaire']}` " ."WHERE " ."`qn_id` IN (".$dbconn->escape($qn_ids).") AND " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner)." " .")"; $dbconn->real_query($sql,"error.db.deletefail"); } function db_insert_answer_set($dbconn,$mb_id_answerer) { global $Config; $sql="INSERT INTO `{$Config->TableMap['answer_set']}` (" ."`mb_id_answerer`, `as_timestamp`" .") VALUE (" .($mb_id_answerer?$dbconn->escape($mb_id_answerer):'NULL').", " ."UTC_TIMESTAMP()" .")"; $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function db_insert_answers($dbconn,$as_id,$answers) { global $Config; if (!$answers) return; $sql="REPLACE INTO `{$Config->TableMap['answer']}` (" ."`as_id`, `qn_id`, `q_id`, `qc_id`, `a_text`" .") VALUES "; $sep=""; foreach ($answers as $answer) { $sql.=$sep."(" .$dbconn->escape($as_id).", " .$dbconn->escape($answer['qn_id']).", " .$dbconn->escape($answer['q_id']).", " .($answer['qc_id']?$dbconn->escape($answer['qc_id']):"NULL").", " .($answer['a_text']?$dbconn->escape($answer['a_text'],true):"NULL").")"; $sep=","; } $dbconn->real_query($sql,"error.db.insertfail"); return $dbconn->insert_id(); } function db_set_course_questionnaire($dbconn,$mb_id_owner,$cs_id,$qn_id) { global $Config; $cs_id=$dbconn->escape($cs_id); $sql="DELETE FROM `{$Config->TableMap['course_questionnaire']}` " ."WHERE " ."`cs_id`=".$cs_id; $dbconn->real_query($sql,"error.db.deletefail"); if (!$qn_id) return; $sql="REPLACE INTO `{$Config->TableMap['course_questionnaire']}` " ."(`cs_id`, `qn_id`) " ."SELECT `cs_id`, `qn_id` " ."FROM `{$Config->TableMap['questionnaire']}` " ."NATURAL JOIN `{$Config->TableMap['course']}` " ."WHERE " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner)." AND " ."`cs_id`=".$cs_id." AND " ."`qn_id`=".$dbconn->escape($qn_id); $dbconn->real_query($sql,"error.db.insertfail"); } function db_set_questionnaire_course($dbconn,$mb_id_owner,$qn_id,$cs_ids) { global $Config; $qn_id=$dbconn->escape($qn_id); $sql="DELETE FROM `{$Config->TableMap['course_questionnaire']}` " ."WHERE " ."`qn_id`=".$qn_id." "; $dbconn->real_query($sql,"error.db.deletefail"); if (!$cs_ids) return; $sql="REPLACE INTO `{$Config->TableMap['course_questionnaire']}` " ."(`qn_id`, `cs_id`) " ."SELECT `qn_id`, `cs_id` " ."FROM `{$Config->TableMap['questionnaire']}` " ."NATURAL JOIN `{$Config->TableMap['course']}` " ."WHERE " ."`mb_id_owner`=".$dbconn->escape($mb_id_owner)." AND " ."`qn_id`=".$qn_id." AND " ."`cs_id` IN (".$dbconn->escape($cs_ids).") "; $dbconn->real_query($sql,"error.db.insertfail"); } function db_load_course_questionnaire_id($dbconn,$cs_id) { global $Config; $sql="SELECT `qn_id` " ."FROM `{$Config->TableMap['course_questionnaire']}` " ."WHERE " ."`cs_id`=".$dbconn->escape($cs_id); return $dbconn->query_value($sql); } function db_load_questionnaire_course_ids($dbconn,$qn_id) { global $Config; $sql="SELECT `cs_id` " ."FROM `{$Config->TableMap['course_questionnaire']}` " ."WHERE " ."`qn_id`=".$dbconn->escape($qn_id); return $dbconn->query_value_array($sql); } function db_insert_reservation_answer_set($dbconn,$rsv_id,$as_id) { global $Config; $sql="INSERT INTO `{$Config->TableMap['reservation_answer_set']}` ( " ."`rsv_id`, `as_id` " .") VALUE (" .$dbconn->escape($rsv_id).", " .$dbconn->escape($as_id).") "; $dbconn->real_query($sql,"error.db.insertfail"); } function db_load_reservations_answer_sets($dbconn,$rsv_ids) { if (!$rsv_ids) return array(); global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['reservation_answer_set']}` " ."WHERE " ."`rsv_id` IN (".$dbconn->escape($rsv_ids).")"; return $dbconn->query_allrows_assoc($sql,"error.db.insertfail"); } function db_load_answer_set($dbconn,$as_id) { global $Config; $sql="SELECT * " ."FROM `{$Config->TableMap['answer']}` " ."WHERE " ."`as_id`=".$dbconn->escape($as_id); return $dbconn->query_allrows_assoc($sql); } function db_count_compere_question($dbconn,$mb_id,$validonly=true) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['question']}` " ."WHERE " ."`mb_id_owner`=".$dbconn->escape($mb_id)." " .($validonly?"AND `q_status`='VALID' ":""); return $dbconn->query_value($sql); } function db_count_compere_questionnaire($dbconn,$mb_id,$validonly=true) { global $Config; $sql="SELECT COUNT(*) " ."FROM `{$Config->TableMap['questionnaire']}` " ."WHERE " ."`mb_id_owner`=".$dbconn->escape($mb_id)." " .($validonly?"AND `qn_status`='VALID' ":""); return $dbconn->query_value($sql); } ?>