<?php function check_online_upgrade() { global $Config; $updateinfo=array(); $lastpackagexmlcache=cache_load(0,$Config->CachePrefix,'upgrade/check',$Config->UpgradeInfo['briefname'],false,time()-$Config->UpgradeInfo['cachelife']); if ($lastpackagexmlcache['src']==$Config->UpgradeInfo['src']) $lastpackagexmltext=$lastpackagexmlcache['xmltext']; else { $lastpackagexmltext=file_get_contents($Config->UpgradeInfo['src']); $lastpackagexmlcache['src']=$Config->UpgradeInfo['src']; $lastpackagexmlcache['xmltext']=$lastpackagexmltext; cache_save(0,$Config->CachePrefix,'upgrade/check',$Config->UpgradeInfo['briefname'],$lastpackagexmlcache); } $lastpackagexml=simplexml_load_string($lastpackagexmltext); $basename=basename($lastpackagexml->path); $ppn=parse_package_name((string)$lastpackagexml->path); if (!$ppn['folders'][$Config->UpgradeInfo['foldername']]) $updateinfo['UPGRADE-UNAVAIL']=array(0); if (!$updateinfo['UPGRADE-UNAVAIL']) { $updateinfo['version']=$ppn['folders'][$Config->UpgradeInfo['foldername']]['version']; $updateinfo['package-path']=(string)$lastpackagexml->path; $updateinfo['hash-md5']=(string)$lastpackagexml->hash->md5; $updateinfo['hash-sha1']=(string)$lastpackagexml->hash->sha1; if ($Config->VERSION) { $lvparts=explode('.',$Config->VERSION); $rvparts=explode('.',$updateinfo['version']); for ($rvi=0;$rvi<sizeof($rvparts);$rvi++) { if (0+$lvparts[$rvi]<0+$rvparts[$rvi]) break; } if ($rvi<sizeof($rvparts)) $updateinfo['UPGRADE-AVAIL']=array(0); } } return $updateinfo; } function get_full_package_url($packagepath) { global $Config; if (strncmp($packagepath,'http://',7)==0) return $packagepath; if (strncmp($packagepath,'https://',8)==0) return $packagepath; return $Config->UpgradeInfo['src'].$packagepath; } function parse_package_name($packagename) { $lpbasename=ereg_replace('\.[a-z0-9A-Z]+$','',basename($packagename)); $lpbnparts=explode('_',$lpbasename); $prefixparts=array(); $folders=array(); for ($lpi=0;$lpi<sizeof($lpbnparts);$lpi++) { if (ctype_digit($lpbnparts[$lpi][0])) { $version=$lpbnparts[$lpi++]; $trail=$lpbnparts[$lpi]; $revision=null; if ($trail[0]=='r') $revision=substr($trail,1); $folders[array_pop($prefixparts)]=array( 'version'=>$version, 'revision'=>$revision ); } else array_push($prefixparts,$lpbnparts[$lpi]); } return array( 'prefix'=>implode('_',$prefixparts), 'prefixpath'=>implode('_',$prefixparts).($prefixparts?'/':''), 'folders'=>$folders ); } function unpack_spk_file($spkfile,$destbasepath,$options) { $fpin=gzopen($spkfile,"rb"); if (!$fpin) return array('status'=>'FAIL','errorfiles'=>array()); $octetsbuffer=gzread($fpin,2); $chunkmaxsize=(ord($octetsbuffer[0])<<8)|ord($octetsbuffer[1]); $octetsbuffer=substr($octetsbuffer,2); $fpout=false; $errorfiles=array(); while (!gzeof($fpin)) { $octetsbuffer=gzread($fpin,2); $infolength=(ord($octetsbuffer[0])<<8)|ord($octetsbuffer[1]); $octetsbuffer=$infolength?gzread($fpin,$infolength):''; $type=ord($octetsbuffer[0]); $path=substr($octetsbuffer,1,$infolength-1); if ($options['includes']) { $included=false; foreach ($options['includes'] as $ptn) if (fnmatch($ptn,$path)) { $included=true; break; } } else $included=true; if ($options['excludes']) { foreach ($options['excludes'] as $ptn) if (fnmatch($ptn,$path)) { $included=false; break; } } $returned=false; if ($options['returns']) { foreach ($options['returns'] as $ptn) if (fnmatch($ptn,$path)) { $returned=true; break; } } $destpath=$destbasepath.'/'.substr($path,$options['removeprefixlen']); if ($included) { if ($type&2) { if (!is_dir($destpath)) if (!@mkdir($destpath,0755,true)) $errorfiles[]=$destpath; } else if (!$returned) { if ($options['istest']) { if (!is_writable(dirname($destpath))) $errorfiles[]=$destpath; } else { $fpout=fopen($destpath,"wb"); if (!$fpout) $errorfiles[]=$destpath; } } } do { $octetsbuffer=gzread($fpin,2); $datalength=(ord($octetsbuffer[0])<<8)|ord($octetsbuffer[1]); $octetsbuffer=$datalength?gzread($fpin,$datalength):''; if ($returned) { if ($options['returnbasename']) $returnedkey=basename($path); else $returnedkey=$path; $returnedfiles[$returnedkey].=$octetsbuffer; } else if ($included && $fpout) fwrite($fpout,$octetsbuffer,$datalength); if ($datalength<$chunkmaxsize) break; } while (!feof($fpin)); if ($fpout) fclose($fpout); $fpout=false; } gzclose($fpin); if (!$errorfiles) return array('status'=>'OK','errorfiles'=>array(),'returned'=>$returnedfiles); return array('status'=>'ERROR','errorfiles'=>$errorfiles,'returned'=>$returnedfiles); } function upgrade_tmp_path($typename,$subtypename=false,$subsubtypename=false) { global $Config; $path=$Config->CachePrefix.'upgrade/'.$typename.'/'; if ($subtypename) $path.=$subtypename.'/'; if ($subsubtypename) $path.=$subsubtypename.'/'; return $path; } function unpack_upgrade_package($localpackage,$extracttopath,$istest) { global $Config; $ppn=parse_package_name($localpackage); $packageinfofolder=$ppn['folders'][$Config->UpgradeInfo['foldername']]; if (!$packageinfofolder) return false; $inpackagepath=$ppn['prefixpath'].$Config->UpgradeInfo['foldername'].'/'; $unpackresult=unpack_spk_file( $localpackage, $extracttopath, array( 'removeprefixlen'=>strlen($inpackagepath), 'includes'=>array($inpackagepath.'*'), 'excludes'=>array( '*/config.common.inc.php', '*/config.locals.inc.php', '*/install/*' ), 'returns'=>array( '*'.$Config->UpgradeInfo['foldername'].'/install/VERSION', '*'.$Config->UpgradeInfo['foldername'].'/install/commands/configcontent.inc.php', '*'.$Config->UpgradeInfo['foldername'].'/install/db/createdb.sql' ), 'returnbasename'=>true, 'istest'=>$istest ) ); return $unpackresult; } function download_upgrade_package(&$session_upgrade) { global $Config; $rtv=array(); $packageinfo=check_online_upgrade(); $cacheprefix=upgrade_tmp_path('packages'); $url=get_full_package_url($packageinfo['package-path']); $cachefile=$cacheprefix.basename($url); if (!file_exists($cachefile) || $packageinfo['hash-sha1']!=sha1_file($cachefile)) { $cachedir=dirname($cachefile); @mkdir($cachedir,0775,true); $fpdest=fopen($cachefile,'wb'); $fpsrc=false; if (!$fpdest) { $rtv['status']='ERROR'; $rtv['message']='Cannot save package.'; } else { $fpsrc=fopen($url,'rb'); if (!$fpsrc) { $rtv['status']='ERROR'; $rtv['message']='Cannot read remote package.'; } else { while ($buf=fread($fpsrc,65536)) fwrite($fpdest,$buf); } if ($fpsrc) fclose($fpsrc); if ($fpdest) fclose($fpdest); if ($fpsrc && $fpdest) { if ($packageinfo['hash-sha1']==sha1_file($cachefile)) $rtv['status']='OK'; else { $rtv['status']='ERROR'; $rtv['message']='Corrupted ('.$cachefile.')'; } } } } else $rtv['status']='OK'; $session_upgrade['packageinfo']=$packageinfo; $session_upgrade['localpackage']=$cachefile; return $rtv; } function upgrade_config_scripts(&$session_upgrade) { global $Config; $cacheprefix=upgrade_tmp_path('tmp',$Config->UpgradeInfo['foldername'],'conf'); $briefname=ereg_replace('[^a-zA-Z0-9_]','',$Config->UpgradeInfo['briefname']); $returned=$session_upgrade['unpack.returned.'.$briefname]; if ($returned) { $configcache_content=$cacheprefix.'configcontent.inc.php'; $configcache_common=$cacheprefix.'config.common.inc.php'; $configcache_locals=$cacheprefix.'config.locals.inc.php'; @mkdir($cacheprefix,0755,true); $configcommon=file_get_contents($Config->UpgradeInfo['config.common']); $configlocals=file_get_contents($Config->UpgradeInfo['config.locals']); $old_configcommon_func='initialize_config_'.$briefname.'_old'; $old_configlocals_func='set_local_configurations_'.$briefname.'_old'; $configcontent_common_func=$briefname.'_config_common_text'; $configcontent_locals_func=$briefname.'_config_locals_text'; $configcommon=ereg_replace('function[\t ]+initialize_config','function '.$old_configcommon_func,$configcommon); $configlocals=ereg_replace('function[\t ]+set_local_configurations','function '.$old_configlocals_func,$configlocals); @mkdir(dirname($configcache_content),0755,true); file_put_contents($configcache_content,$returned['configcontent.inc.php']); file_put_contents($configcache_common,$configcommon); file_put_contents($configcache_locals,$configlocals); $oldConfig=null; require $configcache_common; require $configcache_locals; require $configcache_content; call_user_func_array($old_configcommon_func,array(&$oldConfig)); call_user_func_array($old_configlocals_func,array(&$oldConfig)); $configcommon_new=call_user_func_array($configcontent_common_func,array(&$oldConfig,array('VERSION'=>$returned['VERSION']))); $configlocals_new=call_user_func_array($configcontent_locals_func,array(&$oldConfig,null)); $fp=fopen($Config->UpgradeInfo['config.common'],'wb'); fwrite($fp,$configcommon_new); fclose($fp); $fp=fopen($Config->UpgradeInfo['config.locals'],'wb'); fwrite($fp,$configlocals_new); fclose($fp); return true; } return false; } ?>