<?php /*~ cache.inc.php
.---------------------------------------------------------------------------.
|  Software: File Caching Utilities Library                                 |
|   Version: 0.1                                                            |
|   Contact: via http://www.uniwits.com/contact                             |
|      Info: http://www.uniwits.com/                                        |
|   Support: http://www.uniwits.com/support                                 |
|      Note: This library is designed for Linux and compatible systems.     |
| ------------------------------------------------------------------------- |
|     Admin: Yuxiang Mao (project admininistrator)                          |
|   Authors: Yuxiang Mao (Uniwits) contact@uniwits.com                      |
|   Founder: Yuxiang Mao                                                    |
| Copyright (c) 2010-2012, Yuxiang Mao. All Rights Reserved.                |
| ------------------------------------------------------------------------- |
|   License: Distributed under Uniwits Shareware License (USL)              |
|            http://www.uniwits.com/licenses/shareware/                     |
| This program is distributed as a part of software provided by Uniwits     |
| System WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                      |
| ------------------------------------------------------------------------- |
*/ function cache_load($id,$cachepathprefix,$cacheclass,$cachename,$session_id=false,$cacherenewtime=0,$unserializer='unserialize') { clearstatcache(); $sessid=$session_id.'$'; $dirpath=$cachepathprefix.$id.'/'.$cacheclass; @mkdir($dirpath,0777,true); $filepath=$dirpath.'/'.$sessid.$cachename; $filetime=@filemtime($filepath); if ($filetime && $cacherenewtime>=$filetime) { $sd=@file_get_contents($filepath); if ($sd) return call_user_func($unserializer,$sd); } return NULL; } function cache_load_depfiles($id,$cachepathprefix,$cacheclass,$cachename,$session_id=false,$depfiles=array(),$unserializer='unserialize') { clearstatcache(); $cacherenewtime=0; foreach ($depfiles as $df) $cacherenewtime=max($cacherenewtime,@filemtime($df)); return cache_load($id,$cachepathprefix,$cacheclass,$cachename,$session_id,$cacherenewtime,$unserializer); } function cache_save($id,$cachepathprefix,$cacheclass,$cachename,$cachedVar,$session_id=false,$serializer='serialize') { clearstatcache(); $sessid=$session_id.'$'; $filepath=$cachepathprefix.$id.'/'.$cacheclass.'/'.$sessid.$cachename; $dir=dirname($filepath); @mkdir($dir,0777,true); $rtv=file_put_contents($filepath,call_user_func($serializer,$cachedVar))!==FALSE; touch($filepath); return $rtv; } function cache_purge($id,$cachepathprefix,$cacheclass,$fnpattern='*',$session_id=false,$cachelifecycle=1800) { clearstatcache(); $sessid=$session_id.'$'; $dir=$cachepathprefix.$id.'/'.$cacheclass; $fnpattern=$sessid.$fnpattern; $time=time(); $dh=@opendir($dir); if ($dh) while (($file=readdir($dh))!==false) { $fullfile=$dir.'/'.$file; if (is_file($fullfile)) { if (fnmatch($fnpattern,$file)) @unlink($fullfile); else if (filemtime($fullfile)+$cachelifecycle<$time) @unlink($fullfile); } } } function cache_file($id,$cachepathprefix,$cacheclass,$cachename,$session_id=false) { $sessid=$session_id.'$'; $filepath=$cachepathprefix.$id.'/'.$cacheclass.'/'.$sessid.$cachename; return $filepath; } /* This function extracts the cachename from a path to a cache file.
   The cachename can be used as $cachename parameter or $fnpattern parameter when
   calling other cache functions to refer to the file. */ function cache_name($filepath) { $basename=basename($filepath); $dp=strpos($basename,'$'); if ($dp===false) return $basename; return substr($basename,$dp+1); } function cache_list($id,$cachepathprefix,$cacheclass,$fnpattern='*',$session_id=false,$cachelifecycle=1800) { $sessid=$session_id.'$'; $dir=$cachepathprefix.$id.'/'.$cacheclass; $fnpattern=$sessid.$fnpattern; $filepaths=array(); $time=time(); $dh=@opendir($dir); if ($dh) while (($file=readdir($dh))!==false) { $fullfile=$dir.'/'.$file; if (is_file($fullfile)) { if (fnmatch($fnpattern,$file)) if (filemtime($fullfile)+$cachelifecycle>$time) array_push($filepaths,$fullfile); } } return $filepaths; } ?>