 /*~ visualeffects.js
.---------------------------------------------------------------------------.
|  Software: JavaScript Visual Effects Library                              |
|   Version: 0.1                                                            |
|   Contact: via http://www.uniwits.com/contact                             |
|      Info: http://www.uniwits.com/                                        |
|   Support: http://www.uniwits.com/support                                 |
| ------------------------------------------------------------------------- |
|     Admin: Yuxiang Mao (project admininistrator)                          |
|   Authors: Yuxiang Mao (Uniwits) contact@uniwits.com                      |
|   Founder: Yuxiang Mao                                                    |
| Copyright (c) 2011, Yuxiang Mao. All Rights Reserved.                     |
| ------------------------------------------------------------------------- |
|   License: Distributed under Uniwits Shareware License (USL)              |
|            http://www.uniwits.com/licenses/shareware/                     |
| This program is distributed as a part of software provided by Uniwits     |
| System WITHOUT ANY WARRANTY; without even the implied warranty of         |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                      |
| ------------------------------------------------------------------------- |
*/ if (!window.UNIWITS_VISUALEFFECTS) window.UNIWITS_VISUALEFFECTS={}; if (!window.getComputedStyle) { window.getComputedStyle =function(el, pseudo) { this.el =el; this.getPropertyValue =function(prop) { var re =/(\-([a-z]){1})/g; if (prop == 'float') prop ='styleFloat'; if (re.test(prop)) { prop =prop.replace(re, function () { return arguments[2].toUpperCase(); }); } return el.currentStyle[prop] ? el.currentStyle[prop] : null; }; return this; }; } function UNIWITS_DECOMPOSE_RGBCOLORNAME(colorname) { if (colorname.charAt(0)=='#') { return [parseInt(colorname.substr(1,2),16),parseInt(colorname.substr(3,2),16),parseInt(colorname.substr(5,2),16)]; } else { var colorparts=colorname.substring(4,colorname.length-1).split(","); return [parseInt(colorparts[0]),parseInt(colorparts[1]),parseInt(colorparts[2])]; } } function UNIWITS_BUILD_HEXRGBCOLORNAME(rgbarray) { var name='#'; for (var i=0;i<3;i++) { var cp=Number(rgbarray[i]).toString(16); if (cp.length<2) cp='0'+cp; name+=cp; } return name; } function UNIWITS_VISUALEFFECTS() { this.set_blink=function(id,colorstylename,radius,radianStep,refreshintervalms) { var uv=window.UNIWITS_VISUALEFFECTS; if (!uv.blink) uv.blink={ bases:new Array(), radii:new Array(), cur_radians:new Array(), stylenames:new Array(), oldstylevalues:new Array(), ids:new Array(), intervalhandles:new Array() }; var targetObj=document.getElementById(id); if (!targetObj) return; var idx; for (idx=0;idx<uv.blink.bases.length;idx++) if (uv.blink.ids[idx]==id) break; if (idx>=uv.blink.bases.length) { var targetStyle=window.getComputedStyle(targetObj,null); var colorname=targetStyle.getPropertyValue(colorstylename); uv.blink.bases.length++; uv.blink.radii.length++; uv.blink.cur_radians.length++; uv.blink.stylenames.length++; uv.blink.intervalhandles.length++; uv.blink.oldstylevalues.length++; uv.blink.bases[idx]=UNIWITS_DECOMPOSE_RGBCOLORNAME(colorname); uv.blink.radii[idx]=radius; uv.blink.cur_radians[idx]=0.0; uv.blink.stylenames[idx]=colorstylename; uv.blink.oldstylevalues[idx]=UNIWITS_VISUALEFFECTS_get_rawstyle(id,colorstylename); uv.blink.ids[idx]=id; } else window.clearInterval(uv.blink.intervalhandles[idx]); uv.blink.intervalhandles[idx]=window.setInterval("UNIWITS_VISUALEFFECTS_update_blink("+idx+","+radianStep+")",refreshintervalms); }; this._stop_blink=function (idx) { var uv=window.UNIWITS_VISUALEFFECTS; if (uv.blink.intervalhandles[idx]>=0) { window.clearInterval(uv.blink.intervalhandles[idx]); uv.blink.intervalhandles[idx]=-1; uv.blink.cur_radians[idx]=0; UNIWITS_VISUALEFFECTS_set_style(uv.blink.ids[idx],uv.blink.stylenames[idx],uv.blink.oldstylevalues[idx]); } }; this.stop_all_blink=function () { var uv=window.UNIWITS_VISUALEFFECTS; if (!uv.blink) return; for (var i=0;i<uv.blink.intervalhandles.length;i++) if (uv.blink.intervalhandles[i]>=0) this._stop_blink(i); }; this.stop_blink=function (id) { var uv=window.UNIWITS_VISUALEFFECTS; if (!uv.blink) return; for (var i=0;i<uv.blink.intervalhandles.length;i++) { if (uv.blink.ids[i]==id) { this._stop_blink(i); break; } } }; } function UNIWITS_script_stylename(stylename) { var snparts=stylename.split('-'); var ssn=snparts[0]; for (var i=1;i<snparts.length;i++) ssn+=snparts[i].charAt(0).toUpperCase()+snparts[i].substr(1); return ssn; } function UNIWITS_VISUALEFFECTS_set_style(id,stylename,value) { var obj=document.getElementById(id); try { obj.style.setProperty(stylename,value,""); } catch (e) { obj.style[UNIWITS_script_stylename(stylename)]=value; } } function UNIWITS_VISUALEFFECTS_get_style(id,stylename) { var obj=document.getElementById(id); var ps=window.getComputedStyle(obj,null); return ps.getPropertyValue(stylename); } function UNIWITS_VISUALEFFECTS_get_rawstyle(id,stylename) { var obj=document.getElementById(id); try { return obj.style.getPropertyValue(stylename); } catch (e) { return obj.style[UNIWITS_script_stylename(stylename)]; } } function UNIWITS_VISUALEFFECTS_transfer_style(idfrom,idto,stylename) { var value=UNIWITS_VISUALEFFECTS_get_style(idfrom,stylename); UNIWITS_VISUALEFFECTS_set_style(idto,stylename,value); } function UNIWITS_VISUALEFFECTS_update_blink(idx,radianStep) { var uv=window.UNIWITS_VISUALEFFECTS; var radian=(uv.blink.cur_radians[idx]+=radianStep); var scale=1+Math.sin(radian)*uv.blink.radii[idx]; var rgb=[Math.round(uv.blink.bases[idx][0]*scale),Math.round(uv.blink.bases[idx][1]*scale),Math.round(uv.blink.bases[idx][2]*scale)]; for (var i=0;i<3;i++) rgb[i]=Math.max(0,Math.min(rgb[i],255)); var obj=document.getElementById(uv.blink.ids[idx]); try { var color="rgb("+rgb[0]+','+rgb[1]+','+rgb[2]+")"; obj.style.setProperty(uv.blink.stylenames[idx],color,""); } catch (e) { var color=UNIWITS_BUILD_HEXRGBCOLORNAME(rgb); obj.style[UNIWITS_script_stylename(uv.blink.stylenames[idx])]=color; } } 