<?php function charge_obj_subscription_if_necessary($dbconn,$mb_id,$obj_name,$obj_id,$daily_price,$default_since_sec,$upto_sec_utc=null,$is_deletion=false) { $load_bill_func="db_load_last_bill_".$obj_name; $insert_bill_func="db_insert_bill_".$obj_name; if (!is_callable($load_bill_func)) throw new Exception("Cannot call bill load function: ".$load_bill_func); if (!is_callable($insert_bill_func)) throw new Exception("Cannot call bill insertion function: ".$insert_bill_func); if (!$obj_id) throw new Exception("Invalid object id: ".$obj_id); $lastbills=call_user_func($load_bill_func,$dbconn,$obj_id); $lastbill=$lastbills[0]; $lastbill_upto_sec=$lastbill['ubd_upto_timestamp']?datetime_to_seconds($lastbill['ubd_upto_timestamp']):$default_since_sec; if (!$upto_sec_utc) $upto_sec_utc=uniwits_time(); if ($is_deletion || $upto_sec_utc-$lastbill_upto_sec>$Config->Charge_Recur_Period_Min_Sec) { $amount=max(1,($upto_sec_utc-$lastbill_upto_sec)/86400.0)*$daily_price; $uh_id=db_record_unilar_flow($dbconn, array( 'mb_id'=>$mb_id, 'uh_amount'=>-$amount, 'uh_reason'=>'CONSUME' ) ); $ubd_id=db_insert_bill_detail($dbconn,$uh_id,$amount,seconds_to_datetime($upto_sec_utc)); call_user_func($insert_bill_func,$dbconn,$ubd_id,$obj_id); } } function charge_obj_subscription_if_necessary_multi($dbconn,$mb_id,$obj_name,$obj_key,$obj_ids,$daily_price,$default_since_sec_map,$upto_sec_utc=null,$is_deletion=false) { $load_bill_func="db_load_last_bill_".$obj_name; $insert_bill_func="db_insert_bill_".$obj_name; if (!is_callable($load_bill_func)) throw new Exception("Cannot call bill load function: ".$load_bill_func); if (!is_callable($insert_bill_func)) throw new Exception("Cannot call bill insertion function: ".$insert_bill_func); if (!$obj_ids) throw new Exception("Invalid object id: ".$obj_ids); if (!is_array($obj_ids)) $obj_ids=array($obj_ids); $lastbills=call_user_func($load_bill_func,$dbconn,$obj_ids); $id2lastbill=rowset2map($lastbills,$obj_key); $lastbill_upto_sec=array(); foreach ($obj_ids as $obj_id) { $lastbill=$id2lastbill[$obj_id]; if ($lastbill['ubd_upto_timestamp']) $lastbill_upto_sec[$obj_id]=datetime_to_seconds($lastbill['ubd_upto_timestamp']); else $lastbill_upto_sec[$obj_id]=$default_since_sec_map[$obj_id]; } if (!$upto_sec_utc) $upto_sec_utc=uniwits_time(); $total_amount=0; $id2amount=array(); foreach ($obj_ids as $obj_id) { if ($is_deletion || $upto_sec_utc-$lastbill_upto_sec[$obj_id]>$Config->Charge_Recur_Period_Min_Sec) { if ($is_deletion) $total_amount+=$id2amount[$obj_id]=max(1,($upto_sec_utc-$lastbill_upto_sec[$obj_id])/86400.0)*$daily_price; else $total_amount+=$id2amount[$obj_id]=($upto_sec_utc-$lastbill_upto_sec[$obj_id])/86400.0*$daily_price; } } $uh_id=null; if ($total_amount>0) { $uh_id=db_record_unilar_flow($dbconn, array( 'mb_id'=>$mb_id, 'uh_amount'=>-$total_amount, 'uh_reason'=>'CONSUME' ) ); } if ($uh_id) { $upto_datetime_utc=seconds_to_datetime($upto_sec_utc); foreach ($id2amount as $id=>$amount) { $ubd_id=db_insert_bill_detail($dbconn,$uh_id,$amount,$upto_datetime_utc); call_user_func($insert_bill_func,$dbconn,$ubd_id,$id); } } } function charge_classroom_subscription($dbconn,$clsr_id,$upto_sec_utc=null,$is_deletion=false) { global $Config; $classroom=db_load_classroom($dbconn,$clsr_id); $amount_daily=$Config->Prices['text.daily.1kb']*ceil(strlen($classroom['clsr_desc'])/1024.0); $amount_daily+=$Config->Prices['classroom.daily.1']; charge_obj_subscription_if_necessary( $dbconn, $classroom['mb_id_owner'], 'classroom', $clsr_id, $amount_daily, datetime_to_seconds($oldci['clsr_timestamp_initial']), $upto_sec_utc, $is_deletion ); } function charge_course_subscription($dbconn,$cs_id,$upto_sec_utc=null,$is_deletion=false) { global $Config; $course=db_load_course_by_id($dbconn,$cs_id); if ($course['cs_desc_type']=='HTML') $amount_daily=$Config->Prices['html.daily.1kb']; else $amount_daily=$Config->Prices['text.daily.1kb']; $amount_daily*=ceil(strlen($course['cs_desc'])/1024.0); $amount_daily+=$Config->Prices['course.daily.1']; charge_obj_subscription_if_necessary( $dbconn, $course['mb_id_owner'], 'course', $cs_id, $amount_daily, datetime_to_seconds($course['cs_timestamp_initial']), $upto_sec_utc, $is_deletion ); } function charge_place_subscription($dbconn,$plc_id,$upto_sec_utc=null,$is_deletion=false) { global $Config; $place=db_load_place($dbconn,$plc_id); charge_obj_subscription_if_necessary( $dbconn, $place['mb_id_owner'], 'place', $plc_id, $Config->Prices['place.daily.1'], datetime_to_seconds($place['plc_timestamp_initial']), $upto_sec_utc, $is_deletion ); } function charge_seat_subscription($dbconn,$mb_id,$st_ids,$upto_sec_utc=null,$is_deletion=false) { global $Config; $seats=db_load_seats($dbconn,$st_ids); $default_since_sec_map=array(); foreach ($seats as $st) $default_since_sec_map[$st['st_id']]=datetime_to_seconds($st['st_timestamp_initial']); charge_obj_subscription_if_necessary_multi( $dbconn, $mb_id, 'seat', 'st_id', $st_ids, $Config->Prices['seat.daily.1'], $default_since_sec_map, $upto_sec_utc, $is_deletion ); } function charge_all_subscriptions_of_member($dbconn,$mb_id,$due_datetime) { global $Config; $unpaid_objs=db_query_member_with_unpaid_subscription( $dbconn, $due_datetime, false, array('`clsr_id`', '`cs_id`', '`plc_id`', '`st_id`'), array('mb_id'=>$mb_id) ); $obj_id_coll=array(); $obj_id_saved_flags=array(); foreach ($unpaid_objs as $row) { foreach ($row as $idkey=>$id) { if ($id && !isset($obj_id_saved_flags[$idkey][$id])) { $obj_id_saved_flags[$idkey][$id]=1; if (!$obj_id_coll[$idkey]) $obj_id_coll[$idkey]=array(); array_push($obj_id_coll[$idkey],$id); } } } $factor_coll=array( 'classroom'=>db_load_classroom_bill_factors($dbconn,$obj_id_coll['clsr_id']), 'course' =>db_load_course_bill_factors ($dbconn,$obj_id_coll['cs_id']), 'place' =>db_load_place_bill_factors ($dbconn,$obj_id_coll['plc_id']), 'seat' =>db_load_seat_bill_factors ($dbconn,$obj_id_coll['st_id']) ); $factor_prefix=array( 'classroom'=>'clsr_', 'course' =>'cs_', 'place' =>'plc_', 'seat' =>'st_' ); $due_datetime_sec=datetime_to_seconds($due_datetime); $total_amount=0; $amount_map=array(); foreach ($factor_coll as $objname=>$factors) { $obj_id_key =$factor_prefix[$objname].'id'; $obj_timestamp_initial_key=$factor_prefix[$objname].'timestamp_initial'; $obj_desc_len_key =$factor_prefix[$objname].'desc_len'; $obj_desc_type_key =$factor_prefix[$objname].'desc_type'; $obj_price_daily =$Config->Prices[$objname.'.daily.1']; foreach ($factors as $obj_facts) { $amount_daily=$obj_price_daily; if ($obj_facts[$obj_desc_len_key]) { if ($obj_facts[$obj_desc_type_key]=='HTML') $amount_daily+=ceil($obj_facts[$obj_desc_len_key]/1024.0)*$Config->Prices['html.daily.1kb']; else $amount_daily+=ceil($obj_facts[$obj_desc_len_key]/1024.0)*$Config->Prices['text.daily.1kb']; } $obj_charge_since_sec=datetime_to_seconds($obj_facts['charge_since']); $daycount=max(1,($due_datetime_sec-$obj_charge_since_sec)/24.0/3600); $amount=$amount_daily*$daycount; $amount_map[$objname][$obj_facts[$obj_id_key]]=$amount; $total_amount+=$amount; } } $uh_id=db_record_unilar_flow($dbconn, array( 'mb_id'=>$mb_id, 'uh_amount'=>-$total_amount, 'uh_reason'=>'CONSUME', 'uh_comment'=>'** AUTO SETTLEMENT **' ) ); foreach ($amount_map as $objname=>$id_amounts) { $billobj='bill_'.$objname; $obj_id_key=$factor_prefix[$objname].'id'; foreach ($id_amounts as $id=>$amount) { $ubd_id=db_insert_bill_detail($dbconn,$uh_id,$amount,$due_datetime); _db_insert_bill_detail_obj($dbconn,$billobj,$ubd_id,$obj_id_key,$id); } } return $uh_id; } ?>