/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	VAI/OfoCXiUARTjhCoiADSP-BF533pj
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include "jsp_kernel.h"
#include "uart.h"


#ifndef _MACRO_ONLY


/**************************************************************
 *  SIOhCȍ[`
 **************************************************************/
void
sio_initialize()
{
	unsigned int imask;
	
	asm volatile( "cli %0;": "=d"(imask) );
	uart_initialize();
	asm volatile( "sti %0;": :"d"(imask) );
}
/**************************************************************
 *  VAI/O|[g̃I[v
 */
SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
	unsigned int imask;
	SIOPCB * r;
	
	asm volatile( "cli %0;": "=d"(imask) );
	r = uart_opn_por( siopid, exinf );
	asm volatile( "sti %0;": :"d"(imask) );
	return( r );
}

/**************************************************************
 *  VAI/O|[g̃N[Y
 *************************************************************
 */
void
sio_cls_por(SIOPCB *siopcb)
{
	unsigned int imask;
	
	asm volatile( "cli %0;": "=d"(imask) );
	sio_cls_por(siopcb);
	asm volatile( "sti %0;": :"d"(imask) );
}

/**************************************************************
 *  SIO̊݃nh
 *************************************************************
 */
void
sio_isr()
{
	unsigned int imask;
	
	asm volatile( "cli %0;": "=d"(imask) );
	uart_isr();
	asm volatile( "sti %0;": :"d"(imask) );
}

/**************************************************************
 *  VAI/O|[gւ̕M
 *************************************************************
 */
BOOL
sio_snd_chr(SIOPCB *siopcb, char c)
{
	unsigned int imask;
	BOOL r;
	
	asm volatile( "cli %0;": "=d"(imask) );
	r = uart_snd_chr(siopcb, c);
	asm volatile( "sti %0;": :"d"(imask) );
	return( r );
}

/**************************************************************
 *  VAI/O|[g̕M
 *************************************************************
 */
INT
sio_rcv_chr(SIOPCB *siopcb)
{
	unsigned int imask;
	INT r;
	
	asm volatile( "cli %0;": "=d"(imask) );
	r = uart_rcv_chr(siopcb);
	asm volatile( "sti %0;": :"d"(imask) );
	return( r );
}

/**************************************************************
 *  VAI/O|[g̃R[obN̋
 *************************************************************
 */
void
sio_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	unsigned int imask;
	
	asm volatile( "cli %0;": "=d"(imask) );
	uart_ena_cbr(siopcb, cbrtn);
	asm volatile( "sti %0;": :"d"(imask) );
}
 
/**************************************************************
 *  VAI/O|[g̃R[obN̋֎~
 *************************************************************
 */
void
sio_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	unsigned int imask;
	
	asm volatile( "cli %0;": "=d"(imask) );
	uart_dis_cbr(siopcb, cbrtn);
	asm volatile( "sti %0;": :"d"(imask) );
}


#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
