/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Attribute;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.DataTypeDeclaration;
import jp.sourceforge.tmdmaker.model.Detail;
import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.IdentifierRef;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.SarogateKey;
import jp.sourceforge.tmdmaker.model.SarogateKeyRef;
import jp.sourceforge.tmdmaker.model.StandardSQLDataType;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.model.SubsetType;
import jp.sourceforge.tmdmaker.model.VirtualEntity;
import jp.sourceforge.tmdmaker.model.util.ModelEditUtils;

public class ImplementRule {
    private static boolean foreignKeyEnabled;

    public static List<AbstractEntityModel> findNotImplementModel(AbstractEntityModel model) {
        ArrayList<AbstractEntityModel> subsets = new ArrayList<AbstractEntityModel>();
        ArrayList<AbstractEntityModel> ves = new ArrayList<AbstractEntityModel>();
        ArrayList<AbstractEntityModel> results = new ArrayList<AbstractEntityModel>();
        ImplementRule.findNotImplementSubset(subsets, model);
        ImplementRule.findNotImplementVirtualEntity(ves, model);
        for (AbstractEntityModel m : subsets) {
            ImplementRule.findNotImplementVirtualEntity(ves, m);
        }
        results.addAll(subsets);
        results.addAll(ves);
        return results;
    }

    private static void findNotImplementSubset(List<AbstractEntityModel> results, AbstractEntityModel model) {
        SubsetType type = model.findSubsetType();
        if (type == null) {
            return;
        }
        for (AbstractConnectionModel connection : type.getModelSourceConnections()) {
            SubsetEntity subset = (SubsetEntity)connection.getTarget();
            if (subset.isNotImplement()) {
                results.add(subset);
            }
            ImplementRule.findNotImplementSubset(results, subset);
        }
    }

    private static void findNotImplementVirtualEntity(List<AbstractEntityModel> results, AbstractEntityModel model) {
        for (AbstractConnectionModel connection : model.getModelSourceConnections()) {
            ConnectableElement e = connection.getTarget();
            if (!(e instanceof VirtualEntity)) continue;
            VirtualEntity ve = (VirtualEntity)e;
            if (ve.isNotImplement()) {
                results.add(ve);
            }
            ImplementRule.findNotImplementVirtualEntity(results, ve);
        }
    }

    public static List<IAttribute> findAllImplementAttributes(AbstractEntityModel model) {
        Object reused;
        ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
        SarogateKey sarogateKey = model.getKeyModels().getSarogateKey();
        if (sarogateKey.isEnabled()) {
            attributes.add(sarogateKey);
        }
        if (model instanceof Entity) {
            attributes.add(((Entity)model).getIdentifier());
        }
        if (model instanceof Detail) {
            attributes.add(((Detail)model).getDetailIdentifier());
        }
        if (model instanceof SubsetEntity) {
            reused = ((SubsetEntity)model).getOriginalReusedIdentifier();
            for (IdentifierRef identifierRef : ((ReusedIdentifier)reused).getUniqueIdentifieres()) {
                attributes.add(identifierRef);
            }
        }
        reused = model.getReusedIdentifieres();
        for (Map.Entry entry : reused.entrySet()) {
            ReusedIdentifier ri = (ReusedIdentifier)entry.getValue();
            if (ri == null) continue;
            if (ri.isSarogateKeyEnabled()) {
                for (SarogateKeyRef s : ri.getSarogateKeys()) {
                    attributes.add(s);
                }
                continue;
            }
            for (IdentifierRef ref : ri.getUniqueIdentifieres()) {
                attributes.add(ref);
            }
        }
        attributes.addAll(model.getAttributes());
        for (AbstractEntityModel abstractEntityModel : model.getImplementDerivationModels()) {
            attributes.addAll(abstractEntityModel.getAttributes());
        }
        return attributes;
    }

    public static AbstractEntityModel findOriginalImplementModel(AbstractEntityModel model) {
        if (model != null && model.isNotImplement()) {
            if (model instanceof SubsetEntity) {
                return ImplementRule.findOriginalImplementModel(((SubsetEntity)model).getSuperset());
            }
            if (model instanceof VirtualEntity) {
                return ImplementRule.findOriginalImplementModel(((VirtualEntity)model).getRealEntity());
            }
            return model;
        }
        return model;
    }

    public static void setModelDefaultValue(AbstractEntityModel model) {
        if (ModelEditUtils.isEmpty(model.getImplementName())) {
            model.setImplementName(model.getName());
        }
    }

    public static void setIdentifierDefaultValue(Identifier identifier) {
        if (ModelEditUtils.isEmpty(identifier.getImplementName())) {
            identifier.setImplementName(identifier.getName());
        }
        if (identifier.getDataTypeDeclaration() == null) {
            identifier.setDataTypeDeclaration(new DataTypeDeclaration(StandardSQLDataType.NUMERIC, 10, 0));
        }
    }

    public static void setEventDefaultAttributeValue(Attribute attribute) {
        attribute.setImplementName(attribute.getName());
        attribute.setDataTypeDeclaration(new DataTypeDeclaration(StandardSQLDataType.DATE, null, null));
    }

    public static void setResourceDefaultAttributeValue(Attribute attribute) {
        attribute.setImplementName(attribute.getName());
        attribute.setDataTypeDeclaration(new DataTypeDeclaration(StandardSQLDataType.CHARACTER_VARYING, 10, null));
    }

    public static boolean isForeignKeyEnabled() {
        return foreignKeyEnabled;
    }

    public static void setForeignKeyEnabled(boolean foreignKeyEnabled) {
        ImplementRule.foreignKeyEnabled = foreignKeyEnabled;
    }
}

