/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.treeeditpart;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.TMDPlugin;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.CombinationTable;
import jp.sourceforge.tmdmaker.model.Detail;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.KeyModel;
import jp.sourceforge.tmdmaker.model.Laputa;
import jp.sourceforge.tmdmaker.model.MappingList;
import jp.sourceforge.tmdmaker.model.MultivalueOrEntity;
import jp.sourceforge.tmdmaker.model.RecursiveTable;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.model.VirtualEntity;
import jp.sourceforge.tmdmaker.treeeditpart.FolderTreeEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractEntityModelTreeEditPart
extends AbstractTreeEditPart
implements PropertyChangeListener {
    private static Logger logger = LoggerFactory.getLogger(AbstractEntityModelTreeEditPart.class);
    private static Map<Type, String> icons = new HashMap<Type, String>();
    List<List<?>> children = new ArrayList();
    List<Identifier> identifiers = new ArrayList<Identifier>();

    static {
        icons.put((Type)((Object)CombinationTable.class), "icons/outline/combination_table.png");
        icons.put((Type)((Object)SubsetEntity.class), "icons/outline/subset_resource.png");
        icons.put((Type)((Object)VirtualEntity.class), "icons/outline/virtual_entity.png");
        icons.put((Type)((Object)MultivalueOrEntity.class), "icons/outline/multivalue_or.png");
        icons.put((Type)((Object)Detail.class), "icons/outline/detail.png");
        icons.put((Type)((Object)RecursiveTable.class), "icons/outline/recursive_table.png");
        icons.put((Type)((Object)MappingList.class), "icons/outline/mapping_list.png");
        icons.put((Type)((Object)Laputa.class), "icons/outline/laputa.png");
    }

    public AbstractEntityModel getModel() {
        return (AbstractEntityModel)super.getModel();
    }

    protected List<List<?>> getModelChildren() {
        return this.children;
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.updateChildren();
    }

    protected void clearChildren() {
        this.children.clear();
        this.identifiers.clear();
    }

    protected void updateChildren() {
        this.clearChildren();
        this.setIdentifiers();
        this.setAttributes();
        this.setKeyModels();
    }

    protected void setIdentifiers() {
        for (ReusedIdentifier r : this.getModel().getReusedIdentifieres().values()) {
            for (Identifier i : r.getIdentifires()) {
                this.identifiers.add(i);
            }
        }
        if (this.identifiers != null && this.identifiers.size() != 0) {
            this.children.add(this.identifiers);
        }
    }

    protected void setAttributes() {
        List attributes = this.getModel().getAttributes();
        if (attributes != null && attributes.size() != 0) {
            this.children.add(attributes);
        }
    }

    protected void setKeyModels() {
        ArrayList<KeyModel> keymodels = new ArrayList<KeyModel>();
        for (KeyModel key : this.getModel().getKeyModels()) {
            keymodels.add(key);
        }
        if (keymodels.size() > 0) {
            this.children.add(keymodels);
        }
    }

    protected String getText() {
        AbstractEntityModel model = this.getModel();
        if (model.getName() == null) {
            return "";
        }
        return model.getName();
    }

    protected Image getImage() {
        if (icons.containsKey(this.getModel().getClass())) {
            String path = icons.get(this.getModel().getClass());
            return TMDPlugin.getImage(path);
        }
        return super.getImage();
    }

    public void activate() {
        super.activate();
        this.getModel().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void deactivate() {
        this.getModel().removePropertyChangeListener((PropertyChangeListener)this);
        super.deactivate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        logger.debug(this.getClass() + "." + evt.getPropertyName());
        if (evt.getPropertyName().equals("_property_name")) {
            this.handleNameChange(evt);
        } else if (evt.getPropertyName().equals("_property_constraint")) {
            this.handleConstraintChange(evt);
        } else if (evt.getPropertyName().equals("p_attribute")) {
            this.handleAttributeChange(evt);
        } else if (evt.getPropertyName().equals("p_source_connection")) {
            this.handleSourceConnectionChange(evt);
        } else if (evt.getPropertyName().equals("p_target_connection")) {
            this.handleTargetConnectionChange(evt);
        } else if (evt.getPropertyName().equals("p_reused")) {
            this.handleReUseKeyChange(evt);
        } else if (evt.getPropertyName().equals("_property_identifier")) {
            this.handleIdentifierChange(evt);
        } else if (evt.getPropertyName().equals("p_attribute_reorder")) {
            logger.warn("Handle Reorder Occured.");
            this.refreshChildren();
        } else {
            logger.warn("Not Handle Event Occured.");
        }
    }

    protected void handleNameChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void handleConstraintChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void handleAttributeChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
        this.refreshChildren();
    }

    protected void handleIdentifierChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void handleAttributeReorder(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void handleReUseKeyChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    protected void handleSourceConnectionChange(PropertyChangeEvent evt) {
    }

    protected void handleTargetConnectionChange(PropertyChangeEvent evt) {
    }

    protected void refreshVisuals() {
        logger.debug(String.valueOf(this.getClass().toString()) + "#refreshVisuals()");
        super.refreshVisuals();
        this.refreshChildren();
    }

    protected void refreshChildren() {
        logger.debug(String.valueOf(this.getClass().toString()) + "#refreshChildren()");
        this.updateChildren();
        List children = this.getChildren();
        int size = children.size();
        HashMap<Object, FolderTreeEditPart> modelToEditPart = new HashMap<Object, FolderTreeEditPart>();
        if (size > 0) {
            modelToEditPart = new HashMap(size);
            for (FolderTreeEditPart e : children) {
                modelToEditPart.put(e.getModel(), e);
            }
        }
        List<List<?>> modelObjects = this.getModelChildren();
        int i = 0;
        while (i < modelObjects.size()) {
            List<?> model = modelObjects.get(i);
            FolderTreeEditPart editPart = (FolderTreeEditPart)modelToEditPart.get(model);
            if (editPart != null) {
                this.reorderChild((EditPart)editPart, i);
            } else {
                editPart = (FolderTreeEditPart)this.createChild(model);
                this.addChild((EditPart)editPart, i);
            }
            ++i;
        }
        size = children.size();
        if (i < size) {
            ArrayList<FolderTreeEditPart> trash = new ArrayList<FolderTreeEditPart>(size - i);
            while (i < size) {
                trash.add((FolderTreeEditPart)children.get(i));
                ++i;
            }
            i = 0;
            while (i < trash.size()) {
                EditPart ep = (EditPart)trash.get(i);
                this.removeChild(ep);
                ++i;
            }
        }
    }
}

