/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpolicy;

import jp.sourceforge.tmdmaker.editpart.AbstractRelationshipEditPart;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editpolicies.ConnectionEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.requests.LocationRequest;

public class RelationshipEditPolicy
extends ConnectionEditPolicy {
    private RelationHint hint;

    public void eraseTargetFeedback(Request request) {
        if (request instanceof LocationRequest) {
            this.eraseHintFeedback((LocationRequest)request);
        } else {
            super.eraseTargetFeedback(request);
        }
    }

    public void showTargetFeedback(Request request) {
        if (request instanceof LocationRequest) {
            this.showHintFeedback((LocationRequest)request);
        } else {
            super.showTargetFeedback(request);
        }
    }

    protected void showHintFeedback(LocationRequest request) {
        this.showHint();
        this.getHint().setFromText(((AbstractConnectionModel)this.getHost().getModel()).getSourceName());
        this.getHint().setToText(((AbstractConnectionModel)this.getHost().getModel()).getTargetName());
        this.getHint().setLocation(request.getLocation());
    }

    protected void eraseHintFeedback(LocationRequest request) {
        this.hideHint();
    }

    protected void showHint() {
        if (this.hint == null) {
            this.hint = new RelationHint();
            this.addFeedback((IFigure)this.hint);
        }
    }

    protected RelationHint getHint() {
        return this.hint;
    }

    protected void hideHint() {
        if (this.hint != null) {
            this.removeFeedback((IFigure)this.hint);
            this.hint = null;
        }
    }

    protected void addFeedback(IFigure figure) {
        this.getFeedbackLayer().add(figure);
    }

    protected void removeFeedback(IFigure figure) {
        this.getFeedbackLayer().remove(figure);
    }

    protected IFigure getFeedbackLayer() {
        return this.getLayer("Feedback Layer");
    }

    protected IFigure getLayer(Object layer) {
        return LayerManager.Helper.find((EditPart)this.getHost()).getLayer(layer);
    }

    protected Command getDeleteCommand(GroupRequest request) {
        return null;
    }

    class RelationHint
    extends Figure {
        private Label from = new Label();
        private Label to;

        public RelationHint() {
            this.from.setBorder((Border)new MarginBorder(2, 2, 2, 2));
            this.to = new Label();
            this.to.setBorder((Border)new MarginBorder(2, 2, 2, 2));
            ToolbarLayout layout = new ToolbarLayout();
            layout.setStretchMinorAxis(false);
            layout.setMinorAlignment(1);
            layout.setStretchMinorAxis(false);
            layout.setSpacing(2);
            this.setLayoutManager((LayoutManager)layout);
            this.setBorder((Border)new LineBorder());
            this.setOpaque(true);
            this.setBackgroundColor(ColorConstants.yellow);
            this.add((IFigure)this.from);
            this.add((IFigure)this.to);
        }

        public void setFromText(String text) {
            this.from.setText("from:" + text);
        }

        public void setToText(String text) {
            this.to.setText("to:" + text);
        }

        private Dimension max(Dimension from, Dimension to) {
            if (from.width >= to.width) {
                return from;
            }
            return to;
        }

        public void setLocation(Point p) {
            Point np = p.getCopy();
            ((AbstractRelationshipEditPart)RelationshipEditPolicy.this.getHost()).getConnectionFigure().translateToRelative((Translatable)np);
            np.x += 10;
            if (this.getLocation().equals((Object)np)) {
                return;
            }
            Dimension d = this.max(this.from.getPreferredSize(), this.to.getPreferredSize()).getCopy();
            d.width = (int)((double)d.width * 1.25);
            d.height = d.height * 2 + 2;
            this.setBounds(new Rectangle(np, d));
            super.setLocation(np);
        }
    }
}

