/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.dialog.VirtualEntityEditDialog;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityEditPart;
import jp.sourceforge.tmdmaker.editpolicy.EntityLayoutEditPolicy;
import jp.sourceforge.tmdmaker.editpolicy.ReconnectableNodeEditPolicy;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.VirtualEntity;
import jp.sourceforge.tmdmaker.model.VirtualEntityType;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;
import jp.sourceforge.tmdmaker.ui.command.ImplementDerivationModelsDeleteCommand;
import jp.sourceforge.tmdmaker.ui.command.ModelEditCommand;
import jp.sourceforge.tmdmaker.ui.command.TableDeleteCommand;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.ModelAppearance;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class VirtualEntityEditPart
extends AbstractEntityEditPart {
    @Override
    protected void onDoubleClicked() {
        VirtualEntity entity = (VirtualEntity)this.getModel();
        VirtualEntityEditDialog dialog = new VirtualEntityEditDialog(this.getViewer().getControl().getShell(), entity);
        if (dialog.open() == 0) {
            CompoundCommand ccommand = new CompoundCommand();
            List<EditAttribute> editAttributeList = dialog.getEditAttributeList();
            this.addAttributeEditCommands(ccommand, (AbstractEntityModel)entity, editAttributeList);
            AbstractEntityModel edited = dialog.getEditedValue();
            ModelEditCommand command = new ModelEditCommand((AbstractEntityModel)entity, edited);
            if (entity.isNotImplement() && !edited.isNotImplement()) {
                AbstractEntityModel original = ImplementRule.findOriginalImplementModel((AbstractEntityModel)entity);
                ccommand.add((Command)new ImplementDerivationModelsDeleteCommand((AbstractEntityModel)entity, original));
            }
            ccommand.add((Command)command);
            this.getViewer().getEditDomain().getCommandStack().execute((Command)ccommand);
        }
    }

    @Override
    protected void updateFigure(IFigure figure) {
        EntityFigure entityFigure = (EntityFigure)figure;
        VirtualEntity entity = (VirtualEntity)this.getModel();
        entityFigure.setNotImplement(entity.isNotImplement());
        entityFigure.removeAllRelationship();
        entityFigure.setEntityName(entity.getName());
        entityFigure.setEntityType(EntityType.VE.getLabel());
        for (Map.Entry rk : entity.getReusedIdentifieres().entrySet()) {
            for (Identifier i : ((ReusedIdentifier)rk.getValue()).getUniqueIdentifieres()) {
                entityFigure.addRelationship(i.getName());
            }
        }
        ModelAppearance appearance = null;
        appearance = entity.getVirtualEntityType().equals((Object)VirtualEntityType.RESOURCE) ? ModelAppearance.RESOURCE_VIRTUAL_ENTITY : (entity.getVirtualEntityType().equals((Object)VirtualEntityType.EVENT) ? ModelAppearance.EVENT_SUBSET : ModelAppearance.VIRTUAL_ENTITY);
        this.setupColor((IFigure)entityFigure, appearance);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new VirtualEntityComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EntityLayoutEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ReconnectableNodeEditPolicy());
    }

    private static class VirtualEntityComponentEditPolicy
    extends ComponentEditPolicy {
        private VirtualEntityComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            VirtualEntity model = (VirtualEntity)this.getHost().getModel();
            CompoundCommand ccommand = new CompoundCommand();
            if (model.isNotImplement()) {
                AbstractEntityModel original = ImplementRule.findOriginalImplementModel((AbstractEntityModel)model);
                ccommand.add((Command)new ImplementDerivationModelsDeleteCommand((AbstractEntityModel)model, original));
            }
            ccommand.add((Command)new TableDeleteCommand((AbstractEntityModel)model, (AbstractConnectionModel)model.getModelTargetConnections().get(0)));
            return ccommand;
        }
    }
}

