/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog.component;

import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.model.StandardSQLDataType;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SarogateKeyPanel2
extends Composite {
    private EditAttribute editAttribute;
    private Label implementNameLabel = null;
    private Text implementNameText = null;
    private Label dataLabel = null;
    private Composite dataTypeComposite = null;
    private Combo dataTypeCombo = null;
    private Label pLabel = null;
    private Text precisionText = null;
    private Label sLabel = null;
    private Text scaleText = null;
    private Button checkBox = null;

    public SarogateKeyPanel2(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridData gridData5 = new GridData();
        gridData5.horizontalSpan = 2;
        gridData5.verticalAlignment = 2;
        gridData5.horizontalAlignment = 4;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.setSize(new Point(254, 113));
        this.checkBox = new Button((Composite)this, 32);
        this.checkBox.setText("\u30b5\u30ed\u30b2\u30fc\u30c8\u30ad\u30fc\u3092\u8ffd\u52a0\u3059\u308b");
        this.checkBox.setLayoutData((Object)gridData5);
        this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("widgetSelected()");
                SarogateKeyPanel2.this.setEnableInputArea(SarogateKeyPanel2.this.checkBox.getSelection());
            }
        });
        this.implementNameLabel = new Label((Composite)this, 0);
        this.implementNameLabel.setText("\u5b9f\u88c5\u540d");
        this.implementNameText = new Text((Composite)this, 2048);
        this.implementNameText.setLayoutData((Object)gridData2);
        this.dataLabel = new Label((Composite)this, 0);
        this.dataLabel.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        this.dataLabel.setText("\u30c7\u30fc\u30bf\u5c5e\u6027");
        this.createDataTypeComposite();
    }

    public void initializeValue(EditAttribute ea) {
        this.editAttribute = ea;
        if (ea.getImplementName() != null && !ea.getImplementName().equals("")) {
            this.checkBox.setSelection(true);
            this.setEnableInputArea(true);
            this.implementNameText.setText(ea.getImplementName());
            StandardSQLDataType dt = ea.getDataType();
            if (dt != null) {
                if (dt.isSupportSize()) {
                    this.precisionText.setText(ea.getSize());
                }
                if (dt.isSupportScale()) {
                    this.scaleText.setText(ea.getScale());
                }
                this.dataTypeCombo.select(dt.ordinal() + 1);
                this.fireDataTypeChanged(this.dataTypeCombo.getSelectionIndex());
            }
        } else {
            this.checkBox.setSelection(false);
            this.setEnableInputArea(false);
        }
    }

    private void fireDataTypeChanged(int index) {
        if (index > 0) {
            StandardSQLDataType dataType = StandardSQLDataType.values()[index - 1];
            this.precisionText.setEnabled(dataType.isSupportSize());
            this.scaleText.setEnabled(dataType.isSupportScale());
        } else {
            this.precisionText.setEnabled(true);
            this.scaleText.setEnabled(true);
        }
    }

    private void setEnableInputArea(boolean enabled) {
        this.implementNameText.setEnabled(enabled);
        this.dataTypeCombo.setEnabled(enabled);
        this.precisionText.setEnabled(enabled);
        this.scaleText.setEnabled(enabled);
    }

    private void createDataTypeComposite() {
        GridData gridData4 = new GridData();
        gridData4.widthHint = 30;
        GridData gridData3 = new GridData();
        gridData3.widthHint = 50;
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 4;
        gridLayout1.marginWidth = 0;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 4;
        this.dataTypeComposite = new Composite((Composite)this, 0);
        this.createDataTypeCombo();
        this.dataTypeComposite.setLayout((Layout)gridLayout1);
        this.dataTypeComposite.setLayoutData((Object)gridData);
        this.pLabel = new Label(this.dataTypeComposite, 0);
        this.pLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.pLabel.setText("\u6841\u6570");
        this.precisionText = new Text(this.dataTypeComposite, 2048);
        this.precisionText.setLayoutData((Object)gridData3);
        this.sLabel = new Label(this.dataTypeComposite, 0);
        this.sLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.sLabel.setText("\u4f4d\u53d6\u308a");
        this.scaleText = new Text(this.dataTypeComposite, 2048);
        this.scaleText.setLayoutData((Object)gridData4);
    }

    private void createDataTypeCombo() {
        GridData gridData1 = new GridData();
        gridData1.horizontalSpan = 4;
        gridData1.verticalAlignment = 2;
        gridData1.widthHint = 180;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.horizontalAlignment = 4;
        this.dataTypeCombo = new Combo(this.dataTypeComposite, 0);
        this.dataTypeCombo.setLayoutData((Object)gridData1);
        this.dataTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("widgetSelected()");
                int index = ((Combo)e.getSource()).getSelectionIndex();
                SarogateKeyPanel2.this.fireDataTypeChanged(index);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.dataTypeCombo.add("");
        StandardSQLDataType[] standardSQLDataTypeArray = StandardSQLDataType.values();
        int n = standardSQLDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            StandardSQLDataType dataType = standardSQLDataTypeArray[n2];
            this.dataTypeCombo.add(dataType.getName());
            ++n2;
        }
    }

    public EditAttribute getEditAttribute() {
        return this.editAttribute;
    }
}

