/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model.rule;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Attribute;
import jp.sourceforge.tmdmaker.model.DataTypeDeclaration;
import jp.sourceforge.tmdmaker.model.Detail;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.MultivalueAndSuperset;
import jp.sourceforge.tmdmaker.model.MultivalueOrEntity;
import jp.sourceforge.tmdmaker.model.StandardSQLDataType;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;

public class MultivalueRule {
    public static MultivalueOrEntity createMultivalueOrEntity(AbstractEntityModel source, String typeName) {
        MultivalueOrEntity target = new MultivalueOrEntity();
        target.setConstraint(source.getConstraint().getTranslated(50, 0));
        target.setName(String.valueOf(source.getName()) + "." + typeName);
        target.setEntityType(source.getEntityType());
        target.addAttribute(MultivalueRule.createTypeCode(typeName));
        return target;
    }

    private static Attribute createTypeCode(String typeName) {
        Attribute attribute = new Attribute();
        attribute.setName(String.valueOf(typeName) + "\u30b3\u30fc\u30c9");
        attribute.setImplementName(attribute.getName());
        attribute.setDataTypeDeclaration(new DataTypeDeclaration(StandardSQLDataType.SMALLINT, null, null));
        return attribute;
    }

    public static Detail createDetail(AbstractEntityModel header) {
        Detail detail = new Detail();
        detail.setName(String.valueOf(header.getName()) + "DTL");
        detail.setEntityType(header.getEntityType());
        detail.setConstraint(header.getConstraint().getTranslated(100, 0));
        detail.setOriginalReusedIdentifier(header.createReusedIdentifier());
        detail.getDetailIdentifier().copyFrom(MultivalueRule.createDetailIdentifier(header.getName()));
        return detail;
    }

    private static Identifier createDetailIdentifier(String headerName) {
        Identifier id = new Identifier(String.valueOf(headerName) + "\u660e\u7d30\u756a\u53f7");
        ImplementRule.setIdentifierDefaultValue(id);
        return id;
    }

    public static MultivalueAndSuperset createMultivalueAndSuperset(AbstractEntityModel header) {
        MultivalueAndSuperset superset = new MultivalueAndSuperset();
        superset.setEntityType(header.getEntityType());
        superset.setConstraint(header.getConstraint().getTranslated(64, -80));
        superset.setName(header.getName());
        superset.addReusedIdentifier(header);
        return superset;
    }

    public static String createHeaderName(AbstractEntityModel model) {
        return String.valueOf(model.getName()) + "HDR";
    }
}

