/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.util.List;
import java.util.Map;
import jp.sourceforge.tmdmaker.dialog.DetailEditDialog;
import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityEditPart;
import jp.sourceforge.tmdmaker.editpolicy.EntityLayoutEditPolicy;
import jp.sourceforge.tmdmaker.editpolicy.TMDModelGraphicalNodeEditPolicy;
import jp.sourceforge.tmdmaker.figure.EntityFigure;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Detail;
import jp.sourceforge.tmdmaker.model.IdentifierRef;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.command.ModelEditCommand;
import jp.sourceforge.tmdmaker.model.command.TableDeleteCommand;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class DetailEditPart
extends AbstractEntityEditPart {
    @Override
    protected void onDoubleClicked() {
        logger.debug(this.getClass() + "#onDoubleClicked()");
        Detail table = (Detail)this.getModel();
        DetailEditDialog dialog = new DetailEditDialog(this.getViewer().getControl().getShell(), table);
        if (dialog.open() == 0) {
            CompoundCommand ccommand = new CompoundCommand();
            List<EditAttribute> editAttributeList = dialog.getEditAttributeList();
            this.addAttributeEditCommands(ccommand, table, editAttributeList);
            ModelEditCommand command = new ModelEditCommand(table, dialog.getEditedValue());
            ccommand.add((Command)command);
            this.getViewer().getEditDomain().getCommandStack().execute((Command)ccommand);
        }
    }

    @Override
    protected void updateFigure(IFigure figure) {
        EntityFigure entityFigure = (EntityFigure)figure;
        Detail entity = (Detail)this.getModel();
        entityFigure.setNotImplement(entity.isNotImplement());
        entityFigure.removeAllRelationship();
        entityFigure.setEntityName(entity.getName());
        IdentifierRef original = entity.getOriginalReusedIdentifier().getIdentifires().get(0);
        entityFigure.setIdentifier(original.getName());
        entityFigure.setIdentifier(entity.getDetailIdentifier().getName());
        for (Map.Entry<AbstractEntityModel, ReusedIdentifier> rk : entity.getReusedIdentifieres().entrySet()) {
            for (IdentifierRef i : rk.getValue().getIdentifires()) {
                if (i.isSame(original)) continue;
                entityFigure.addRelationship(i.getName());
            }
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DetailComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new TMDModelGraphicalNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new EntityLayoutEditPolicy());
    }

    private static class DetailComponentEditPolicy
    extends ComponentEditPolicy {
        private DetailComponentEditPolicy() {
        }

        protected Command createDeleteCommand(GroupRequest deleteRequest) {
            Detail model = (Detail)this.getHost().getModel();
            return new TableDeleteCommand(model, model.getModelTargetConnections().get(0));
        }
    }
}

