/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.wizards.datatransfer.FileSystemExportOperation;
import org.eclipse.ui.wizards.datatransfer.CPOpUtils;

public class CPFileSystemOp
extends FileSystemExportOperation {
    public static final boolean CREATE_CONTAINER_DIRECTORIES_DEFAULT = true;
    public static final boolean CREATE_LEADUP_STRUCTURE_DEFAULT = true;
    public static final boolean OVERWRITE_FILES_DEFAULT = false;
    private boolean _createContainerDirectories = true;
    private boolean _createLeadupStructure = true;
    private boolean _overwriteFiles = false;
    private final String _destinationPath;
    private List _resourcesToExport;
    private List _unknownResources;
    public IStatus _status;

    public CPFileSystemOp(List resources, String destinationPath, IOverwriteQuery overwriteImplementor) {
        super(null, resources, destinationPath, overwriteImplementor);
        this._resourcesToExport = resources;
        this._destinationPath = destinationPath;
    }

    public boolean getCreateContainerDirectories() {
        return this._createContainerDirectories;
    }

    public void setCreateContainerDirectories(boolean value) {
        this._createContainerDirectories = value;
        super.setCreateContainerDirectories(value);
    }

    public boolean getCreateLeadupStructure() {
        return this._createLeadupStructure;
    }

    public void setCreateLeadupStructure(boolean value) {
        this._createLeadupStructure = value;
        super.setCreateLeadupStructure(value);
    }

    public boolean getOverwriteFiles() {
        return this._overwriteFiles;
    }

    public void setOverwriteFiles(boolean value) {
        this._overwriteFiles = value;
        super.setOverwriteFiles(value);
    }

    public List getResourcesToExport() {
        return this._resourcesToExport;
    }

    public String getDestinationPath() {
        return this._destinationPath;
    }

    public List getUnknownResources() {
        if (this._unknownResources == null) {
            this._unknownResources = new ArrayList();
        }
        return this._unknownResources;
    }

    public void setUnknownResources(List unknownResources) {
        this._unknownResources = unknownResources;
    }

    public void run(IProgressMonitor monitor) throws InterruptedException {
        if (!this.validateDestination(monitor)) {
            return;
        }
        super.run(monitor);
    }

    private boolean validateDestination(IProgressMonitor monitor) {
        this._status = CPOpUtils.validateDirectory(new File(this._destinationPath), monitor);
        return this._status == null;
    }

    public IStatus getStatus() {
        return this._status != null ? this._status : super.getStatus();
    }
}

