/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.terasoluna.fw.exception.SystemException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/**
 * OItsANVB
 *
 * <p>
 * ̃NX̎ł́A݂HTTPZbV𖳌A
 * struts-config.xml&lt;action&gt;vf
 * parameterɎw肵ɃtH[hB
 * struts-config.xmlyBean`t@C̐ݒ͉L̂ƂłB
 * </p>
 * <p>
 * <strong>Bean`t@C̐ݒ</strong>
 *  <code><pre>
 *  &lt;bean name="/logoff" scope="prototype"
 *      <strong>class="jp.terasoluna.fw.web.struts.actions.LogoffAction"</strong>&gt;
 *  &lt;/bean&gt;
 *  </pre></code>
 * </p>
 * <p>
 * <strong>struts-config.xml̐ݒ</strong>
 * <code><pre>
 * &lt;action path="/logoff"
 *     name="_logonForm"
 *     scope="session"
 *     parameter="/foo.jsp"&gt;
 * &lt;/action&gt;
 * </pre></code>
 * OCɂẮAUserValueObjectABLogicQƂ̂ƁB
 * </p>
 *
 */
public class LogoffAction extends ActionEx {

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(LogoffAction.class);
    
    /**
     * G[y[Wi404jJڎsG[R[hB
     */
    private static final String FORWARD_ERRORPAGE_ERROR = 
        "error.forward.errorpage";

    /**
     * OItsBHTTPZbV𖳌A
     * parameterɐݒ肳ꂽJڐ
     * ANVtH[hɃZbgĕԂB
     * parameterݒ肳ĂȂꍇAi404jG[ԂB
     *
     * @param mapping ANV}bsO
     * @param form ANVtH[
     * @param req HTTPNGXg
     * @param res HTTPX|X
     * @return Jڐ̃ANVtH[h
     */
    @Override
    public ActionForward doExecute(ActionMapping mapping,
                                    ActionForm form,
                                    HttpServletRequest req,
                                    HttpServletResponse res) {
        if (log.isDebugEnabled()) {
            log.debug("doExecute() called.");
        }

        // p̃ZbV𖳌
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.invalidate();
        }

        // parameteritH[hj擾
        String path = mapping.getParameter();

        if (path == null) {
            // parameterݒ肳ĂȂꍇAi404jG[ԋp
            try {
                res.sendError(HttpServletResponse.SC_NOT_FOUND);
            } catch (IOException e) {
                log.error("Error page(404) forwarding failed.");
                
                throw new SystemException(e, FORWARD_ERRORPAGE_ERROR);
            }
            return null;
        }

        // ANVtH[h𐶐
        ActionForward retVal = new ActionForward(path);

        return retVal;
    }

}
