/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import java.util.Locale;

import org.apache.struts.util.MessageResources;
import org.apache.struts.util.MessageResourcesFactory;
import org.apache.struts.util.PropertyMessageResources;

/**
 * VXeit[[NjƋƖʂ̃bZ[W\[X\\ɂ
 * vpeBt@CbZ[W\[XB
 * 
 * <p>
 * Struts̎dlƂāAbZ[W\[X`t@C𗘗pꍇA
 * ̒`̓W[ƂɓƗĂ邽߁A
 * ׂẴW[ɋʂ郁bZ[W\[X͈ꌳIɒ`łȂB<br>
 * TERASOLUNAł̓W[ׂĂɋʂȁA
 * ƖʃbZ[WAVXebZ[W𗘗p邽߂̕@
 * 񋟂ĂB<br>
 * ̃NX́AStrutsPropertyMessageResourcesgA
 * eƖ̃bZ[W\[X`t@CłȂAƖʃbZ[WƁA
 * VXẽbZ[W𗘗p\ɂB<br>
 * ƖʁEVXẽbZ[W\[X̒`eɂẮA
 * GlobalMessageResourcesQƂ̂ƁB
 * </p>
 * <h5>gp@</h5>
 *  ̃NX𗘗pɂ́Astruts-config.xml
 *  &lt;message-resource&gt;vf
 * <ul>
 *  <li>parameterɃvpeBt@C(.properties͕sv)</li>
 *  <li>factoryɁAPropertyMessageResourcesExFactory</li>
 * </ul>
 *  w肷BLstruts-config.xml̐ݒłB
 * <pre><code>
 * &lt;struts-config&gt;
 *   c
 *   &lt;message-resources parameter="MessageResources"
 *                      factory="jp.terasoluna.fw.web.struts.action.PropertyMessageResourcesExFactory"
 *   /&gt;
 *  c
 * &lt;/struts-config&gt;
 * </code></pre>
 *
 * <h5></h5>
 * <ol>
 *  <li>VXẽbZ[W\[X͍ۉΉȂB</li>
 *  <li>Ɩʂ̃bZ[W\[X͍ۉΉȂB</li>
 * </ol>
 * L[Ŏ擾郁bZ[W\[X̗D揇ʂ͉L̒ʂƂȂB
 * <ol>
 *   <li>bZ[W\[X`t@C̃bZ[W\[X</li>
 *   <li>ƖʃbZ[W\[X`t@C
 *       iapplication-messages.propertiesj̃bZ[W\[X</li>
 *   <li>VXebZ[W\[X`t@Cisystem-messages.propertiesj
 *       bZ[W\[X</li>
 * </ol>
 *
 * @see jp.terasoluna.fw.web.struts.action.PropertyMessageResourcesExFactory
 * @see jp.terasoluna.fw.web.struts.action.DBMessageResources
 * @see jp.terasoluna.fw.web.struts.action.GlobalMessageResources
 *
 */
public class PropertyMessageResourcesEx extends PropertyMessageResources {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = -8239553100324527837L;

    /**
     * RXgN^B
     *
     * @param factory ̃NX̃t@NgIuWFNg
     * @param config bZ[W\[Xt@C
     */
    public PropertyMessageResourcesEx(
            MessageResourcesFactory factory,
            String config) {
        super(factory, config);
    }

    /**
     * RXgN^B
     *
     * @param factory ̃NX̃t@NgIuWFNg
     * @param config bZ[W\[Xt@C
     * @param returnNull bZ[W\[XL[o^ĂȂꍇAnull
     *                   Ԃǂ
     */
    public PropertyMessageResourcesEx(MessageResourcesFactory factory,
                                      String config,
                                      boolean returnNull) {
        super(factory, config, returnNull);
    }

    /**
     * bZ[W擾B
     * bZ[W擾̗D揇ʂ͉L̂悤ɂȂB
     * <ol>
     *  <li>(eW[Œ`ꂽ)bZ[W\[X
     *  t@C̃bZ[W</li>
     *  <li>Ɩʂ̃bZ[W</li>
     *  <li>VXẽbZ[W</li>
     * </ol>
     *
     * @param locale NGXg擾ꂽP[
     * @param key bZ[W\[XL[
     * @return bZ[W
     */
    @Override
    public String getMessage(Locale locale, String key) {
        // Ɩ̃bZ[W\[Xt@CAbZ[WԋpB
        String localMessage = super.getMessage(locale, key);
        if (localMessage != null && !localMessage.startsWith("???")
                && !localMessage.endsWith("???")) {
            // nullԋpꂸAL[l"???"ŋ܂ĂȂ
            // (RXgN^returnNullfalse)̎A
            // ƖbZ[WԋpB
            return localMessage;
        }

        // ƖʁEVXẽbZ[WꍇԋpB
        MessageResources globalMessageResources
            = GlobalMessageResources.getInstance();
        String globalMessage = globalMessageResources.getMessage(locale, key);
        if (globalMessage != null) {
            // ƖʁEVXebZ[Wꍇ́A
            // bZ[WԋpB
            return globalMessage;
        }
        // ȂꍇAStruts̃bZ[W\[X`ŕԋp
        return localMessage;
    }
}
