/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import java.sql.ResultSet;
import java.sql.SQLException;

import javax.sql.DataSource;

import jp.terasoluna.fw.exception.SystemException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.object.MappingSqlQuery;
/**
 * DB擾sDBMessageBeanCX^XɋlߑւĕԂ\bh
 * MappingSqlQueryNXB
 * 
 * @see jp.terasoluna.fw.web.struts.action.DBMessageBean
 * @see jp.terasoluna.fw.web.struts.action.MessageResourcesDAOImpl
 * 
 */
public class DBMessageBeanMappingSqlQuery extends MappingSqlQuery {
    
    /**
     * SQL̐ݒɌ肪ꍇ킷G[R[h
     */
    private static final String DB_MESSAGE_BEAN_MAPPING_SQL_QUERY
        = "errors.db.message.bean.mapping.sql.query";
    
    /**
     * ONXB
     */ 
    private static Log log 
        = LogFactory.getLog(DBMessageBeanMappingSqlQuery.class);

    /**
     * RXgN^B
     * 
     * @param dataSource f[^\[X
     * @param sql SQL
     */
    DBMessageBeanMappingSqlQuery(DataSource dataSource, String sql) {
        super(dataSource, sql);
    }
    
    /**
     * sDBMessageBeanɋlߑւĕԂB
     * 
     * @param rs s
     * @param rowNum Ăsԍ
     * 
     * @return slߑւꂽDBMessageBean
     * 
     * @throws SQLException ݒ肳ꂽSQLĂꍇ
     */
    @Override
    protected DBMessageBean mapRow(ResultSet rs, int rowNum)
    throws SQLException {
        // sDBMessageBeanCX^Xɋlߑւ
        return createDBMessageBean(rs); 
    }

    /**
     * sDBMessageBeanɋlߑւĕԂB
     * 
     * @param rs s
     * 
     * @return slߑւꂽDBMessageBean
     * 
     * @throws SQLException ݒ肳ꂽSQLĂꍇ
     */
    protected DBMessageBean createDBMessageBean(ResultSet rs) 
    throws SQLException {
        DBMessageBean msg = new DBMessageBean();
        int columnCount = 0;
        String key = null;
        String value = null;
        
        // bZ[W\[X̓Ăe[uK؂Ȍ`łȂƂ
        // OX[B
        columnCount = rs.getMetaData().getColumnCount();
        if (columnCount != 2) {
            // SQL̕Ԃr[2ł͂ȂꍇASQLĂ
            log.error("SQL for DB message returns "
                      + columnCount + " column(s) result set.");
            throw new SystemException(null, DB_MESSAGE_BEAN_MAPPING_SQL_QUERY);
        }
        
        // keyݒ
        key = rs.getString(1);
        if (key == null || "".equals(key)) {
            if (log.isWarnEnabled()) {
                log.warn("DBMessage resource keys contain null or empty.");
            }
            key = "";
        }        
        msg.setKey(key);        
        
        // valueݒ
        value = rs.getString(2);
        if (value == null) {
            value = "";
        }
        msg.setValue(value);
        
        return msg;
    }
}
