/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.message;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.support.AbstractMessageSource;

/**
 * DAO擾bZ[W\[XAbZ[WR[hyуP[L[
 * ƂāAbZ[W̓bZ[WtH[}bg肷NXB
 * 
 * <p>
 * {NX̓NX[hDBQƂADB̃bZ[W\[X烁bZ[W
 * ̓bZ[WtH[}bg肷NXłB
 * ܂AۉɑΉĂAR[hAR[hAoAgR[hɂ
 * P[ʂ\łB
 * </p>
 * <strong>gp@</strong><br>
 * ̃NX𗘗pɂ̓AvP[VReLXgNMessageSource
 * ƂĐݒ肵A܂bZ[W\[Xi[DBƂ̐ڑ
 * DAOIuWFNgƂĐݒ肷KvB<br>
 * <br>
 * <strong>ݒ</strong><br>
 * Bean`t@CɈȉ̓e̋LqB<br>
 * DAOƂDBMessageResourceDAO𗘗pꍇ<br>
 * 
 * <pre>
 * &lt;bean id = &quot;messageSource&quot;
 *   class = &quot;jp.terasoluna.fw.message.DataSourceMessageSource&quot;&gt;
 *   &lt;property name = &quot;DBMessageResourceDAO&quot;&gt;
 *     &lt;ref bean = &quot;dBMessageResourceDAO&quot;&gt;&lt;/ref&gt;
 *   &lt;/property&gt;
 * &lt;/bean&gt;
 * </pre>
 * 
 * <strong></strong><br>
 * &lt;bean&gt;vfid"messageSource" w肷邱ƂMessageSource
 * ƂĔFB<br>
 * &lt;bean>vf&lt;property&gt;vfɂDAO̐ݒLqB<br>
 * <br>
 * 
 * <br>
 * ftHgP[̕ύX<br>
 * ftHgP[́AbZ[W\[X̃P[ݒ肳ĂȂꍇA
 * ͐ݒ肳ĂĂP[ݒ肳ĂȂꍇɎw肳
 * P[łB<br>
 * ftHgP[̏ݒ́ANCAgVMŎgp郍P[łB
 * <br>
 * ftHgP[͖{NXɎĂsetDefaultLocale𗘗p
 * ƂŕύX邱ƂoB <br>
 * <br>
 * <strong>ݒ</strong><br>
 * Bean`t@CɈȉ̓e̋LqB<br>
 * ftHgP[{iR[hujav)ɂꍇB<br>
 * <br>
 * 
 * <pre>
 * &lt;bean id = &quot;messageSource&quot;
 *   class = &quot;jp.terasoluna.fw.message.DataSourceMessageSource&quot;&gt;
 *   &lt;property name = &quot;DBMessageResourceDAO&quot;&gt;
 *     &lt;ref bean = &quot;dBMessageResourceDAO&quot;&gt;&lt;/ref&gt;
 *   &lt;/property&gt;
 *   &lt;property name = &quot;defaultLocale&quot;&gt;
 *     &lt;value&gt;ja&lt;/value&gt;
 *   &lt;/property&gt;
 * &lt;/bean&gt;
 * </pre>
 * 
 * <strong></strong><br>
 * &lt;bean&gt;vf&lt;properities&gt;vfnamedefaultLocalew肵A
 * valueɂĐݒ肵lw肷B
 * 
 * @see jp.terasoluna.fw.message.DBMessage
 * @see jp.terasoluna.fw.message.DBMessageQuery
 * @see jp.terasoluna.fw.message.DBMessageResourceDAO
 * @see jp.terasoluna.fw.message.DBMessageResourceDAOImpl
 * 
 * 
 */
public class DataSourceMessageSource extends AbstractMessageSource implements
        InitializingBean {

    /**
     * bZ[WR[hɃP[ƃbZ[WtH[}bg}bvŕێB
     * <br>
     * Map &lt;Code, Map &lt;Locale, MessageFormat&gt;&gt;
     */
    protected final Map<String, Map<Locale, MessageFormat>> cachedMessageFormats
                            = new HashMap<String, Map<Locale, MessageFormat>>();

    /**
     * P[ɃbZ[WR[hƃbZ[W}bvŕێB
     * <br/> Map &lt;Locale, Properties&gt;
     */
    protected Map<Locale, Properties> cachedMergedProperties
                            = new HashMap<Locale, Properties>();

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(DataSourceMessageSource.class);
    
    /**
     * P[w肳ĂȂꍇ̃ftHgP[B bZ[W\[X
     * ŃP[w肳ĂȂꍇA ̃P[ݒ肳B
     * ftHgł̓T[o[JVM̌R[ĥ݂P[ƂĎgpB
     */
    protected Locale defaultLocale
                            = new Locale(Locale.getDefault().getLanguage());
    
    /**
     * bZ[W\[X擾DAOB
     */
    protected DBMessageResourceDAO dbMessageResourceDAO = null;

    /**
     * ftHgP[ݒ肷Bݒ肵Ȃꍇ̓NCAgVM̃P[
     * ݒ肳BVM̃P[FłȂꍇ͉pꂪݒ肳B
     * 
     * @see #getMessageInternal
     * @see java.util.Locale#getDefault
     * 
     * @param defaultLocale
     *            ftHg̃P[B
     */
    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    /**
     * DBMessageResourceDAOݒ肷B
     * 
     * @param dbMessageResourceDAO
     *            SẴbZ[W\[X擾DAO
     */
    public void setDbMessageResourceDAO(
            DBMessageResourceDAO dbMessageResourceDAO) {
        this.dbMessageResourceDAO = dbMessageResourceDAO;
    }

    /**
     * WebAvP[VReLXgNɎsB<br>
     * bZ[W\[X烁bZ[WR[hAP[AbZ[W
     * ibZ[WtH[}bg܂ށĵRڂŕނALbVɕێB
     * 
     * @see #cachedMergedProperties
     * 
     */
    public void afterPropertiesSet() {
        if (log.isDebugEnabled()) {
            log.debug("afterPropertiesSet");
        }
        readMessagesFromDataSource();
    }

    /**
     * bZ[W\[X[hB
     * ̃\bh𖾎IɌĂяoƂDB瓮IɃbZ[W\[X
     * [hBDB̍XVꍇÃ\bhĂяoƂ
     * bZ[W\[X[h邱Ƃ\B
     */
    public synchronized void reloadDataSourceMessage() {
        readMessagesFromDataSource();
    }
    
    /**
     * DAO烁bZ[W\[X擾ABbZ[W\[XP[
     * ʂɂ܂Ƃ߁AbZ[WR[hƃbZ[W{̂ZbgɂĊi[B
     * 擾SẴbZ[W\[Xɑ΂Ď{B<br>
     * bZ[W\[XƂ́AbZ[WR[hAR[hAR[hA
     * oAgR[hAbZ[W{̂łB
     */
     protected synchronized void readMessagesFromDataSource() {
        if (log.isDebugEnabled()) {
            log.debug("readMessageFromDataSource");
        }
        cachedMergedProperties.clear();
        cachedMessageFormats.clear();
        // DAO烁bZ[W\[X擾
        List<DBMessage> messages = dbMessageResourceDAO.findDBMessages();
        //bZ[WR[hƃbZ[Wenullł͂ȂꍇA
        //LbVɓǂݍ
        for (DBMessage message : messages) {
            if (message.code != null && message.message != null) {
                mapMessage(message);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("get MessageResource from DAO.");
        }
    }

    /**
     * bZ[W\[XP[ʂɐAbZ[WR[hƃbZ[W{
     * ZbgɂāAnbVe[uɊi[B
     * 
     * @param message
     *            bZ[W\[Xi[DBMessageIuWFNgB
     */
    protected void mapMessage(DBMessage message) {
        // P[IuWFNgR[hAR[hAoAgR[h
        // B
        Locale locale = createLocale(message);
        // P[ɑΉSẴbZ[W擾B
        Properties messages = getMessages(locale);
        // 擾SẴbZ[WɐVKbZ[WǉB
        messages.setProperty(message.getCode(), message.getMessage());
        if (log.isDebugEnabled()) {
            log.debug("add Message[" + message.getMessage() + "] (code["
                    + message.getCode() + "], locale[" + locale + "])");
        }
    }

    /**
     * LocaleIuWFNg𐶐B<br>
     * R[hAR[hAoAgR[hLocaleIuWFNg𐶐B
     * R[h^ĂȂꍇ́AftHgP[̌R[ĥ
     * i[ALocaleIuWFNg𐶐B
     * 
     * @param message bZ[W\[X
     * 
     * @return
     *      R[hAR[hAoAgR[hi[LocaleIuWFNgB
     *
     * @throws IllegalArgumentException
     *      bZ[WR[hyуbZ[W݂郁bZ[W\[X
     *      P[ݒ肳ĂȂBAftHgP[ݒoȂ
     *      ꍇ̃G[B
     */
    protected Locale createLocale(DBMessage message) {
        if (message.getLanguage() == null) {
            if (defaultLocale != null) {
                return defaultLocale;
            }
            if (log.isErrorEnabled()) {
                log.error("Can't resolve Locale.Define Locale"
                        + " in MessageSource or Defaultlocale.");
            }
            throw new IllegalArgumentException("Can't resolve Locale."
                    + "Define Locale in MessageSource or Defaultlocale.");
        }
        if (message.getCountry() == null) {
            return new Locale(message.getLanguage());
        }
        if (message.getVariant() == null) {
            return new Locale(message.getLanguage(), message.getCountry());
        }
        return new Locale(message.getLanguage(), message.getCountry(),
                          message.getVariant());
    }

    /**
     * P[ɑΉSẴbZ[WԋpB w肳ꂽP[
     * bZ[W݂Ȃꍇ͐VɐAnullԋpȂB
     * 
     * @param locale
     *            bZ[W̃P[B
     * 
     * @return P[ɑΉSẴbZ[WB bZ[WR[h
     * bZ[W{̂֘AtAi[ĂB
     */
    protected Properties getMessages(Locale locale) {
        // P[L[ƂASẴbZ[W擾 B
        Properties messages = cachedMergedProperties.get(locale);
        // P[ɑΉSẴbZ[W݂ȂꍇA
        // Vɍ쐬AcachedMergedPropertiesɊi[B
        if (messages == null) {
            messages = new Properties();
            cachedMergedProperties.put(locale, messages);
        }
        return messages;
    }

    /**
     * ƂēnꂽbZ[WR[hƃP[烁bZ[W肵A
     * bZ[WԋpBeNXĂяo郁\bhB
     * AbstractMessageSourcẽ\bhI[o[ChĂB
     * 
     * @param code
     *            bZ[WR[h
     * @param locale
     *            bZ[W̃P[
     * 
     * @return bZ[W{
     */
    @Override
    protected synchronized String resolveCodeWithoutArguments(
            String code,
            Locale locale) {
        String msg = internalResolveCodeWithoutArguments(code, locale);
        if (msg == null) {
            if (log.isDebugEnabled()) {
                log.debug("could not resolve [" + code + "] for locale ["
                        + locale + "]");
            }
        }
        return msg;
    }

    /**
     * bZ[WR[hƃP[烁bZ[W肷B Ƃė^ꂽ
     * P[ŃbZ[W̌肪oȂꍇAP[ωA
     * bZ[W̎擾݂B
     * ܂AftHgP[^ĂꍇAftHgP[ł
     * bZ[W̌ŌɎ݂B
     * 
     * @param code
     *            bZ[WR[h
     * @param locale
     *            bZ[W̃P[
     * 
     * @return bZ[W{
     */
    protected String internalResolveCodeWithoutArguments(
            String code,
            Locale locale) {
        // bZ[WR[hƃP[ɑΉbZ[W{̂msgɊi[B
        String msg = getMessages(locale).getProperty(code);
        // bZ[W{̂̎擾oꍇAbZ[W{̂ԋpB
        if (msg != null) {
            return msg;
        }
        // bZ[W{̂̎擾oȂꍇAP[ω
        // bZ[W{̂̎擾݂B

        // P[IuWFNg̃p^[̐
        List<Locale> locales = getAlternativeLocales(locale);
        // bZ[WR[hƐVɐP[ɑΉbZ[W肵A
        // bZ[W{̂ԋp܂B
        for (int i = 0; i < locales.size(); i++) {
            msg = getMessages(locales.get(i)).getProperty(code);
            if (msg != null) {
                return msg;
            }
        }
        // bZ[W擾łȂꍇnullԋpB
        return null;
    }

    /**
     * bZ[W肷ۂ̃L[𐶐B P[̒l
     * P[IuWFNg𐶐AXgɊi[AԋpB
     * PDlocalěR[hAR[h́BioAgR[h폜Bj
     * QDlocalěR[h́BiR[hAoAgR[h폜Bj
     * RDftHgP[̌R[hAR[hAoAgR[h́B
     * SDftHgP[̌R[hAR[h́B
     * TDftHgP[̌R[h́B
     * 
     * @param locale
     *            P[IuWFNg
     * 
     * @return bZ[W̃L[ƂȂ郍P[IuWFNg
     */
    protected List<Locale> getAlternativeLocales(Locale locale) {
        List<Locale> locales = new ArrayList<Locale>();
        // P[ɃoAgR[h݂ꍇ
        if (locale.getVariant().length() > 0) {
            // Locale(language,country,"")ݒ
            locales.add(new Locale(locale.getLanguage(), locale.getCountry()));
        }
        // P[ɍR[h݂ꍇ
        if (locale.getCountry().length() > 0) {
            // Locale(language,"","")ݒ
            locales.add(new Locale(locale.getLanguage()));
        }
        // ftHgP[ݒ肳Ăꍇ
        if (defaultLocale != null && !locale.equals(defaultLocale)) {
            if (defaultLocale.getVariant().length() > 0) {
                // Locale(language,country,"")ݒ
                locales.add(defaultLocale);
            }
            if (defaultLocale.getCountry().length() > 0) {
                // Locale(language,country,"")ݒ
                locales.add(new Locale(defaultLocale.getLanguage(),
                        defaultLocale.getCountry()));
            }
            // P[ɍR[h݂ꍇ
            if (defaultLocale.getLanguage().length() > 0) {
                // Locale(language,"","")ݒ
                locales.add(new Locale(defaultLocale.getLanguage()));
            }
        }
        return locales;
    }

    /**
     * ƂēnꂽbZ[WR[hƃP[烁bZ[WtH[}bg
     * 肵AbZ[WtH[}bgԋpB
     * eNXĂяo郁\bhBAbstractMessageSourcẽ\bh
     * I[o[ChĂB
     * 
     * @param code
     *            bZ[WR[h
     * @param locale
     *            bZ[W̃P[
     * 
     * @return bZ[WtH[}bg
     */
    @Override
    protected synchronized MessageFormat resolveCode(
            String code,
            Locale locale) {
        // bZ[WR[hƃP[ɑΉbZ[W{̂messageFormat
        // i[B
        MessageFormat messageFormat = getMessageFormat(code, locale);
        // bZ[W{̂̎擾oꍇAbZ[WtH[}bgԋp
        if (messageFormat != null) {
            if (log.isDebugEnabled()) {
                log.debug("resolved [" + code + "] for locale [" + locale
                        + "] => [" + messageFormat + "]");
            }
            return messageFormat;
        }
        // bZ[WtH[}bg̎擾oȂꍇAP[ω
        // bZ[WtH[}bg̎擾݂B

        // P[IuWFNg̃p^[̐
        List<Locale> locales = getAlternativeLocales(locale);
        // bZ[WR[hƐVɐP[ɑΉ
        // bZ[WtH[}bg肵AbZ[WtH[}bgԋp܂B
        for (int i = 0; i < locales.size(); i++) {
            messageFormat = getMessageFormat(code, locales.get(i));
            if (messageFormat != null) {
                if (log.isDebugEnabled()) {
                    log.debug("resolved [" + code + "] for locale [" + locale
                            + "] => [" + messageFormat + "]");
                }
                return messageFormat;
            }
        }
        if (messageFormat == null) {
            if (log.isDebugEnabled()) {
                log.debug("could not resolve [" + code + "] for locale ["
                        + locale + "]");
            }
        }
        // bZ[WtH[}bg擾oȂꍇnullԋpB
        return null;
    }

    /**
     * ƂēnꂽbZ[WR[hƃP[烁bZ[WtH[}bg
     * 肷B
     * 
     * @param code
     *            bZ[WR[h
     * @param locale
     *            bZ[W̃P[
     * 
     * @return 肳ꂽbZ[WtH[}bg
     */
    protected MessageFormat getMessageFormat(String code, Locale locale) {
        // bZ[WR[hɑΉP[}bv擾B
        Map<Locale, MessageFormat> localeMap
                                   = this.cachedMessageFormats.get(code);
        // P[}bv݂ꍇAP[}bv胍P[ɑΉ
        // bZ[WtH[}bg擾AԋpB
        if (localeMap != null) {
            MessageFormat result = localeMap.get(locale);
            if (result != null) {
                return result;
            }
        }
        
        String msg = getMessages(locale).getProperty(code);

        // bZ[W݂ꍇ
        if (msg != null) {

            // P[}bv݂ȂꍇAVɃP[}bv𐶐A
            // bZ[WtH[}bgԋpB
            if (localeMap == null) {
                localeMap = new HashMap<Locale, MessageFormat>();
                this.cachedMessageFormats.put(code, localeMap);
            }
            // bZ[WƃP[胁bZ[WtH[}bg쐬B
            MessageFormat result = createMessageFormat(msg, locale);
            localeMap.put(locale, result);
            return result;
        }
        // bZ[WtH[}bg擾oȂꍇnullԋpB
        return null;
    }
}