/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.beans.jxpath;

import java.util.Locale;

import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.BeanPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;

/**
 * Bean|C^̊gNXB
 */
public class BeanPointerEx extends BeanPointer {

    /**
     * VAo[WIDB
     */
    private static final long serialVersionUID = -7414445615036653661L;
    
    /**
     * ^[QbgBean̏B
     */
    private JXPathBeanInfo beanInfo;
    
    /**
     * RXgN^B
     * @param name QName
     * @param bean ^[QbgBean
     * @param beanInfo ^[QbgBean̏
     * @param locale P[
     */
    public BeanPointerEx(QName name, Object bean, JXPathBeanInfo beanInfo,
            Locale locale) {
        super(name, bean, beanInfo, locale);
        this.beanInfo = beanInfo;
    }

    /**
     * RXgN^B
     * @param parent eBean|C^
     * @param name QName
     * @param bean ^[QbgBean
     * @param beanInfo ^[QbgBean̏
     */
    public BeanPointerEx(NodePointer parent, QName name, Object bean,
            JXPathBeanInfo beanInfo) {
        super(parent, name, bean, beanInfo);
        this.beanInfo = beanInfo;
    }

    /**
     * vpeB|C^擾B
     * @return BeanvpeB|C^
     */
    @Override
    public PropertyPointer getPropertyPointer() {
        return new BeanPropertyPointerEx(this, beanInfo);
    }
}
