/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ExceptionUtil {
    private static Log log = LogFactory.getLog(ExceptionUtil.class);
    private static final String SERVLET_EXCEPTION_NAME = "javax.servlet.ServletException";
    private static final String GET_ROOT_CAUSE = "getRootCause";

    public static String getStackTrace(Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (throwable != null) {
            baos.reset();
            throwable.printStackTrace(new PrintStream(baos));
            sb.append(baos.toString());
            Class<?> throwableClass = throwable.getClass();
            if (SERVLET_EXCEPTION_NAME.equals(throwableClass.getName())) {
                try {
                    Method method = throwableClass.getMethod(GET_ROOT_CAUSE, new Class[0]);
                    throwable = (Throwable)method.invoke((Object)throwable, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    log.error((Object)e.getMessage());
                    throwable = null;
                }
                catch (IllegalAccessException e) {
                    log.error((Object)e.getMessage());
                    throwable = null;
                }
                catch (InvocationTargetException e) {
                    log.error((Object)e.getMessage());
                    throwable = null;
                }
                continue;
            }
            throwable = throwable.getCause();
        }
        return sb.toString();
    }
}

