/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.message;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import jp.terasoluna.fw.message.DBMessage;
import jp.terasoluna.fw.message.DBMessageResourceDAO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.support.AbstractMessageSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceMessageSource
extends AbstractMessageSource
implements InitializingBean {
    protected final Map<String, Map<Locale, MessageFormat>> cachedMessageFormats = new HashMap<String, Map<Locale, MessageFormat>>();
    protected Map<Locale, Properties> cachedMergedProperties = new HashMap<Locale, Properties>();
    private static Log log = LogFactory.getLog(DataSourceMessageSource.class);
    protected Locale defaultLocale = new Locale(Locale.getDefault().getLanguage());
    protected DBMessageResourceDAO dbMessageResourceDAO = null;

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public void setDbMessageResourceDAO(DBMessageResourceDAO dbMessageResourceDAO) {
        this.dbMessageResourceDAO = dbMessageResourceDAO;
    }

    public void afterPropertiesSet() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"afterPropertiesSet");
        }
        this.readMessagesFromDataSource();
    }

    public synchronized void reloadDataSourceMessage() {
        this.readMessagesFromDataSource();
    }

    protected synchronized void readMessagesFromDataSource() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"readMessageFromDataSource");
        }
        this.cachedMergedProperties.clear();
        this.cachedMessageFormats.clear();
        List<DBMessage> messages = this.dbMessageResourceDAO.findDBMessages();
        for (DBMessage message : messages) {
            if (message.code == null || message.message == null) continue;
            this.mapMessage(message);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"get MessageResource from DAO.");
        }
    }

    protected void mapMessage(DBMessage message) {
        Locale locale = this.createLocale(message);
        Properties messages = this.getMessages(locale);
        messages.setProperty(message.getCode(), message.getMessage());
        if (log.isDebugEnabled()) {
            log.debug((Object)("add Message[" + message.getMessage() + "] (code[" + message.getCode() + "], locale[" + locale + "])"));
        }
    }

    protected Locale createLocale(DBMessage message) {
        if (message.getLanguage() == null) {
            if (this.defaultLocale != null) {
                return this.defaultLocale;
            }
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't resolve Locale.Define Locale in MessageSource or Defaultlocale.");
            }
            throw new IllegalArgumentException("Can't resolve Locale.Define Locale in MessageSource or Defaultlocale.");
        }
        if (message.getCountry() == null) {
            return new Locale(message.getLanguage());
        }
        if (message.getVariant() == null) {
            return new Locale(message.getLanguage(), message.getCountry());
        }
        return new Locale(message.getLanguage(), message.getCountry(), message.getVariant());
    }

    protected Properties getMessages(Locale locale) {
        Properties messages = this.cachedMergedProperties.get(locale);
        if (messages == null) {
            messages = new Properties();
            this.cachedMergedProperties.put(locale, messages);
        }
        return messages;
    }

    protected synchronized String resolveCodeWithoutArguments(String code, Locale locale) {
        String msg = this.internalResolveCodeWithoutArguments(code, locale);
        if (msg == null && log.isDebugEnabled()) {
            log.debug((Object)("could not resolve [" + code + "] for locale [" + locale + "]"));
        }
        return msg;
    }

    protected String internalResolveCodeWithoutArguments(String code, Locale locale) {
        String msg = this.getMessages(locale).getProperty(code);
        if (msg != null) {
            return msg;
        }
        List<Locale> locales = this.getAlternativeLocales(locale);
        for (int i = 0; i < locales.size(); ++i) {
            msg = this.getMessages(locales.get(i)).getProperty(code);
            if (msg == null) continue;
            return msg;
        }
        return null;
    }

    protected List<Locale> getAlternativeLocales(Locale locale) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        if (locale.getVariant().length() > 0) {
            locales.add(new Locale(locale.getLanguage(), locale.getCountry()));
        }
        if (locale.getCountry().length() > 0) {
            locales.add(new Locale(locale.getLanguage()));
        }
        if (this.defaultLocale != null && !locale.equals(this.defaultLocale)) {
            if (this.defaultLocale.getVariant().length() > 0) {
                locales.add(this.defaultLocale);
            }
            if (this.defaultLocale.getCountry().length() > 0) {
                locales.add(new Locale(this.defaultLocale.getLanguage(), this.defaultLocale.getCountry()));
            }
            if (this.defaultLocale.getLanguage().length() > 0) {
                locales.add(new Locale(this.defaultLocale.getLanguage()));
            }
        }
        return locales;
    }

    protected synchronized MessageFormat resolveCode(String code, Locale locale) {
        MessageFormat messageFormat = this.getMessageFormat(code, locale);
        if (messageFormat != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("resolved [" + code + "] for locale [" + locale + "] => [" + messageFormat + "]"));
            }
            return messageFormat;
        }
        List<Locale> locales = this.getAlternativeLocales(locale);
        for (int i = 0; i < locales.size(); ++i) {
            messageFormat = this.getMessageFormat(code, locales.get(i));
            if (messageFormat == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("resolved [" + code + "] for locale [" + locale + "] => [" + messageFormat + "]"));
            }
            return messageFormat;
        }
        if (messageFormat == null && log.isDebugEnabled()) {
            log.debug((Object)("could not resolve [" + code + "] for locale [" + locale + "]"));
        }
        return null;
    }

    protected MessageFormat getMessageFormat(String code, Locale locale) {
        MessageFormat result;
        Map<Locale, MessageFormat> localeMap = this.cachedMessageFormats.get(code);
        if (localeMap != null && (result = localeMap.get(locale)) != null) {
            return result;
        }
        String msg = this.getMessages(locale).getProperty(code);
        if (msg != null) {
            if (localeMap == null) {
                localeMap = new HashMap<Locale, MessageFormat>();
                this.cachedMessageFormats.put(code, localeMap);
            }
            MessageFormat result2 = this.createMessageFormat(msg, locale);
            localeMap.put(locale, result2);
            return result2;
        }
        return null;
    }
}

