/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1999
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Lorenzo Colitti <lorenzo@colitti.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef _nsImapCore_H_
#define _nsImapCore_H_

#include "MailNewsTypes.h"
#include "nsStringGlue.h"
#include "nsIMailboxSpec.h"
#include "nsIImapFlagAndUidState.h"

class nsIMAPNamespace;
class nsImapProtocol;
class nsImapFlagAndUidState;

/* imap message flags */
typedef PRUint16 imapMessageFlagsType;

/* used for communication between imap thread and event sinks */
#define kNoFlags     0x00 /* RFC flags */
#define kMarked      0x01
#define kUnmarked    0x02
#define kNoinferiors 0x04
#define kNoselect    0x08
#define kImapTrash   0x10 /* Navigator flag */
#define kJustExpunged 0x20 /* This update is a post expunge url update. */
#define kPersonalMailbox 0x40 /* this mailbox is in the personal namespace */
#define kPublicMailbox 0x80 /* this mailbox is in the public namespace */
#define kOtherUsersMailbox 0x100 /* this mailbox is in the other users' namespace */
#define kNameSpace 0x200 /* this mailbox IS a namespace */
#define kNewlyCreatedFolder 0x400 /* this folder was just created */
#define kImapDrafts 0x800 /* XLIST says this is the drafts folder */
#define kImapSpam 0x1000 /* XLIST says this is the spam folder */
#define kImapSent 0x2000 /* XLIST says this is the sent folder */
#define kImapInbox 0x4000 /* XLIST says this is the INBOX folder */
#define kImapAllMail 0x8000 /* XLIST says this is AllMail (GMail) */
#define kImapXListTrash 0x10000 /* XLIST says this is the trash */

/* flags for individual messages */
/* currently the ui only offers \Seen and \Flagged */
#define kNoImapMsgFlag                0x0000
#define kImapMsgSeenFlag              0x0001
#define kImapMsgAnsweredFlag          0x0002
#define kImapMsgFlaggedFlag           0x0004
#define kImapMsgDeletedFlag           0x0008
#define kImapMsgDraftFlag             0x0010
#define kImapMsgRecentFlag            0x0020
#define	kImapMsgForwardedFlag         0x0040		/* Not always supported, check mailbox folder */
#define kImapMsgMDNSentFlag           0x0080		/* Not always supported. check mailbox folder */
#define kImapMsgCustomKeywordFlag     0x0100            /* this msg has a custom keyword */
#define kImapMsgLabelFlags            0x0E00            /* supports 5 labels only supported if the folder supports keywords */
#define kImapMsgSupportMDNSentFlag    0x2000
#define kImapMsgSupportForwardedFlag  0x4000
/**
 * We use a separate xlist trash flag so we can prefer the GMail trash
 * over an existing Trash folder we may have created.
 */
#define kImapMsgSupportUserFlag       0x8000		
/* This seems to be the most cost effective way of
* piggying back the server support user flag info.
*/

/* if a url creator does not know the hierarchyDelimiter, use this */
#define kOnlineHierarchySeparatorUnknown '^'
#define kOnlineHierarchySeparatorNil '|'

#define IMAP_URL_TOKEN_SEPARATOR ">"
#define kUidUnknown -1

// this has to do with Mime Parts on Demand. It used to live in net.h
// I'm not sure where this will live, but here is OK temporarily
typedef enum {
	IMAP_CONTENT_NOT_MODIFIED = 0,
	IMAP_CONTENT_MODIFIED_VIEW_INLINE,
	IMAP_CONTENT_MODIFIED_VIEW_AS_LINKS,
	IMAP_CONTENT_FORCE_CONTENT_NOT_MODIFIED
} IMAP_ContentModifiedType;

// I think this should really go in an imap.h equivalent file
typedef enum {
    kPersonalNamespace = 0,
    kOtherUsersNamespace,
    kPublicNamespace,
    kDefaultNamespace,
    kUnknownNamespace
} EIMAPNamespaceType;

typedef enum {
    kCapabilityUndefined = 0x00000000,
    kCapabilityDefined = 0x00000001,
    kHasAuthLoginCapability = 0x00000002, /* AUTH LOGIN (not the same as kHasAuthOldLoginCapability) */
    kHasAuthOldLoginCapability = 0x00000004, /* original IMAP login method */
    kHasXSenderCapability = 0x00000008,
    kIMAP4Capability = 0x00000010,          /* RFC1734 */
    kIMAP4rev1Capability = 0x00000020,      /* RFC2060 */
    kIMAP4other = 0x00000040,                       /* future rev?? */
    kNoHierarchyRename = 0x00000080,                        /* no hierarchy rename */
    kACLCapability = 0x00000100,          /* ACL extension */
    kNamespaceCapability = 0x00000200,    /* IMAP4 Namespace Extension */
    kHasIDCapability = 0x00000400,  /* client user agent id extension */
    kXServerInfoCapability = 0x00000800,  /* XSERVERINFO extension for admin urls */
    kHasAuthPlainCapability = 0x00001000, /* new form of auth plain base64 login */
    kUidplusCapability = 0x00002000,   /* RFC 2359 UIDPLUS extension */
    kLiteralPlusCapability = 0x00004000, /* RFC 2088 LITERAL+ extension */
    kAOLImapCapability = 0x00008000,     /* aol imap extensions */
    kHasLanguageCapability = 0x00010000, /* language extensions */
    kHasCRAMCapability     = 0x00020000, /* CRAM auth extension */
    kQuotaCapability       = 0x00040000, /* RFC 2087 quota extension */
    kHasIdleCapability       = 0x00080000,  /* RFC 2177 idle extension */
    kHasAuthNTLMCapability = 0x00100000,  /* AUTH NTLM extension */
    kHasAuthMSNCapability = 0x00200000,   /* AUTH MSN extension */
    kHasStartTLSCapability = 0x00400000,   /* STARTTLS support */
    kHasAuthNoneCapability = 0x00800000, /* needs no login */
    kHasAuthGssApiCapability = 0x01000000, /* GSSAPI AUTH */
    kHasCondStoreCapability =  0x02000000, /* RFC 3551 CondStore extension */
    kHasEnableCapability    =  0x04000000, /* RFC 5161 ENABLE extension */
    kHasXListCapability    =  0x08000000,  /* XLIST extension */
    kHasCompressDeflateCapability  = 0x10000000,  /* RFC 4978 COMPRESS extension */
    kHasAuthExternalCapability  = 0x20000000,  /* RFC 2222 SASL AUTH EXTERNAL */
    kHasMoveCapability  = 0x40000000,  /* Proposed MOVE RFC */
    kHasHighestModSeqCapability  = 0x80000000  /* Subset of RFC 3551 */
} eIMAPCapabilityFlag;

// this used to be part of the connection object class - maybe we should move it into 
// something similar
typedef enum {
    kEveryThingRFC822,
    kEveryThingRFC822Peek,
    kHeadersRFC822andUid,
    kUid,
    kFlags,
    kRFC822Size,
    kRFC822HeadersOnly,
    kMIMEPart,
    kMIMEHeader,
    kBodyStart
} nsIMAPeFetchFields;

typedef struct _utf_name_struct {
	bool toUtf7Imap;
	unsigned char *sourceString;
	unsigned char *convertedString;
} utf_name_struct;

typedef struct _ProgressInfo {
  PRUnichar *message;
  PRInt32 currentProgress;
  PRInt32 maxProgress;
} ProgressInfo;

typedef enum {
    eContinue,
    eContinueNew,
    eListMyChildren,
    eNewServerDirectory,
    eCancelled 
} EMailboxDiscoverStatus;

#endif
