<?php
class View
{
    var $view_dir;
    var $encode;
    var $post;
    var $get;

    /**
     * @param string $dir 
     * @param string $encode : default NULL -> htmlspecialchars() uses ISO-8859-1
     * @access public
     * @return void
     */
    function View($dir, $encode = NULL)
    {
        $this->view_dir = $dir;
        $this->encode   = $encode;
        $this->post     = $_POST;
        $this->get      = $_GET;
    }

    /**
     * @param string $tpl 
     * @param array $d 
     * @access public
     * @return void
     */
    function Assign($tpl, $d = array())
    {
        $this->_Escape($d);

        foreach ($d as $k => $v) {
            ${$k} = $v;
        }

        $this->_Escape($this->post);
        $this->_Escape($this->get);
        $post = $this->post;
        $get  = $this->get;
        unset($_POST);
        unset($_GET);

        include $this->view_dir.$tpl.'.php';
    }

    /**
     * @access protected
     */
    function _Escape(&$d)
    {
        if (is_array($d)) {
            foreach ($d as $k => $v) {
                if (is_array($d[$k])) {
                    $this->_Escape($d[$k]);
                } else {
                    $d[$k] = ($v != '') ? htmlspecialchars($v, ENT_QUOTES, $this->encode) : $v;
                }
            }
        } elseif ($d != NULL) {
            exit('application error: '.__FILE__);
        }
    }
}
