/*
 * Decompiled with CFR 0.152.
 */
package plugin.sympathy.rss.util;

import de.nava.informa.core.ParseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.sql.SQLException;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;

public class ExceptionHandler {
    private Shell parentShell;
    private Exception e;

    public void exceptionHandlar(Exception e, Shell parentShell) {
        this.parentShell = parentShell;
        this.e = e;
        if (e instanceof ClassNotFoundException) {
            this.openErrorDialog(1);
        } else if (e instanceof IllegalAccessException) {
            this.openErrorDialog(2);
        } else if (e instanceof InvocationTargetException) {
            this.openErrorDialog(3);
        } else if (e instanceof NoSuchMethodException) {
            this.openErrorDialog(4);
        } else if (e instanceof InstantiationException) {
            this.openErrorDialog(5);
        } else if (e instanceof SQLException) {
            this.openErrorDialog(6);
        } else if (e instanceof FileNotFoundException) {
            this.openErrorDialog(7);
        } else if (e instanceof JAXBException) {
            this.openErrorDialog(8);
        } else if (e instanceof IllegalArgumentException) {
            this.openErrorDialog(9);
        } else if (e instanceof IOException) {
            this.openErrorDialog(10);
        } else if (e instanceof MalformedURLException) {
            this.openErrorDialog(11);
        } else if (e instanceof ParseException) {
            this.openErrorDialog(12);
        }
    }

    private void openErrorDialog(int errorCode) {
        Status status = new Status(4, "SympathyRSS", errorCode, this.e.getMessage(), (Throwable)this.e);
        ErrorDialog.openError((Shell)this.parentShell, (String)"\u30a8\u30e9\u30fc", (String)"\u30a8\u30e9\u30fc\u30e1\u30c3\u30bb\u30fc\u30b8", (IStatus)status);
    }
}

