
--
-- Copyright (C) 2017  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (avent)

procedure draw_maze6 is

	hwdoor : constant float := 0.8;
	fhdoor : constant float := 1.8;

begin

	snake6rad := 7.0;

	snake6angl := 0.02*onepi*currenttime;

	-- given my coords, this defines a clockwise rotation:
	x6snake:= snake6rad*fmath.cos(snake6angl);
	z6snake:= snake6rad*fmath.sin(snake6angl);


		-- green mamba
		glUseProgram( snaketexshadid );
		gluniformmatrix4fv(snakemvid, 1, gl_false, imv(1,1)'address );
		gluniformmatrix4fv(snakeMatrixID, 1, gl_false, imvp(1,1)'address );
		gluniform1i(snakeuniftex,0);
		glUniform3f(snakecenID, 0.0, glfloat( -iymax+0.02 ), 0.0 );
		glUniform1f(snakeunifrad, glfloat(snake6rad) ); -- circle radius
		glUniform1f(snakeunifangl, glfloat(snake6angl) ); -- angle around orbit
		glUniform1f(snakeunifwvel, 1.0 ); --wiggle freq
		glUniform1f(snakeunifwamp, 4.0 ); --wiggle amplitude

		glUniform1i(snakeunifdark, darkness);
		gluniform1i(snakeuniflev, interfaces.c.int(3) ); 
		-- 1=>normal, 2=>heavy, 3=>extreme fog
		gluniform1i(snakeunifclr, interfaces.c.int(1) ); 
		-- 1=>gray, 2=>brown, 3=>purple fog

		glbindtexture(gl_texture_2d, snake_texid);
		longtube.draw( snake, vertbuff,uvbuff,elembuff );






		--for normal textured objects:
		glUseProgram( pgmtexshadid );

		gluniformmatrix4fv( mvid, 1, gl_false, imv(1,1)'address );
		gluniformmatrix4fv( matrixid, 1, gl_false, imvp(1,1)'address );

		gluniform1i(uniftex,0);
		glUniform1i(unifdark, darkness);

		gluniform1i(uniflev, interfaces.c.int(3) ); 
		-- 1=>normal, 2=>heavy, 3=>extreme fog
		gluniform1i(unifclr, interfaces.c.int(1) ); 
		-- 1=>gray, 2=>brown, 3=>purple fog

		glbindtexture(gl_texture_2d, mazeouter_texid);
		droomobj.draw(mdo6,vertbuff,uvbuff,elembuff); --textured room


		--floor
		glbindtexture(gl_texture_2d, grass_texid);
		rectobj.draw(mfloor, vertbuff,uvbuff,elembuff);


		glbindtexture(gl_texture_2d, doort_texid);
		-- transition doors
		pictobj.draw(doora1, vertbuff,uvbuff,elembuff);
		pictobj.draw(doora2, vertbuff,uvbuff,elembuff);
		pictobj.draw(doorb1, vertbuff,uvbuff,elembuff);
		pictobj.draw(doorb2, vertbuff,uvbuff,elembuff);
		pictobj.draw(doorv6, vertbuff,uvbuff,elembuff);
		pictobj.draw(doorw6, vertbuff,uvbuff,elembuff);
		pictobj.draw(doorx6, vertbuff,uvbuff,elembuff);
		pictobj.draw(doory6, vertbuff,uvbuff,elembuff);
		pictobj.draw(doorz6, vertbuff,uvbuff,elembuff);
		pictobj.draw(doorc6, vertbuff,uvbuff,elembuff);
		pictobj.draw(doord6, vertbuff,uvbuff,elembuff);
		pictobj.draw(doore6, vertbuff,uvbuff,elembuff);
		pictobj.draw(doorf6, vertbuff,uvbuff,elembuff);
		pictobj.draw(doorg6, vertbuff,uvbuff,elembuff);






		--maze walls
		glbindtexture(gl_texture_2d, hedge_texid); --barrier
		for row in -mrows..mrows loop
		for col in -mcols..mcols loop
		if iswall(6,row,col) then
			if not passthru(6,row,col) then
				rectobj.draw(
					mzwall(6,row,col), 
						vertbuff,uvbuff,elembuff);
			end if;
		end if;
		end loop;
		end loop;

		--secret pass-thru wall uses slightly different texture:
		glbindtexture(gl_texture_2d, mazeouter_texid); --passthru
		for row in -mrows..mrows loop
		for col in -mcols..mcols loop
		if iswall(6,row,col) then
			if passthru(6,row,col) then
				null;
				rectobj.draw(
					mzwall(6,row,col), 
						vertbuff,uvbuff,elembuff);
			end if;
		end if;
		end loop;
		end loop;







		if liongoingup then

			elapsed := currenttime-liontime;
			tt := elapsed/liftduration;
			if tt>1.0 then 
				lionwait:=false; 
				lionopen:=true;
				liongoingup:=false;
				tt:=1.0; 
			end if;

			ylion:=-iymax+fhdoor/2.0+tt*fhdoor*0.8;
			pictobj.setrect( 
				dungdoor,
				xlion, ylion, zlion,
				hwdoor-0.05, fhdoor/2.0, 0.05,
				j1,j2,j3,j4,j5,j6);

			--disable KO #lko
			koxlo(lko):=0.0;
			koxhi(lko):=0.0;
			koylo(lko):=0.0;
			koyhi(lko):=0.0;
			kozlo(lko):=0.0;
			kozhi(lko):=0.0;

		end if;

		-- lion lifting door
		glbindtexture(gl_texture_2d, lion_texid);
		pictobj.draw(dungdoor, vertbuff,uvbuff,elembuff);

		--pillars
		glbindtexture(gl_texture_2d, gmarble_texid);
		cylobj.draw(pillar1, vertbuff,uvbuff,elembuff);
		cylobj.draw(pillar2, vertbuff,uvbuff,elembuff);
		pictobj.draw(beam12, vertbuff,uvbuff,elembuff);







---------------------------------------------------------------

		if not gkeyheld and sgkey=6 and gkeyvisible then
			glbindtexture(gl_texture_2d, gkey_texid);
			pictobj.draw(key3, vertbuff,uvbuff,elembuff);
		end if;


		if not bkeyheld and sbkey=6 and not bathasbkey then
			glbindtexture(gl_texture_2d, bkey_texid);
			pictobj.draw(key2, vertbuff,uvbuff,elembuff);
		end if;

		if not wkeyheld and swkey=6 and not bathaswkey then
			glbindtexture(gl_texture_2d, key_texid);
			pictobj.draw(key1, vertbuff,uvbuff,elembuff);
		end if;

		if not swordheld and ssword=6 then
			glbindtexture(gl_texture_2d, sword_texid);
			pictobj.draw(sword, vertbuff,uvbuff,elembuff);
		end if;



	if drawchalice and schalice=6 and not chaliceheld then
	-- use uniforms to set position
		glUseProgram(cupTexShadID);

	glUniform1f(cupunifang, 0.0);

		glUniformMatrix4fv(cupMatrixID, 1, GL_FALSE, imvp(1,1)'address);
		glUniform1i(cupuniftex, 0);
		glUniform1i(cupunifdark, darkness);
			glUniform3f(cupcenid, xchalice,ychalice,zchalice );
			glUniform3f(cupradid, wcup, hcup, wcup );


		gluniform1i(cupuniflev, interfaces.c.int(3) ); 
		-- 1=>normal, 2=>dense, 3=>extreme fog

		gluniform1i(cupunifclr, interfaces.c.int(1) ); 
		-- 1=>gray, 2=>brown, 3=>purple fog

		glUniformMatrix4fv(cupmvid, 1, GL_FALSE, imv(1,1)'address);



		glbindtexture(gl_texture_2d, chalice_texid);
		xtreeobj.draw(chalice, vertbuff,uvbuff,elembuff);
	end if;


if scene=6 then

			showingGlyph:=false;

		-- glyphs drawn @ screen center
		if gkeyheld then --draw key
			utex.print2d("^",0.5,0.5,50); -- "^" => green key
			showingGlyph:=true;

		elsif bkeyheld then --draw key
			utex.print2d("|",0.5,0.5,50); -- "|" => black key
			showingGlyph:=true;

		elsif wkeyheld then --draw key
			utex.print2d("~",0.5,0.5,50); -- "~" => white key
			showingGlyph:=true;

		elsif swordheld then --draw sword
			utex.print2d("=",0.5,0.5,120); -- "=" => sword
			showingGlyph:=true;

		elsif chaliceheld then --draw chalice
			utex.print2d(";",0.5,0.5,80); -- ";" => chalice
			showingGlyph:=true;
		end if;

		if 
			(gkeynear or bkeynear or wkeynear or swordnear or chalicenear)
			and not gatewait and not lionwait and not mazewait
		then
			utex.print2d("`",0.5,0.4,50); -- "`" = hand
			showingGlyph:=true;
		end if;

end if;


		-- fancy fragshader draws cloud ceiling
		glUseProgram( skyshadid );
		gluniformmatrix4fv( skymatid, 1, gl_false, imvp(1,1)'address );
		gluniform1f(skytimeid, glfloat(currentTime) );
		gluniform2f(skyresid, glfloat(winwidth), glfloat(winheight) );
		rectxobj.draw(rox,vertbuff,elembuff);




end draw_maze6;


