--                                                                    --
--  package                         Copyright (c)  Dmitry A. Kazakov  --
--     Strings_Edit.UTF8.Mapping                   Luebeck            --
--  Implementation                                 Winter, 2008       --
--                                                                    --
--                                Last revision :  21:03 21 Apr 2009  --
--                                                                    --
--  This  library  is  free software; you can redistribute it and/or  --
--  modify it under the terms of the GNU General Public  License  as  --
--  published by the Free Software Foundation; either version  2  of  --
--  the License, or (at your option) any later version. This library  --
--  is distributed in the hope that it will be useful,  but  WITHOUT  --
--  ANY   WARRANTY;   without   even   the   implied   warranty   of  --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  --
--  General  Public  License  for  more  details.  You  should  have  --
--  received  a  copy  of  the GNU General Public License along with  --
--  this library; if not, write to  the  Free  Software  Foundation,  --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.    --
--                                                                    --
--  As a special exception, if other files instantiate generics from  --
--  this unit, or you link this unit with other files to produce  an  --
--  executable, this unit does not by  itself  cause  the  resulting  --
--  executable to be covered by the GNU General Public License. This  --
--  exception  does not however invalidate any other reasons why the  --
--  executable file might be covered by the GNU Public License.       --
--____________________________________________________________________--

with Ada.IO_Exceptions;  use Ada.IO_Exceptions;

package body Strings_Edit.UTF8.Mapping is

   type Categorization is record
      Code  : UTF8_Code_Point;
      Upper : UTF8_Code_Point;
      Lower : UTF8_Code_Point;
   end record;
   type Categorization_Index is range 1..3070;
   type Categorization_Array is array (Categorization_Index)
      of Categorization;

   Mapping : constant Categorization_Array :=
   (
      (16#41#,16#41#,16#61#),(16#42#,16#42#,16#62#),(16#43#,16#43#,16#63#),
      (16#44#,16#44#,16#64#),(16#45#,16#45#,16#65#),(16#46#,16#46#,16#66#),
      (16#47#,16#47#,16#67#),(16#48#,16#48#,16#68#),(16#49#,16#49#,16#69#),
      (16#4A#,16#4A#,16#6A#),(16#4B#,16#4B#,16#6B#),(16#4C#,16#4C#,16#6C#),
      (16#4D#,16#4D#,16#6D#),(16#4E#,16#4E#,16#6E#),(16#4F#,16#4F#,16#6F#),
      (16#50#,16#50#,16#70#),(16#51#,16#51#,16#71#),(16#52#,16#52#,16#72#),
      (16#53#,16#53#,16#73#),(16#54#,16#54#,16#74#),(16#55#,16#55#,16#75#),
      (16#56#,16#56#,16#76#),(16#57#,16#57#,16#77#),(16#58#,16#58#,16#78#),
      (16#59#,16#59#,16#79#),(16#5A#,16#5A#,16#7A#),(16#61#,16#41#,16#61#),
      (16#62#,16#42#,16#62#),(16#63#,16#43#,16#63#),(16#64#,16#44#,16#64#),
      (16#65#,16#45#,16#65#),(16#66#,16#46#,16#66#),(16#67#,16#47#,16#67#),
      (16#68#,16#48#,16#68#),(16#69#,16#49#,16#69#),(16#6A#,16#4A#,16#6A#),
      (16#6B#,16#4B#,16#6B#),(16#6C#,16#4C#,16#6C#),(16#6D#,16#4D#,16#6D#),
      (16#6E#,16#4E#,16#6E#),(16#6F#,16#4F#,16#6F#),(16#70#,16#50#,16#70#),
      (16#71#,16#51#,16#71#),(16#72#,16#52#,16#72#),(16#73#,16#53#,16#73#),
      (16#74#,16#54#,16#74#),(16#75#,16#55#,16#75#),(16#76#,16#56#,16#76#),
      (16#77#,16#57#,16#77#),(16#78#,16#58#,16#78#),(16#79#,16#59#,16#79#),
      (16#7A#,16#5A#,16#7A#),(16#AA#,16#AA#,16#AA#),(16#B5#,16#39C#,16#B5#),
      (16#BA#,16#BA#,16#BA#),(16#C0#,16#C0#,16#E0#),(16#C1#,16#C1#,16#E1#),
      (16#C2#,16#C2#,16#E2#),(16#C3#,16#C3#,16#E3#),(16#C4#,16#C4#,16#E4#),
      (16#C5#,16#C5#,16#E5#),(16#C6#,16#C6#,16#E6#),(16#C7#,16#C7#,16#E7#),
      (16#C8#,16#C8#,16#E8#),(16#C9#,16#C9#,16#E9#),(16#CA#,16#CA#,16#EA#),
      (16#CB#,16#CB#,16#EB#),(16#CC#,16#CC#,16#EC#),(16#CD#,16#CD#,16#ED#),
      (16#CE#,16#CE#,16#EE#),(16#CF#,16#CF#,16#EF#),(16#D0#,16#D0#,16#F0#),
      (16#D1#,16#D1#,16#F1#),(16#D2#,16#D2#,16#F2#),(16#D3#,16#D3#,16#F3#),
      (16#D4#,16#D4#,16#F4#),(16#D5#,16#D5#,16#F5#),(16#D6#,16#D6#,16#F6#),
      (16#D8#,16#D8#,16#F8#),(16#D9#,16#D9#,16#F9#),(16#DA#,16#DA#,16#FA#),
      (16#DB#,16#DB#,16#FB#),(16#DC#,16#DC#,16#FC#),(16#DD#,16#DD#,16#FD#),
      (16#DE#,16#DE#,16#FE#),(16#DF#,16#DF#,16#DF#),(16#E0#,16#C0#,16#E0#),
      (16#E1#,16#C1#,16#E1#),(16#E2#,16#C2#,16#E2#),(16#E3#,16#C3#,16#E3#),
      (16#E4#,16#C4#,16#E4#),(16#E5#,16#C5#,16#E5#),(16#E6#,16#C6#,16#E6#),
      (16#E7#,16#C7#,16#E7#),(16#E8#,16#C8#,16#E8#),(16#E9#,16#C9#,16#E9#),
      (16#EA#,16#CA#,16#EA#),(16#EB#,16#CB#,16#EB#),(16#EC#,16#CC#,16#EC#),
      (16#ED#,16#CD#,16#ED#),(16#EE#,16#CE#,16#EE#),(16#EF#,16#CF#,16#EF#),
      (16#F0#,16#D0#,16#F0#),(16#F1#,16#D1#,16#F1#),(16#F2#,16#D2#,16#F2#),
      (16#F3#,16#D3#,16#F3#),(16#F4#,16#D4#,16#F4#),(16#F5#,16#D5#,16#F5#),
      (16#F6#,16#D6#,16#F6#),(16#F8#,16#D8#,16#F8#),(16#F9#,16#D9#,16#F9#),
      (16#FA#,16#DA#,16#FA#),(16#FB#,16#DB#,16#FB#),(16#FC#,16#DC#,16#FC#),
      (16#FD#,16#DD#,16#FD#),(16#FE#,16#DE#,16#FE#),(16#FF#,16#178#,16#FF#),
      (16#100#,16#100#,16#101#),(16#101#,16#100#,16#101#),(16#102#,16#102#,16#103#),
      (16#103#,16#102#,16#103#),(16#104#,16#104#,16#105#),(16#105#,16#104#,16#105#),
      (16#106#,16#106#,16#107#),(16#107#,16#106#,16#107#),(16#108#,16#108#,16#109#),
      (16#109#,16#108#,16#109#),(16#10A#,16#10A#,16#10B#),(16#10B#,16#10A#,16#10B#),
      (16#10C#,16#10C#,16#10D#),(16#10D#,16#10C#,16#10D#),(16#10E#,16#10E#,16#10F#),
      (16#10F#,16#10E#,16#10F#),(16#110#,16#110#,16#111#),(16#111#,16#110#,16#111#),
      (16#112#,16#112#,16#113#),(16#113#,16#112#,16#113#),(16#114#,16#114#,16#115#),
      (16#115#,16#114#,16#115#),(16#116#,16#116#,16#117#),(16#117#,16#116#,16#117#),
      (16#118#,16#118#,16#119#),(16#119#,16#118#,16#119#),(16#11A#,16#11A#,16#11B#),
      (16#11B#,16#11A#,16#11B#),(16#11C#,16#11C#,16#11D#),(16#11D#,16#11C#,16#11D#),
      (16#11E#,16#11E#,16#11F#),(16#11F#,16#11E#,16#11F#),(16#120#,16#120#,16#121#),
      (16#121#,16#120#,16#121#),(16#122#,16#122#,16#123#),(16#123#,16#122#,16#123#),
      (16#124#,16#124#,16#125#),(16#125#,16#124#,16#125#),(16#126#,16#126#,16#127#),
      (16#127#,16#126#,16#127#),(16#128#,16#128#,16#129#),(16#129#,16#128#,16#129#),
      (16#12A#,16#12A#,16#12B#),(16#12B#,16#12A#,16#12B#),(16#12C#,16#12C#,16#12D#),
      (16#12D#,16#12C#,16#12D#),(16#12E#,16#12E#,16#12F#),(16#12F#,16#12E#,16#12F#),
      (16#130#,16#130#,16#69#),(16#131#,16#49#,16#131#),(16#132#,16#132#,16#133#),
      (16#133#,16#132#,16#133#),(16#134#,16#134#,16#135#),(16#135#,16#134#,16#135#),
      (16#136#,16#136#,16#137#),(16#137#,16#136#,16#137#),(16#138#,16#138#,16#138#),
      (16#139#,16#139#,16#13A#),(16#13A#,16#139#,16#13A#),(16#13B#,16#13B#,16#13C#),
      (16#13C#,16#13B#,16#13C#),(16#13D#,16#13D#,16#13E#),(16#13E#,16#13D#,16#13E#),
      (16#13F#,16#13F#,16#140#),(16#140#,16#13F#,16#140#),(16#141#,16#141#,16#142#),
      (16#142#,16#141#,16#142#),(16#143#,16#143#,16#144#),(16#144#,16#143#,16#144#),
      (16#145#,16#145#,16#146#),(16#146#,16#145#,16#146#),(16#147#,16#147#,16#148#),
      (16#148#,16#147#,16#148#),(16#149#,16#149#,16#149#),(16#14A#,16#14A#,16#14B#),
      (16#14B#,16#14A#,16#14B#),(16#14C#,16#14C#,16#14D#),(16#14D#,16#14C#,16#14D#),
      (16#14E#,16#14E#,16#14F#),(16#14F#,16#14E#,16#14F#),(16#150#,16#150#,16#151#),
      (16#151#,16#150#,16#151#),(16#152#,16#152#,16#153#),(16#153#,16#152#,16#153#),
      (16#154#,16#154#,16#155#),(16#155#,16#154#,16#155#),(16#156#,16#156#,16#157#),
      (16#157#,16#156#,16#157#),(16#158#,16#158#,16#159#),(16#159#,16#158#,16#159#),
      (16#15A#,16#15A#,16#15B#),(16#15B#,16#15A#,16#15B#),(16#15C#,16#15C#,16#15D#),
      (16#15D#,16#15C#,16#15D#),(16#15E#,16#15E#,16#15F#),(16#15F#,16#15E#,16#15F#),
      (16#160#,16#160#,16#161#),(16#161#,16#160#,16#161#),(16#162#,16#162#,16#163#),
      (16#163#,16#162#,16#163#),(16#164#,16#164#,16#165#),(16#165#,16#164#,16#165#),
      (16#166#,16#166#,16#167#),(16#167#,16#166#,16#167#),(16#168#,16#168#,16#169#),
      (16#169#,16#168#,16#169#),(16#16A#,16#16A#,16#16B#),(16#16B#,16#16A#,16#16B#),
      (16#16C#,16#16C#,16#16D#),(16#16D#,16#16C#,16#16D#),(16#16E#,16#16E#,16#16F#),
      (16#16F#,16#16E#,16#16F#),(16#170#,16#170#,16#171#),(16#171#,16#170#,16#171#),
      (16#172#,16#172#,16#173#),(16#173#,16#172#,16#173#),(16#174#,16#174#,16#175#),
      (16#175#,16#174#,16#175#),(16#176#,16#176#,16#177#),(16#177#,16#176#,16#177#),
      (16#178#,16#178#,16#FF#),(16#179#,16#179#,16#17A#),(16#17A#,16#179#,16#17A#),
      (16#17B#,16#17B#,16#17C#),(16#17C#,16#17B#,16#17C#),(16#17D#,16#17D#,16#17E#),
      (16#17E#,16#17D#,16#17E#),(16#17F#,16#53#,16#17F#),(16#180#,16#243#,16#180#),
      (16#181#,16#181#,16#253#),(16#182#,16#182#,16#183#),(16#183#,16#182#,16#183#),
      (16#184#,16#184#,16#185#),(16#185#,16#184#,16#185#),(16#186#,16#186#,16#254#),
      (16#187#,16#187#,16#188#),(16#188#,16#187#,16#188#),(16#189#,16#189#,16#256#),
      (16#18A#,16#18A#,16#257#),(16#18B#,16#18B#,16#18C#),(16#18C#,16#18B#,16#18C#),
      (16#18D#,16#18D#,16#18D#),(16#18E#,16#18E#,16#1DD#),(16#18F#,16#18F#,16#259#),
      (16#190#,16#190#,16#25B#),(16#191#,16#191#,16#192#),(16#192#,16#191#,16#192#),
      (16#193#,16#193#,16#260#),(16#194#,16#194#,16#263#),(16#195#,16#1F6#,16#195#),
      (16#196#,16#196#,16#269#),(16#197#,16#197#,16#268#),(16#198#,16#198#,16#199#),
      (16#199#,16#198#,16#199#),(16#19A#,16#23D#,16#19A#),(16#19B#,16#19B#,16#19B#),
      (16#19C#,16#19C#,16#26F#),(16#19D#,16#19D#,16#272#),(16#19E#,16#220#,16#19E#),
      (16#19F#,16#19F#,16#275#),(16#1A0#,16#1A0#,16#1A1#),(16#1A1#,16#1A0#,16#1A1#),
      (16#1A2#,16#1A2#,16#1A3#),(16#1A3#,16#1A2#,16#1A3#),(16#1A4#,16#1A4#,16#1A5#),
      (16#1A5#,16#1A4#,16#1A5#),(16#1A6#,16#1A6#,16#280#),(16#1A7#,16#1A7#,16#1A8#),
      (16#1A8#,16#1A7#,16#1A8#),(16#1A9#,16#1A9#,16#283#),(16#1AA#,16#1AA#,16#1AA#),
      (16#1AB#,16#1AB#,16#1AB#),(16#1AC#,16#1AC#,16#1AD#),(16#1AD#,16#1AC#,16#1AD#),
      (16#1AE#,16#1AE#,16#288#),(16#1AF#,16#1AF#,16#1B0#),(16#1B0#,16#1AF#,16#1B0#),
      (16#1B1#,16#1B1#,16#28A#),(16#1B2#,16#1B2#,16#28B#),(16#1B3#,16#1B3#,16#1B4#),
      (16#1B4#,16#1B3#,16#1B4#),(16#1B5#,16#1B5#,16#1B6#),(16#1B6#,16#1B5#,16#1B6#),
      (16#1B7#,16#1B7#,16#292#),(16#1B8#,16#1B8#,16#1B9#),(16#1B9#,16#1B8#,16#1B9#),
      (16#1BA#,16#1BA#,16#1BA#),(16#1BC#,16#1BC#,16#1BD#),(16#1BD#,16#1BC#,16#1BD#),
      (16#1BE#,16#1BE#,16#1BE#),(16#1BF#,16#1F7#,16#1BF#),(16#1C4#,16#1C4#,16#1C6#),
      (16#1C5#,16#1C4#,16#1C6#),(16#1C6#,16#1C4#,16#1C6#),(16#1C7#,16#1C7#,16#1C9#),
      (16#1C8#,16#1C7#,16#1C9#),(16#1C9#,16#1C7#,16#1C9#),(16#1CA#,16#1CA#,16#1CC#),
      (16#1CB#,16#1CA#,16#1CC#),(16#1CC#,16#1CA#,16#1CC#),(16#1CD#,16#1CD#,16#1CE#),
      (16#1CE#,16#1CD#,16#1CE#),(16#1CF#,16#1CF#,16#1D0#),(16#1D0#,16#1CF#,16#1D0#),
      (16#1D1#,16#1D1#,16#1D2#),(16#1D2#,16#1D1#,16#1D2#),(16#1D3#,16#1D3#,16#1D4#),
      (16#1D4#,16#1D3#,16#1D4#),(16#1D5#,16#1D5#,16#1D6#),(16#1D6#,16#1D5#,16#1D6#),
      (16#1D7#,16#1D7#,16#1D8#),(16#1D8#,16#1D7#,16#1D8#),(16#1D9#,16#1D9#,16#1DA#),
      (16#1DA#,16#1D9#,16#1DA#),(16#1DB#,16#1DB#,16#1DC#),(16#1DC#,16#1DB#,16#1DC#),
      (16#1DD#,16#18E#,16#1DD#),(16#1DE#,16#1DE#,16#1DF#),(16#1DF#,16#1DE#,16#1DF#),
      (16#1E0#,16#1E0#,16#1E1#),(16#1E1#,16#1E0#,16#1E1#),(16#1E2#,16#1E2#,16#1E3#),
      (16#1E3#,16#1E2#,16#1E3#),(16#1E4#,16#1E4#,16#1E5#),(16#1E5#,16#1E4#,16#1E5#),
      (16#1E6#,16#1E6#,16#1E7#),(16#1E7#,16#1E6#,16#1E7#),(16#1E8#,16#1E8#,16#1E9#),
      (16#1E9#,16#1E8#,16#1E9#),(16#1EA#,16#1EA#,16#1EB#),(16#1EB#,16#1EA#,16#1EB#),
      (16#1EC#,16#1EC#,16#1ED#),(16#1ED#,16#1EC#,16#1ED#),(16#1EE#,16#1EE#,16#1EF#),
      (16#1EF#,16#1EE#,16#1EF#),(16#1F0#,16#1F0#,16#1F0#),(16#1F1#,16#1F1#,16#1F3#),
      (16#1F2#,16#1F1#,16#1F3#),(16#1F3#,16#1F1#,16#1F3#),(16#1F4#,16#1F4#,16#1F5#),
      (16#1F5#,16#1F4#,16#1F5#),(16#1F6#,16#1F6#,16#195#),(16#1F7#,16#1F7#,16#1BF#),
      (16#1F8#,16#1F8#,16#1F9#),(16#1F9#,16#1F8#,16#1F9#),(16#1FA#,16#1FA#,16#1FB#),
      (16#1FB#,16#1FA#,16#1FB#),(16#1FC#,16#1FC#,16#1FD#),(16#1FD#,16#1FC#,16#1FD#),
      (16#1FE#,16#1FE#,16#1FF#),(16#1FF#,16#1FE#,16#1FF#),(16#200#,16#200#,16#201#),
      (16#201#,16#200#,16#201#),(16#202#,16#202#,16#203#),(16#203#,16#202#,16#203#),
      (16#204#,16#204#,16#205#),(16#205#,16#204#,16#205#),(16#206#,16#206#,16#207#),
      (16#207#,16#206#,16#207#),(16#208#,16#208#,16#209#),(16#209#,16#208#,16#209#),
      (16#20A#,16#20A#,16#20B#),(16#20B#,16#20A#,16#20B#),(16#20C#,16#20C#,16#20D#),
      (16#20D#,16#20C#,16#20D#),(16#20E#,16#20E#,16#20F#),(16#20F#,16#20E#,16#20F#),
      (16#210#,16#210#,16#211#),(16#211#,16#210#,16#211#),(16#212#,16#212#,16#213#),
      (16#213#,16#212#,16#213#),(16#214#,16#214#,16#215#),(16#215#,16#214#,16#215#),
      (16#216#,16#216#,16#217#),(16#217#,16#216#,16#217#),(16#218#,16#218#,16#219#),
      (16#219#,16#218#,16#219#),(16#21A#,16#21A#,16#21B#),(16#21B#,16#21A#,16#21B#),
      (16#21C#,16#21C#,16#21D#),(16#21D#,16#21C#,16#21D#),(16#21E#,16#21E#,16#21F#),
      (16#21F#,16#21E#,16#21F#),(16#220#,16#220#,16#19E#),(16#221#,16#221#,16#221#),
      (16#222#,16#222#,16#223#),(16#223#,16#222#,16#223#),(16#224#,16#224#,16#225#),
      (16#225#,16#224#,16#225#),(16#226#,16#226#,16#227#),(16#227#,16#226#,16#227#),
      (16#228#,16#228#,16#229#),(16#229#,16#228#,16#229#),(16#22A#,16#22A#,16#22B#),
      (16#22B#,16#22A#,16#22B#),(16#22C#,16#22C#,16#22D#),(16#22D#,16#22C#,16#22D#),
      (16#22E#,16#22E#,16#22F#),(16#22F#,16#22E#,16#22F#),(16#230#,16#230#,16#231#),
      (16#231#,16#230#,16#231#),(16#232#,16#232#,16#233#),(16#233#,16#232#,16#233#),
      (16#234#,16#234#,16#234#),(16#235#,16#235#,16#235#),(16#236#,16#236#,16#236#),
      (16#237#,16#237#,16#237#),(16#238#,16#238#,16#238#),(16#239#,16#239#,16#239#),
      (16#23A#,16#23A#,16#2C65#),(16#23B#,16#23B#,16#23C#),(16#23C#,16#23B#,16#23C#),
      (16#23D#,16#23D#,16#19A#),(16#23E#,16#23E#,16#2C66#),(16#23F#,16#23F#,16#23F#),
      (16#240#,16#240#,16#240#),(16#241#,16#241#,16#242#),(16#242#,16#241#,16#242#),
      (16#243#,16#243#,16#180#),(16#244#,16#244#,16#289#),(16#245#,16#245#,16#28C#),
      (16#246#,16#246#,16#247#),(16#247#,16#246#,16#247#),(16#248#,16#248#,16#249#),
      (16#249#,16#248#,16#249#),(16#24A#,16#24A#,16#24B#),(16#24B#,16#24A#,16#24B#),
      (16#24C#,16#24C#,16#24D#),(16#24D#,16#24C#,16#24D#),(16#24E#,16#24E#,16#24F#),
      (16#24F#,16#24E#,16#24F#),(16#250#,16#250#,16#250#),(16#251#,16#251#,16#251#),
      (16#252#,16#252#,16#252#),(16#253#,16#181#,16#253#),(16#254#,16#186#,16#254#),
      (16#255#,16#255#,16#255#),(16#256#,16#189#,16#256#),(16#257#,16#18A#,16#257#),
      (16#258#,16#258#,16#258#),(16#259#,16#18F#,16#259#),(16#25A#,16#25A#,16#25A#),
      (16#25B#,16#190#,16#25B#),(16#25C#,16#25C#,16#25C#),(16#25D#,16#25D#,16#25D#),
      (16#25E#,16#25E#,16#25E#),(16#25F#,16#25F#,16#25F#),(16#260#,16#193#,16#260#),
      (16#261#,16#261#,16#261#),(16#262#,16#262#,16#262#),(16#263#,16#194#,16#263#),
      (16#264#,16#264#,16#264#),(16#265#,16#265#,16#265#),(16#266#,16#266#,16#266#),
      (16#267#,16#267#,16#267#),(16#268#,16#197#,16#268#),(16#269#,16#196#,16#269#),
      (16#26A#,16#26A#,16#26A#),(16#26B#,16#2C62#,16#26B#),(16#26C#,16#26C#,16#26C#),
      (16#26D#,16#26D#,16#26D#),(16#26E#,16#26E#,16#26E#),(16#26F#,16#19C#,16#26F#),
      (16#270#,16#270#,16#270#),(16#271#,16#271#,16#271#),(16#272#,16#19D#,16#272#),
      (16#273#,16#273#,16#273#),(16#274#,16#274#,16#274#),(16#275#,16#19F#,16#275#),
      (16#276#,16#276#,16#276#),(16#277#,16#277#,16#277#),(16#278#,16#278#,16#278#),
      (16#279#,16#279#,16#279#),(16#27A#,16#27A#,16#27A#),(16#27B#,16#27B#,16#27B#),
      (16#27C#,16#27C#,16#27C#),(16#27D#,16#2C64#,16#27D#),(16#27E#,16#27E#,16#27E#),
      (16#27F#,16#27F#,16#27F#),(16#280#,16#1A6#,16#280#),(16#281#,16#281#,16#281#),
      (16#282#,16#282#,16#282#),(16#283#,16#1A9#,16#283#),(16#284#,16#284#,16#284#),
      (16#285#,16#285#,16#285#),(16#286#,16#286#,16#286#),(16#287#,16#287#,16#287#),
      (16#288#,16#1AE#,16#288#),(16#289#,16#244#,16#289#),(16#28A#,16#1B1#,16#28A#),
      (16#28B#,16#1B2#,16#28B#),(16#28C#,16#245#,16#28C#),(16#28D#,16#28D#,16#28D#),
      (16#28E#,16#28E#,16#28E#),(16#28F#,16#28F#,16#28F#),(16#290#,16#290#,16#290#),
      (16#291#,16#291#,16#291#),(16#292#,16#1B7#,16#292#),(16#293#,16#293#,16#293#),
      (16#295#,16#295#,16#295#),(16#296#,16#296#,16#296#),(16#297#,16#297#,16#297#),
      (16#298#,16#298#,16#298#),(16#299#,16#299#,16#299#),(16#29A#,16#29A#,16#29A#),
      (16#29B#,16#29B#,16#29B#),(16#29C#,16#29C#,16#29C#),(16#29D#,16#29D#,16#29D#),
      (16#29E#,16#29E#,16#29E#),(16#29F#,16#29F#,16#29F#),(16#2A0#,16#2A0#,16#2A0#),
      (16#2A1#,16#2A1#,16#2A1#),(16#2A2#,16#2A2#,16#2A2#),(16#2A3#,16#2A3#,16#2A3#),
      (16#2A4#,16#2A4#,16#2A4#),(16#2A5#,16#2A5#,16#2A5#),(16#2A6#,16#2A6#,16#2A6#),
      (16#2A7#,16#2A7#,16#2A7#),(16#2A8#,16#2A8#,16#2A8#),(16#2A9#,16#2A9#,16#2A9#),
      (16#2AA#,16#2AA#,16#2AA#),(16#2AB#,16#2AB#,16#2AB#),(16#2AC#,16#2AC#,16#2AC#),
      (16#2AD#,16#2AD#,16#2AD#),(16#2AE#,16#2AE#,16#2AE#),(16#2AF#,16#2AF#,16#2AF#),
      (16#345#,16#399#,16#345#),(16#37B#,16#3FD#,16#37B#),(16#37C#,16#3FE#,16#37C#),
      (16#37D#,16#3FF#,16#37D#),(16#386#,16#386#,16#3AC#),(16#388#,16#388#,16#3AD#),
      (16#389#,16#389#,16#3AE#),(16#38A#,16#38A#,16#3AF#),(16#38C#,16#38C#,16#3CC#),
      (16#38E#,16#38E#,16#3CD#),(16#38F#,16#38F#,16#3CE#),(16#390#,16#390#,16#390#),
      (16#391#,16#391#,16#3B1#),(16#392#,16#392#,16#3B2#),(16#393#,16#393#,16#3B3#),
      (16#394#,16#394#,16#3B4#),(16#395#,16#395#,16#3B5#),(16#396#,16#396#,16#3B6#),
      (16#397#,16#397#,16#3B7#),(16#398#,16#398#,16#3B8#),(16#399#,16#399#,16#3B9#),
      (16#39A#,16#39A#,16#3BA#),(16#39B#,16#39B#,16#3BB#),(16#39C#,16#39C#,16#3BC#),
      (16#39D#,16#39D#,16#3BD#),(16#39E#,16#39E#,16#3BE#),(16#39F#,16#39F#,16#3BF#),
      (16#3A0#,16#3A0#,16#3C0#),(16#3A1#,16#3A1#,16#3C1#),(16#3A3#,16#3A3#,16#3C3#),
      (16#3A4#,16#3A4#,16#3C4#),(16#3A5#,16#3A5#,16#3C5#),(16#3A6#,16#3A6#,16#3C6#),
      (16#3A7#,16#3A7#,16#3C7#),(16#3A8#,16#3A8#,16#3C8#),(16#3A9#,16#3A9#,16#3C9#),
      (16#3AA#,16#3AA#,16#3CA#),(16#3AB#,16#3AB#,16#3CB#),(16#3AC#,16#386#,16#3AC#),
      (16#3AD#,16#388#,16#3AD#),(16#3AE#,16#389#,16#3AE#),(16#3AF#,16#38A#,16#3AF#),
      (16#3B0#,16#3B0#,16#3B0#),(16#3B1#,16#391#,16#3B1#),(16#3B2#,16#392#,16#3B2#),
      (16#3B3#,16#393#,16#3B3#),(16#3B4#,16#394#,16#3B4#),(16#3B5#,16#395#,16#3B5#),
      (16#3B6#,16#396#,16#3B6#),(16#3B7#,16#397#,16#3B7#),(16#3B8#,16#398#,16#3B8#),
      (16#3B9#,16#399#,16#3B9#),(16#3BA#,16#39A#,16#3BA#),(16#3BB#,16#39B#,16#3BB#),
      (16#3BC#,16#39C#,16#3BC#),(16#3BD#,16#39D#,16#3BD#),(16#3BE#,16#39E#,16#3BE#),
      (16#3BF#,16#39F#,16#3BF#),(16#3C0#,16#3A0#,16#3C0#),(16#3C1#,16#3A1#,16#3C1#),
      (16#3C2#,16#3A3#,16#3C2#),(16#3C3#,16#3A3#,16#3C3#),(16#3C4#,16#3A4#,16#3C4#),
      (16#3C5#,16#3A5#,16#3C5#),(16#3C6#,16#3A6#,16#3C6#),(16#3C7#,16#3A7#,16#3C7#),
      (16#3C8#,16#3A8#,16#3C8#),(16#3C9#,16#3A9#,16#3C9#),(16#3CA#,16#3AA#,16#3CA#),
      (16#3CB#,16#3AB#,16#3CB#),(16#3CC#,16#38C#,16#3CC#),(16#3CD#,16#38E#,16#3CD#),
      (16#3CE#,16#38F#,16#3CE#),(16#3D0#,16#392#,16#3D0#),(16#3D1#,16#398#,16#3D1#),
      (16#3D2#,16#3D2#,16#3D2#),(16#3D3#,16#3D3#,16#3D3#),(16#3D4#,16#3D4#,16#3D4#),
      (16#3D5#,16#3A6#,16#3D5#),(16#3D6#,16#3A0#,16#3D6#),(16#3D7#,16#3D7#,16#3D7#),
      (16#3D8#,16#3D8#,16#3D9#),(16#3D9#,16#3D8#,16#3D9#),(16#3DA#,16#3DA#,16#3DB#),
      (16#3DB#,16#3DA#,16#3DB#),(16#3DC#,16#3DC#,16#3DD#),(16#3DD#,16#3DC#,16#3DD#),
      (16#3DE#,16#3DE#,16#3DF#),(16#3DF#,16#3DE#,16#3DF#),(16#3E0#,16#3E0#,16#3E1#),
      (16#3E1#,16#3E0#,16#3E1#),(16#3E2#,16#3E2#,16#3E3#),(16#3E3#,16#3E2#,16#3E3#),
      (16#3E4#,16#3E4#,16#3E5#),(16#3E5#,16#3E4#,16#3E5#),(16#3E6#,16#3E6#,16#3E7#),
      (16#3E7#,16#3E6#,16#3E7#),(16#3E8#,16#3E8#,16#3E9#),(16#3E9#,16#3E8#,16#3E9#),
      (16#3EA#,16#3EA#,16#3EB#),(16#3EB#,16#3EA#,16#3EB#),(16#3EC#,16#3EC#,16#3ED#),
      (16#3ED#,16#3EC#,16#3ED#),(16#3EE#,16#3EE#,16#3EF#),(16#3EF#,16#3EE#,16#3EF#),
      (16#3F0#,16#39A#,16#3F0#),(16#3F1#,16#3A1#,16#3F1#),(16#3F2#,16#3F9#,16#3F2#),
      (16#3F3#,16#3F3#,16#3F3#),(16#3F4#,16#3F4#,16#3B8#),(16#3F5#,16#395#,16#3F5#),
      (16#3F7#,16#3F7#,16#3F8#),(16#3F8#,16#3F7#,16#3F8#),(16#3F9#,16#3F9#,16#3F2#),
      (16#3FA#,16#3FA#,16#3FB#),(16#3FB#,16#3FA#,16#3FB#),(16#3FC#,16#3FC#,16#3FC#),
      (16#3FD#,16#3FD#,16#37B#),(16#3FE#,16#3FE#,16#37C#),(16#3FF#,16#3FF#,16#37D#),
      (16#400#,16#400#,16#450#),(16#401#,16#401#,16#451#),(16#402#,16#402#,16#452#),
      (16#403#,16#403#,16#453#),(16#404#,16#404#,16#454#),(16#405#,16#405#,16#455#),
      (16#406#,16#406#,16#456#),(16#407#,16#407#,16#457#),(16#408#,16#408#,16#458#),
      (16#409#,16#409#,16#459#),(16#40A#,16#40A#,16#45A#),(16#40B#,16#40B#,16#45B#),
      (16#40C#,16#40C#,16#45C#),(16#40D#,16#40D#,16#45D#),(16#40E#,16#40E#,16#45E#),
      (16#40F#,16#40F#,16#45F#),(16#410#,16#410#,16#430#),(16#411#,16#411#,16#431#),
      (16#412#,16#412#,16#432#),(16#413#,16#413#,16#433#),(16#414#,16#414#,16#434#),
      (16#415#,16#415#,16#435#),(16#416#,16#416#,16#436#),(16#417#,16#417#,16#437#),
      (16#418#,16#418#,16#438#),(16#419#,16#419#,16#439#),(16#41A#,16#41A#,16#43A#),
      (16#41B#,16#41B#,16#43B#),(16#41C#,16#41C#,16#43C#),(16#41D#,16#41D#,16#43D#),
      (16#41E#,16#41E#,16#43E#),(16#41F#,16#41F#,16#43F#),(16#420#,16#420#,16#440#),
      (16#421#,16#421#,16#441#),(16#422#,16#422#,16#442#),(16#423#,16#423#,16#443#),
      (16#424#,16#424#,16#444#),(16#425#,16#425#,16#445#),(16#426#,16#426#,16#446#),
      (16#427#,16#427#,16#447#),(16#428#,16#428#,16#448#),(16#429#,16#429#,16#449#),
      (16#42A#,16#42A#,16#44A#),(16#42B#,16#42B#,16#44B#),(16#42C#,16#42C#,16#44C#),
      (16#42D#,16#42D#,16#44D#),(16#42E#,16#42E#,16#44E#),(16#42F#,16#42F#,16#44F#),
      (16#430#,16#410#,16#430#),(16#431#,16#411#,16#431#),(16#432#,16#412#,16#432#),
      (16#433#,16#413#,16#433#),(16#434#,16#414#,16#434#),(16#435#,16#415#,16#435#),
      (16#436#,16#416#,16#436#),(16#437#,16#417#,16#437#),(16#438#,16#418#,16#438#),
      (16#439#,16#419#,16#439#),(16#43A#,16#41A#,16#43A#),(16#43B#,16#41B#,16#43B#),
      (16#43C#,16#41C#,16#43C#),(16#43D#,16#41D#,16#43D#),(16#43E#,16#41E#,16#43E#),
      (16#43F#,16#41F#,16#43F#),(16#440#,16#420#,16#440#),(16#441#,16#421#,16#441#),
      (16#442#,16#422#,16#442#),(16#443#,16#423#,16#443#),(16#444#,16#424#,16#444#),
      (16#445#,16#425#,16#445#),(16#446#,16#426#,16#446#),(16#447#,16#427#,16#447#),
      (16#448#,16#428#,16#448#),(16#449#,16#429#,16#449#),(16#44A#,16#42A#,16#44A#),
      (16#44B#,16#42B#,16#44B#),(16#44C#,16#42C#,16#44C#),(16#44D#,16#42D#,16#44D#),
      (16#44E#,16#42E#,16#44E#),(16#44F#,16#42F#,16#44F#),(16#450#,16#400#,16#450#),
      (16#451#,16#401#,16#451#),(16#452#,16#402#,16#452#),(16#453#,16#403#,16#453#),
      (16#454#,16#404#,16#454#),(16#455#,16#405#,16#455#),(16#456#,16#406#,16#456#),
      (16#457#,16#407#,16#457#),(16#458#,16#408#,16#458#),(16#459#,16#409#,16#459#),
      (16#45A#,16#40A#,16#45A#),(16#45B#,16#40B#,16#45B#),(16#45C#,16#40C#,16#45C#),
      (16#45D#,16#40D#,16#45D#),(16#45E#,16#40E#,16#45E#),(16#45F#,16#40F#,16#45F#),
      (16#460#,16#460#,16#461#),(16#461#,16#460#,16#461#),(16#462#,16#462#,16#463#),
      (16#463#,16#462#,16#463#),(16#464#,16#464#,16#465#),(16#465#,16#464#,16#465#),
      (16#466#,16#466#,16#467#),(16#467#,16#466#,16#467#),(16#468#,16#468#,16#469#),
      (16#469#,16#468#,16#469#),(16#46A#,16#46A#,16#46B#),(16#46B#,16#46A#,16#46B#),
      (16#46C#,16#46C#,16#46D#),(16#46D#,16#46C#,16#46D#),(16#46E#,16#46E#,16#46F#),
      (16#46F#,16#46E#,16#46F#),(16#470#,16#470#,16#471#),(16#471#,16#470#,16#471#),
      (16#472#,16#472#,16#473#),(16#473#,16#472#,16#473#),(16#474#,16#474#,16#475#),
      (16#475#,16#474#,16#475#),(16#476#,16#476#,16#477#),(16#477#,16#476#,16#477#),
      (16#478#,16#478#,16#479#),(16#479#,16#478#,16#479#),(16#47A#,16#47A#,16#47B#),
      (16#47B#,16#47A#,16#47B#),(16#47C#,16#47C#,16#47D#),(16#47D#,16#47C#,16#47D#),
      (16#47E#,16#47E#,16#47F#),(16#47F#,16#47E#,16#47F#),(16#480#,16#480#,16#481#),
      (16#481#,16#480#,16#481#),(16#48A#,16#48A#,16#48B#),(16#48B#,16#48A#,16#48B#),
      (16#48C#,16#48C#,16#48D#),(16#48D#,16#48C#,16#48D#),(16#48E#,16#48E#,16#48F#),
      (16#48F#,16#48E#,16#48F#),(16#490#,16#490#,16#491#),(16#491#,16#490#,16#491#),
      (16#492#,16#492#,16#493#),(16#493#,16#492#,16#493#),(16#494#,16#494#,16#495#),
      (16#495#,16#494#,16#495#),(16#496#,16#496#,16#497#),(16#497#,16#496#,16#497#),
      (16#498#,16#498#,16#499#),(16#499#,16#498#,16#499#),(16#49A#,16#49A#,16#49B#),
      (16#49B#,16#49A#,16#49B#),(16#49C#,16#49C#,16#49D#),(16#49D#,16#49C#,16#49D#),
      (16#49E#,16#49E#,16#49F#),(16#49F#,16#49E#,16#49F#),(16#4A0#,16#4A0#,16#4A1#),
      (16#4A1#,16#4A0#,16#4A1#),(16#4A2#,16#4A2#,16#4A3#),(16#4A3#,16#4A2#,16#4A3#),
      (16#4A4#,16#4A4#,16#4A5#),(16#4A5#,16#4A4#,16#4A5#),(16#4A6#,16#4A6#,16#4A7#),
      (16#4A7#,16#4A6#,16#4A7#),(16#4A8#,16#4A8#,16#4A9#),(16#4A9#,16#4A8#,16#4A9#),
      (16#4AA#,16#4AA#,16#4AB#),(16#4AB#,16#4AA#,16#4AB#),(16#4AC#,16#4AC#,16#4AD#),
      (16#4AD#,16#4AC#,16#4AD#),(16#4AE#,16#4AE#,16#4AF#),(16#4AF#,16#4AE#,16#4AF#),
      (16#4B0#,16#4B0#,16#4B1#),(16#4B1#,16#4B0#,16#4B1#),(16#4B2#,16#4B2#,16#4B3#),
      (16#4B3#,16#4B2#,16#4B3#),(16#4B4#,16#4B4#,16#4B5#),(16#4B5#,16#4B4#,16#4B5#),
      (16#4B6#,16#4B6#,16#4B7#),(16#4B7#,16#4B6#,16#4B7#),(16#4B8#,16#4B8#,16#4B9#),
      (16#4B9#,16#4B8#,16#4B9#),(16#4BA#,16#4BA#,16#4BB#),(16#4BB#,16#4BA#,16#4BB#),
      (16#4BC#,16#4BC#,16#4BD#),(16#4BD#,16#4BC#,16#4BD#),(16#4BE#,16#4BE#,16#4BF#),
      (16#4BF#,16#4BE#,16#4BF#),(16#4C0#,16#4C0#,16#4CF#),(16#4C1#,16#4C1#,16#4C2#),
      (16#4C2#,16#4C1#,16#4C2#),(16#4C3#,16#4C3#,16#4C4#),(16#4C4#,16#4C3#,16#4C4#),
      (16#4C5#,16#4C5#,16#4C6#),(16#4C6#,16#4C5#,16#4C6#),(16#4C7#,16#4C7#,16#4C8#),
      (16#4C8#,16#4C7#,16#4C8#),(16#4C9#,16#4C9#,16#4CA#),(16#4CA#,16#4C9#,16#4CA#),
      (16#4CB#,16#4CB#,16#4CC#),(16#4CC#,16#4CB#,16#4CC#),(16#4CD#,16#4CD#,16#4CE#),
      (16#4CE#,16#4CD#,16#4CE#),(16#4CF#,16#4C0#,16#4CF#),(16#4D0#,16#4D0#,16#4D1#),
      (16#4D1#,16#4D0#,16#4D1#),(16#4D2#,16#4D2#,16#4D3#),(16#4D3#,16#4D2#,16#4D3#),
      (16#4D4#,16#4D4#,16#4D5#),(16#4D5#,16#4D4#,16#4D5#),(16#4D6#,16#4D6#,16#4D7#),
      (16#4D7#,16#4D6#,16#4D7#),(16#4D8#,16#4D8#,16#4D9#),(16#4D9#,16#4D8#,16#4D9#),
      (16#4DA#,16#4DA#,16#4DB#),(16#4DB#,16#4DA#,16#4DB#),(16#4DC#,16#4DC#,16#4DD#),
      (16#4DD#,16#4DC#,16#4DD#),(16#4DE#,16#4DE#,16#4DF#),(16#4DF#,16#4DE#,16#4DF#),
      (16#4E0#,16#4E0#,16#4E1#),(16#4E1#,16#4E0#,16#4E1#),(16#4E2#,16#4E2#,16#4E3#),
      (16#4E3#,16#4E2#,16#4E3#),(16#4E4#,16#4E4#,16#4E5#),(16#4E5#,16#4E4#,16#4E5#),
      (16#4E6#,16#4E6#,16#4E7#),(16#4E7#,16#4E6#,16#4E7#),(16#4E8#,16#4E8#,16#4E9#),
      (16#4E9#,16#4E8#,16#4E9#),(16#4EA#,16#4EA#,16#4EB#),(16#4EB#,16#4EA#,16#4EB#),
      (16#4EC#,16#4EC#,16#4ED#),(16#4ED#,16#4EC#,16#4ED#),(16#4EE#,16#4EE#,16#4EF#),
      (16#4EF#,16#4EE#,16#4EF#),(16#4F0#,16#4F0#,16#4F1#),(16#4F1#,16#4F0#,16#4F1#),
      (16#4F2#,16#4F2#,16#4F3#),(16#4F3#,16#4F2#,16#4F3#),(16#4F4#,16#4F4#,16#4F5#),
      (16#4F5#,16#4F4#,16#4F5#),(16#4F6#,16#4F6#,16#4F7#),(16#4F7#,16#4F6#,16#4F7#),
      (16#4F8#,16#4F8#,16#4F9#),(16#4F9#,16#4F8#,16#4F9#),(16#4FA#,16#4FA#,16#4FB#),
      (16#4FB#,16#4FA#,16#4FB#),(16#4FC#,16#4FC#,16#4FD#),(16#4FD#,16#4FC#,16#4FD#),
      (16#4FE#,16#4FE#,16#4FF#),(16#4FF#,16#4FE#,16#4FF#),(16#500#,16#500#,16#501#),
      (16#501#,16#500#,16#501#),(16#502#,16#502#,16#503#),(16#503#,16#502#,16#503#),
      (16#504#,16#504#,16#505#),(16#505#,16#504#,16#505#),(16#506#,16#506#,16#507#),
      (16#507#,16#506#,16#507#),(16#508#,16#508#,16#509#),(16#509#,16#508#,16#509#),
      (16#50A#,16#50A#,16#50B#),(16#50B#,16#50A#,16#50B#),(16#50C#,16#50C#,16#50D#),
      (16#50D#,16#50C#,16#50D#),(16#50E#,16#50E#,16#50F#),(16#50F#,16#50E#,16#50F#),
      (16#510#,16#510#,16#511#),(16#511#,16#510#,16#511#),(16#512#,16#512#,16#513#),
      (16#513#,16#512#,16#513#),(16#531#,16#531#,16#561#),(16#532#,16#532#,16#562#),
      (16#533#,16#533#,16#563#),(16#534#,16#534#,16#564#),(16#535#,16#535#,16#565#),
      (16#536#,16#536#,16#566#),(16#537#,16#537#,16#567#),(16#538#,16#538#,16#568#),
      (16#539#,16#539#,16#569#),(16#53A#,16#53A#,16#56A#),(16#53B#,16#53B#,16#56B#),
      (16#53C#,16#53C#,16#56C#),(16#53D#,16#53D#,16#56D#),(16#53E#,16#53E#,16#56E#),
      (16#53F#,16#53F#,16#56F#),(16#540#,16#540#,16#570#),(16#541#,16#541#,16#571#),
      (16#542#,16#542#,16#572#),(16#543#,16#543#,16#573#),(16#544#,16#544#,16#574#),
      (16#545#,16#545#,16#575#),(16#546#,16#546#,16#576#),(16#547#,16#547#,16#577#),
      (16#548#,16#548#,16#578#),(16#549#,16#549#,16#579#),(16#54A#,16#54A#,16#57A#),
      (16#54B#,16#54B#,16#57B#),(16#54C#,16#54C#,16#57C#),(16#54D#,16#54D#,16#57D#),
      (16#54E#,16#54E#,16#57E#),(16#54F#,16#54F#,16#57F#),(16#550#,16#550#,16#580#),
      (16#551#,16#551#,16#581#),(16#552#,16#552#,16#582#),(16#553#,16#553#,16#583#),
      (16#554#,16#554#,16#584#),(16#555#,16#555#,16#585#),(16#556#,16#556#,16#586#),
      (16#561#,16#531#,16#561#),(16#562#,16#532#,16#562#),(16#563#,16#533#,16#563#),
      (16#564#,16#534#,16#564#),(16#565#,16#535#,16#565#),(16#566#,16#536#,16#566#),
      (16#567#,16#537#,16#567#),(16#568#,16#538#,16#568#),(16#569#,16#539#,16#569#),
      (16#56A#,16#53A#,16#56A#),(16#56B#,16#53B#,16#56B#),(16#56C#,16#53C#,16#56C#),
      (16#56D#,16#53D#,16#56D#),(16#56E#,16#53E#,16#56E#),(16#56F#,16#53F#,16#56F#),
      (16#570#,16#540#,16#570#),(16#571#,16#541#,16#571#),(16#572#,16#542#,16#572#),
      (16#573#,16#543#,16#573#),(16#574#,16#544#,16#574#),(16#575#,16#545#,16#575#),
      (16#576#,16#546#,16#576#),(16#577#,16#547#,16#577#),(16#578#,16#548#,16#578#),
      (16#579#,16#549#,16#579#),(16#57A#,16#54A#,16#57A#),(16#57B#,16#54B#,16#57B#),
      (16#57C#,16#54C#,16#57C#),(16#57D#,16#54D#,16#57D#),(16#57E#,16#54E#,16#57E#),
      (16#57F#,16#54F#,16#57F#),(16#580#,16#550#,16#580#),(16#581#,16#551#,16#581#),
      (16#582#,16#552#,16#582#),(16#583#,16#553#,16#583#),(16#584#,16#554#,16#584#),
      (16#585#,16#555#,16#585#),(16#586#,16#556#,16#586#),(16#587#,16#587#,16#587#),
      (16#10A0#,16#10A0#,16#2D00#),(16#10A1#,16#10A1#,16#2D01#),(16#10A2#,16#10A2#,16#2D02#),
      (16#10A3#,16#10A3#,16#2D03#),(16#10A4#,16#10A4#,16#2D04#),(16#10A5#,16#10A5#,16#2D05#),
      (16#10A6#,16#10A6#,16#2D06#),(16#10A7#,16#10A7#,16#2D07#),(16#10A8#,16#10A8#,16#2D08#),
      (16#10A9#,16#10A9#,16#2D09#),(16#10AA#,16#10AA#,16#2D0A#),(16#10AB#,16#10AB#,16#2D0B#),
      (16#10AC#,16#10AC#,16#2D0C#),(16#10AD#,16#10AD#,16#2D0D#),(16#10AE#,16#10AE#,16#2D0E#),
      (16#10AF#,16#10AF#,16#2D0F#),(16#10B0#,16#10B0#,16#2D10#),(16#10B1#,16#10B1#,16#2D11#),
      (16#10B2#,16#10B2#,16#2D12#),(16#10B3#,16#10B3#,16#2D13#),(16#10B4#,16#10B4#,16#2D14#),
      (16#10B5#,16#10B5#,16#2D15#),(16#10B6#,16#10B6#,16#2D16#),(16#10B7#,16#10B7#,16#2D17#),
      (16#10B8#,16#10B8#,16#2D18#),(16#10B9#,16#10B9#,16#2D19#),(16#10BA#,16#10BA#,16#2D1A#),
      (16#10BB#,16#10BB#,16#2D1B#),(16#10BC#,16#10BC#,16#2D1C#),(16#10BD#,16#10BD#,16#2D1D#),
      (16#10BE#,16#10BE#,16#2D1E#),(16#10BF#,16#10BF#,16#2D1F#),(16#10C0#,16#10C0#,16#2D20#),
      (16#10C1#,16#10C1#,16#2D21#),(16#10C2#,16#10C2#,16#2D22#),(16#10C3#,16#10C3#,16#2D23#),
      (16#10C4#,16#10C4#,16#2D24#),(16#10C5#,16#10C5#,16#2D25#),(16#1D00#,16#1D00#,16#1D00#),
      (16#1D01#,16#1D01#,16#1D01#),(16#1D02#,16#1D02#,16#1D02#),(16#1D03#,16#1D03#,16#1D03#),
      (16#1D04#,16#1D04#,16#1D04#),(16#1D05#,16#1D05#,16#1D05#),(16#1D06#,16#1D06#,16#1D06#),
      (16#1D07#,16#1D07#,16#1D07#),(16#1D08#,16#1D08#,16#1D08#),(16#1D09#,16#1D09#,16#1D09#),
      (16#1D0A#,16#1D0A#,16#1D0A#),(16#1D0B#,16#1D0B#,16#1D0B#),(16#1D0C#,16#1D0C#,16#1D0C#),
      (16#1D0D#,16#1D0D#,16#1D0D#),(16#1D0E#,16#1D0E#,16#1D0E#),(16#1D0F#,16#1D0F#,16#1D0F#),
      (16#1D10#,16#1D10#,16#1D10#),(16#1D11#,16#1D11#,16#1D11#),(16#1D12#,16#1D12#,16#1D12#),
      (16#1D13#,16#1D13#,16#1D13#),(16#1D14#,16#1D14#,16#1D14#),(16#1D15#,16#1D15#,16#1D15#),
      (16#1D16#,16#1D16#,16#1D16#),(16#1D17#,16#1D17#,16#1D17#),(16#1D18#,16#1D18#,16#1D18#),
      (16#1D19#,16#1D19#,16#1D19#),(16#1D1A#,16#1D1A#,16#1D1A#),(16#1D1B#,16#1D1B#,16#1D1B#),
      (16#1D1C#,16#1D1C#,16#1D1C#),(16#1D1D#,16#1D1D#,16#1D1D#),(16#1D1E#,16#1D1E#,16#1D1E#),
      (16#1D1F#,16#1D1F#,16#1D1F#),(16#1D20#,16#1D20#,16#1D20#),(16#1D21#,16#1D21#,16#1D21#),
      (16#1D22#,16#1D22#,16#1D22#),(16#1D23#,16#1D23#,16#1D23#),(16#1D24#,16#1D24#,16#1D24#),
      (16#1D25#,16#1D25#,16#1D25#),(16#1D26#,16#1D26#,16#1D26#),(16#1D27#,16#1D27#,16#1D27#),
      (16#1D28#,16#1D28#,16#1D28#),(16#1D29#,16#1D29#,16#1D29#),(16#1D2A#,16#1D2A#,16#1D2A#),
      (16#1D2B#,16#1D2B#,16#1D2B#),(16#1D62#,16#1D62#,16#1D62#),(16#1D63#,16#1D63#,16#1D63#),
      (16#1D64#,16#1D64#,16#1D64#),(16#1D65#,16#1D65#,16#1D65#),(16#1D66#,16#1D66#,16#1D66#),
      (16#1D67#,16#1D67#,16#1D67#),(16#1D68#,16#1D68#,16#1D68#),(16#1D69#,16#1D69#,16#1D69#),
      (16#1D6A#,16#1D6A#,16#1D6A#),(16#1D6B#,16#1D6B#,16#1D6B#),(16#1D6C#,16#1D6C#,16#1D6C#),
      (16#1D6D#,16#1D6D#,16#1D6D#),(16#1D6E#,16#1D6E#,16#1D6E#),(16#1D6F#,16#1D6F#,16#1D6F#),
      (16#1D70#,16#1D70#,16#1D70#),(16#1D71#,16#1D71#,16#1D71#),(16#1D72#,16#1D72#,16#1D72#),
      (16#1D73#,16#1D73#,16#1D73#),(16#1D74#,16#1D74#,16#1D74#),(16#1D75#,16#1D75#,16#1D75#),
      (16#1D76#,16#1D76#,16#1D76#),(16#1D77#,16#1D77#,16#1D77#),(16#1D79#,16#1D79#,16#1D79#),
      (16#1D7A#,16#1D7A#,16#1D7A#),(16#1D7B#,16#1D7B#,16#1D7B#),(16#1D7C#,16#1D7C#,16#1D7C#),
      (16#1D7D#,16#2C63#,16#1D7D#),(16#1D7E#,16#1D7E#,16#1D7E#),(16#1D7F#,16#1D7F#,16#1D7F#),
      (16#1D80#,16#1D80#,16#1D80#),(16#1D81#,16#1D81#,16#1D81#),(16#1D82#,16#1D82#,16#1D82#),
      (16#1D83#,16#1D83#,16#1D83#),(16#1D84#,16#1D84#,16#1D84#),(16#1D85#,16#1D85#,16#1D85#),
      (16#1D86#,16#1D86#,16#1D86#),(16#1D87#,16#1D87#,16#1D87#),(16#1D88#,16#1D88#,16#1D88#),
      (16#1D89#,16#1D89#,16#1D89#),(16#1D8A#,16#1D8A#,16#1D8A#),(16#1D8B#,16#1D8B#,16#1D8B#),
      (16#1D8C#,16#1D8C#,16#1D8C#),(16#1D8D#,16#1D8D#,16#1D8D#),(16#1D8E#,16#1D8E#,16#1D8E#),
      (16#1D8F#,16#1D8F#,16#1D8F#),(16#1D90#,16#1D90#,16#1D90#),(16#1D91#,16#1D91#,16#1D91#),
      (16#1D92#,16#1D92#,16#1D92#),(16#1D93#,16#1D93#,16#1D93#),(16#1D94#,16#1D94#,16#1D94#),
      (16#1D95#,16#1D95#,16#1D95#),(16#1D96#,16#1D96#,16#1D96#),(16#1D97#,16#1D97#,16#1D97#),
      (16#1D98#,16#1D98#,16#1D98#),(16#1D99#,16#1D99#,16#1D99#),(16#1D9A#,16#1D9A#,16#1D9A#),
      (16#1E00#,16#1E00#,16#1E01#),(16#1E01#,16#1E00#,16#1E01#),(16#1E02#,16#1E02#,16#1E03#),
      (16#1E03#,16#1E02#,16#1E03#),(16#1E04#,16#1E04#,16#1E05#),(16#1E05#,16#1E04#,16#1E05#),
      (16#1E06#,16#1E06#,16#1E07#),(16#1E07#,16#1E06#,16#1E07#),(16#1E08#,16#1E08#,16#1E09#),
      (16#1E09#,16#1E08#,16#1E09#),(16#1E0A#,16#1E0A#,16#1E0B#),(16#1E0B#,16#1E0A#,16#1E0B#),
      (16#1E0C#,16#1E0C#,16#1E0D#),(16#1E0D#,16#1E0C#,16#1E0D#),(16#1E0E#,16#1E0E#,16#1E0F#),
      (16#1E0F#,16#1E0E#,16#1E0F#),(16#1E10#,16#1E10#,16#1E11#),(16#1E11#,16#1E10#,16#1E11#),
      (16#1E12#,16#1E12#,16#1E13#),(16#1E13#,16#1E12#,16#1E13#),(16#1E14#,16#1E14#,16#1E15#),
      (16#1E15#,16#1E14#,16#1E15#),(16#1E16#,16#1E16#,16#1E17#),(16#1E17#,16#1E16#,16#1E17#),
      (16#1E18#,16#1E18#,16#1E19#),(16#1E19#,16#1E18#,16#1E19#),(16#1E1A#,16#1E1A#,16#1E1B#),
      (16#1E1B#,16#1E1A#,16#1E1B#),(16#1E1C#,16#1E1C#,16#1E1D#),(16#1E1D#,16#1E1C#,16#1E1D#),
      (16#1E1E#,16#1E1E#,16#1E1F#),(16#1E1F#,16#1E1E#,16#1E1F#),(16#1E20#,16#1E20#,16#1E21#),
      (16#1E21#,16#1E20#,16#1E21#),(16#1E22#,16#1E22#,16#1E23#),(16#1E23#,16#1E22#,16#1E23#),
      (16#1E24#,16#1E24#,16#1E25#),(16#1E25#,16#1E24#,16#1E25#),(16#1E26#,16#1E26#,16#1E27#),
      (16#1E27#,16#1E26#,16#1E27#),(16#1E28#,16#1E28#,16#1E29#),(16#1E29#,16#1E28#,16#1E29#),
      (16#1E2A#,16#1E2A#,16#1E2B#),(16#1E2B#,16#1E2A#,16#1E2B#),(16#1E2C#,16#1E2C#,16#1E2D#),
      (16#1E2D#,16#1E2C#,16#1E2D#),(16#1E2E#,16#1E2E#,16#1E2F#),(16#1E2F#,16#1E2E#,16#1E2F#),
      (16#1E30#,16#1E30#,16#1E31#),(16#1E31#,16#1E30#,16#1E31#),(16#1E32#,16#1E32#,16#1E33#),
      (16#1E33#,16#1E32#,16#1E33#),(16#1E34#,16#1E34#,16#1E35#),(16#1E35#,16#1E34#,16#1E35#),
      (16#1E36#,16#1E36#,16#1E37#),(16#1E37#,16#1E36#,16#1E37#),(16#1E38#,16#1E38#,16#1E39#),
      (16#1E39#,16#1E38#,16#1E39#),(16#1E3A#,16#1E3A#,16#1E3B#),(16#1E3B#,16#1E3A#,16#1E3B#),
      (16#1E3C#,16#1E3C#,16#1E3D#),(16#1E3D#,16#1E3C#,16#1E3D#),(16#1E3E#,16#1E3E#,16#1E3F#),
      (16#1E3F#,16#1E3E#,16#1E3F#),(16#1E40#,16#1E40#,16#1E41#),(16#1E41#,16#1E40#,16#1E41#),
      (16#1E42#,16#1E42#,16#1E43#),(16#1E43#,16#1E42#,16#1E43#),(16#1E44#,16#1E44#,16#1E45#),
      (16#1E45#,16#1E44#,16#1E45#),(16#1E46#,16#1E46#,16#1E47#),(16#1E47#,16#1E46#,16#1E47#),
      (16#1E48#,16#1E48#,16#1E49#),(16#1E49#,16#1E48#,16#1E49#),(16#1E4A#,16#1E4A#,16#1E4B#),
      (16#1E4B#,16#1E4A#,16#1E4B#),(16#1E4C#,16#1E4C#,16#1E4D#),(16#1E4D#,16#1E4C#,16#1E4D#),
      (16#1E4E#,16#1E4E#,16#1E4F#),(16#1E4F#,16#1E4E#,16#1E4F#),(16#1E50#,16#1E50#,16#1E51#),
      (16#1E51#,16#1E50#,16#1E51#),(16#1E52#,16#1E52#,16#1E53#),(16#1E53#,16#1E52#,16#1E53#),
      (16#1E54#,16#1E54#,16#1E55#),(16#1E55#,16#1E54#,16#1E55#),(16#1E56#,16#1E56#,16#1E57#),
      (16#1E57#,16#1E56#,16#1E57#),(16#1E58#,16#1E58#,16#1E59#),(16#1E59#,16#1E58#,16#1E59#),
      (16#1E5A#,16#1E5A#,16#1E5B#),(16#1E5B#,16#1E5A#,16#1E5B#),(16#1E5C#,16#1E5C#,16#1E5D#),
      (16#1E5D#,16#1E5C#,16#1E5D#),(16#1E5E#,16#1E5E#,16#1E5F#),(16#1E5F#,16#1E5E#,16#1E5F#),
      (16#1E60#,16#1E60#,16#1E61#),(16#1E61#,16#1E60#,16#1E61#),(16#1E62#,16#1E62#,16#1E63#),
      (16#1E63#,16#1E62#,16#1E63#),(16#1E64#,16#1E64#,16#1E65#),(16#1E65#,16#1E64#,16#1E65#),
      (16#1E66#,16#1E66#,16#1E67#),(16#1E67#,16#1E66#,16#1E67#),(16#1E68#,16#1E68#,16#1E69#),
      (16#1E69#,16#1E68#,16#1E69#),(16#1E6A#,16#1E6A#,16#1E6B#),(16#1E6B#,16#1E6A#,16#1E6B#),
      (16#1E6C#,16#1E6C#,16#1E6D#),(16#1E6D#,16#1E6C#,16#1E6D#),(16#1E6E#,16#1E6E#,16#1E6F#),
      (16#1E6F#,16#1E6E#,16#1E6F#),(16#1E70#,16#1E70#,16#1E71#),(16#1E71#,16#1E70#,16#1E71#),
      (16#1E72#,16#1E72#,16#1E73#),(16#1E73#,16#1E72#,16#1E73#),(16#1E74#,16#1E74#,16#1E75#),
      (16#1E75#,16#1E74#,16#1E75#),(16#1E76#,16#1E76#,16#1E77#),(16#1E77#,16#1E76#,16#1E77#),
      (16#1E78#,16#1E78#,16#1E79#),(16#1E79#,16#1E78#,16#1E79#),(16#1E7A#,16#1E7A#,16#1E7B#),
      (16#1E7B#,16#1E7A#,16#1E7B#),(16#1E7C#,16#1E7C#,16#1E7D#),(16#1E7D#,16#1E7C#,16#1E7D#),
      (16#1E7E#,16#1E7E#,16#1E7F#),(16#1E7F#,16#1E7E#,16#1E7F#),(16#1E80#,16#1E80#,16#1E81#),
      (16#1E81#,16#1E80#,16#1E81#),(16#1E82#,16#1E82#,16#1E83#),(16#1E83#,16#1E82#,16#1E83#),
      (16#1E84#,16#1E84#,16#1E85#),(16#1E85#,16#1E84#,16#1E85#),(16#1E86#,16#1E86#,16#1E87#),
      (16#1E87#,16#1E86#,16#1E87#),(16#1E88#,16#1E88#,16#1E89#),(16#1E89#,16#1E88#,16#1E89#),
      (16#1E8A#,16#1E8A#,16#1E8B#),(16#1E8B#,16#1E8A#,16#1E8B#),(16#1E8C#,16#1E8C#,16#1E8D#),
      (16#1E8D#,16#1E8C#,16#1E8D#),(16#1E8E#,16#1E8E#,16#1E8F#),(16#1E8F#,16#1E8E#,16#1E8F#),
      (16#1E90#,16#1E90#,16#1E91#),(16#1E91#,16#1E90#,16#1E91#),(16#1E92#,16#1E92#,16#1E93#),
      (16#1E93#,16#1E92#,16#1E93#),(16#1E94#,16#1E94#,16#1E95#),(16#1E95#,16#1E94#,16#1E95#),
      (16#1E96#,16#1E96#,16#1E96#),(16#1E97#,16#1E97#,16#1E97#),(16#1E98#,16#1E98#,16#1E98#),
      (16#1E99#,16#1E99#,16#1E99#),(16#1E9A#,16#1E9A#,16#1E9A#),(16#1E9B#,16#1E60#,16#1E9B#),
      (16#1EA0#,16#1EA0#,16#1EA1#),(16#1EA1#,16#1EA0#,16#1EA1#),(16#1EA2#,16#1EA2#,16#1EA3#),
      (16#1EA3#,16#1EA2#,16#1EA3#),(16#1EA4#,16#1EA4#,16#1EA5#),(16#1EA5#,16#1EA4#,16#1EA5#),
      (16#1EA6#,16#1EA6#,16#1EA7#),(16#1EA7#,16#1EA6#,16#1EA7#),(16#1EA8#,16#1EA8#,16#1EA9#),
      (16#1EA9#,16#1EA8#,16#1EA9#),(16#1EAA#,16#1EAA#,16#1EAB#),(16#1EAB#,16#1EAA#,16#1EAB#),
      (16#1EAC#,16#1EAC#,16#1EAD#),(16#1EAD#,16#1EAC#,16#1EAD#),(16#1EAE#,16#1EAE#,16#1EAF#),
      (16#1EAF#,16#1EAE#,16#1EAF#),(16#1EB0#,16#1EB0#,16#1EB1#),(16#1EB1#,16#1EB0#,16#1EB1#),
      (16#1EB2#,16#1EB2#,16#1EB3#),(16#1EB3#,16#1EB2#,16#1EB3#),(16#1EB4#,16#1EB4#,16#1EB5#),
      (16#1EB5#,16#1EB4#,16#1EB5#),(16#1EB6#,16#1EB6#,16#1EB7#),(16#1EB7#,16#1EB6#,16#1EB7#),
      (16#1EB8#,16#1EB8#,16#1EB9#),(16#1EB9#,16#1EB8#,16#1EB9#),(16#1EBA#,16#1EBA#,16#1EBB#),
      (16#1EBB#,16#1EBA#,16#1EBB#),(16#1EBC#,16#1EBC#,16#1EBD#),(16#1EBD#,16#1EBC#,16#1EBD#),
      (16#1EBE#,16#1EBE#,16#1EBF#),(16#1EBF#,16#1EBE#,16#1EBF#),(16#1EC0#,16#1EC0#,16#1EC1#),
      (16#1EC1#,16#1EC0#,16#1EC1#),(16#1EC2#,16#1EC2#,16#1EC3#),(16#1EC3#,16#1EC2#,16#1EC3#),
      (16#1EC4#,16#1EC4#,16#1EC5#),(16#1EC5#,16#1EC4#,16#1EC5#),(16#1EC6#,16#1EC6#,16#1EC7#),
      (16#1EC7#,16#1EC6#,16#1EC7#),(16#1EC8#,16#1EC8#,16#1EC9#),(16#1EC9#,16#1EC8#,16#1EC9#),
      (16#1ECA#,16#1ECA#,16#1ECB#),(16#1ECB#,16#1ECA#,16#1ECB#),(16#1ECC#,16#1ECC#,16#1ECD#),
      (16#1ECD#,16#1ECC#,16#1ECD#),(16#1ECE#,16#1ECE#,16#1ECF#),(16#1ECF#,16#1ECE#,16#1ECF#),
      (16#1ED0#,16#1ED0#,16#1ED1#),(16#1ED1#,16#1ED0#,16#1ED1#),(16#1ED2#,16#1ED2#,16#1ED3#),
      (16#1ED3#,16#1ED2#,16#1ED3#),(16#1ED4#,16#1ED4#,16#1ED5#),(16#1ED5#,16#1ED4#,16#1ED5#),
      (16#1ED6#,16#1ED6#,16#1ED7#),(16#1ED7#,16#1ED6#,16#1ED7#),(16#1ED8#,16#1ED8#,16#1ED9#),
      (16#1ED9#,16#1ED8#,16#1ED9#),(16#1EDA#,16#1EDA#,16#1EDB#),(16#1EDB#,16#1EDA#,16#1EDB#),
      (16#1EDC#,16#1EDC#,16#1EDD#),(16#1EDD#,16#1EDC#,16#1EDD#),(16#1EDE#,16#1EDE#,16#1EDF#),
      (16#1EDF#,16#1EDE#,16#1EDF#),(16#1EE0#,16#1EE0#,16#1EE1#),(16#1EE1#,16#1EE0#,16#1EE1#),
      (16#1EE2#,16#1EE2#,16#1EE3#),(16#1EE3#,16#1EE2#,16#1EE3#),(16#1EE4#,16#1EE4#,16#1EE5#),
      (16#1EE5#,16#1EE4#,16#1EE5#),(16#1EE6#,16#1EE6#,16#1EE7#),(16#1EE7#,16#1EE6#,16#1EE7#),
      (16#1EE8#,16#1EE8#,16#1EE9#),(16#1EE9#,16#1EE8#,16#1EE9#),(16#1EEA#,16#1EEA#,16#1EEB#),
      (16#1EEB#,16#1EEA#,16#1EEB#),(16#1EEC#,16#1EEC#,16#1EED#),(16#1EED#,16#1EEC#,16#1EED#),
      (16#1EEE#,16#1EEE#,16#1EEF#),(16#1EEF#,16#1EEE#,16#1EEF#),(16#1EF0#,16#1EF0#,16#1EF1#),
      (16#1EF1#,16#1EF0#,16#1EF1#),(16#1EF2#,16#1EF2#,16#1EF3#),(16#1EF3#,16#1EF2#,16#1EF3#),
      (16#1EF4#,16#1EF4#,16#1EF5#),(16#1EF5#,16#1EF4#,16#1EF5#),(16#1EF6#,16#1EF6#,16#1EF7#),
      (16#1EF7#,16#1EF6#,16#1EF7#),(16#1EF8#,16#1EF8#,16#1EF9#),(16#1EF9#,16#1EF8#,16#1EF9#),
      (16#1F00#,16#1F08#,16#1F00#),(16#1F01#,16#1F09#,16#1F01#),(16#1F02#,16#1F0A#,16#1F02#),
      (16#1F03#,16#1F0B#,16#1F03#),(16#1F04#,16#1F0C#,16#1F04#),(16#1F05#,16#1F0D#,16#1F05#),
      (16#1F06#,16#1F0E#,16#1F06#),(16#1F07#,16#1F0F#,16#1F07#),(16#1F08#,16#1F08#,16#1F00#),
      (16#1F09#,16#1F09#,16#1F01#),(16#1F0A#,16#1F0A#,16#1F02#),(16#1F0B#,16#1F0B#,16#1F03#),
      (16#1F0C#,16#1F0C#,16#1F04#),(16#1F0D#,16#1F0D#,16#1F05#),(16#1F0E#,16#1F0E#,16#1F06#),
      (16#1F0F#,16#1F0F#,16#1F07#),(16#1F10#,16#1F18#,16#1F10#),(16#1F11#,16#1F19#,16#1F11#),
      (16#1F12#,16#1F1A#,16#1F12#),(16#1F13#,16#1F1B#,16#1F13#),(16#1F14#,16#1F1C#,16#1F14#),
      (16#1F15#,16#1F1D#,16#1F15#),(16#1F18#,16#1F18#,16#1F10#),(16#1F19#,16#1F19#,16#1F11#),
      (16#1F1A#,16#1F1A#,16#1F12#),(16#1F1B#,16#1F1B#,16#1F13#),(16#1F1C#,16#1F1C#,16#1F14#),
      (16#1F1D#,16#1F1D#,16#1F15#),(16#1F20#,16#1F28#,16#1F20#),(16#1F21#,16#1F29#,16#1F21#),
      (16#1F22#,16#1F2A#,16#1F22#),(16#1F23#,16#1F2B#,16#1F23#),(16#1F24#,16#1F2C#,16#1F24#),
      (16#1F25#,16#1F2D#,16#1F25#),(16#1F26#,16#1F2E#,16#1F26#),(16#1F27#,16#1F2F#,16#1F27#),
      (16#1F28#,16#1F28#,16#1F20#),(16#1F29#,16#1F29#,16#1F21#),(16#1F2A#,16#1F2A#,16#1F22#),
      (16#1F2B#,16#1F2B#,16#1F23#),(16#1F2C#,16#1F2C#,16#1F24#),(16#1F2D#,16#1F2D#,16#1F25#),
      (16#1F2E#,16#1F2E#,16#1F26#),(16#1F2F#,16#1F2F#,16#1F27#),(16#1F30#,16#1F38#,16#1F30#),
      (16#1F31#,16#1F39#,16#1F31#),(16#1F32#,16#1F3A#,16#1F32#),(16#1F33#,16#1F3B#,16#1F33#),
      (16#1F34#,16#1F3C#,16#1F34#),(16#1F35#,16#1F3D#,16#1F35#),(16#1F36#,16#1F3E#,16#1F36#),
      (16#1F37#,16#1F3F#,16#1F37#),(16#1F38#,16#1F38#,16#1F30#),(16#1F39#,16#1F39#,16#1F31#),
      (16#1F3A#,16#1F3A#,16#1F32#),(16#1F3B#,16#1F3B#,16#1F33#),(16#1F3C#,16#1F3C#,16#1F34#),
      (16#1F3D#,16#1F3D#,16#1F35#),(16#1F3E#,16#1F3E#,16#1F36#),(16#1F3F#,16#1F3F#,16#1F37#),
      (16#1F40#,16#1F48#,16#1F40#),(16#1F41#,16#1F49#,16#1F41#),(16#1F42#,16#1F4A#,16#1F42#),
      (16#1F43#,16#1F4B#,16#1F43#),(16#1F44#,16#1F4C#,16#1F44#),(16#1F45#,16#1F4D#,16#1F45#),
      (16#1F48#,16#1F48#,16#1F40#),(16#1F49#,16#1F49#,16#1F41#),(16#1F4A#,16#1F4A#,16#1F42#),
      (16#1F4B#,16#1F4B#,16#1F43#),(16#1F4C#,16#1F4C#,16#1F44#),(16#1F4D#,16#1F4D#,16#1F45#),
      (16#1F50#,16#1F50#,16#1F50#),(16#1F51#,16#1F59#,16#1F51#),(16#1F52#,16#1F52#,16#1F52#),
      (16#1F53#,16#1F5B#,16#1F53#),(16#1F54#,16#1F54#,16#1F54#),(16#1F55#,16#1F5D#,16#1F55#),
      (16#1F56#,16#1F56#,16#1F56#),(16#1F57#,16#1F5F#,16#1F57#),(16#1F59#,16#1F59#,16#1F51#),
      (16#1F5B#,16#1F5B#,16#1F53#),(16#1F5D#,16#1F5D#,16#1F55#),(16#1F5F#,16#1F5F#,16#1F57#),
      (16#1F60#,16#1F68#,16#1F60#),(16#1F61#,16#1F69#,16#1F61#),(16#1F62#,16#1F6A#,16#1F62#),
      (16#1F63#,16#1F6B#,16#1F63#),(16#1F64#,16#1F6C#,16#1F64#),(16#1F65#,16#1F6D#,16#1F65#),
      (16#1F66#,16#1F6E#,16#1F66#),(16#1F67#,16#1F6F#,16#1F67#),(16#1F68#,16#1F68#,16#1F60#),
      (16#1F69#,16#1F69#,16#1F61#),(16#1F6A#,16#1F6A#,16#1F62#),(16#1F6B#,16#1F6B#,16#1F63#),
      (16#1F6C#,16#1F6C#,16#1F64#),(16#1F6D#,16#1F6D#,16#1F65#),(16#1F6E#,16#1F6E#,16#1F66#),
      (16#1F6F#,16#1F6F#,16#1F67#),(16#1F70#,16#1FBA#,16#1F70#),(16#1F71#,16#1FBB#,16#1F71#),
      (16#1F72#,16#1FC8#,16#1F72#),(16#1F73#,16#1FC9#,16#1F73#),(16#1F74#,16#1FCA#,16#1F74#),
      (16#1F75#,16#1FCB#,16#1F75#),(16#1F76#,16#1FDA#,16#1F76#),(16#1F77#,16#1FDB#,16#1F77#),
      (16#1F78#,16#1FF8#,16#1F78#),(16#1F79#,16#1FF9#,16#1F79#),(16#1F7A#,16#1FEA#,16#1F7A#),
      (16#1F7B#,16#1FEB#,16#1F7B#),(16#1F7C#,16#1FFA#,16#1F7C#),(16#1F7D#,16#1FFB#,16#1F7D#),
      (16#1F80#,16#1F88#,16#1F80#),(16#1F81#,16#1F89#,16#1F81#),(16#1F82#,16#1F8A#,16#1F82#),
      (16#1F83#,16#1F8B#,16#1F83#),(16#1F84#,16#1F8C#,16#1F84#),(16#1F85#,16#1F8D#,16#1F85#),
      (16#1F86#,16#1F8E#,16#1F86#),(16#1F87#,16#1F8F#,16#1F87#),(16#1F88#,16#1F88#,16#1F80#),
      (16#1F89#,16#1F89#,16#1F81#),(16#1F8A#,16#1F8A#,16#1F82#),(16#1F8B#,16#1F8B#,16#1F83#),
      (16#1F8C#,16#1F8C#,16#1F84#),(16#1F8D#,16#1F8D#,16#1F85#),(16#1F8E#,16#1F8E#,16#1F86#),
      (16#1F8F#,16#1F8F#,16#1F87#),(16#1F90#,16#1F98#,16#1F90#),(16#1F91#,16#1F99#,16#1F91#),
      (16#1F92#,16#1F9A#,16#1F92#),(16#1F93#,16#1F9B#,16#1F93#),(16#1F94#,16#1F9C#,16#1F94#),
      (16#1F95#,16#1F9D#,16#1F95#),(16#1F96#,16#1F9E#,16#1F96#),(16#1F97#,16#1F9F#,16#1F97#),
      (16#1F98#,16#1F98#,16#1F90#),(16#1F99#,16#1F99#,16#1F91#),(16#1F9A#,16#1F9A#,16#1F92#),
      (16#1F9B#,16#1F9B#,16#1F93#),(16#1F9C#,16#1F9C#,16#1F94#),(16#1F9D#,16#1F9D#,16#1F95#),
      (16#1F9E#,16#1F9E#,16#1F96#),(16#1F9F#,16#1F9F#,16#1F97#),(16#1FA0#,16#1FA8#,16#1FA0#),
      (16#1FA1#,16#1FA9#,16#1FA1#),(16#1FA2#,16#1FAA#,16#1FA2#),(16#1FA3#,16#1FAB#,16#1FA3#),
      (16#1FA4#,16#1FAC#,16#1FA4#),(16#1FA5#,16#1FAD#,16#1FA5#),(16#1FA6#,16#1FAE#,16#1FA6#),
      (16#1FA7#,16#1FAF#,16#1FA7#),(16#1FA8#,16#1FA8#,16#1FA0#),(16#1FA9#,16#1FA9#,16#1FA1#),
      (16#1FAA#,16#1FAA#,16#1FA2#),(16#1FAB#,16#1FAB#,16#1FA3#),(16#1FAC#,16#1FAC#,16#1FA4#),
      (16#1FAD#,16#1FAD#,16#1FA5#),(16#1FAE#,16#1FAE#,16#1FA6#),(16#1FAF#,16#1FAF#,16#1FA7#),
      (16#1FB0#,16#1FB8#,16#1FB0#),(16#1FB1#,16#1FB9#,16#1FB1#),(16#1FB2#,16#1FB2#,16#1FB2#),
      (16#1FB3#,16#1FBC#,16#1FB3#),(16#1FB4#,16#1FB4#,16#1FB4#),(16#1FB6#,16#1FB6#,16#1FB6#),
      (16#1FB7#,16#1FB7#,16#1FB7#),(16#1FB8#,16#1FB8#,16#1FB0#),(16#1FB9#,16#1FB9#,16#1FB1#),
      (16#1FBA#,16#1FBA#,16#1F70#),(16#1FBB#,16#1FBB#,16#1F71#),(16#1FBC#,16#1FBC#,16#1FB3#),
      (16#1FBE#,16#399#,16#1FBE#),(16#1FC2#,16#1FC2#,16#1FC2#),(16#1FC3#,16#1FCC#,16#1FC3#),
      (16#1FC4#,16#1FC4#,16#1FC4#),(16#1FC6#,16#1FC6#,16#1FC6#),(16#1FC7#,16#1FC7#,16#1FC7#),
      (16#1FC8#,16#1FC8#,16#1F72#),(16#1FC9#,16#1FC9#,16#1F73#),(16#1FCA#,16#1FCA#,16#1F74#),
      (16#1FCB#,16#1FCB#,16#1F75#),(16#1FCC#,16#1FCC#,16#1FC3#),(16#1FD0#,16#1FD8#,16#1FD0#),
      (16#1FD1#,16#1FD9#,16#1FD1#),(16#1FD2#,16#1FD2#,16#1FD2#),(16#1FD3#,16#1FD3#,16#1FD3#),
      (16#1FD6#,16#1FD6#,16#1FD6#),(16#1FD7#,16#1FD7#,16#1FD7#),(16#1FD8#,16#1FD8#,16#1FD0#),
      (16#1FD9#,16#1FD9#,16#1FD1#),(16#1FDA#,16#1FDA#,16#1F76#),(16#1FDB#,16#1FDB#,16#1F77#),
      (16#1FE0#,16#1FE8#,16#1FE0#),(16#1FE1#,16#1FE9#,16#1FE1#),(16#1FE2#,16#1FE2#,16#1FE2#),
      (16#1FE3#,16#1FE3#,16#1FE3#),(16#1FE4#,16#1FE4#,16#1FE4#),(16#1FE5#,16#1FEC#,16#1FE5#),
      (16#1FE6#,16#1FE6#,16#1FE6#),(16#1FE7#,16#1FE7#,16#1FE7#),(16#1FE8#,16#1FE8#,16#1FE0#),
      (16#1FE9#,16#1FE9#,16#1FE1#),(16#1FEA#,16#1FEA#,16#1F7A#),(16#1FEB#,16#1FEB#,16#1F7B#),
      (16#1FEC#,16#1FEC#,16#1FE5#),(16#1FF2#,16#1FF2#,16#1FF2#),(16#1FF3#,16#1FFC#,16#1FF3#),
      (16#1FF4#,16#1FF4#,16#1FF4#),(16#1FF6#,16#1FF6#,16#1FF6#),(16#1FF7#,16#1FF7#,16#1FF7#),
      (16#1FF8#,16#1FF8#,16#1F78#),(16#1FF9#,16#1FF9#,16#1F79#),(16#1FFA#,16#1FFA#,16#1F7C#),
      (16#1FFB#,16#1FFB#,16#1F7D#),(16#1FFC#,16#1FFC#,16#1FF3#),(16#2071#,16#2071#,16#2071#),
      (16#207F#,16#207F#,16#207F#),(16#2102#,16#2102#,16#2102#),(16#2107#,16#2107#,16#2107#),
      (16#210A#,16#210A#,16#210A#),(16#210B#,16#210B#,16#210B#),(16#210C#,16#210C#,16#210C#),
      (16#210D#,16#210D#,16#210D#),(16#210E#,16#210E#,16#210E#),(16#210F#,16#210F#,16#210F#),
      (16#2110#,16#2110#,16#2110#),(16#2111#,16#2111#,16#2111#),(16#2112#,16#2112#,16#2112#),
      (16#2113#,16#2113#,16#2113#),(16#2115#,16#2115#,16#2115#),(16#2119#,16#2119#,16#2119#),
      (16#211A#,16#211A#,16#211A#),(16#211B#,16#211B#,16#211B#),(16#211C#,16#211C#,16#211C#),
      (16#211D#,16#211D#,16#211D#),(16#2124#,16#2124#,16#2124#),(16#2126#,16#2126#,16#3C9#),
      (16#2128#,16#2128#,16#2128#),(16#212A#,16#212A#,16#6B#),(16#212B#,16#212B#,16#E5#),
      (16#212C#,16#212C#,16#212C#),(16#212D#,16#212D#,16#212D#),(16#212F#,16#212F#,16#212F#),
      (16#2130#,16#2130#,16#2130#),(16#2131#,16#2131#,16#2131#),(16#2132#,16#2132#,16#214E#),
      (16#2133#,16#2133#,16#2133#),(16#2134#,16#2134#,16#2134#),(16#2139#,16#2139#,16#2139#),
      (16#213C#,16#213C#,16#213C#),(16#213D#,16#213D#,16#213D#),(16#213E#,16#213E#,16#213E#),
      (16#213F#,16#213F#,16#213F#),(16#2145#,16#2145#,16#2145#),(16#2146#,16#2146#,16#2146#),
      (16#2147#,16#2147#,16#2147#),(16#2148#,16#2148#,16#2148#),(16#2149#,16#2149#,16#2149#),
      (16#214E#,16#2132#,16#214E#),(16#2160#,16#2160#,16#2170#),(16#2161#,16#2161#,16#2171#),
      (16#2162#,16#2162#,16#2172#),(16#2163#,16#2163#,16#2173#),(16#2164#,16#2164#,16#2174#),
      (16#2165#,16#2165#,16#2175#),(16#2166#,16#2166#,16#2176#),(16#2167#,16#2167#,16#2177#),
      (16#2168#,16#2168#,16#2178#),(16#2169#,16#2169#,16#2179#),(16#216A#,16#216A#,16#217A#),
      (16#216B#,16#216B#,16#217B#),(16#216C#,16#216C#,16#217C#),(16#216D#,16#216D#,16#217D#),
      (16#216E#,16#216E#,16#217E#),(16#216F#,16#216F#,16#217F#),(16#2170#,16#2160#,16#2170#),
      (16#2171#,16#2161#,16#2171#),(16#2172#,16#2162#,16#2172#),(16#2173#,16#2163#,16#2173#),
      (16#2174#,16#2164#,16#2174#),(16#2175#,16#2165#,16#2175#),(16#2176#,16#2166#,16#2176#),
      (16#2177#,16#2167#,16#2177#),(16#2178#,16#2168#,16#2178#),(16#2179#,16#2169#,16#2179#),
      (16#217A#,16#216A#,16#217A#),(16#217B#,16#216B#,16#217B#),(16#217C#,16#216C#,16#217C#),
      (16#217D#,16#216D#,16#217D#),(16#217E#,16#216E#,16#217E#),(16#217F#,16#216F#,16#217F#),
      (16#2183#,16#2183#,16#2184#),(16#2184#,16#2183#,16#2184#),(16#24B6#,16#24B6#,16#24D0#),
      (16#24B7#,16#24B7#,16#24D1#),(16#24B8#,16#24B8#,16#24D2#),(16#24B9#,16#24B9#,16#24D3#),
      (16#24BA#,16#24BA#,16#24D4#),(16#24BB#,16#24BB#,16#24D5#),(16#24BC#,16#24BC#,16#24D6#),
      (16#24BD#,16#24BD#,16#24D7#),(16#24BE#,16#24BE#,16#24D8#),(16#24BF#,16#24BF#,16#24D9#),
      (16#24C0#,16#24C0#,16#24DA#),(16#24C1#,16#24C1#,16#24DB#),(16#24C2#,16#24C2#,16#24DC#),
      (16#24C3#,16#24C3#,16#24DD#),(16#24C4#,16#24C4#,16#24DE#),(16#24C5#,16#24C5#,16#24DF#),
      (16#24C6#,16#24C6#,16#24E0#),(16#24C7#,16#24C7#,16#24E1#),(16#24C8#,16#24C8#,16#24E2#),
      (16#24C9#,16#24C9#,16#24E3#),(16#24CA#,16#24CA#,16#24E4#),(16#24CB#,16#24CB#,16#24E5#),
      (16#24CC#,16#24CC#,16#24E6#),(16#24CD#,16#24CD#,16#24E7#),(16#24CE#,16#24CE#,16#24E8#),
      (16#24CF#,16#24CF#,16#24E9#),(16#24D0#,16#24B6#,16#24D0#),(16#24D1#,16#24B7#,16#24D1#),
      (16#24D2#,16#24B8#,16#24D2#),(16#24D3#,16#24B9#,16#24D3#),(16#24D4#,16#24BA#,16#24D4#),
      (16#24D5#,16#24BB#,16#24D5#),(16#24D6#,16#24BC#,16#24D6#),(16#24D7#,16#24BD#,16#24D7#),
      (16#24D8#,16#24BE#,16#24D8#),(16#24D9#,16#24BF#,16#24D9#),(16#24DA#,16#24C0#,16#24DA#),
      (16#24DB#,16#24C1#,16#24DB#),(16#24DC#,16#24C2#,16#24DC#),(16#24DD#,16#24C3#,16#24DD#),
      (16#24DE#,16#24C4#,16#24DE#),(16#24DF#,16#24C5#,16#24DF#),(16#24E0#,16#24C6#,16#24E0#),
      (16#24E1#,16#24C7#,16#24E1#),(16#24E2#,16#24C8#,16#24E2#),(16#24E3#,16#24C9#,16#24E3#),
      (16#24E4#,16#24CA#,16#24E4#),(16#24E5#,16#24CB#,16#24E5#),(16#24E6#,16#24CC#,16#24E6#),
      (16#24E7#,16#24CD#,16#24E7#),(16#24E8#,16#24CE#,16#24E8#),(16#24E9#,16#24CF#,16#24E9#),
      (16#2C00#,16#2C00#,16#2C30#),(16#2C01#,16#2C01#,16#2C31#),(16#2C02#,16#2C02#,16#2C32#),
      (16#2C03#,16#2C03#,16#2C33#),(16#2C04#,16#2C04#,16#2C34#),(16#2C05#,16#2C05#,16#2C35#),
      (16#2C06#,16#2C06#,16#2C36#),(16#2C07#,16#2C07#,16#2C37#),(16#2C08#,16#2C08#,16#2C38#),
      (16#2C09#,16#2C09#,16#2C39#),(16#2C0A#,16#2C0A#,16#2C3A#),(16#2C0B#,16#2C0B#,16#2C3B#),
      (16#2C0C#,16#2C0C#,16#2C3C#),(16#2C0D#,16#2C0D#,16#2C3D#),(16#2C0E#,16#2C0E#,16#2C3E#),
      (16#2C0F#,16#2C0F#,16#2C3F#),(16#2C10#,16#2C10#,16#2C40#),(16#2C11#,16#2C11#,16#2C41#),
      (16#2C12#,16#2C12#,16#2C42#),(16#2C13#,16#2C13#,16#2C43#),(16#2C14#,16#2C14#,16#2C44#),
      (16#2C15#,16#2C15#,16#2C45#),(16#2C16#,16#2C16#,16#2C46#),(16#2C17#,16#2C17#,16#2C47#),
      (16#2C18#,16#2C18#,16#2C48#),(16#2C19#,16#2C19#,16#2C49#),(16#2C1A#,16#2C1A#,16#2C4A#),
      (16#2C1B#,16#2C1B#,16#2C4B#),(16#2C1C#,16#2C1C#,16#2C4C#),(16#2C1D#,16#2C1D#,16#2C4D#),
      (16#2C1E#,16#2C1E#,16#2C4E#),(16#2C1F#,16#2C1F#,16#2C4F#),(16#2C20#,16#2C20#,16#2C50#),
      (16#2C21#,16#2C21#,16#2C51#),(16#2C22#,16#2C22#,16#2C52#),(16#2C23#,16#2C23#,16#2C53#),
      (16#2C24#,16#2C24#,16#2C54#),(16#2C25#,16#2C25#,16#2C55#),(16#2C26#,16#2C26#,16#2C56#),
      (16#2C27#,16#2C27#,16#2C57#),(16#2C28#,16#2C28#,16#2C58#),(16#2C29#,16#2C29#,16#2C59#),
      (16#2C2A#,16#2C2A#,16#2C5A#),(16#2C2B#,16#2C2B#,16#2C5B#),(16#2C2C#,16#2C2C#,16#2C5C#),
      (16#2C2D#,16#2C2D#,16#2C5D#),(16#2C2E#,16#2C2E#,16#2C5E#),(16#2C30#,16#2C00#,16#2C30#),
      (16#2C31#,16#2C01#,16#2C31#),(16#2C32#,16#2C02#,16#2C32#),(16#2C33#,16#2C03#,16#2C33#),
      (16#2C34#,16#2C04#,16#2C34#),(16#2C35#,16#2C05#,16#2C35#),(16#2C36#,16#2C06#,16#2C36#),
      (16#2C37#,16#2C07#,16#2C37#),(16#2C38#,16#2C08#,16#2C38#),(16#2C39#,16#2C09#,16#2C39#),
      (16#2C3A#,16#2C0A#,16#2C3A#),(16#2C3B#,16#2C0B#,16#2C3B#),(16#2C3C#,16#2C0C#,16#2C3C#),
      (16#2C3D#,16#2C0D#,16#2C3D#),(16#2C3E#,16#2C0E#,16#2C3E#),(16#2C3F#,16#2C0F#,16#2C3F#),
      (16#2C40#,16#2C10#,16#2C40#),(16#2C41#,16#2C11#,16#2C41#),(16#2C42#,16#2C12#,16#2C42#),
      (16#2C43#,16#2C13#,16#2C43#),(16#2C44#,16#2C14#,16#2C44#),(16#2C45#,16#2C15#,16#2C45#),
      (16#2C46#,16#2C16#,16#2C46#),(16#2C47#,16#2C17#,16#2C47#),(16#2C48#,16#2C18#,16#2C48#),
      (16#2C49#,16#2C19#,16#2C49#),(16#2C4A#,16#2C1A#,16#2C4A#),(16#2C4B#,16#2C1B#,16#2C4B#),
      (16#2C4C#,16#2C1C#,16#2C4C#),(16#2C4D#,16#2C1D#,16#2C4D#),(16#2C4E#,16#2C1E#,16#2C4E#),
      (16#2C4F#,16#2C1F#,16#2C4F#),(16#2C50#,16#2C20#,16#2C50#),(16#2C51#,16#2C21#,16#2C51#),
      (16#2C52#,16#2C22#,16#2C52#),(16#2C53#,16#2C23#,16#2C53#),(16#2C54#,16#2C24#,16#2C54#),
      (16#2C55#,16#2C25#,16#2C55#),(16#2C56#,16#2C26#,16#2C56#),(16#2C57#,16#2C27#,16#2C57#),
      (16#2C58#,16#2C28#,16#2C58#),(16#2C59#,16#2C29#,16#2C59#),(16#2C5A#,16#2C2A#,16#2C5A#),
      (16#2C5B#,16#2C2B#,16#2C5B#),(16#2C5C#,16#2C2C#,16#2C5C#),(16#2C5D#,16#2C2D#,16#2C5D#),
      (16#2C5E#,16#2C2E#,16#2C5E#),(16#2C60#,16#2C60#,16#2C61#),(16#2C61#,16#2C60#,16#2C61#),
      (16#2C62#,16#2C62#,16#26B#),(16#2C63#,16#2C63#,16#1D7D#),(16#2C64#,16#2C64#,16#27D#),
      (16#2C65#,16#23A#,16#2C65#),(16#2C66#,16#23E#,16#2C66#),(16#2C67#,16#2C67#,16#2C68#),
      (16#2C68#,16#2C67#,16#2C68#),(16#2C69#,16#2C69#,16#2C6A#),(16#2C6A#,16#2C69#,16#2C6A#),
      (16#2C6B#,16#2C6B#,16#2C6C#),(16#2C6C#,16#2C6B#,16#2C6C#),(16#2C74#,16#2C74#,16#2C74#),
      (16#2C75#,16#2C75#,16#2C76#),(16#2C76#,16#2C75#,16#2C76#),(16#2C77#,16#2C77#,16#2C77#),
      (16#2C80#,16#2C80#,16#2C81#),(16#2C81#,16#2C80#,16#2C81#),(16#2C82#,16#2C82#,16#2C83#),
      (16#2C83#,16#2C82#,16#2C83#),(16#2C84#,16#2C84#,16#2C85#),(16#2C85#,16#2C84#,16#2C85#),
      (16#2C86#,16#2C86#,16#2C87#),(16#2C87#,16#2C86#,16#2C87#),(16#2C88#,16#2C88#,16#2C89#),
      (16#2C89#,16#2C88#,16#2C89#),(16#2C8A#,16#2C8A#,16#2C8B#),(16#2C8B#,16#2C8A#,16#2C8B#),
      (16#2C8C#,16#2C8C#,16#2C8D#),(16#2C8D#,16#2C8C#,16#2C8D#),(16#2C8E#,16#2C8E#,16#2C8F#),
      (16#2C8F#,16#2C8E#,16#2C8F#),(16#2C90#,16#2C90#,16#2C91#),(16#2C91#,16#2C90#,16#2C91#),
      (16#2C92#,16#2C92#,16#2C93#),(16#2C93#,16#2C92#,16#2C93#),(16#2C94#,16#2C94#,16#2C95#),
      (16#2C95#,16#2C94#,16#2C95#),(16#2C96#,16#2C96#,16#2C97#),(16#2C97#,16#2C96#,16#2C97#),
      (16#2C98#,16#2C98#,16#2C99#),(16#2C99#,16#2C98#,16#2C99#),(16#2C9A#,16#2C9A#,16#2C9B#),
      (16#2C9B#,16#2C9A#,16#2C9B#),(16#2C9C#,16#2C9C#,16#2C9D#),(16#2C9D#,16#2C9C#,16#2C9D#),
      (16#2C9E#,16#2C9E#,16#2C9F#),(16#2C9F#,16#2C9E#,16#2C9F#),(16#2CA0#,16#2CA0#,16#2CA1#),
      (16#2CA1#,16#2CA0#,16#2CA1#),(16#2CA2#,16#2CA2#,16#2CA3#),(16#2CA3#,16#2CA2#,16#2CA3#),
      (16#2CA4#,16#2CA4#,16#2CA5#),(16#2CA5#,16#2CA4#,16#2CA5#),(16#2CA6#,16#2CA6#,16#2CA7#),
      (16#2CA7#,16#2CA6#,16#2CA7#),(16#2CA8#,16#2CA8#,16#2CA9#),(16#2CA9#,16#2CA8#,16#2CA9#),
      (16#2CAA#,16#2CAA#,16#2CAB#),(16#2CAB#,16#2CAA#,16#2CAB#),(16#2CAC#,16#2CAC#,16#2CAD#),
      (16#2CAD#,16#2CAC#,16#2CAD#),(16#2CAE#,16#2CAE#,16#2CAF#),(16#2CAF#,16#2CAE#,16#2CAF#),
      (16#2CB0#,16#2CB0#,16#2CB1#),(16#2CB1#,16#2CB0#,16#2CB1#),(16#2CB2#,16#2CB2#,16#2CB3#),
      (16#2CB3#,16#2CB2#,16#2CB3#),(16#2CB4#,16#2CB4#,16#2CB5#),(16#2CB5#,16#2CB4#,16#2CB5#),
      (16#2CB6#,16#2CB6#,16#2CB7#),(16#2CB7#,16#2CB6#,16#2CB7#),(16#2CB8#,16#2CB8#,16#2CB9#),
      (16#2CB9#,16#2CB8#,16#2CB9#),(16#2CBA#,16#2CBA#,16#2CBB#),(16#2CBB#,16#2CBA#,16#2CBB#),
      (16#2CBC#,16#2CBC#,16#2CBD#),(16#2CBD#,16#2CBC#,16#2CBD#),(16#2CBE#,16#2CBE#,16#2CBF#),
      (16#2CBF#,16#2CBE#,16#2CBF#),(16#2CC0#,16#2CC0#,16#2CC1#),(16#2CC1#,16#2CC0#,16#2CC1#),
      (16#2CC2#,16#2CC2#,16#2CC3#),(16#2CC3#,16#2CC2#,16#2CC3#),(16#2CC4#,16#2CC4#,16#2CC5#),
      (16#2CC5#,16#2CC4#,16#2CC5#),(16#2CC6#,16#2CC6#,16#2CC7#),(16#2CC7#,16#2CC6#,16#2CC7#),
      (16#2CC8#,16#2CC8#,16#2CC9#),(16#2CC9#,16#2CC8#,16#2CC9#),(16#2CCA#,16#2CCA#,16#2CCB#),
      (16#2CCB#,16#2CCA#,16#2CCB#),(16#2CCC#,16#2CCC#,16#2CCD#),(16#2CCD#,16#2CCC#,16#2CCD#),
      (16#2CCE#,16#2CCE#,16#2CCF#),(16#2CCF#,16#2CCE#,16#2CCF#),(16#2CD0#,16#2CD0#,16#2CD1#),
      (16#2CD1#,16#2CD0#,16#2CD1#),(16#2CD2#,16#2CD2#,16#2CD3#),(16#2CD3#,16#2CD2#,16#2CD3#),
      (16#2CD4#,16#2CD4#,16#2CD5#),(16#2CD5#,16#2CD4#,16#2CD5#),(16#2CD6#,16#2CD6#,16#2CD7#),
      (16#2CD7#,16#2CD6#,16#2CD7#),(16#2CD8#,16#2CD8#,16#2CD9#),(16#2CD9#,16#2CD8#,16#2CD9#),
      (16#2CDA#,16#2CDA#,16#2CDB#),(16#2CDB#,16#2CDA#,16#2CDB#),(16#2CDC#,16#2CDC#,16#2CDD#),
      (16#2CDD#,16#2CDC#,16#2CDD#),(16#2CDE#,16#2CDE#,16#2CDF#),(16#2CDF#,16#2CDE#,16#2CDF#),
      (16#2CE0#,16#2CE0#,16#2CE1#),(16#2CE1#,16#2CE0#,16#2CE1#),(16#2CE2#,16#2CE2#,16#2CE3#),
      (16#2CE3#,16#2CE2#,16#2CE3#),(16#2CE4#,16#2CE4#,16#2CE4#),(16#2D00#,16#10A0#,16#2D00#),
      (16#2D01#,16#10A1#,16#2D01#),(16#2D02#,16#10A2#,16#2D02#),(16#2D03#,16#10A3#,16#2D03#),
      (16#2D04#,16#10A4#,16#2D04#),(16#2D05#,16#10A5#,16#2D05#),(16#2D06#,16#10A6#,16#2D06#),
      (16#2D07#,16#10A7#,16#2D07#),(16#2D08#,16#10A8#,16#2D08#),(16#2D09#,16#10A9#,16#2D09#),
      (16#2D0A#,16#10AA#,16#2D0A#),(16#2D0B#,16#10AB#,16#2D0B#),(16#2D0C#,16#10AC#,16#2D0C#),
      (16#2D0D#,16#10AD#,16#2D0D#),(16#2D0E#,16#10AE#,16#2D0E#),(16#2D0F#,16#10AF#,16#2D0F#),
      (16#2D10#,16#10B0#,16#2D10#),(16#2D11#,16#10B1#,16#2D11#),(16#2D12#,16#10B2#,16#2D12#),
      (16#2D13#,16#10B3#,16#2D13#),(16#2D14#,16#10B4#,16#2D14#),(16#2D15#,16#10B5#,16#2D15#),
      (16#2D16#,16#10B6#,16#2D16#),(16#2D17#,16#10B7#,16#2D17#),(16#2D18#,16#10B8#,16#2D18#),
      (16#2D19#,16#10B9#,16#2D19#),(16#2D1A#,16#10BA#,16#2D1A#),(16#2D1B#,16#10BB#,16#2D1B#),
      (16#2D1C#,16#10BC#,16#2D1C#),(16#2D1D#,16#10BD#,16#2D1D#),(16#2D1E#,16#10BE#,16#2D1E#),
      (16#2D1F#,16#10BF#,16#2D1F#),(16#2D20#,16#10C0#,16#2D20#),(16#2D21#,16#10C1#,16#2D21#),
      (16#2D22#,16#10C2#,16#2D22#),(16#2D23#,16#10C3#,16#2D23#),(16#2D24#,16#10C4#,16#2D24#),
      (16#2D25#,16#10C5#,16#2D25#),(16#FB00#,16#FB00#,16#FB00#),(16#FB01#,16#FB01#,16#FB01#),
      (16#FB02#,16#FB02#,16#FB02#),(16#FB03#,16#FB03#,16#FB03#),(16#FB04#,16#FB04#,16#FB04#),
      (16#FB05#,16#FB05#,16#FB05#),(16#FB06#,16#FB06#,16#FB06#),(16#FB13#,16#FB13#,16#FB13#),
      (16#FB14#,16#FB14#,16#FB14#),(16#FB15#,16#FB15#,16#FB15#),(16#FB16#,16#FB16#,16#FB16#),
      (16#FB17#,16#FB17#,16#FB17#),(16#FF21#,16#FF21#,16#FF41#),(16#FF22#,16#FF22#,16#FF42#),
      (16#FF23#,16#FF23#,16#FF43#),(16#FF24#,16#FF24#,16#FF44#),(16#FF25#,16#FF25#,16#FF45#),
      (16#FF26#,16#FF26#,16#FF46#),(16#FF27#,16#FF27#,16#FF47#),(16#FF28#,16#FF28#,16#FF48#),
      (16#FF29#,16#FF29#,16#FF49#),(16#FF2A#,16#FF2A#,16#FF4A#),(16#FF2B#,16#FF2B#,16#FF4B#),
      (16#FF2C#,16#FF2C#,16#FF4C#),(16#FF2D#,16#FF2D#,16#FF4D#),(16#FF2E#,16#FF2E#,16#FF4E#),
      (16#FF2F#,16#FF2F#,16#FF4F#),(16#FF30#,16#FF30#,16#FF50#),(16#FF31#,16#FF31#,16#FF51#),
      (16#FF32#,16#FF32#,16#FF52#),(16#FF33#,16#FF33#,16#FF53#),(16#FF34#,16#FF34#,16#FF54#),
      (16#FF35#,16#FF35#,16#FF55#),(16#FF36#,16#FF36#,16#FF56#),(16#FF37#,16#FF37#,16#FF57#),
      (16#FF38#,16#FF38#,16#FF58#),(16#FF39#,16#FF39#,16#FF59#),(16#FF3A#,16#FF3A#,16#FF5A#),
      (16#FF41#,16#FF21#,16#FF41#),(16#FF42#,16#FF22#,16#FF42#),(16#FF43#,16#FF23#,16#FF43#),
      (16#FF44#,16#FF24#,16#FF44#),(16#FF45#,16#FF25#,16#FF45#),(16#FF46#,16#FF26#,16#FF46#),
      (16#FF47#,16#FF27#,16#FF47#),(16#FF48#,16#FF28#,16#FF48#),(16#FF49#,16#FF29#,16#FF49#),
      (16#FF4A#,16#FF2A#,16#FF4A#),(16#FF4B#,16#FF2B#,16#FF4B#),(16#FF4C#,16#FF2C#,16#FF4C#),
      (16#FF4D#,16#FF2D#,16#FF4D#),(16#FF4E#,16#FF2E#,16#FF4E#),(16#FF4F#,16#FF2F#,16#FF4F#),
      (16#FF50#,16#FF30#,16#FF50#),(16#FF51#,16#FF31#,16#FF51#),(16#FF52#,16#FF32#,16#FF52#),
      (16#FF53#,16#FF33#,16#FF53#),(16#FF54#,16#FF34#,16#FF54#),(16#FF55#,16#FF35#,16#FF55#),
      (16#FF56#,16#FF36#,16#FF56#),(16#FF57#,16#FF37#,16#FF57#),(16#FF58#,16#FF38#,16#FF58#),
      (16#FF59#,16#FF39#,16#FF59#),(16#FF5A#,16#FF3A#,16#FF5A#),(16#10400#,16#10400#,16#10428#),
      (16#10401#,16#10401#,16#10429#),(16#10402#,16#10402#,16#1042A#),(16#10403#,16#10403#,16#1042B#),
      (16#10404#,16#10404#,16#1042C#),(16#10405#,16#10405#,16#1042D#),(16#10406#,16#10406#,16#1042E#),
      (16#10407#,16#10407#,16#1042F#),(16#10408#,16#10408#,16#10430#),(16#10409#,16#10409#,16#10431#),
      (16#1040A#,16#1040A#,16#10432#),(16#1040B#,16#1040B#,16#10433#),(16#1040C#,16#1040C#,16#10434#),
      (16#1040D#,16#1040D#,16#10435#),(16#1040E#,16#1040E#,16#10436#),(16#1040F#,16#1040F#,16#10437#),
      (16#10410#,16#10410#,16#10438#),(16#10411#,16#10411#,16#10439#),(16#10412#,16#10412#,16#1043A#),
      (16#10413#,16#10413#,16#1043B#),(16#10414#,16#10414#,16#1043C#),(16#10415#,16#10415#,16#1043D#),
      (16#10416#,16#10416#,16#1043E#),(16#10417#,16#10417#,16#1043F#),(16#10418#,16#10418#,16#10440#),
      (16#10419#,16#10419#,16#10441#),(16#1041A#,16#1041A#,16#10442#),(16#1041B#,16#1041B#,16#10443#),
      (16#1041C#,16#1041C#,16#10444#),(16#1041D#,16#1041D#,16#10445#),(16#1041E#,16#1041E#,16#10446#),
      (16#1041F#,16#1041F#,16#10447#),(16#10420#,16#10420#,16#10448#),(16#10421#,16#10421#,16#10449#),
      (16#10422#,16#10422#,16#1044A#),(16#10423#,16#10423#,16#1044B#),(16#10424#,16#10424#,16#1044C#),
      (16#10425#,16#10425#,16#1044D#),(16#10426#,16#10426#,16#1044E#),(16#10427#,16#10427#,16#1044F#),
      (16#10428#,16#10400#,16#10428#),(16#10429#,16#10401#,16#10429#),(16#1042A#,16#10402#,16#1042A#),
      (16#1042B#,16#10403#,16#1042B#),(16#1042C#,16#10404#,16#1042C#),(16#1042D#,16#10405#,16#1042D#),
      (16#1042E#,16#10406#,16#1042E#),(16#1042F#,16#10407#,16#1042F#),(16#10430#,16#10408#,16#10430#),
      (16#10431#,16#10409#,16#10431#),(16#10432#,16#1040A#,16#10432#),(16#10433#,16#1040B#,16#10433#),
      (16#10434#,16#1040C#,16#10434#),(16#10435#,16#1040D#,16#10435#),(16#10436#,16#1040E#,16#10436#),
      (16#10437#,16#1040F#,16#10437#),(16#10438#,16#10410#,16#10438#),(16#10439#,16#10411#,16#10439#),
      (16#1043A#,16#10412#,16#1043A#),(16#1043B#,16#10413#,16#1043B#),(16#1043C#,16#10414#,16#1043C#),
      (16#1043D#,16#10415#,16#1043D#),(16#1043E#,16#10416#,16#1043E#),(16#1043F#,16#10417#,16#1043F#),
      (16#10440#,16#10418#,16#10440#),(16#10441#,16#10419#,16#10441#),(16#10442#,16#1041A#,16#10442#),
      (16#10443#,16#1041B#,16#10443#),(16#10444#,16#1041C#,16#10444#),(16#10445#,16#1041D#,16#10445#),
      (16#10446#,16#1041E#,16#10446#),(16#10447#,16#1041F#,16#10447#),(16#10448#,16#10420#,16#10448#),
      (16#10449#,16#10421#,16#10449#),(16#1044A#,16#10422#,16#1044A#),(16#1044B#,16#10423#,16#1044B#),
      (16#1044C#,16#10424#,16#1044C#),(16#1044D#,16#10425#,16#1044D#),(16#1044E#,16#10426#,16#1044E#),
      (16#1044F#,16#10427#,16#1044F#),(16#1D400#,16#1D400#,16#1D400#),(16#1D401#,16#1D401#,16#1D401#),
      (16#1D402#,16#1D402#,16#1D402#),(16#1D403#,16#1D403#,16#1D403#),(16#1D404#,16#1D404#,16#1D404#),
      (16#1D405#,16#1D405#,16#1D405#),(16#1D406#,16#1D406#,16#1D406#),(16#1D407#,16#1D407#,16#1D407#),
      (16#1D408#,16#1D408#,16#1D408#),(16#1D409#,16#1D409#,16#1D409#),(16#1D40A#,16#1D40A#,16#1D40A#),
      (16#1D40B#,16#1D40B#,16#1D40B#),(16#1D40C#,16#1D40C#,16#1D40C#),(16#1D40D#,16#1D40D#,16#1D40D#),
      (16#1D40E#,16#1D40E#,16#1D40E#),(16#1D40F#,16#1D40F#,16#1D40F#),(16#1D410#,16#1D410#,16#1D410#),
      (16#1D411#,16#1D411#,16#1D411#),(16#1D412#,16#1D412#,16#1D412#),(16#1D413#,16#1D413#,16#1D413#),
      (16#1D414#,16#1D414#,16#1D414#),(16#1D415#,16#1D415#,16#1D415#),(16#1D416#,16#1D416#,16#1D416#),
      (16#1D417#,16#1D417#,16#1D417#),(16#1D418#,16#1D418#,16#1D418#),(16#1D419#,16#1D419#,16#1D419#),
      (16#1D41A#,16#1D41A#,16#1D41A#),(16#1D41B#,16#1D41B#,16#1D41B#),(16#1D41C#,16#1D41C#,16#1D41C#),
      (16#1D41D#,16#1D41D#,16#1D41D#),(16#1D41E#,16#1D41E#,16#1D41E#),(16#1D41F#,16#1D41F#,16#1D41F#),
      (16#1D420#,16#1D420#,16#1D420#),(16#1D421#,16#1D421#,16#1D421#),(16#1D422#,16#1D422#,16#1D422#),
      (16#1D423#,16#1D423#,16#1D423#),(16#1D424#,16#1D424#,16#1D424#),(16#1D425#,16#1D425#,16#1D425#),
      (16#1D426#,16#1D426#,16#1D426#),(16#1D427#,16#1D427#,16#1D427#),(16#1D428#,16#1D428#,16#1D428#),
      (16#1D429#,16#1D429#,16#1D429#),(16#1D42A#,16#1D42A#,16#1D42A#),(16#1D42B#,16#1D42B#,16#1D42B#),
      (16#1D42C#,16#1D42C#,16#1D42C#),(16#1D42D#,16#1D42D#,16#1D42D#),(16#1D42E#,16#1D42E#,16#1D42E#),
      (16#1D42F#,16#1D42F#,16#1D42F#),(16#1D430#,16#1D430#,16#1D430#),(16#1D431#,16#1D431#,16#1D431#),
      (16#1D432#,16#1D432#,16#1D432#),(16#1D433#,16#1D433#,16#1D433#),(16#1D434#,16#1D434#,16#1D434#),
      (16#1D435#,16#1D435#,16#1D435#),(16#1D436#,16#1D436#,16#1D436#),(16#1D437#,16#1D437#,16#1D437#),
      (16#1D438#,16#1D438#,16#1D438#),(16#1D439#,16#1D439#,16#1D439#),(16#1D43A#,16#1D43A#,16#1D43A#),
      (16#1D43B#,16#1D43B#,16#1D43B#),(16#1D43C#,16#1D43C#,16#1D43C#),(16#1D43D#,16#1D43D#,16#1D43D#),
      (16#1D43E#,16#1D43E#,16#1D43E#),(16#1D43F#,16#1D43F#,16#1D43F#),(16#1D440#,16#1D440#,16#1D440#),
      (16#1D441#,16#1D441#,16#1D441#),(16#1D442#,16#1D442#,16#1D442#),(16#1D443#,16#1D443#,16#1D443#),
      (16#1D444#,16#1D444#,16#1D444#),(16#1D445#,16#1D445#,16#1D445#),(16#1D446#,16#1D446#,16#1D446#),
      (16#1D447#,16#1D447#,16#1D447#),(16#1D448#,16#1D448#,16#1D448#),(16#1D449#,16#1D449#,16#1D449#),
      (16#1D44A#,16#1D44A#,16#1D44A#),(16#1D44B#,16#1D44B#,16#1D44B#),(16#1D44C#,16#1D44C#,16#1D44C#),
      (16#1D44D#,16#1D44D#,16#1D44D#),(16#1D44E#,16#1D44E#,16#1D44E#),(16#1D44F#,16#1D44F#,16#1D44F#),
      (16#1D450#,16#1D450#,16#1D450#),(16#1D451#,16#1D451#,16#1D451#),(16#1D452#,16#1D452#,16#1D452#),
      (16#1D453#,16#1D453#,16#1D453#),(16#1D454#,16#1D454#,16#1D454#),(16#1D456#,16#1D456#,16#1D456#),
      (16#1D457#,16#1D457#,16#1D457#),(16#1D458#,16#1D458#,16#1D458#),(16#1D459#,16#1D459#,16#1D459#),
      (16#1D45A#,16#1D45A#,16#1D45A#),(16#1D45B#,16#1D45B#,16#1D45B#),(16#1D45C#,16#1D45C#,16#1D45C#),
      (16#1D45D#,16#1D45D#,16#1D45D#),(16#1D45E#,16#1D45E#,16#1D45E#),(16#1D45F#,16#1D45F#,16#1D45F#),
      (16#1D460#,16#1D460#,16#1D460#),(16#1D461#,16#1D461#,16#1D461#),(16#1D462#,16#1D462#,16#1D462#),
      (16#1D463#,16#1D463#,16#1D463#),(16#1D464#,16#1D464#,16#1D464#),(16#1D465#,16#1D465#,16#1D465#),
      (16#1D466#,16#1D466#,16#1D466#),(16#1D467#,16#1D467#,16#1D467#),(16#1D468#,16#1D468#,16#1D468#),
      (16#1D469#,16#1D469#,16#1D469#),(16#1D46A#,16#1D46A#,16#1D46A#),(16#1D46B#,16#1D46B#,16#1D46B#),
      (16#1D46C#,16#1D46C#,16#1D46C#),(16#1D46D#,16#1D46D#,16#1D46D#),(16#1D46E#,16#1D46E#,16#1D46E#),
      (16#1D46F#,16#1D46F#,16#1D46F#),(16#1D470#,16#1D470#,16#1D470#),(16#1D471#,16#1D471#,16#1D471#),
      (16#1D472#,16#1D472#,16#1D472#),(16#1D473#,16#1D473#,16#1D473#),(16#1D474#,16#1D474#,16#1D474#),
      (16#1D475#,16#1D475#,16#1D475#),(16#1D476#,16#1D476#,16#1D476#),(16#1D477#,16#1D477#,16#1D477#),
      (16#1D478#,16#1D478#,16#1D478#),(16#1D479#,16#1D479#,16#1D479#),(16#1D47A#,16#1D47A#,16#1D47A#),
      (16#1D47B#,16#1D47B#,16#1D47B#),(16#1D47C#,16#1D47C#,16#1D47C#),(16#1D47D#,16#1D47D#,16#1D47D#),
      (16#1D47E#,16#1D47E#,16#1D47E#),(16#1D47F#,16#1D47F#,16#1D47F#),(16#1D480#,16#1D480#,16#1D480#),
      (16#1D481#,16#1D481#,16#1D481#),(16#1D482#,16#1D482#,16#1D482#),(16#1D483#,16#1D483#,16#1D483#),
      (16#1D484#,16#1D484#,16#1D484#),(16#1D485#,16#1D485#,16#1D485#),(16#1D486#,16#1D486#,16#1D486#),
      (16#1D487#,16#1D487#,16#1D487#),(16#1D488#,16#1D488#,16#1D488#),(16#1D489#,16#1D489#,16#1D489#),
      (16#1D48A#,16#1D48A#,16#1D48A#),(16#1D48B#,16#1D48B#,16#1D48B#),(16#1D48C#,16#1D48C#,16#1D48C#),
      (16#1D48D#,16#1D48D#,16#1D48D#),(16#1D48E#,16#1D48E#,16#1D48E#),(16#1D48F#,16#1D48F#,16#1D48F#),
      (16#1D490#,16#1D490#,16#1D490#),(16#1D491#,16#1D491#,16#1D491#),(16#1D492#,16#1D492#,16#1D492#),
      (16#1D493#,16#1D493#,16#1D493#),(16#1D494#,16#1D494#,16#1D494#),(16#1D495#,16#1D495#,16#1D495#),
      (16#1D496#,16#1D496#,16#1D496#),(16#1D497#,16#1D497#,16#1D497#),(16#1D498#,16#1D498#,16#1D498#),
      (16#1D499#,16#1D499#,16#1D499#),(16#1D49A#,16#1D49A#,16#1D49A#),(16#1D49B#,16#1D49B#,16#1D49B#),
      (16#1D49C#,16#1D49C#,16#1D49C#),(16#1D49E#,16#1D49E#,16#1D49E#),(16#1D49F#,16#1D49F#,16#1D49F#),
      (16#1D4A2#,16#1D4A2#,16#1D4A2#),(16#1D4A5#,16#1D4A5#,16#1D4A5#),(16#1D4A6#,16#1D4A6#,16#1D4A6#),
      (16#1D4A9#,16#1D4A9#,16#1D4A9#),(16#1D4AA#,16#1D4AA#,16#1D4AA#),(16#1D4AB#,16#1D4AB#,16#1D4AB#),
      (16#1D4AC#,16#1D4AC#,16#1D4AC#),(16#1D4AE#,16#1D4AE#,16#1D4AE#),(16#1D4AF#,16#1D4AF#,16#1D4AF#),
      (16#1D4B0#,16#1D4B0#,16#1D4B0#),(16#1D4B1#,16#1D4B1#,16#1D4B1#),(16#1D4B2#,16#1D4B2#,16#1D4B2#),
      (16#1D4B3#,16#1D4B3#,16#1D4B3#),(16#1D4B4#,16#1D4B4#,16#1D4B4#),(16#1D4B5#,16#1D4B5#,16#1D4B5#),
      (16#1D4B6#,16#1D4B6#,16#1D4B6#),(16#1D4B7#,16#1D4B7#,16#1D4B7#),(16#1D4B8#,16#1D4B8#,16#1D4B8#),
      (16#1D4B9#,16#1D4B9#,16#1D4B9#),(16#1D4BB#,16#1D4BB#,16#1D4BB#),(16#1D4BD#,16#1D4BD#,16#1D4BD#),
      (16#1D4BE#,16#1D4BE#,16#1D4BE#),(16#1D4BF#,16#1D4BF#,16#1D4BF#),(16#1D4C0#,16#1D4C0#,16#1D4C0#),
      (16#1D4C1#,16#1D4C1#,16#1D4C1#),(16#1D4C2#,16#1D4C2#,16#1D4C2#),(16#1D4C3#,16#1D4C3#,16#1D4C3#),
      (16#1D4C5#,16#1D4C5#,16#1D4C5#),(16#1D4C6#,16#1D4C6#,16#1D4C6#),(16#1D4C7#,16#1D4C7#,16#1D4C7#),
      (16#1D4C8#,16#1D4C8#,16#1D4C8#),(16#1D4C9#,16#1D4C9#,16#1D4C9#),(16#1D4CA#,16#1D4CA#,16#1D4CA#),
      (16#1D4CB#,16#1D4CB#,16#1D4CB#),(16#1D4CC#,16#1D4CC#,16#1D4CC#),(16#1D4CD#,16#1D4CD#,16#1D4CD#),
      (16#1D4CE#,16#1D4CE#,16#1D4CE#),(16#1D4CF#,16#1D4CF#,16#1D4CF#),(16#1D4D0#,16#1D4D0#,16#1D4D0#),
      (16#1D4D1#,16#1D4D1#,16#1D4D1#),(16#1D4D2#,16#1D4D2#,16#1D4D2#),(16#1D4D3#,16#1D4D3#,16#1D4D3#),
      (16#1D4D4#,16#1D4D4#,16#1D4D4#),(16#1D4D5#,16#1D4D5#,16#1D4D5#),(16#1D4D6#,16#1D4D6#,16#1D4D6#),
      (16#1D4D7#,16#1D4D7#,16#1D4D7#),(16#1D4D8#,16#1D4D8#,16#1D4D8#),(16#1D4D9#,16#1D4D9#,16#1D4D9#),
      (16#1D4DA#,16#1D4DA#,16#1D4DA#),(16#1D4DB#,16#1D4DB#,16#1D4DB#),(16#1D4DC#,16#1D4DC#,16#1D4DC#),
      (16#1D4DD#,16#1D4DD#,16#1D4DD#),(16#1D4DE#,16#1D4DE#,16#1D4DE#),(16#1D4DF#,16#1D4DF#,16#1D4DF#),
      (16#1D4E0#,16#1D4E0#,16#1D4E0#),(16#1D4E1#,16#1D4E1#,16#1D4E1#),(16#1D4E2#,16#1D4E2#,16#1D4E2#),
      (16#1D4E3#,16#1D4E3#,16#1D4E3#),(16#1D4E4#,16#1D4E4#,16#1D4E4#),(16#1D4E5#,16#1D4E5#,16#1D4E5#),
      (16#1D4E6#,16#1D4E6#,16#1D4E6#),(16#1D4E7#,16#1D4E7#,16#1D4E7#),(16#1D4E8#,16#1D4E8#,16#1D4E8#),
      (16#1D4E9#,16#1D4E9#,16#1D4E9#),(16#1D4EA#,16#1D4EA#,16#1D4EA#),(16#1D4EB#,16#1D4EB#,16#1D4EB#),
      (16#1D4EC#,16#1D4EC#,16#1D4EC#),(16#1D4ED#,16#1D4ED#,16#1D4ED#),(16#1D4EE#,16#1D4EE#,16#1D4EE#),
      (16#1D4EF#,16#1D4EF#,16#1D4EF#),(16#1D4F0#,16#1D4F0#,16#1D4F0#),(16#1D4F1#,16#1D4F1#,16#1D4F1#),
      (16#1D4F2#,16#1D4F2#,16#1D4F2#),(16#1D4F3#,16#1D4F3#,16#1D4F3#),(16#1D4F4#,16#1D4F4#,16#1D4F4#),
      (16#1D4F5#,16#1D4F5#,16#1D4F5#),(16#1D4F6#,16#1D4F6#,16#1D4F6#),(16#1D4F7#,16#1D4F7#,16#1D4F7#),
      (16#1D4F8#,16#1D4F8#,16#1D4F8#),(16#1D4F9#,16#1D4F9#,16#1D4F9#),(16#1D4FA#,16#1D4FA#,16#1D4FA#),
      (16#1D4FB#,16#1D4FB#,16#1D4FB#),(16#1D4FC#,16#1D4FC#,16#1D4FC#),(16#1D4FD#,16#1D4FD#,16#1D4FD#),
      (16#1D4FE#,16#1D4FE#,16#1D4FE#),(16#1D4FF#,16#1D4FF#,16#1D4FF#),(16#1D500#,16#1D500#,16#1D500#),
      (16#1D501#,16#1D501#,16#1D501#),(16#1D502#,16#1D502#,16#1D502#),(16#1D503#,16#1D503#,16#1D503#),
      (16#1D504#,16#1D504#,16#1D504#),(16#1D505#,16#1D505#,16#1D505#),(16#1D507#,16#1D507#,16#1D507#),
      (16#1D508#,16#1D508#,16#1D508#),(16#1D509#,16#1D509#,16#1D509#),(16#1D50A#,16#1D50A#,16#1D50A#),
      (16#1D50D#,16#1D50D#,16#1D50D#),(16#1D50E#,16#1D50E#,16#1D50E#),(16#1D50F#,16#1D50F#,16#1D50F#),
      (16#1D510#,16#1D510#,16#1D510#),(16#1D511#,16#1D511#,16#1D511#),(16#1D512#,16#1D512#,16#1D512#),
      (16#1D513#,16#1D513#,16#1D513#),(16#1D514#,16#1D514#,16#1D514#),(16#1D516#,16#1D516#,16#1D516#),
      (16#1D517#,16#1D517#,16#1D517#),(16#1D518#,16#1D518#,16#1D518#),(16#1D519#,16#1D519#,16#1D519#),
      (16#1D51A#,16#1D51A#,16#1D51A#),(16#1D51B#,16#1D51B#,16#1D51B#),(16#1D51C#,16#1D51C#,16#1D51C#),
      (16#1D51E#,16#1D51E#,16#1D51E#),(16#1D51F#,16#1D51F#,16#1D51F#),(16#1D520#,16#1D520#,16#1D520#),
      (16#1D521#,16#1D521#,16#1D521#),(16#1D522#,16#1D522#,16#1D522#),(16#1D523#,16#1D523#,16#1D523#),
      (16#1D524#,16#1D524#,16#1D524#),(16#1D525#,16#1D525#,16#1D525#),(16#1D526#,16#1D526#,16#1D526#),
      (16#1D527#,16#1D527#,16#1D527#),(16#1D528#,16#1D528#,16#1D528#),(16#1D529#,16#1D529#,16#1D529#),
      (16#1D52A#,16#1D52A#,16#1D52A#),(16#1D52B#,16#1D52B#,16#1D52B#),(16#1D52C#,16#1D52C#,16#1D52C#),
      (16#1D52D#,16#1D52D#,16#1D52D#),(16#1D52E#,16#1D52E#,16#1D52E#),(16#1D52F#,16#1D52F#,16#1D52F#),
      (16#1D530#,16#1D530#,16#1D530#),(16#1D531#,16#1D531#,16#1D531#),(16#1D532#,16#1D532#,16#1D532#),
      (16#1D533#,16#1D533#,16#1D533#),(16#1D534#,16#1D534#,16#1D534#),(16#1D535#,16#1D535#,16#1D535#),
      (16#1D536#,16#1D536#,16#1D536#),(16#1D537#,16#1D537#,16#1D537#),(16#1D538#,16#1D538#,16#1D538#),
      (16#1D539#,16#1D539#,16#1D539#),(16#1D53B#,16#1D53B#,16#1D53B#),(16#1D53C#,16#1D53C#,16#1D53C#),
      (16#1D53D#,16#1D53D#,16#1D53D#),(16#1D53E#,16#1D53E#,16#1D53E#),(16#1D540#,16#1D540#,16#1D540#),
      (16#1D541#,16#1D541#,16#1D541#),(16#1D542#,16#1D542#,16#1D542#),(16#1D543#,16#1D543#,16#1D543#),
      (16#1D544#,16#1D544#,16#1D544#),(16#1D546#,16#1D546#,16#1D546#),(16#1D54A#,16#1D54A#,16#1D54A#),
      (16#1D54B#,16#1D54B#,16#1D54B#),(16#1D54C#,16#1D54C#,16#1D54C#),(16#1D54D#,16#1D54D#,16#1D54D#),
      (16#1D54E#,16#1D54E#,16#1D54E#),(16#1D54F#,16#1D54F#,16#1D54F#),(16#1D550#,16#1D550#,16#1D550#),
      (16#1D552#,16#1D552#,16#1D552#),(16#1D553#,16#1D553#,16#1D553#),(16#1D554#,16#1D554#,16#1D554#),
      (16#1D555#,16#1D555#,16#1D555#),(16#1D556#,16#1D556#,16#1D556#),(16#1D557#,16#1D557#,16#1D557#),
      (16#1D558#,16#1D558#,16#1D558#),(16#1D559#,16#1D559#,16#1D559#),(16#1D55A#,16#1D55A#,16#1D55A#),
      (16#1D55B#,16#1D55B#,16#1D55B#),(16#1D55C#,16#1D55C#,16#1D55C#),(16#1D55D#,16#1D55D#,16#1D55D#),
      (16#1D55E#,16#1D55E#,16#1D55E#),(16#1D55F#,16#1D55F#,16#1D55F#),(16#1D560#,16#1D560#,16#1D560#),
      (16#1D561#,16#1D561#,16#1D561#),(16#1D562#,16#1D562#,16#1D562#),(16#1D563#,16#1D563#,16#1D563#),
      (16#1D564#,16#1D564#,16#1D564#),(16#1D565#,16#1D565#,16#1D565#),(16#1D566#,16#1D566#,16#1D566#),
      (16#1D567#,16#1D567#,16#1D567#),(16#1D568#,16#1D568#,16#1D568#),(16#1D569#,16#1D569#,16#1D569#),
      (16#1D56A#,16#1D56A#,16#1D56A#),(16#1D56B#,16#1D56B#,16#1D56B#),(16#1D56C#,16#1D56C#,16#1D56C#),
      (16#1D56D#,16#1D56D#,16#1D56D#),(16#1D56E#,16#1D56E#,16#1D56E#),(16#1D56F#,16#1D56F#,16#1D56F#),
      (16#1D570#,16#1D570#,16#1D570#),(16#1D571#,16#1D571#,16#1D571#),(16#1D572#,16#1D572#,16#1D572#),
      (16#1D573#,16#1D573#,16#1D573#),(16#1D574#,16#1D574#,16#1D574#),(16#1D575#,16#1D575#,16#1D575#),
      (16#1D576#,16#1D576#,16#1D576#),(16#1D577#,16#1D577#,16#1D577#),(16#1D578#,16#1D578#,16#1D578#),
      (16#1D579#,16#1D579#,16#1D579#),(16#1D57A#,16#1D57A#,16#1D57A#),(16#1D57B#,16#1D57B#,16#1D57B#),
      (16#1D57C#,16#1D57C#,16#1D57C#),(16#1D57D#,16#1D57D#,16#1D57D#),(16#1D57E#,16#1D57E#,16#1D57E#),
      (16#1D57F#,16#1D57F#,16#1D57F#),(16#1D580#,16#1D580#,16#1D580#),(16#1D581#,16#1D581#,16#1D581#),
      (16#1D582#,16#1D582#,16#1D582#),(16#1D583#,16#1D583#,16#1D583#),(16#1D584#,16#1D584#,16#1D584#),
      (16#1D585#,16#1D585#,16#1D585#),(16#1D586#,16#1D586#,16#1D586#),(16#1D587#,16#1D587#,16#1D587#),
      (16#1D588#,16#1D588#,16#1D588#),(16#1D589#,16#1D589#,16#1D589#),(16#1D58A#,16#1D58A#,16#1D58A#),
      (16#1D58B#,16#1D58B#,16#1D58B#),(16#1D58C#,16#1D58C#,16#1D58C#),(16#1D58D#,16#1D58D#,16#1D58D#),
      (16#1D58E#,16#1D58E#,16#1D58E#),(16#1D58F#,16#1D58F#,16#1D58F#),(16#1D590#,16#1D590#,16#1D590#),
      (16#1D591#,16#1D591#,16#1D591#),(16#1D592#,16#1D592#,16#1D592#),(16#1D593#,16#1D593#,16#1D593#),
      (16#1D594#,16#1D594#,16#1D594#),(16#1D595#,16#1D595#,16#1D595#),(16#1D596#,16#1D596#,16#1D596#),
      (16#1D597#,16#1D597#,16#1D597#),(16#1D598#,16#1D598#,16#1D598#),(16#1D599#,16#1D599#,16#1D599#),
      (16#1D59A#,16#1D59A#,16#1D59A#),(16#1D59B#,16#1D59B#,16#1D59B#),(16#1D59C#,16#1D59C#,16#1D59C#),
      (16#1D59D#,16#1D59D#,16#1D59D#),(16#1D59E#,16#1D59E#,16#1D59E#),(16#1D59F#,16#1D59F#,16#1D59F#),
      (16#1D5A0#,16#1D5A0#,16#1D5A0#),(16#1D5A1#,16#1D5A1#,16#1D5A1#),(16#1D5A2#,16#1D5A2#,16#1D5A2#),
      (16#1D5A3#,16#1D5A3#,16#1D5A3#),(16#1D5A4#,16#1D5A4#,16#1D5A4#),(16#1D5A5#,16#1D5A5#,16#1D5A5#),
      (16#1D5A6#,16#1D5A6#,16#1D5A6#),(16#1D5A7#,16#1D5A7#,16#1D5A7#),(16#1D5A8#,16#1D5A8#,16#1D5A8#),
      (16#1D5A9#,16#1D5A9#,16#1D5A9#),(16#1D5AA#,16#1D5AA#,16#1D5AA#),(16#1D5AB#,16#1D5AB#,16#1D5AB#),
      (16#1D5AC#,16#1D5AC#,16#1D5AC#),(16#1D5AD#,16#1D5AD#,16#1D5AD#),(16#1D5AE#,16#1D5AE#,16#1D5AE#),
      (16#1D5AF#,16#1D5AF#,16#1D5AF#),(16#1D5B0#,16#1D5B0#,16#1D5B0#),(16#1D5B1#,16#1D5B1#,16#1D5B1#),
      (16#1D5B2#,16#1D5B2#,16#1D5B2#),(16#1D5B3#,16#1D5B3#,16#1D5B3#),(16#1D5B4#,16#1D5B4#,16#1D5B4#),
      (16#1D5B5#,16#1D5B5#,16#1D5B5#),(16#1D5B6#,16#1D5B6#,16#1D5B6#),(16#1D5B7#,16#1D5B7#,16#1D5B7#),
      (16#1D5B8#,16#1D5B8#,16#1D5B8#),(16#1D5B9#,16#1D5B9#,16#1D5B9#),(16#1D5BA#,16#1D5BA#,16#1D5BA#),
      (16#1D5BB#,16#1D5BB#,16#1D5BB#),(16#1D5BC#,16#1D5BC#,16#1D5BC#),(16#1D5BD#,16#1D5BD#,16#1D5BD#),
      (16#1D5BE#,16#1D5BE#,16#1D5BE#),(16#1D5BF#,16#1D5BF#,16#1D5BF#),(16#1D5C0#,16#1D5C0#,16#1D5C0#),
      (16#1D5C1#,16#1D5C1#,16#1D5C1#),(16#1D5C2#,16#1D5C2#,16#1D5C2#),(16#1D5C3#,16#1D5C3#,16#1D5C3#),
      (16#1D5C4#,16#1D5C4#,16#1D5C4#),(16#1D5C5#,16#1D5C5#,16#1D5C5#),(16#1D5C6#,16#1D5C6#,16#1D5C6#),
      (16#1D5C7#,16#1D5C7#,16#1D5C7#),(16#1D5C8#,16#1D5C8#,16#1D5C8#),(16#1D5C9#,16#1D5C9#,16#1D5C9#),
      (16#1D5CA#,16#1D5CA#,16#1D5CA#),(16#1D5CB#,16#1D5CB#,16#1D5CB#),(16#1D5CC#,16#1D5CC#,16#1D5CC#),
      (16#1D5CD#,16#1D5CD#,16#1D5CD#),(16#1D5CE#,16#1D5CE#,16#1D5CE#),(16#1D5CF#,16#1D5CF#,16#1D5CF#),
      (16#1D5D0#,16#1D5D0#,16#1D5D0#),(16#1D5D1#,16#1D5D1#,16#1D5D1#),(16#1D5D2#,16#1D5D2#,16#1D5D2#),
      (16#1D5D3#,16#1D5D3#,16#1D5D3#),(16#1D5D4#,16#1D5D4#,16#1D5D4#),(16#1D5D5#,16#1D5D5#,16#1D5D5#),
      (16#1D5D6#,16#1D5D6#,16#1D5D6#),(16#1D5D7#,16#1D5D7#,16#1D5D7#),(16#1D5D8#,16#1D5D8#,16#1D5D8#),
      (16#1D5D9#,16#1D5D9#,16#1D5D9#),(16#1D5DA#,16#1D5DA#,16#1D5DA#),(16#1D5DB#,16#1D5DB#,16#1D5DB#),
      (16#1D5DC#,16#1D5DC#,16#1D5DC#),(16#1D5DD#,16#1D5DD#,16#1D5DD#),(16#1D5DE#,16#1D5DE#,16#1D5DE#),
      (16#1D5DF#,16#1D5DF#,16#1D5DF#),(16#1D5E0#,16#1D5E0#,16#1D5E0#),(16#1D5E1#,16#1D5E1#,16#1D5E1#),
      (16#1D5E2#,16#1D5E2#,16#1D5E2#),(16#1D5E3#,16#1D5E3#,16#1D5E3#),(16#1D5E4#,16#1D5E4#,16#1D5E4#),
      (16#1D5E5#,16#1D5E5#,16#1D5E5#),(16#1D5E6#,16#1D5E6#,16#1D5E6#),(16#1D5E7#,16#1D5E7#,16#1D5E7#),
      (16#1D5E8#,16#1D5E8#,16#1D5E8#),(16#1D5E9#,16#1D5E9#,16#1D5E9#),(16#1D5EA#,16#1D5EA#,16#1D5EA#),
      (16#1D5EB#,16#1D5EB#,16#1D5EB#),(16#1D5EC#,16#1D5EC#,16#1D5EC#),(16#1D5ED#,16#1D5ED#,16#1D5ED#),
      (16#1D5EE#,16#1D5EE#,16#1D5EE#),(16#1D5EF#,16#1D5EF#,16#1D5EF#),(16#1D5F0#,16#1D5F0#,16#1D5F0#),
      (16#1D5F1#,16#1D5F1#,16#1D5F1#),(16#1D5F2#,16#1D5F2#,16#1D5F2#),(16#1D5F3#,16#1D5F3#,16#1D5F3#),
      (16#1D5F4#,16#1D5F4#,16#1D5F4#),(16#1D5F5#,16#1D5F5#,16#1D5F5#),(16#1D5F6#,16#1D5F6#,16#1D5F6#),
      (16#1D5F7#,16#1D5F7#,16#1D5F7#),(16#1D5F8#,16#1D5F8#,16#1D5F8#),(16#1D5F9#,16#1D5F9#,16#1D5F9#),
      (16#1D5FA#,16#1D5FA#,16#1D5FA#),(16#1D5FB#,16#1D5FB#,16#1D5FB#),(16#1D5FC#,16#1D5FC#,16#1D5FC#),
      (16#1D5FD#,16#1D5FD#,16#1D5FD#),(16#1D5FE#,16#1D5FE#,16#1D5FE#),(16#1D5FF#,16#1D5FF#,16#1D5FF#),
      (16#1D600#,16#1D600#,16#1D600#),(16#1D601#,16#1D601#,16#1D601#),(16#1D602#,16#1D602#,16#1D602#),
      (16#1D603#,16#1D603#,16#1D603#),(16#1D604#,16#1D604#,16#1D604#),(16#1D605#,16#1D605#,16#1D605#),
      (16#1D606#,16#1D606#,16#1D606#),(16#1D607#,16#1D607#,16#1D607#),(16#1D608#,16#1D608#,16#1D608#),
      (16#1D609#,16#1D609#,16#1D609#),(16#1D60A#,16#1D60A#,16#1D60A#),(16#1D60B#,16#1D60B#,16#1D60B#),
      (16#1D60C#,16#1D60C#,16#1D60C#),(16#1D60D#,16#1D60D#,16#1D60D#),(16#1D60E#,16#1D60E#,16#1D60E#),
      (16#1D60F#,16#1D60F#,16#1D60F#),(16#1D610#,16#1D610#,16#1D610#),(16#1D611#,16#1D611#,16#1D611#),
      (16#1D612#,16#1D612#,16#1D612#),(16#1D613#,16#1D613#,16#1D613#),(16#1D614#,16#1D614#,16#1D614#),
      (16#1D615#,16#1D615#,16#1D615#),(16#1D616#,16#1D616#,16#1D616#),(16#1D617#,16#1D617#,16#1D617#),
      (16#1D618#,16#1D618#,16#1D618#),(16#1D619#,16#1D619#,16#1D619#),(16#1D61A#,16#1D61A#,16#1D61A#),
      (16#1D61B#,16#1D61B#,16#1D61B#),(16#1D61C#,16#1D61C#,16#1D61C#),(16#1D61D#,16#1D61D#,16#1D61D#),
      (16#1D61E#,16#1D61E#,16#1D61E#),(16#1D61F#,16#1D61F#,16#1D61F#),(16#1D620#,16#1D620#,16#1D620#),
      (16#1D621#,16#1D621#,16#1D621#),(16#1D622#,16#1D622#,16#1D622#),(16#1D623#,16#1D623#,16#1D623#),
      (16#1D624#,16#1D624#,16#1D624#),(16#1D625#,16#1D625#,16#1D625#),(16#1D626#,16#1D626#,16#1D626#),
      (16#1D627#,16#1D627#,16#1D627#),(16#1D628#,16#1D628#,16#1D628#),(16#1D629#,16#1D629#,16#1D629#),
      (16#1D62A#,16#1D62A#,16#1D62A#),(16#1D62B#,16#1D62B#,16#1D62B#),(16#1D62C#,16#1D62C#,16#1D62C#),
      (16#1D62D#,16#1D62D#,16#1D62D#),(16#1D62E#,16#1D62E#,16#1D62E#),(16#1D62F#,16#1D62F#,16#1D62F#),
      (16#1D630#,16#1D630#,16#1D630#),(16#1D631#,16#1D631#,16#1D631#),(16#1D632#,16#1D632#,16#1D632#),
      (16#1D633#,16#1D633#,16#1D633#),(16#1D634#,16#1D634#,16#1D634#),(16#1D635#,16#1D635#,16#1D635#),
      (16#1D636#,16#1D636#,16#1D636#),(16#1D637#,16#1D637#,16#1D637#),(16#1D638#,16#1D638#,16#1D638#),
      (16#1D639#,16#1D639#,16#1D639#),(16#1D63A#,16#1D63A#,16#1D63A#),(16#1D63B#,16#1D63B#,16#1D63B#),
      (16#1D63C#,16#1D63C#,16#1D63C#),(16#1D63D#,16#1D63D#,16#1D63D#),(16#1D63E#,16#1D63E#,16#1D63E#),
      (16#1D63F#,16#1D63F#,16#1D63F#),(16#1D640#,16#1D640#,16#1D640#),(16#1D641#,16#1D641#,16#1D641#),
      (16#1D642#,16#1D642#,16#1D642#),(16#1D643#,16#1D643#,16#1D643#),(16#1D644#,16#1D644#,16#1D644#),
      (16#1D645#,16#1D645#,16#1D645#),(16#1D646#,16#1D646#,16#1D646#),(16#1D647#,16#1D647#,16#1D647#),
      (16#1D648#,16#1D648#,16#1D648#),(16#1D649#,16#1D649#,16#1D649#),(16#1D64A#,16#1D64A#,16#1D64A#),
      (16#1D64B#,16#1D64B#,16#1D64B#),(16#1D64C#,16#1D64C#,16#1D64C#),(16#1D64D#,16#1D64D#,16#1D64D#),
      (16#1D64E#,16#1D64E#,16#1D64E#),(16#1D64F#,16#1D64F#,16#1D64F#),(16#1D650#,16#1D650#,16#1D650#),
      (16#1D651#,16#1D651#,16#1D651#),(16#1D652#,16#1D652#,16#1D652#),(16#1D653#,16#1D653#,16#1D653#),
      (16#1D654#,16#1D654#,16#1D654#),(16#1D655#,16#1D655#,16#1D655#),(16#1D656#,16#1D656#,16#1D656#),
      (16#1D657#,16#1D657#,16#1D657#),(16#1D658#,16#1D658#,16#1D658#),(16#1D659#,16#1D659#,16#1D659#),
      (16#1D65A#,16#1D65A#,16#1D65A#),(16#1D65B#,16#1D65B#,16#1D65B#),(16#1D65C#,16#1D65C#,16#1D65C#),
      (16#1D65D#,16#1D65D#,16#1D65D#),(16#1D65E#,16#1D65E#,16#1D65E#),(16#1D65F#,16#1D65F#,16#1D65F#),
      (16#1D660#,16#1D660#,16#1D660#),(16#1D661#,16#1D661#,16#1D661#),(16#1D662#,16#1D662#,16#1D662#),
      (16#1D663#,16#1D663#,16#1D663#),(16#1D664#,16#1D664#,16#1D664#),(16#1D665#,16#1D665#,16#1D665#),
      (16#1D666#,16#1D666#,16#1D666#),(16#1D667#,16#1D667#,16#1D667#),(16#1D668#,16#1D668#,16#1D668#),
      (16#1D669#,16#1D669#,16#1D669#),(16#1D66A#,16#1D66A#,16#1D66A#),(16#1D66B#,16#1D66B#,16#1D66B#),
      (16#1D66C#,16#1D66C#,16#1D66C#),(16#1D66D#,16#1D66D#,16#1D66D#),(16#1D66E#,16#1D66E#,16#1D66E#),
      (16#1D66F#,16#1D66F#,16#1D66F#),(16#1D670#,16#1D670#,16#1D670#),(16#1D671#,16#1D671#,16#1D671#),
      (16#1D672#,16#1D672#,16#1D672#),(16#1D673#,16#1D673#,16#1D673#),(16#1D674#,16#1D674#,16#1D674#),
      (16#1D675#,16#1D675#,16#1D675#),(16#1D676#,16#1D676#,16#1D676#),(16#1D677#,16#1D677#,16#1D677#),
      (16#1D678#,16#1D678#,16#1D678#),(16#1D679#,16#1D679#,16#1D679#),(16#1D67A#,16#1D67A#,16#1D67A#),
      (16#1D67B#,16#1D67B#,16#1D67B#),(16#1D67C#,16#1D67C#,16#1D67C#),(16#1D67D#,16#1D67D#,16#1D67D#),
      (16#1D67E#,16#1D67E#,16#1D67E#),(16#1D67F#,16#1D67F#,16#1D67F#),(16#1D680#,16#1D680#,16#1D680#),
      (16#1D681#,16#1D681#,16#1D681#),(16#1D682#,16#1D682#,16#1D682#),(16#1D683#,16#1D683#,16#1D683#),
      (16#1D684#,16#1D684#,16#1D684#),(16#1D685#,16#1D685#,16#1D685#),(16#1D686#,16#1D686#,16#1D686#),
      (16#1D687#,16#1D687#,16#1D687#),(16#1D688#,16#1D688#,16#1D688#),(16#1D689#,16#1D689#,16#1D689#),
      (16#1D68A#,16#1D68A#,16#1D68A#),(16#1D68B#,16#1D68B#,16#1D68B#),(16#1D68C#,16#1D68C#,16#1D68C#),
      (16#1D68D#,16#1D68D#,16#1D68D#),(16#1D68E#,16#1D68E#,16#1D68E#),(16#1D68F#,16#1D68F#,16#1D68F#),
      (16#1D690#,16#1D690#,16#1D690#),(16#1D691#,16#1D691#,16#1D691#),(16#1D692#,16#1D692#,16#1D692#),
      (16#1D693#,16#1D693#,16#1D693#),(16#1D694#,16#1D694#,16#1D694#),(16#1D695#,16#1D695#,16#1D695#),
      (16#1D696#,16#1D696#,16#1D696#),(16#1D697#,16#1D697#,16#1D697#),(16#1D698#,16#1D698#,16#1D698#),
      (16#1D699#,16#1D699#,16#1D699#),(16#1D69A#,16#1D69A#,16#1D69A#),(16#1D69B#,16#1D69B#,16#1D69B#),
      (16#1D69C#,16#1D69C#,16#1D69C#),(16#1D69D#,16#1D69D#,16#1D69D#),(16#1D69E#,16#1D69E#,16#1D69E#),
      (16#1D69F#,16#1D69F#,16#1D69F#),(16#1D6A0#,16#1D6A0#,16#1D6A0#),(16#1D6A1#,16#1D6A1#,16#1D6A1#),
      (16#1D6A2#,16#1D6A2#,16#1D6A2#),(16#1D6A3#,16#1D6A3#,16#1D6A3#),(16#1D6A4#,16#1D6A4#,16#1D6A4#),
      (16#1D6A5#,16#1D6A5#,16#1D6A5#),(16#1D6A8#,16#1D6A8#,16#1D6A8#),(16#1D6A9#,16#1D6A9#,16#1D6A9#),
      (16#1D6AA#,16#1D6AA#,16#1D6AA#),(16#1D6AB#,16#1D6AB#,16#1D6AB#),(16#1D6AC#,16#1D6AC#,16#1D6AC#),
      (16#1D6AD#,16#1D6AD#,16#1D6AD#),(16#1D6AE#,16#1D6AE#,16#1D6AE#),(16#1D6AF#,16#1D6AF#,16#1D6AF#),
      (16#1D6B0#,16#1D6B0#,16#1D6B0#),(16#1D6B1#,16#1D6B1#,16#1D6B1#),(16#1D6B2#,16#1D6B2#,16#1D6B2#),
      (16#1D6B3#,16#1D6B3#,16#1D6B3#),(16#1D6B4#,16#1D6B4#,16#1D6B4#),(16#1D6B5#,16#1D6B5#,16#1D6B5#),
      (16#1D6B6#,16#1D6B6#,16#1D6B6#),(16#1D6B7#,16#1D6B7#,16#1D6B7#),(16#1D6B8#,16#1D6B8#,16#1D6B8#),
      (16#1D6B9#,16#1D6B9#,16#1D6B9#),(16#1D6BA#,16#1D6BA#,16#1D6BA#),(16#1D6BB#,16#1D6BB#,16#1D6BB#),
      (16#1D6BC#,16#1D6BC#,16#1D6BC#),(16#1D6BD#,16#1D6BD#,16#1D6BD#),(16#1D6BE#,16#1D6BE#,16#1D6BE#),
      (16#1D6BF#,16#1D6BF#,16#1D6BF#),(16#1D6C0#,16#1D6C0#,16#1D6C0#),(16#1D6C2#,16#1D6C2#,16#1D6C2#),
      (16#1D6C3#,16#1D6C3#,16#1D6C3#),(16#1D6C4#,16#1D6C4#,16#1D6C4#),(16#1D6C5#,16#1D6C5#,16#1D6C5#),
      (16#1D6C6#,16#1D6C6#,16#1D6C6#),(16#1D6C7#,16#1D6C7#,16#1D6C7#),(16#1D6C8#,16#1D6C8#,16#1D6C8#),
      (16#1D6C9#,16#1D6C9#,16#1D6C9#),(16#1D6CA#,16#1D6CA#,16#1D6CA#),(16#1D6CB#,16#1D6CB#,16#1D6CB#),
      (16#1D6CC#,16#1D6CC#,16#1D6CC#),(16#1D6CD#,16#1D6CD#,16#1D6CD#),(16#1D6CE#,16#1D6CE#,16#1D6CE#),
      (16#1D6CF#,16#1D6CF#,16#1D6CF#),(16#1D6D0#,16#1D6D0#,16#1D6D0#),(16#1D6D1#,16#1D6D1#,16#1D6D1#),
      (16#1D6D2#,16#1D6D2#,16#1D6D2#),(16#1D6D3#,16#1D6D3#,16#1D6D3#),(16#1D6D4#,16#1D6D4#,16#1D6D4#),
      (16#1D6D5#,16#1D6D5#,16#1D6D5#),(16#1D6D6#,16#1D6D6#,16#1D6D6#),(16#1D6D7#,16#1D6D7#,16#1D6D7#),
      (16#1D6D8#,16#1D6D8#,16#1D6D8#),(16#1D6D9#,16#1D6D9#,16#1D6D9#),(16#1D6DA#,16#1D6DA#,16#1D6DA#),
      (16#1D6DC#,16#1D6DC#,16#1D6DC#),(16#1D6DD#,16#1D6DD#,16#1D6DD#),(16#1D6DE#,16#1D6DE#,16#1D6DE#),
      (16#1D6DF#,16#1D6DF#,16#1D6DF#),(16#1D6E0#,16#1D6E0#,16#1D6E0#),(16#1D6E1#,16#1D6E1#,16#1D6E1#),
      (16#1D6E2#,16#1D6E2#,16#1D6E2#),(16#1D6E3#,16#1D6E3#,16#1D6E3#),(16#1D6E4#,16#1D6E4#,16#1D6E4#),
      (16#1D6E5#,16#1D6E5#,16#1D6E5#),(16#1D6E6#,16#1D6E6#,16#1D6E6#),(16#1D6E7#,16#1D6E7#,16#1D6E7#),
      (16#1D6E8#,16#1D6E8#,16#1D6E8#),(16#1D6E9#,16#1D6E9#,16#1D6E9#),(16#1D6EA#,16#1D6EA#,16#1D6EA#),
      (16#1D6EB#,16#1D6EB#,16#1D6EB#),(16#1D6EC#,16#1D6EC#,16#1D6EC#),(16#1D6ED#,16#1D6ED#,16#1D6ED#),
      (16#1D6EE#,16#1D6EE#,16#1D6EE#),(16#1D6EF#,16#1D6EF#,16#1D6EF#),(16#1D6F0#,16#1D6F0#,16#1D6F0#),
      (16#1D6F1#,16#1D6F1#,16#1D6F1#),(16#1D6F2#,16#1D6F2#,16#1D6F2#),(16#1D6F3#,16#1D6F3#,16#1D6F3#),
      (16#1D6F4#,16#1D6F4#,16#1D6F4#),(16#1D6F5#,16#1D6F5#,16#1D6F5#),(16#1D6F6#,16#1D6F6#,16#1D6F6#),
      (16#1D6F7#,16#1D6F7#,16#1D6F7#),(16#1D6F8#,16#1D6F8#,16#1D6F8#),(16#1D6F9#,16#1D6F9#,16#1D6F9#),
      (16#1D6FA#,16#1D6FA#,16#1D6FA#),(16#1D6FC#,16#1D6FC#,16#1D6FC#),(16#1D6FD#,16#1D6FD#,16#1D6FD#),
      (16#1D6FE#,16#1D6FE#,16#1D6FE#),(16#1D6FF#,16#1D6FF#,16#1D6FF#),(16#1D700#,16#1D700#,16#1D700#),
      (16#1D701#,16#1D701#,16#1D701#),(16#1D702#,16#1D702#,16#1D702#),(16#1D703#,16#1D703#,16#1D703#),
      (16#1D704#,16#1D704#,16#1D704#),(16#1D705#,16#1D705#,16#1D705#),(16#1D706#,16#1D706#,16#1D706#),
      (16#1D707#,16#1D707#,16#1D707#),(16#1D708#,16#1D708#,16#1D708#),(16#1D709#,16#1D709#,16#1D709#),
      (16#1D70A#,16#1D70A#,16#1D70A#),(16#1D70B#,16#1D70B#,16#1D70B#),(16#1D70C#,16#1D70C#,16#1D70C#),
      (16#1D70D#,16#1D70D#,16#1D70D#),(16#1D70E#,16#1D70E#,16#1D70E#),(16#1D70F#,16#1D70F#,16#1D70F#),
      (16#1D710#,16#1D710#,16#1D710#),(16#1D711#,16#1D711#,16#1D711#),(16#1D712#,16#1D712#,16#1D712#),
      (16#1D713#,16#1D713#,16#1D713#),(16#1D714#,16#1D714#,16#1D714#),(16#1D716#,16#1D716#,16#1D716#),
      (16#1D717#,16#1D717#,16#1D717#),(16#1D718#,16#1D718#,16#1D718#),(16#1D719#,16#1D719#,16#1D719#),
      (16#1D71A#,16#1D71A#,16#1D71A#),(16#1D71B#,16#1D71B#,16#1D71B#),(16#1D71C#,16#1D71C#,16#1D71C#),
      (16#1D71D#,16#1D71D#,16#1D71D#),(16#1D71E#,16#1D71E#,16#1D71E#),(16#1D71F#,16#1D71F#,16#1D71F#),
      (16#1D720#,16#1D720#,16#1D720#),(16#1D721#,16#1D721#,16#1D721#),(16#1D722#,16#1D722#,16#1D722#),
      (16#1D723#,16#1D723#,16#1D723#),(16#1D724#,16#1D724#,16#1D724#),(16#1D725#,16#1D725#,16#1D725#),
      (16#1D726#,16#1D726#,16#1D726#),(16#1D727#,16#1D727#,16#1D727#),(16#1D728#,16#1D728#,16#1D728#),
      (16#1D729#,16#1D729#,16#1D729#),(16#1D72A#,16#1D72A#,16#1D72A#),(16#1D72B#,16#1D72B#,16#1D72B#),
      (16#1D72C#,16#1D72C#,16#1D72C#),(16#1D72D#,16#1D72D#,16#1D72D#),(16#1D72E#,16#1D72E#,16#1D72E#),
      (16#1D72F#,16#1D72F#,16#1D72F#),(16#1D730#,16#1D730#,16#1D730#),(16#1D731#,16#1D731#,16#1D731#),
      (16#1D732#,16#1D732#,16#1D732#),(16#1D733#,16#1D733#,16#1D733#),(16#1D734#,16#1D734#,16#1D734#),
      (16#1D736#,16#1D736#,16#1D736#),(16#1D737#,16#1D737#,16#1D737#),(16#1D738#,16#1D738#,16#1D738#),
      (16#1D739#,16#1D739#,16#1D739#),(16#1D73A#,16#1D73A#,16#1D73A#),(16#1D73B#,16#1D73B#,16#1D73B#),
      (16#1D73C#,16#1D73C#,16#1D73C#),(16#1D73D#,16#1D73D#,16#1D73D#),(16#1D73E#,16#1D73E#,16#1D73E#),
      (16#1D73F#,16#1D73F#,16#1D73F#),(16#1D740#,16#1D740#,16#1D740#),(16#1D741#,16#1D741#,16#1D741#),
      (16#1D742#,16#1D742#,16#1D742#),(16#1D743#,16#1D743#,16#1D743#),(16#1D744#,16#1D744#,16#1D744#),
      (16#1D745#,16#1D745#,16#1D745#),(16#1D746#,16#1D746#,16#1D746#),(16#1D747#,16#1D747#,16#1D747#),
      (16#1D748#,16#1D748#,16#1D748#),(16#1D749#,16#1D749#,16#1D749#),(16#1D74A#,16#1D74A#,16#1D74A#),
      (16#1D74B#,16#1D74B#,16#1D74B#),(16#1D74C#,16#1D74C#,16#1D74C#),(16#1D74D#,16#1D74D#,16#1D74D#),
      (16#1D74E#,16#1D74E#,16#1D74E#),(16#1D750#,16#1D750#,16#1D750#),(16#1D751#,16#1D751#,16#1D751#),
      (16#1D752#,16#1D752#,16#1D752#),(16#1D753#,16#1D753#,16#1D753#),(16#1D754#,16#1D754#,16#1D754#),
      (16#1D755#,16#1D755#,16#1D755#),(16#1D756#,16#1D756#,16#1D756#),(16#1D757#,16#1D757#,16#1D757#),
      (16#1D758#,16#1D758#,16#1D758#),(16#1D759#,16#1D759#,16#1D759#),(16#1D75A#,16#1D75A#,16#1D75A#),
      (16#1D75B#,16#1D75B#,16#1D75B#),(16#1D75C#,16#1D75C#,16#1D75C#),(16#1D75D#,16#1D75D#,16#1D75D#),
      (16#1D75E#,16#1D75E#,16#1D75E#),(16#1D75F#,16#1D75F#,16#1D75F#),(16#1D760#,16#1D760#,16#1D760#),
      (16#1D761#,16#1D761#,16#1D761#),(16#1D762#,16#1D762#,16#1D762#),(16#1D763#,16#1D763#,16#1D763#),
      (16#1D764#,16#1D764#,16#1D764#),(16#1D765#,16#1D765#,16#1D765#),(16#1D766#,16#1D766#,16#1D766#),
      (16#1D767#,16#1D767#,16#1D767#),(16#1D768#,16#1D768#,16#1D768#),(16#1D769#,16#1D769#,16#1D769#),
      (16#1D76A#,16#1D76A#,16#1D76A#),(16#1D76B#,16#1D76B#,16#1D76B#),(16#1D76C#,16#1D76C#,16#1D76C#),
      (16#1D76D#,16#1D76D#,16#1D76D#),(16#1D76E#,16#1D76E#,16#1D76E#),(16#1D770#,16#1D770#,16#1D770#),
      (16#1D771#,16#1D771#,16#1D771#),(16#1D772#,16#1D772#,16#1D772#),(16#1D773#,16#1D773#,16#1D773#),
      (16#1D774#,16#1D774#,16#1D774#),(16#1D775#,16#1D775#,16#1D775#),(16#1D776#,16#1D776#,16#1D776#),
      (16#1D777#,16#1D777#,16#1D777#),(16#1D778#,16#1D778#,16#1D778#),(16#1D779#,16#1D779#,16#1D779#),
      (16#1D77A#,16#1D77A#,16#1D77A#),(16#1D77B#,16#1D77B#,16#1D77B#),(16#1D77C#,16#1D77C#,16#1D77C#),
      (16#1D77D#,16#1D77D#,16#1D77D#),(16#1D77E#,16#1D77E#,16#1D77E#),(16#1D77F#,16#1D77F#,16#1D77F#),
      (16#1D780#,16#1D780#,16#1D780#),(16#1D781#,16#1D781#,16#1D781#),(16#1D782#,16#1D782#,16#1D782#),
      (16#1D783#,16#1D783#,16#1D783#),(16#1D784#,16#1D784#,16#1D784#),(16#1D785#,16#1D785#,16#1D785#),
      (16#1D786#,16#1D786#,16#1D786#),(16#1D787#,16#1D787#,16#1D787#),(16#1D788#,16#1D788#,16#1D788#),
      (16#1D78A#,16#1D78A#,16#1D78A#),(16#1D78B#,16#1D78B#,16#1D78B#),(16#1D78C#,16#1D78C#,16#1D78C#),
      (16#1D78D#,16#1D78D#,16#1D78D#),(16#1D78E#,16#1D78E#,16#1D78E#),(16#1D78F#,16#1D78F#,16#1D78F#),
      (16#1D790#,16#1D790#,16#1D790#),(16#1D791#,16#1D791#,16#1D791#),(16#1D792#,16#1D792#,16#1D792#),
      (16#1D793#,16#1D793#,16#1D793#),(16#1D794#,16#1D794#,16#1D794#),(16#1D795#,16#1D795#,16#1D795#),
      (16#1D796#,16#1D796#,16#1D796#),(16#1D797#,16#1D797#,16#1D797#),(16#1D798#,16#1D798#,16#1D798#),
      (16#1D799#,16#1D799#,16#1D799#),(16#1D79A#,16#1D79A#,16#1D79A#),(16#1D79B#,16#1D79B#,16#1D79B#),
      (16#1D79C#,16#1D79C#,16#1D79C#),(16#1D79D#,16#1D79D#,16#1D79D#),(16#1D79E#,16#1D79E#,16#1D79E#),
      (16#1D79F#,16#1D79F#,16#1D79F#),(16#1D7A0#,16#1D7A0#,16#1D7A0#),(16#1D7A1#,16#1D7A1#,16#1D7A1#),
      (16#1D7A2#,16#1D7A2#,16#1D7A2#),(16#1D7A3#,16#1D7A3#,16#1D7A3#),(16#1D7A4#,16#1D7A4#,16#1D7A4#),
      (16#1D7A5#,16#1D7A5#,16#1D7A5#),(16#1D7A6#,16#1D7A6#,16#1D7A6#),(16#1D7A7#,16#1D7A7#,16#1D7A7#),
      (16#1D7A8#,16#1D7A8#,16#1D7A8#),(16#1D7AA#,16#1D7AA#,16#1D7AA#),(16#1D7AB#,16#1D7AB#,16#1D7AB#),
      (16#1D7AC#,16#1D7AC#,16#1D7AC#),(16#1D7AD#,16#1D7AD#,16#1D7AD#),(16#1D7AE#,16#1D7AE#,16#1D7AE#),
      (16#1D7AF#,16#1D7AF#,16#1D7AF#),(16#1D7B0#,16#1D7B0#,16#1D7B0#),(16#1D7B1#,16#1D7B1#,16#1D7B1#),
      (16#1D7B2#,16#1D7B2#,16#1D7B2#),(16#1D7B3#,16#1D7B3#,16#1D7B3#),(16#1D7B4#,16#1D7B4#,16#1D7B4#),
      (16#1D7B5#,16#1D7B5#,16#1D7B5#),(16#1D7B6#,16#1D7B6#,16#1D7B6#),(16#1D7B7#,16#1D7B7#,16#1D7B7#),
      (16#1D7B8#,16#1D7B8#,16#1D7B8#),(16#1D7B9#,16#1D7B9#,16#1D7B9#),(16#1D7BA#,16#1D7BA#,16#1D7BA#),
      (16#1D7BB#,16#1D7BB#,16#1D7BB#),(16#1D7BC#,16#1D7BC#,16#1D7BC#),(16#1D7BD#,16#1D7BD#,16#1D7BD#),
      (16#1D7BE#,16#1D7BE#,16#1D7BE#),(16#1D7BF#,16#1D7BF#,16#1D7BF#),(16#1D7C0#,16#1D7C0#,16#1D7C0#),
      (16#1D7C1#,16#1D7C1#,16#1D7C1#),(16#1D7C2#,16#1D7C2#,16#1D7C2#),(16#1D7C4#,16#1D7C4#,16#1D7C4#),
      (16#1D7C5#,16#1D7C5#,16#1D7C5#),(16#1D7C6#,16#1D7C6#,16#1D7C6#),(16#1D7C7#,16#1D7C7#,16#1D7C7#),
      (16#1D7C8#,16#1D7C8#,16#1D7C8#),(16#1D7C9#,16#1D7C9#,16#1D7C9#),(16#1D7CA#,16#1D7CA#,16#1D7CA#),
      (16#1D7CB#,16#1D7CB#,16#1D7CB#)
   );

   procedure Find
             (  Code  : UTF8_Code_Point;
                Found : out Boolean;
                Index : in out Categorization_Index
             )  is
      From : Categorization_Index := Mapping'First;
      To   : Categorization_Index := Mapping'Last;
      This : Categorization_Index;
      Current : Code_Point;
   begin
      loop
         This := (From + To) / 2;
         Current := Mapping (This).Code;
         if Current = Code then
            Found := True;
            Index := This;
            return;
         elsif Current > Code then
            exit when This = From;
            To := This - 1;
         else
            exit when This = To;
            From := This + 1;
         end if;
      end loop;
      Found := False;
   end Find;

   function Has_Case (Value : UTF8_Code_Point) return Boolean is
      Index : Categorization_Index := Categorization_Index'First;
      Found : Boolean;
   begin
      Find (Value, Found, Index);
      if Found then
         return
         (  Mapping (Index).Lower = Value
         or else
            Mapping (Index).Upper = Value
         );
      else
         return False;
      end if;
   end Has_Case;

   function Is_Lowercase (Value : UTF8_Code_Point) return Boolean is
      Index : Categorization_Index := Categorization_Index'First;
      Found : Boolean;
   begin
      Find (Value, Found, Index);
      if Found then
         return Mapping (Index).Lower = Value;
      else
         return False;
      end if;
   end Is_Lowercase;

   function Is_Uppercase (Value : UTF8_Code_Point) return Boolean is
      Index : Categorization_Index := Categorization_Index'First;
      Found : Boolean;
   begin
      Find (Value, Found, Index);
      if Found then
         return Mapping (Index).Upper = Value;
      else
         return False;
      end if;
   end Is_Uppercase;

   function To_Lowercase (Value : UTF8_Code_Point)
      return UTF8_Code_Point is
      Index : Categorization_Index := Categorization_Index'First;
      Found : Boolean;
   begin
      Find (Value, Found, Index);
      if Found then
         return Mapping (Index).Lower;
      else
         return Value;
      end if;
   end To_Lowercase;

   function To_Lowercase (Value : String) return String is
      Result : String (1..Value'Length);
      From   : Integer := Value'First;
      To     : Integer := 1;
      Code   : UTF8_Code_Point;
   begin
      while From <= Value'Last loop
         Get (Value, From, Code);
         Code := To_Lowercase (Code);
         Put (Result, To, Code);
      end loop;
      return Result (1..To - 1);
   exception
      when Layout_Error =>
         if From > Value'Last then
            return Result (1..To - 1) & Image (Code);
         else
            return
            (  Result (1..To - 1)
            &  Image (Code)
            &  To_Lowercase (Value (From..Value'Last))
            );
         end if;
   end To_Lowercase;

   function To_Uppercase (Value : UTF8_Code_Point)
      return UTF8_Code_Point is
      Index : Categorization_Index := Categorization_Index'First;
      Found : Boolean;
   begin
      Find (Value, Found, Index);
      if Found then
         return Mapping (Index).Upper;
      else
         return Value;
      end if;
   end To_Uppercase;

   function To_Uppercase (Value : String) return String is
      Result : String (1..Value'Length);
      From   : Integer := Value'First;
      To     : Integer := 1;
      Code   : UTF8_Code_Point;
   begin
      while From <= Value'Last loop
         Get (Value, From, Code);
         Code := To_Uppercase (Code);
         Put (Result, To, Code);
      end loop;
      return Result (1..To - 1);
   exception
      when Layout_Error =>
         if From > Value'Last then
            return Result (1..To - 1) & Image (Code);
         else
            return
            (  Result (1..To - 1)
            &  Image (Code)
            &  To_Uppercase (Value (From..Value'Last))
            );
         end if;
   end To_Uppercase;

end Strings_Edit.UTF8.Mapping;
