#include "global.h"
#include "enum.h"

#include "snowcp.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/stat.h>
#include <unistd.h>

#include "glib.h"

// 関数プロトタイプ
void option_get();
void option_set();
static void clean(char stdin_buf[]);

/*******************************************************************************
設定をファイルから読み込む
*******************************************************************************/
void option_get()
{
	char buf[PATH_LEN];
	FILE *config = fopen(config_file, "r");
	while(fgets(buf, PATH_LEN, config) != NULL)
	{
		switch(buf[0])
		{
		// SHA1SUM
		case '1':
			C = ONE;
			if(buf[2] == '1')
			{
				compare_mode = 1;
			}
			else if(buf[2] == '2')
			{
				compare_mode = 2;
			}
			else
			{
				puts("設定ファイルが正しくありません");
				exit(-1);
			}
			break;
		// MD5SUM
		case '5':
			C = FIVE;
			if(buf[2] == '1')
			{
				compare_mode = 1;
			}
			else if(buf[2] == '2')
			{
				compare_mode = 2;
			}
			else
			{
				puts("設定ファイルが正しくありません");
				exit(-1);
			}
			break;
		// バッファサイズを指定
		case 'b':
			B = BUFFER;
			{
				// 改行文字をヌル文字に
				buf[strlen(buf) - 1] = '\0';
				// csv切り出し
				char *cp = strtok(buf, "," );
				cp = strtok(NULL, "," );
				if(cp != NULL)
				{
					char *endptr = NULL;
					buffer_size = (int)strtol(cp, &endptr, 10);
					buffer_size = 1024 * 1024 * buffer_size;
					if(buffer_size <= 0)
					{
						puts("バッファサイズが0以下です");
						exit(-1);
					}
				}
				else
				{
					puts("設定ファイルが正しくありません");
					exit(-1);
				}
			}
			break;
		// コンペア
		case 'c':
			C = COMPARE;
			if(buf[2] == '1')
			{
				compare_mode = 1;
			}
			else if(buf[2] == '2')
			{
				compare_mode = 2;
			}
			else
			{
				puts("設定ファイルが正しくありません");
				exit(-1);
			}
			break;
		// 上書き時に確認する
		case 'i':
			I = INTERACTIVE;
			N = NOT;
			break;
		// 非上書きモード
		case 'n':
			N = NOT_OVERWRITE;
			I = NOT;
			break;
		// 表示モード
		case 'v':
			V = VERBOS;
			break;
		}
	}
	fclose(config);
}

/*******************************************************************************
設定をファイルへ保存する
*******************************************************************************/
void option_set()
{
	if(g_file_test(config_dir, G_FILE_TEST_EXISTS) == FALSE)
		mkdir(config_dir, 0755);
	if(g_file_test(settings_dir, G_FILE_TEST_EXISTS) == FALSE)
		mkdir(settings_dir, 0755);

	char stdin_buf[PATH_LEN];
	char compare = '@';
	char compare_mode = '@';
	int b = 0;
	char i = '@';
	char n = '@';
	char v = '@';

	puts("設定の変更を行います");
	puts("");
	printf("ファイルコピー後にコンペアを行いますか?\n");
	printf("(y / n) :");
	fgets(stdin_buf, PATH_LEN, stdin);
	clean(stdin_buf);

	if(stdin_buf[0] == 'y')
	{
		puts("");
		puts("コンペアオプションを選んでください");
		puts("1 : SHA-1");
		puts("5 : MD5");
		puts("c : 単純比較");
		printf("(1 / 5 / c) :");

		fgets(stdin_buf, PATH_LEN, stdin);
		clean(stdin_buf);

		if((stdin_buf[0] == '1') || (stdin_buf[0] == '5') || (stdin_buf[0] == 'c'))
		{
			compare = stdin_buf[0];
			puts("");
			puts("コンペアモードを選んでください");
			puts("1 : コピー直後にコンペア");
			puts("2 : 全コピー終了後に一括コンペア");
			printf("(1 / 2) :");

			fgets(stdin_buf, PATH_LEN, stdin);
			clean(stdin_buf);

			if((stdin_buf[0] == '1') || (stdin_buf[0] == '2'))
			{
				compare_mode = stdin_buf[0];
			}
		}
	}

	puts("");
	printf("バッファのサイズを変更しますか?\n");
	printf("(y / n) :");
	fgets(stdin_buf, PATH_LEN, stdin);
	clean(stdin_buf);

	if(stdin_buf[0] == 'y')
	{
		puts("数値を入力してください(初期値は64です)");
		printf(" :");

		fgets(stdin_buf, PATH_LEN, stdin);
		clean(stdin_buf);

		char *endptr = NULL;
		b = (int)strtol(stdin_buf, &endptr, 10);

		if(b < 0)
			b = 0;
	}

	puts("");
	printf("ファイルを上書きする前に確認しますか?\n");
	printf("(y / n) :");
	fgets(stdin_buf, PATH_LEN, stdin);
	clean(stdin_buf);

	if(stdin_buf[0] == 'y')
	{
		i = stdin_buf[0];
	}
	else
	{
		puts("");
		printf("ファイルを上書きしないようにしますか?\n");
		printf("(y / n) :");
		fgets(stdin_buf, PATH_LEN, stdin);
		clean(stdin_buf);

		if(stdin_buf[0] == 'y')
		{
			n = stdin_buf[0];
		}
	}

	puts("");
	printf("コピー中のファイル名を表示しますか?\n");
	printf("(y / n) :");
	fgets(stdin_buf, PATH_LEN, stdin);
	clean(stdin_buf);

	if(stdin_buf[0] == 'y')
	{
		v = stdin_buf[0];
	}

	if(
		(compare_mode != '@') ||
		(b > 0) ||
		(i != '@') ||
		(n != '@') ||
		(v != '@')
	)
	{
		FILE *config = fopen(config_file, "w");
		fputs("!,1", config);
		fputs("\n", config);

		if(compare_mode != '@')
		{
			fputc(compare, config);
			fputs(",", config);
			fputc(compare_mode, config);
			fputs("\n", config);
		}
		if(b > 0)
		{
			char tmp[PATH_LEN];
			sprintf(tmp, "%d", b);
			fputs("b", config);
			fputs(",", config);
			fputs(tmp, config);
			fputs("\n", config);
		}
		if(i != '@')
		{
			fputs("i", config);
			fputs(",", config);
			fputs("NULL", config);
			fputs("\n", config);
		}
		if(n != '@')
		{
			fputs("n", config);
			fputs(",", config);
			fputs("NULL", config);
			fputs("\n", config);
		}
		if(v != '@')
		{
			fputs("v", config);
			fputs(",", config);
			fputs("NULL", config);
			fputs("\n", config);
		}
	fclose(config);
	}
	else
	{
		unlink(config_file);
	}
}

void clean(char stdin_buf[])
{
	// バッファチェック
	int a = 0;
	for(int i = 0; i < PATH_LEN; i++)
	{
		if(stdin_buf[i] == '\n')
		{
			a++;
			break;
		}
	}
	if(a == 0)
	{
		// 入力バッファの掃除
		while(getchar() != '\n');
	}
}
