{*********************************************************

 SlavaNap source code.

 Copyright 2001,2002 by SlavaNap development team
 Released under GNU General Public License

 Latest version is available at
 http://www.slavanap.org

**********************************************************

 Unit: Constants

 All constants are here

*********************************************************}
unit Constants;

interface

{$I Defines.pas}

const
  // Main
  SLAVANAP_TITLE        = 'SlavaNap';
  SLAVANAP_VERSION      = '2.4.1';
  SLAVANAP_BUILD        = '108';
  SLAVANAP_BUILD_DATE   = '24 January 2003';
  SLAVANAP_SHUUSEI      = '149';
  SLAVANAP_SHUUSEI_DATE = '24 July 2004';
  SLAVANAP_VERSION_SHORT = SLAVANAP_TITLE + ' ' + SLAVANAP_VERSION;
  SLAVANAP_FULL         = SLAVANAP_TITLE + ' ' + SLAVANAP_VERSION +
    ' (build ' + SLAVANAP_BUILD + ' shuusei ' + SLAVANAP_SHUUSEI +
    ' - ' + SLAVANAP_SHUUSEI_DATE + ')';
  SLAVANAP_BUILD_TEXT = 'Build ' + SLAVANAP_BUILD +
    ' (' + SLAVANAP_BUILD_DATE + ')';
  SLAVANAP_VERSION_MOTD = SLAVANAP_TITLE + ' ' + SLAVANAP_VERSION + '.' +
    SLAVANAP_BUILD + '.' + SLAVANAP_SHUUSEI + ' ' + '{o[W';
  NET_BUILD             = '19';
  // Limits
  MAX_USER_NAME         = 19;
  MIN_USER_NAME         = 1;
  MAX_CHANNEL_NAME      = 32;
  Max_Software          = 32;
  Max_Software_Index    = 1000;
  Max_Custom_Block      = 31;
  MAX_CUSTOM_ALLOW      = 31;
  Def_Channel_Limit     = 100;
  Def_Ban_Timeout       = (31 * 24 * 60 * 60);
  Max_Announcement      = 63;
  MAX_LOGINIM           = 63;
  // Sockets
  MAX_LISTEN_SOCKET     = 7; // Maximum listen sockets
  MAX_LISTEN_TRAPSOCKET = 7; // Maximum listen trapsockets
  DEF_LISTEN_PORT       = 8888; // 3456; // Default port for listening
  DEF_LISTEN_PORTS      = '3456 8888';
  RECV_BUF_SIZE_MIN     = 128;
  RECV_BUF_SIZE_DEF     = 256;
  RECV_BUF_SIZE_MAX     = 8192;
  RECV_BUF_SIZE_SERVER  = 4096;
  MAX_SERVER_COMMAND    = 4092;
  MAX_SERVER_COMMANDS   = 32;
  MAX_COMMANDS_PER_CYCLE = 10; // Max received commands from one user
  MAX_COMMANDS_PER_CYCLE2 = 2;
    // Max received commands from one user when server is linking
  MAX_FLUSH_INDEX       = 4;
  MAX_SEND_DELAY        = 600000;
  MAX_LOGIN_TIMEOUT     = 60000;
  SERVER_LOGIN_DELAY    = 1500;
  SERVER_MAX_RECEIVE_RECURSE = 10;
  SERVER_SYNCH_TIMEOUT  = 60000; // Timeout for sync operations
  // Timeouts
  LASTSEARCH_TIMEOUT    = 15000; // Timeout for remote search
  LASTBROWSE_TIMEOUT    = 15000; // Timeout for remote browse
  MIN_SERVER_LAG = 2000;
    // Minimum server lag. if TimeOut is larger,
    // search and browse results are not returned
  BANDWIDTH_TIMEOUT     = 10000;
  BANDWIDTH_CYCLE       = 20;
  OUTPUT_CHECK_DELAY    = 10000; // Check sockets every 10 seconds
  CONSOLE_SYNC          = 300;
  // Other
  CONSOLE_PASS          = 'console_user';
  CONSOLE_PASS_OFFLINE  = 'remote_console';
  CONSOLE_SOFT          = 'SlavaNap Console';
  Null_Md5              = '00000000000000000000000000000000';
  KiloByte              = Int64(1024);
  MegaByte              = Int64(1048576);
  GigaByte              = Int64(1073741824);
  FileSizeLimit         = Int64(10737418240);
  Blocked_Bantime       = 86400; // 1 Day
  POSSIBLE_LEAK         = 10485760; // 10Mb
  EXPIRE_INVITATION     = 3600000;
  WINMX_DETECT_TIME     = 300000; // 5 Min.
  INITIAL_JOIN_DELAY    = 3000;
    // ܂ł̕Wx(~b, SmallInt^)
  DefaultCryptPass      = 'himitsu';
  Null_Ip               = '0';
  // Users list
  // USERS_INDEX_INC       = 47; // 46;
  USERS_NAME_ARRAY      = 503; // Ɠ`3{炢̑f
    // 2209; // 2116; // = USERS_INDEX_INC ^ 2
  USERS_IP_ARRAY        = 1 shl 8; // 1 shl 10 = 1024; K2nɂ邱ƁB
  // Sharing
  MAX_FILE_KEYWORDS     = 12; // Max keywords per file
  KEYWORD_LEN_MAX       = 24; // Maximum length of keyword (< 255)
  KEYWORD_LEN_MIN       = 2; // Minimum length of keyword. Should be '2' or more
  KEYWORD_MAX_SEARCH    = 8; // Maximum keywords in search query
  MAX_KEYWORD_ITEMS     = 8000;
    // Limit of items in one keyword. All items exceeding this limit
    // won't be skipped - This limit makes sence only if keyword was
    // selected as base keyword for search
  KEYWORDS_HASH_MAX     = 40; // DB_Keywords2ڂ̔z񐔂ɂȂ
  KEYWORDS_NOINDEX      = -1; // Unknown index in keywords list
  MIN_FILE_NAME         = 5;
    // minimum filename allowed to share (including directory and extension)
    //  - constant used internally. don't make it less than '5'
  KATAKANA =
    '               ' +
    '           ' +
    '          ' +
    '                    ' +
    '    ݳ  '; // SpJ^Ji̕R[hɔpJ^Jiׂf[^
  EISUUJI       =
    '0123456789       ' +
    'ABCDEFGHIJKLMNOPQRSTUVWXYZ       ' +
    'abcdefghijklmnopqrstuvwxyz';
    // Spp̕R[hɔppׂf[^
  HIRAGANA_D    = ''; // ɂȂЂ炪Ȃ2oCg
  HIRAGANA_H    = ''; // ɂȂЂ炪(ς҂Ղ؂)2oCg
  // Types of items in DB_Ips
  IP_MASK               = 1;
  IP_RESOLVE            = 2;
  IP_IP                 = 3;
  // Internal messages for Sync_Reply_List
  MSG_SR_LOG            = 1;
  MSG_SR_CONSOLELOG     = 2;
  MSG_SR_RESTART        = 3;
  MSG_SR_CONSOLEREPLY   = 4;
  // Internal messages for Cmd_List
  MSG_CMD_SAVEDATA      = 20001;
  MSG_CMD_LISTREGISTERED = 20002;
  MSG_CMD_REFRESHTYPES  = 20003;
  MSG_CMD_LISTUSERS     = 20004;
  MSG_CMD_SETNAPIGATORPASS = 20005;
  MSG_CMD_LISTSERVERS   = 20006;
  MSG_CMD_LISTCHANNELS  = 20007;
  MSG_CMD_LISTBANS      = 20008;
  MSG_CMD_LISTHOTLIST   = 20009;
  MSG_CMD_CHANNELPROPS  = 20012;
  MSG_CMD_RELOADCHMOTD  = 20013;
  MSG_CMD_WALLOP        = 20014;
  MSG_CMD_REFRESHLISTS  = 20015;
  MSG_CMD_ADDSERVER     = 20016;
  MSG_CMD_SERVERPROPS   = 20017;
  MSG_CMD_UPDATESERVERPROPS = 20018;
  MSG_CMD_RESETLOG      = 20019;
  MSG_CMD_SETCOMPRESS   = 20020;
  MSG_CMD_SETSTARTUP    = 20021;
  MSG_CMD_MOTDCHANGE    = 20022;
  MSG_CMD_GETMODE       = 20023;
  MSG_CMD_SAVESHARED    = 20024;
  MSG_CMD_SETDAGSTAPASS = 20025;
  // System
  MAX_RECURSE           = 7;
  // Software
  softNapster           = 0;
  softAudioGnome        = 1;
  softWinMXNormal       = 2;
  softGnomePlus         = 3;
  softAmster            = 4;
  softFileNavigator     = 5;
  softCQEX              = 6;
  softSunshineUN        = 7;
  softTekNap            = 8;
  softNap               = 9;
  softMacNap            = 10;
  softMP3Rage           = 11;
  softXNap              = 12;
  softSpotlight         = 13;
  softNFS               = 14;
  softDMNapster         = 15;
  softKNapster          = 16;
  softLopster           = 17;
  softRapigator         = 18;
  softSwaptor           = 19;
  softDagsta            = 20;
  softFloodster         = 21;
  softDrumbeat          = 22;
  softWinMXHidden       = 23;
  softMlDonkey          = 24;
  softNapigator         = 25;
  softOpennap           = 26;
  softNap08             = 27;
  softWinMXJap          = 28;
  softNapchan           = 29;
  softUtatane           = 30;
  Soft2get              = 31;
  softRegnessem         = 32;
  softMameya            = 33;
  softKazaam            = 34;
  softUnknown           = 35;

  // Users list Items
  UL_LEVEL              = 0;
  UL_SHARED             = 1;
  UL_SIZE               = 2;
  UL_AVERAGE            = 3;
  UL_SOFT               = 4;
  UL_SPEED              = 5;
  UL_IP                 = 6;
  UL_REMOTEHOST         = 7;
  UL_PORT               = 8;
  UL_TIME               = 9;
  UL_UP                 = 10;
  UL_DOWN               = 11;
  UL_TRANSFERS          = 12;
  UL_TUP                = 13;
  UL_TDOWN              = 14;
  UL_TTRANSFERS         = 15;
  UL_SERVER             = 16;
  UL_ULREQUESTS         = 17;
  UL_DLREQUESTS         = 18;
  UL_SEARCHREQS         = 19;
  UL_BLOCKFILES         = 20;
  UL_STATUS             = 21;

  MSG_SERVER_ERROR                      = 0;
  MSG_CLIENT_LOGIN                      = 2;
  MSG_SERVER_EMAIL                      = 3;
  MSG_CLIENT_VERSION_CHECK              = 4;
  MSG_CLIENT_LOGIN_REGISTER             = 6;
  MSG_CLIENT_REGISTER                   = 7;
  MSG_SERVER_REGISTER_OK                = 8;
  MSG_SERVER_REGISTER_FAIL              = 9;
  MSG_SERVER_BAD_NICK                   = 10;
  MSG_CLIENT_CHECK_PASS                 = 11;
  MSG_SERVER_PASS_OK                    = 12;
  MSG_SERVER_ECHO                       = 13;
  MSG_CLIENT_REGISTRATION_INFO          = 14;
  MSG_CLIENT_REGISTRATION_NEW           = 15;
  MSG_CLIENT_ADD_FILE                   = 100;
  MSG_CLIENT_REMOVE_FILE                = 102;
  MSG_CLIENT_UNSHARE_ALL                = 110;
  MSG_CLIENT_SEARCH                     = 200;
  MSG_SERVER_SEARCH_RESULT              = 201;
  MSG_SERVER_SEARCH_END                 = 202;
  MSG_CLIENT_DOWNLOAD                   = 203;
  MSG_SERVER_FILE_READY                 = 204;
  MSG_CLIENT_PRIVMSG                    = 205;
  MSG_SERVER_PRIVMSG                    = 205;
  MSG_SERVER_SEND_ERROR                 = 206;
  MSG_CLIENT_ADD_HOTLIST                = 207;
  MSG_CLIENT_ADD_HOTLIST_SEQ            = 208;
  MSG_SERVER_USER_SIGNON                = 209;
  MSG_SERVER_USER_SIGNOFF               = 210;
  MSG_CLIENT_BROWSE                     = 211;
  MSG_SERVER_BROWSE_RESPONSE            = 212;
  MSG_SERVER_BROWSE_END                 = 213;
  MSG_SERVER_STATS                      = 214;
  MSG_CLIENT_RESUME_REQUEST             = 215;
  MSG_SERVER_RESUME_MATCH               = 216;
  MSG_SERVER_RESUME_MATCH_END           = 217;
  MSG_CLIENT_DOWNLOAD_START             = 218;
  MSG_CLIENT_DOWNLOAD_END               = 219;
  MSG_CLIENT_UPLOAD_START               = 220;
  MSG_CLIENT_UPLOAD_END                 = 221;
  MSG_CLIENT_CHECK_PORT                 = 300;
  MSG_SERVER_HOTLIST_ACK                = 301;
  MSG_SERVER_HOTLIST_ERROR              = 302;
  MSG_CLIENT_REMOVE_HOTLIST             = 303;
  MSG_SERVER_DISCONNECTING              = 316;
  MSG_CLIENT_IGNORE_LIST                = 320;
  MSG_SERVER_IGNORE_ENTRY               = 321;
  MSG_CLIENT_IGNORE_USER                = 322;
  MSG_CLIENT_UNIGNORE_USER              = 323;
  MSG_SERVER_NOT_IGNORED                = 324;
  MSG_SERVER_ALREADY_IGNORED            = 325;
  MSG_CLIENT_CLEAR_IGNORE               = 326;
  MSG_CLIENT_JOIN                       = 400;
  MSG_CLIENT_PART                       = 401;
  MSG_CLIENT_PUBLIC                     = 402;
  MSG_SERVER_PUBLIC                     = 403;
  MSG_SERVER_NOSUCH                     = 404;
  MSG_SERVER_JOIN_ACK                   = 405;
  MSG_SERVER_JOIN                       = 406;
  MSG_SERVER_PART                       = 407;
  MSG_SERVER_CHANNEL_USER_LIST          = 408;
  MSG_SERVER_CHANNEL_USER_LIST_END      = 409;
  MSG_SERVER_TOPIC                      = 410;
  MSG_CLIENT_CHANNEL_BAN_LIST           = 420;
  MSG_SERVER_CHANNEL_BAN_LIST           = 421;
  MSG_CLIENT_CHANNEL_BAN                = 422;
  MSG_CLIENT_CHANNEL_UNBAN              = 423;
  MSG_CLIENT_CHANNEL_CLEAR_BANS         = 424;
  MSG_CLIENT_CHANNEL_INVITE             = 430;
  MSG_CLIENT_CHANNEL_INVITE_ACCEPT      = 431;
  MSG_CLIENT_CHANNEL_INVITE_DECLINE     = 432;
  MSG_CLIENT_DOWNLOAD_FIREWALL          = 500;
  MSG_SERVER_UPLOAD_FIREWALL            = 501;
  MSG_CLIENT_USERSPEED                  = 600;
  MSG_SERVER_USER_SPEED                 = 601;
  MSG_CLIENT_WHOIS                      = 603;
  MSG_SERVER_WHOIS_RESPONSE             = 604;
  MSG_SERVER_WHOWAS                     = 605;
  MSG_CLIENT_SETUSERLEVEL               = 606;
  MSG_SERVER_UPLOAD_REQUEST             = 607;
  MSG_CLIENT_UPLOAD_OK                  = 608;
  MSG_SERVER_UPLOAD_FAILED              = 609;
  MSG_CLIENT_KILL                       = 610;
  MSG_CLIENT_NUKE                       = 611;
  MSG_CLIENT_BAN                        = 612;
  MSG_CLIENT_ALTER_PORT                 = 613;
  MSG_CLIENT_UNBAN                      = 614;
  MSG_CLIENT_BANLIST                    = 615;
  MSG_SERVER_IP_BANLIST                 = 616;
  MSG_CLIENT_LIST_CHANNELS              = 617;
  MSG_SERVER_CHANNEL_LIST_END           = 617;
  MSG_SERVER_CHANNEL_LIST               = 618;
  MSG_CLIENT_LIMIT                      = 619;
  MSG_SERVER_LIMIT                      = 620;
  MSG_CLIENT_MOTD                       = 621;
  MSG_SERVER_MOTD                       = 621;
  MSG_CLIENT_MUZZLE                     = 622;
  MSG_CLIENT_UNMUZZLE                   = 623;
  MSG_CLIENT_UNNUKE                     = 624;
  MSG_CLIENT_ALTER_SPEED                = 625;
  MSG_CLIENT_DATA_PORT_ERROR            = 626;
  MSG_SERVER_DATA_PORT_ERROR            = 626;
  MSG_CLIENT_WALLOP                     = 627;
  MSG_SERVER_WALLOP                     = 627;
  MSG_CLIENT_ANNOUNCE                   = 628;
  MSG_SERVER_ANNOUNCE                   = 628;
  MSG_SERVER_NICK_BANLIST               = 629;
  MSG_CLIENT_BROWSE_DIRECT              = 640;
  MSG_SERVER_BROWSE_DIRECT_OK           = 641;
  MSG_SERVER_BROWSE_DIRECT_ERR          = 642;
  MSG_CLIENT_CLOAK                      = 652;
  MSG_CLIENT_CHANGE_SPEED               = 700;
  MSG_CLIENT_CHANGE_PASS                = 701;
  MSG_CLIENT_CHANGE_EMAIL               = 702;
  MSG_CLIENT_CHANGE_DATA_PORT           = 703;
  MSG_SERVER_GHOST                      = 748;
  MSG_CLIENT_PING_SERVER                = 750;
  MSG_CLIENT_PING                       = 751;
  MSG_SERVER_PING                       = 751;
  MSG_CLIENT_PONG                       = 752;
  MSG_SERVER_PONG                       = 752;
  MSG_CLIENT_ALTER_PASS                 = 753;
  MSG_CLIENT_SERVER_RECONFIG            = 800;
  MSG_CLIENT_SERVER_VERSION             = 801;
  MSG_CLIENT_SERVER_CONFIG              = 810;
  MSG_CLIENT_CLEAR_CHANNEL              = 820;
  MSG_CLIENT_REDIRECT                   = 821;
  MSG_CLIENT_CYCLE                      = 822;
  MSG_CLIENT_SET_CHAN_LEVEL             = 823;
  MSG_CLIENT_EMOTE                      = 824;
  MSG_SERVER_EMOTE                      = 824;
  MSG_SERVER_NAMES_LIST                 = 825;
  MSG_CLIENT_CHANNEL_LIMIT              = 826;
  MSG_CLIENT_FULL_CHANNEL_LIST          = 827;
  MSG_SERVER_FULL_CHANNEL_INFO          = 828;
  MSG_CLIENT_KICK                       = 829;
  MSG_SERVER_NAMES_LIST_END             = 830;
  MSG_CLIENT_NAMES_LIST                 = 830;
  MSG_CLIENT_GLOBAL_USER_LIST           = 831;
  MSG_SERVER_GLOBAL_USER_LIST           = 832;
  MSG_CLIENT_ADD_DIRECTORY              = 870;
  MSG_CLIENT_BEFORELOGIN                = 920;
  MSG_SERVER_BLOCKMD5                   = 931;
  MSG_CLIENT_NEWSHARE                   = 932;

  // Supported OpenNap Messages
  MSG_CLIENT_OPENNAPSERVER              = 10010;
  MSG_CLIENT_OPENNAPSERVERACK           = 10011;
  MSG_SERVER_TIME_CHECK                 = 10023;
  MSG_CLIENT_CONNECT                    = 10100;
  MSG_CLIENT_DISCONNECT                 = 10101;
  MSG_CLIENT_KILL_SERVER                = 10110;
  MSG_CLIENT_REMOVE_SERVER              = 10111;
  MSG_CLIENT_LINKS                      = 10112;
  MSG_CLIENT_USAGE_STATS                = 10115; // Server usage stats
  MSG_CLIENT_VERSION_STATS              = 10118; // Client version stats
  MSG_CLIENT_WHICH_SERVER               = 10119;
  MSG_CLIENT_PING_ALL_SERVERS           = 10120;
  MSG_CLIENT_WHO_WAS                    = 10121;
  MSG_CLIENT_HISTOGRAM                  = 10123;
  MSG_SERVER_HISTOGRAM                  = 10124;
  MSG_CLIENT_REGISTER_USER              = 10200;
  MSG_CLIENT_USER_MODE                  = 10203; // Set a user mode
  MSG_SERVER_USER_MODE                  = 10203;
  MSG_CLIENT_OP                         = 10204;
  MSG_CLIENT_DEOP                       = 10205;
  MSG_CLIENT_DROP_CHANNEL               = 10207;
  MSG_CLIENT_CHANNEL_WALLOP             = 10208;
  MSG_CLIENT_CHANNEL_MODE               = 10209;
  MSG_CLIENT_CHANNEL_INVITE_OPENNAP     = 10210;
  MSG_CLIENT_CHANNEL_VOICE              = 10211;
  MSG_CLIENT_CHANNEL_UNVOICE            = 10212;
  MSG_CLIENT_CHANNEL_MUZZLE             = 10213;
  MSG_CLIENT_CHANNEL_UNMUZZLE           = 10214;
  MSG_CLIENT_SHARE_FILE                 = 10300; // Generic media type

  // SlavaNap Messages
  MSG_CLIENT_RELAY                      = 8100;
    // Relay message to another user
  MSG_CLIENT_PRELAY                     = 8101;
    // Relay message to all users (except yourself) - Elite only
  MSG_CLIENT_USERLIST                   = 8102; // List users
  MSG_CLIENT_SETVAR                     = 8103; // set variable
  MSG_CLIENT_RESTART                    = 8104; // Restart server
  MSG_CLIENT_BLOCK                      = 8105; // Block files
  MSG_CLIENT_UNBLOCK                    = 8106; // Unblock files
  MSG_CLIENT_BLOCKLIST                  = 8107; // List blocks
  MSG_CLIENT_MUZZLEINV                  = 8108; // Invert muzzle state
  MSG_CLIENT_GETCONSOLE                 = 8109; // Get console user name
  MSG_CLIENT_CHANNEL_BANIP              = 8111; // Ban user's IP in channel
  MSG_CLIENT_SETTRANSFERS               = 8112; // set transfers
  MSG_CLIENT_GETTRANSFERS               = 8113; // Get transfers for user
  MSG_CLIENT_ADDCHANNEL                 = 8114;
    // Create new registered channel
  MSG_CLIENT_FRIENDS                    = 8115; // Add/delete/list friends
  MSG_CLIENT_BANEX                      = 8116; // Ban user
  MSG_CLIENT_CHANGEBAN                  = 8117; // Change ban
  MSG_CLIENT_CHANNEL_OPEMOTE            = 8118; // Opemote
  MSG_CLIENT_ALIAS                      = 8119; // Server alias list
  MSG_CLIENT_GHOST                      = 8120; // Kill ghosting nic
  MSG_CLIENT_PRIVMSG_ANON               = 8121;
    // Send privmgs from user 'Server'
  MSG_CLIENT_ALLOWEDLIST                = 8122;
    // Show admin+ outgoing allowed connections list
  MSG_CLIENT_CLIENTBLOCKS               = 8123; // Show blocked clients
  MSG_CLIENT_UNREGISTER                 = 8124; // Nuke without kill
  MSG_CLIENT_SETSERVERPASSWORDS         = 8125; // set all server passwords
  MSG_CLIENT_SHOWSETTING                = 8126; // Show remote server variables
  MSG_CLIENT_SHOWALLSETTINGS            = 8127;
    // Show one setting on all remote servers
  MSG_CLIENT_REBOOT                     = 8128; // Reboot server pc

  // Other
  MSG_CLIENT_MSGSERV_READALL            = 10500; // Read all messages
  MSG_CLIENT_MSGSERV_READNEW            = 10501; // Read new messages
  MSG_CLIENT_MSGSERV_WRITE              = 10502; // Leave a message
  MSG_CLIENT_MSGSERV_DELETE             = 10503; // Delete a message
  MSG_CLIENT_MSGSERV_CLEAR              = 10504; // Delete all messages

  // SlavaNap Server-server Messages
  MSG_SRV_LOGIN                         = 8000;
  MSG_SRV_LOGIN_ACK                     = 8001;
  MSG_SRV_SETLASTINV                    = 8002;
  MSG_SRV_FORWARDALL                    = 8003;
    // Forward message to all linked servers
  MSG_SRV_DISCONNECTED                  = 8004; // Remote server disconnected
  MSG_SRV_CHECKPASS                     = 8005; // Server authentication
  MSG_SRV_CHECKPASS2                    = 8006; // Server authentication reply
  MSG_SRV_RELAY                         = 8007;
    // Relay message to other server thru hub
  MSG_SRV_SYNCCH                        = 8008; // Channel sync
  MSG_SRV_VOICE                         = 8009;
    // Voice user in channel (done by server)
  MSG_SRV_OP                            = 8010;
    // Op user in channel (done by server)
  MSG_SRV_SYNCSRV                       = 8011; // Sync linked server
  MSG_SRV_SYNCUSER                      = 8012; // Sync user
  MSG_SRV_PUBLICSYNCUSER                = 8013;
    // Sync user (sent to all servers)
  MSG_SRV_USEROFFLINE                   = 8014; // Kick remote user
  MSG_SRV_WALLOP                        = 8015; // do wallop
  MSG_SRV_COMPRESSED                    = 8016; // Compressed data
  MSG_SRV_UPDATEUSER                    = 8017; // Update user data
  MSG_SRV_SEARCH_RESULT                 = 8018; // Remote search result
  MSG_SRV_SEARCH_END                    = 8019; // End remote search
  MSG_SRV_SYNCREGISTERED                = 8020; // Sync registered user
  MSG_SRV_REMOTEBANKICK                 = 8021; // Kicking banned user
  MSG_SRV_SERVERBAN                     = 8022; // Ban user
  MSG_SRV_SERVERBANCLEAR                = 8023; // Clear bans
  MSG_SRV_SERVERBANSYNC                 = 8024; // Sync ban
  MSG_SRV_REGISTEREDCLEAR               = 8025; // Sync regisreations start
  MSG_SRV_REGISTEREDSYNC                = 8026; // Sync registrations
  MSG_SRV_SHUTDOWN                      = 8027; // Server shutdown
  MSG_SRV_FLOODER                       = 8028; // Inform about flooder
  MSG_SRV_ALIAS                         = 8029; // Server alias
  MSG_SRV_UPDATEBAN                     = 8030;
    // Update banfile with connection attempt info
  MSG_SRV_BLOCKLISTCLEAR                = 8031; // Clear blocked files list
  MSG_SRV_BLOCKLISTSYNC                 = 8032; // Sync blocked files list
  MSG_SRV_REMOTE_VAR_REQUEST            = 8033;
    // Request value of setting for variable on remote server
  MSG_SRV_REMOTE_VAR_REPLY              = 8034; // Reply to 8033

implementation

end.
