/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gtp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.gm.GMChannelRoute;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.gtp.GTPOutputStream;
import org.herac.tuxguitar.io.gtp.GTPSettings;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGDivisionType;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGStroke;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGText;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloPicking;
import org.herac.tuxguitar.song.models.effects.TGEffectTrill;

public class GP5OutputStream
extends GTPOutputStream {
    private static final String GP5_VERSION = "FICHIER GUITAR PRO v5.00";
    private static final int GP_BEND_SEMITONE = 25;
    private static final int GP_BEND_POSITION = 60;
    private static final String[] PAGE_SETUP_LINES = new String[]{"%TITLE%", "%SUBTITLE%", "%ARTIST%", "%ALBUM%", "Words by %WORDS%", "Music by %MUSIC%", "Words & Music by %WORDSMUSIC%", "Copyright %COPYRIGHT%", "All Rights Reserved - International Copyright Secured", "Page %N%/%P%", "Moderate"};

    public GP5OutputStream(GTPSettings settings) {
        super(settings);
    }

    public TGFileFormat getFileFormat() {
        return new TGFileFormat("Guitar Pro 5", "audio/x-gtp", new String[]{"gp5"});
    }

    @Override
    public void writeSong(TGSong song) {
        try {
            if (song.isEmpty()) {
                throw new TGFileFormatException("Empty Song!!!");
            }
            this.configureChannelRouter(song);
            TGMeasureHeader header = song.getMeasureHeader(0);
            this.writeStringByte(GP5_VERSION, 30, "UTF-8");
            this.writeInfo(song);
            this.writeLyrics(song);
            this.writePageSetup();
            this.writeInt(header.getTempo().getValue());
            this.writeInt(0);
            this.writeByte((byte)0);
            this.writeChannels(song);
            for (int i = 0; i < 42; ++i) {
                this.writeByte((byte)-1);
            }
            this.writeInt(song.countMeasureHeaders());
            this.writeInt(song.countTracks());
            this.writeMeasureHeaders(song);
            this.writeTracks(song);
            this.skipBytes(2);
            this.writeMeasures(song, header.getTempo().clone(this.getFactory()));
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeInfo(TGSong song) throws IOException {
        List<String> comments = this.toCommentLines(song.getComments());
        this.writeStringByteSizeOfInteger(song.getName());
        this.writeStringByteSizeOfInteger("");
        this.writeStringByteSizeOfInteger(song.getArtist());
        this.writeStringByteSizeOfInteger(song.getAlbum());
        this.writeStringByteSizeOfInteger(song.getAuthor());
        this.writeStringByteSizeOfInteger("");
        this.writeStringByteSizeOfInteger(song.getCopyright());
        this.writeStringByteSizeOfInteger(song.getWriter());
        this.writeStringByteSizeOfInteger("");
        this.writeInt(comments.size());
        for (int i = 0; i < comments.size(); ++i) {
            this.writeStringByteSizeOfInteger(comments.get(i));
        }
    }

    private void writeLyrics(TGSong song) throws IOException {
        TGTrack lyricTrack = null;
        Iterator it = song.getTracks();
        while (it.hasNext()) {
            TGTrack track = (TGTrack)it.next();
            if (track.getLyrics().isEmpty()) continue;
            lyricTrack = track;
            break;
        }
        this.writeInt(lyricTrack == null ? 0 : lyricTrack.getNumber());
        this.writeInt(lyricTrack == null ? 0 : lyricTrack.getLyrics().getFrom());
        this.writeStringInteger(lyricTrack == null ? "" : lyricTrack.getLyrics().getLyrics());
        for (int i = 0; i < 4; ++i) {
            this.writeInt(lyricTrack == null ? 0 : 1);
            this.writeStringInteger("");
        }
    }

    private void writePageSetup() throws IOException {
        this.writeInt(210);
        this.writeInt(297);
        this.writeInt(10);
        this.writeInt(10);
        this.writeInt(15);
        this.writeInt(10);
        this.writeInt(100);
        this.writeByte((byte)-1);
        this.writeByte((byte)1);
        for (int i = 0; i < PAGE_SETUP_LINES.length; ++i) {
            this.writeInt(PAGE_SETUP_LINES[i].length() + 1);
            this.writeStringByte(PAGE_SETUP_LINES[i], 0);
        }
    }

    private void writeChannels(TGSong song) throws IOException {
        TGChannel[] channels = this.makeChannels(song);
        for (int i = 0; i < channels.length; ++i) {
            this.writeInt(channels[i].getProgram());
            this.writeByte(this.toChannelByte(channels[i].getVolume()));
            this.writeByte(this.toChannelByte(channels[i].getBalance()));
            this.writeByte(this.toChannelByte(channels[i].getChorus()));
            this.writeByte(this.toChannelByte(channels[i].getReverb()));
            this.writeByte(this.toChannelByte(channels[i].getPhaser()));
            this.writeByte(this.toChannelByte(channels[i].getTremolo()));
            this.writeBytes(new byte[]{0, 0});
        }
    }

    private void writeMeasureHeaders(TGSong song) throws IOException {
        TGTimeSignature timeSignature = this.getFactory().newTimeSignature();
        if (song.countMeasureHeaders() > 0) {
            for (int i = 0; i < song.countMeasureHeaders(); ++i) {
                if (i > 0) {
                    this.skipBytes(1);
                }
                TGMeasureHeader measure = song.getMeasureHeader(i);
                this.writeMeasureHeader(measure, timeSignature);
                timeSignature.setNumerator(measure.getTimeSignature().getNumerator());
                timeSignature.getDenominator().setValue(measure.getTimeSignature().getDenominator().getValue());
            }
        }
    }

    private void writeMeasureHeader(TGMeasureHeader measure, TGTimeSignature timeSignature) throws IOException {
        int flags = 0;
        if (measure.getNumber() == 1) {
            flags |= 0x40;
        }
        if (measure.getNumber() == 1 || !measure.getTimeSignature().isEqual(timeSignature)) {
            flags |= 1;
            flags |= 2;
        }
        if (measure.isRepeatOpen()) {
            flags |= 4;
        }
        if (measure.getRepeatClose() > 0) {
            flags |= 8;
        }
        if (measure.getRepeatAlternative() > 0) {
            flags |= 0x10;
        }
        if (measure.hasMarker()) {
            flags |= 0x20;
        }
        this.writeUnsignedByte(flags);
        if ((flags & 1) != 0) {
            this.writeByte((byte)measure.getTimeSignature().getNumerator());
        }
        if ((flags & 2) != 0) {
            this.writeByte((byte)measure.getTimeSignature().getDenominator().getValue());
        }
        if ((flags & 8) != 0) {
            this.writeByte((byte)(measure.getRepeatClose() + 1));
        }
        if ((flags & 0x20) != 0) {
            this.writeMarker(measure.getMarker());
        }
        if ((flags & 0x10) != 0) {
            this.writeByte((byte)measure.getRepeatAlternative());
        }
        if ((flags & 0x40) != 0) {
            this.skipBytes(2);
        }
        if ((flags & 1) != 0) {
            this.writeBytes(this.makeBeamEighthNoteBytes(measure.getTimeSignature()));
        }
        if ((flags & 0x10) == 0) {
            this.writeByte((byte)0);
        }
        if (measure.getTripletFeel() == 1) {
            this.writeByte((byte)0);
        } else if (measure.getTripletFeel() == 2) {
            this.writeByte((byte)1);
        } else if (measure.getTripletFeel() == 3) {
            this.writeByte((byte)2);
        }
    }

    private void writeTracks(TGSong song) throws IOException {
        for (int i = 0; i < song.countTracks(); ++i) {
            TGTrack track = song.getTrack(i);
            this.writeTrack(track);
        }
    }

    private void writeTrack(TGTrack track) throws IOException {
        GMChannelRoute channel = this.getChannelRoute(track.getChannelId());
        List<TGString> strings = this.createWritableStrings(track);
        int flags = 0;
        if (this.isPercussionChannel(track.getSong(), track.getChannelId())) {
            flags |= 1;
        }
        this.writeUnsignedByte(flags);
        this.writeUnsignedByte(8 | flags);
        this.writeStringByte(track.getName(), 40);
        this.writeInt(strings.size());
        for (int i = 0; i < 7; ++i) {
            int value = 0;
            if (strings.size() > i) {
                value = strings.get(i).getValue();
            }
            this.writeInt(value);
        }
        this.writeInt(1);
        this.writeInt(channel.getChannel1() + 1);
        this.writeInt(channel.getChannel2() + 1);
        this.writeInt(24);
        this.writeInt(track.getOffset());
        this.writeColor(track.getColor());
        this.writeBytes(new byte[]{67, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 100, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, -1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1});
    }

    private void writeMeasures(TGSong song, TGTempo tempo) throws IOException {
        for (int i = 0; i < song.countMeasureHeaders(); ++i) {
            TGMeasureHeader header = song.getMeasureHeader(i);
            for (int j = 0; j < song.countTracks(); ++j) {
                TGTrack track = song.getTrack(j);
                TGMeasure measure = track.getMeasure(i);
                this.writeMeasure(measure, header.getTempo().getValue() != tempo.getValue());
                this.skipBytes(1);
            }
            tempo.copyFrom(header.getTempo());
        }
    }

    private void writeMeasure(TGMeasure measure, boolean changeTempo) throws IOException {
        for (int v = 0; v < 2; ++v) {
            TGVoice voice;
            TGBeat beat;
            ArrayList<TGVoice> voices = new ArrayList<TGVoice>();
            for (int m = 0; m < measure.countBeats(); ++m) {
                beat = measure.getBeat(m);
                if (v >= beat.countVoices() || (voice = beat.getVoice(v)).isEmpty()) continue;
                voices.add(voice);
            }
            if (voices.size() > 0) {
                this.writeInt(voices.size());
                for (int i = 0; i < voices.size(); ++i) {
                    TGVoice voice2 = (TGVoice)voices.get(i);
                    this.writeBeat(voice2, voice2.getBeat(), measure, changeTempo && i == 0);
                }
                continue;
            }
            int count = measure.getTimeSignature().getNumerator();
            beat = this.getFactory().newBeat();
            if (v >= beat.countVoices()) continue;
            voice = beat.getVoice(v);
            voice.getDuration().setValue(measure.getTimeSignature().getDenominator().getValue());
            voice.setEmpty(true);
            this.writeInt(count);
            for (int i = 0; i < count; ++i) {
                this.writeBeat(voice, voice.getBeat(), measure, changeTempo && i == 0);
            }
        }
    }

    private void writeBeat(TGVoice voice, TGBeat beat, TGMeasure measure, boolean changeTempo) throws IOException {
        int i;
        TGDuration duration = voice.getDuration();
        TGNoteEffect effect = this.getFactory().newEffect();
        for (int i2 = 0; i2 < voice.countNotes(); ++i2) {
            TGNote playedNote = voice.getNote(i2);
            if (playedNote.getEffect().isFadeIn()) {
                effect.setFadeIn(true);
            }
            if (playedNote.getEffect().isTremoloBar()) {
                effect.setTremoloBar(playedNote.getEffect().getTremoloBar().clone(this.getFactory()));
            }
            if (playedNote.getEffect().isTapping()) {
                effect.setTapping(true);
            }
            if (playedNote.getEffect().isSlapping()) {
                effect.setSlapping(true);
            }
            if (!playedNote.getEffect().isPopping()) continue;
            effect.setPopping(true);
        }
        int flags = 0;
        if (duration.isDotted() || duration.isDoubleDotted()) {
            flags |= 1;
        }
        if (voice.getIndex() == 0 && beat.isChordBeat()) {
            flags |= 2;
        }
        if (voice.getIndex() == 0 && beat.isTextBeat()) {
            flags |= 4;
        }
        if (beat.getStroke().getDirection() != 0) {
            flags |= 8;
        } else if (effect.isTremoloBar() || effect.isTapping() || effect.isSlapping() || effect.isPopping() || effect.isFadeIn()) {
            flags |= 8;
        }
        if (changeTempo) {
            flags |= 0x10;
        }
        if (!duration.getDivision().isEqual(TGDivisionType.NORMAL)) {
            flags |= 0x20;
        }
        if (voice.isEmpty() || voice.isRestVoice()) {
            flags |= 0x40;
        }
        this.writeUnsignedByte(flags);
        if ((flags & 0x40) != 0) {
            this.writeUnsignedByte(voice.isEmpty() ? 0 : 2);
        }
        this.writeByte(this.parseDuration(duration));
        if ((flags & 0x20) != 0) {
            this.writeInt(duration.getDivision().getEnters());
        }
        if ((flags & 2) != 0) {
            this.writeChord(beat.getChord());
        }
        if ((flags & 4) != 0) {
            this.writeText(beat.getText());
        }
        if ((flags & 8) != 0) {
            this.writeBeatEffects(beat, effect);
        }
        if ((flags & 0x10) != 0) {
            this.writeMixChange(measure.getTempo());
        }
        int stringFlags = 0;
        if (!voice.isRestVoice()) {
            for (i = 0; i < voice.countNotes(); ++i) {
                TGNote playedNote = voice.getNote(i);
                int string = 7 - playedNote.getString();
                stringFlags |= 1 << string;
            }
        }
        this.writeUnsignedByte(stringFlags);
        block2: for (i = 6; i >= 0; --i) {
            if ((stringFlags & 1 << i) == 0) continue;
            for (int n = 0; n < voice.countNotes(); ++n) {
                TGNote playedNote = voice.getNote(n);
                if (playedNote.getString() != 6 - i + 1) continue;
                this.writeNote(playedNote);
                continue block2;
            }
        }
        this.skipBytes(2);
    }

    private void writeNote(TGNote note) throws IOException {
        int flags = 48;
        if (note.getEffect().isVibrato() || note.getEffect().isBend() || note.getEffect().isSlide() || note.getEffect().isHammer() || note.getEffect().isLetRing() || note.getEffect().isPalmMute() || note.getEffect().isStaccato() || note.getEffect().isTrill() || note.getEffect().isGrace() || note.getEffect().isHarmonic() || note.getEffect().isTremoloPicking()) {
            flags |= 8;
        }
        if (note.getEffect().isGhostNote()) {
            flags |= 4;
        }
        if (note.getEffect().isHeavyAccentuatedNote()) {
            flags |= 2;
        }
        if (note.getEffect().isAccentuatedNote()) {
            flags |= 0x40;
        }
        this.writeUnsignedByte(flags);
        if ((flags & 0x20) != 0) {
            int typeHeader = 1;
            if (note.isTiedNote()) {
                typeHeader = 2;
            } else if (note.getEffect().isDeadNote()) {
                typeHeader = 3;
            }
            this.writeUnsignedByte(typeHeader);
        }
        if ((flags & 0x10) != 0) {
            this.writeByte((byte)((note.getVelocity() - 15) / 16 + 1));
        }
        if ((flags & 0x20) != 0) {
            this.writeByte((byte)note.getValue());
        }
        this.skipBytes(1);
        if ((flags & 8) != 0) {
            this.writeNoteEffects(note.getEffect());
        }
    }

    private byte parseDuration(TGDuration duration) {
        byte value = 0;
        switch (duration.getValue()) {
            case 1: {
                value = -2;
                break;
            }
            case 2: {
                value = -1;
                break;
            }
            case 4: {
                value = 0;
                break;
            }
            case 8: {
                value = 1;
                break;
            }
            case 16: {
                value = 2;
                break;
            }
            case 32: {
                value = 3;
                break;
            }
            case 64: {
                value = 4;
            }
        }
        return value;
    }

    private void writeChord(TGChord chord) throws IOException {
        this.writeBytes(new byte[]{1, 1, 0, 0, 0, 12, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0, 0});
        this.writeStringByte(chord.getName(), 21);
        this.skipBytes(4);
        this.writeInt(chord.getFirstFret());
        for (int i = 0; i < 7; ++i) {
            this.writeInt(i < chord.countStrings() ? chord.getFretValue(i) : -1);
        }
        this.skipBytes(32);
    }

    private void writeBeatEffects(TGBeat beat, TGNoteEffect effect) throws IOException {
        int flags1 = 0;
        int flags2 = 0;
        if (effect.isFadeIn()) {
            flags1 |= 0x10;
        }
        if (effect.isTapping() || effect.isSlapping() || effect.isPopping()) {
            flags1 |= 0x20;
        }
        if (effect.isTremoloBar()) {
            flags2 |= 4;
        }
        if (beat.getStroke().getDirection() != 0) {
            flags1 |= 0x40;
        }
        this.writeUnsignedByte(flags1);
        this.writeUnsignedByte(flags2);
        if ((flags1 & 0x20) != 0) {
            if (effect.isTapping()) {
                this.writeUnsignedByte(1);
            } else if (effect.isSlapping()) {
                this.writeUnsignedByte(2);
            } else if (effect.isPopping()) {
                this.writeUnsignedByte(3);
            }
        }
        if ((flags2 & 4) != 0) {
            this.writeTremoloBar(effect.getTremoloBar());
        }
        if ((flags1 & 0x40) != 0) {
            this.writeUnsignedByte(beat.getStroke().getDirection() == 1 ? this.toStrokeValue(beat.getStroke()) : 0);
            this.writeUnsignedByte(beat.getStroke().getDirection() == -1 ? this.toStrokeValue(beat.getStroke()) : 0);
        }
    }

    private void writeNoteEffects(TGNoteEffect effect) throws IOException {
        int flags1 = 0;
        int flags2 = 0;
        if (effect.isBend()) {
            flags1 |= 1;
        }
        if (effect.isHammer()) {
            flags1 |= 2;
        }
        if (effect.isLetRing()) {
            flags1 |= 8;
        }
        if (effect.isGrace()) {
            flags1 |= 0x10;
        }
        if (effect.isStaccato()) {
            flags2 |= 1;
        }
        if (effect.isPalmMute()) {
            flags2 |= 2;
        }
        if (effect.isTremoloPicking()) {
            flags2 |= 4;
        }
        if (effect.isSlide()) {
            flags2 |= 8;
        }
        if (effect.isHarmonic()) {
            flags2 |= 0x10;
        }
        if (effect.isTrill()) {
            flags2 |= 0x20;
        }
        if (effect.isVibrato()) {
            flags2 |= 0x40;
        }
        this.writeUnsignedByte(flags1);
        this.writeUnsignedByte(flags2);
        if ((flags1 & 1) != 0) {
            this.writeBend(effect.getBend());
        }
        if ((flags1 & 0x10) != 0) {
            this.writeGrace(effect.getGrace());
        }
        if ((flags2 & 4) != 0) {
            this.writeTremoloPicking(effect.getTremoloPicking());
        }
        if ((flags2 & 8) != 0) {
            this.writeByte((byte)1);
        }
        if ((flags2 & 0x10) != 0) {
            this.writeByte((byte)1);
        }
        if ((flags2 & 0x20) != 0) {
            this.writeTrill(effect.getTrill());
        }
    }

    private void writeBend(TGEffectBend bend) throws IOException {
        int points = bend.getPoints().size();
        this.writeByte((byte)1);
        this.writeInt(0);
        this.writeInt(points);
        for (int i = 0; i < points; ++i) {
            TGEffectBend.BendPoint point = (TGEffectBend.BendPoint)bend.getPoints().get(i);
            this.writeInt(point.getPosition() * 60 / 12);
            this.writeInt(point.getValue() * 25 / 1);
            this.writeByte((byte)0);
        }
    }

    private void writeTremoloBar(TGEffectTremoloBar tremoloBar) throws IOException {
        int points = tremoloBar.getPoints().size();
        this.writeByte((byte)1);
        this.writeInt(0);
        this.writeInt(points);
        for (int i = 0; i < points; ++i) {
            TGEffectTremoloBar.TremoloBarPoint point = (TGEffectTremoloBar.TremoloBarPoint)tremoloBar.getPoints().get(i);
            this.writeInt(point.getPosition() * 60 / 12);
            this.writeInt(point.getValue() * 50);
            this.writeByte((byte)0);
        }
    }

    private void writeGrace(TGEffectGrace grace) throws IOException {
        this.writeUnsignedByte(grace.getFret());
        this.writeUnsignedByte((grace.getDynamic() - 15) / 16 + 1);
        if (grace.getTransition() == 0) {
            this.writeUnsignedByte(0);
        } else if (grace.getTransition() == 1) {
            this.writeUnsignedByte(1);
        } else if (grace.getTransition() == 2) {
            this.writeUnsignedByte(2);
        } else if (grace.getTransition() == 3) {
            this.writeUnsignedByte(3);
        }
        this.writeUnsignedByte(grace.getDuration());
        this.writeUnsignedByte((grace.isDead() ? 1 : 0) | (grace.isOnBeat() ? 2 : 0));
    }

    private void writeTrill(TGEffectTrill trill) throws IOException {
        this.writeByte((byte)trill.getFret());
        if (trill.getDuration().getValue() == 16) {
            this.writeByte((byte)1);
        } else if (trill.getDuration().getValue() == 32) {
            this.writeByte((byte)2);
        } else if (trill.getDuration().getValue() == 64) {
            this.writeByte((byte)3);
        }
    }

    private void writeTremoloPicking(TGEffectTremoloPicking tremoloPicking) throws IOException {
        if (tremoloPicking.getDuration().getValue() == 8) {
            this.writeByte((byte)1);
        } else if (tremoloPicking.getDuration().getValue() == 16) {
            this.writeByte((byte)2);
        } else if (tremoloPicking.getDuration().getValue() == 32) {
            this.writeByte((byte)3);
        }
    }

    private void writeText(TGText text) throws IOException {
        this.writeStringByteSizeOfInteger(text.getValue());
    }

    private void writeMixChange(TGTempo tempo) throws IOException {
        this.writeByte((byte)-1);
        for (int i = 0; i < 16; ++i) {
            this.writeByte((byte)-1);
        }
        this.writeByte((byte)-1);
        this.writeByte((byte)-1);
        this.writeByte((byte)-1);
        this.writeByte((byte)-1);
        this.writeByte((byte)-1);
        this.writeByte((byte)-1);
        this.writeStringByteSizeOfInteger("");
        this.writeInt(tempo != null ? tempo.getValue() : -1);
        if (tempo != null) {
            this.skipBytes(1);
        }
        this.writeByte((byte)1);
        this.writeByte((byte)-1);
    }

    private void writeMarker(TGMarker marker) throws IOException {
        this.writeStringByteSizeOfInteger(marker.getTitle());
        this.writeColor(marker.getColor());
    }

    private void writeColor(TGColor color) throws IOException {
        this.writeUnsignedByte(color.getR());
        this.writeUnsignedByte(color.getG());
        this.writeUnsignedByte(color.getB());
        this.writeByte((byte)0);
    }

    private TGChannel[] makeChannels(TGSong song) {
        TGChannel[] channels = new TGChannel[64];
        for (int i = 0; i < channels.length; ++i) {
            channels[i] = this.getFactory().newChannel();
            channels[i].setProgram((short)24);
            channels[i].setVolume((short)13);
            channels[i].setBalance((short)8);
            channels[i].setChorus((short)0);
            channels[i].setReverb((short)0);
            channels[i].setPhaser((short)0);
            channels[i].setTremolo((short)0);
        }
        Iterator it = song.getChannels();
        while (it.hasNext()) {
            TGChannel tgChannel = (TGChannel)it.next();
            GMChannelRoute gmChannelRoute = this.getChannelRoute(tgChannel.getChannelId());
            channels[gmChannelRoute.getChannel1()].setProgram(tgChannel.getProgram());
            channels[gmChannelRoute.getChannel1()].setVolume(tgChannel.getVolume());
            channels[gmChannelRoute.getChannel1()].setBalance(tgChannel.getBalance());
            channels[gmChannelRoute.getChannel2()].setProgram(tgChannel.getProgram());
            channels[gmChannelRoute.getChannel2()].setVolume(tgChannel.getVolume());
            channels[gmChannelRoute.getChannel1()].setBalance(tgChannel.getBalance());
        }
        return channels;
    }

    private byte[] makeBeamEighthNoteBytes(TGTimeSignature ts) {
        byte[] bytes = new byte[]{0, 0, 0, 0};
        if (ts.getDenominator().getValue() <= 8) {
            int eighthsInDenominator = 8 / ts.getDenominator().getValue();
            int total = eighthsInDenominator * ts.getNumerator();
            int byteValue = total / 4;
            int missingValue = total - 4 * byteValue;
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)byteValue;
            }
            if (missingValue > 0) {
                bytes[0] = (byte)(bytes[0] + missingValue);
            }
        }
        return bytes;
    }

    private int toStrokeValue(TGStroke stroke) {
        if (stroke.getValue() == 64) {
            return 2;
        }
        if (stroke.getValue() == 32) {
            return 3;
        }
        if (stroke.getValue() == 16) {
            return 4;
        }
        if (stroke.getValue() == 8) {
            return 5;
        }
        if (stroke.getValue() == 4) {
            return 6;
        }
        return 2;
    }

    private byte toChannelByte(short s) {
        return (byte)((s + 1) / 8);
    }

    private List<String> toCommentLines(String comments) {
        ArrayList<String> lines = new ArrayList<String>();
        String line = comments;
        while (line.length() > 127) {
            String subline = line.substring(0, 127);
            lines.add(subline);
            line = line.substring(127);
        }
        lines.add(line);
        return lines;
    }
}

