/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gtp;

import java.io.IOException;
import java.util.Iterator;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.gtp.GTPFileFormatVersion;
import org.herac.tuxguitar.io.gtp.GTPFormatException;
import org.herac.tuxguitar.io.gtp.GTPInputStream;
import org.herac.tuxguitar.io.gtp.GTPSettings;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChannelParameter;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGText;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;

public class GP1InputStream
extends GTPInputStream {
    public static final TGFileFormat FILE_FORMAT = new TGFileFormat("Guitar Pro", "audio/x-gtp", new String[]{"gtp"});
    public static final GTPFileFormatVersion[] SUPPORTED_VERSIONS = new GTPFileFormatVersion[]{new GTPFileFormatVersion(FILE_FORMAT, "FICHIER GUITARE PRO v1", 0), new GTPFileFormatVersion(FILE_FORMAT, "FICHIER GUITARE PRO v1.01", 1), new GTPFileFormatVersion(FILE_FORMAT, "FICHIER GUITARE PRO v1.02", 2), new GTPFileFormatVersion(FILE_FORMAT, "FICHIER GUITARE PRO v1.03", 3), new GTPFileFormatVersion(FILE_FORMAT, "FICHIER GUITARE PRO v1.04", 4)};
    private static final short[][] TRACK_CHANNELS = new short[][]{{1, 0, 1}, {2, 2, 3}, {3, 4, 5}, {4, 6, 7}, {5, 8, 10}, {6, 11, 12}, {7, 13, 14}, {8, 9, 9}};
    private int trackCount;

    public GP1InputStream(GTPSettings settings) {
        super(settings, SUPPORTED_VERSIONS);
    }

    public TGFileFormat getFileFormat() {
        return FILE_FORMAT;
    }

    @Override
    public TGSong readSong() throws TGFileFormatException {
        try {
            int i;
            int tripletFeel;
            this.readVersion();
            this.trackCount = this.getVersion().getVersionCode() > 2 ? 8 : 1;
            TGSong song = this.getFactory().newSong();
            this.readInfo(song);
            int tempo = this.readInt();
            int n = tripletFeel = this.readInt() == 1 ? 2 : 1;
            if (this.getVersion().getVersionCode() > 2) {
                this.readInt();
            }
            for (i = 0; i < this.trackCount; ++i) {
                TGChannel channel = this.getFactory().newChannel();
                TGChannelParameter gmChannel1Param = this.getFactory().newChannelParameter();
                TGChannelParameter gmChannel2Param = this.getFactory().newChannelParameter();
                gmChannel1Param.setKey("gm-channel-1");
                gmChannel1Param.setValue(Integer.toString(TRACK_CHANNELS[i][1]));
                gmChannel2Param.setKey("gm-channel-2");
                gmChannel2Param.setValue(Integer.toString(TRACK_CHANNELS[i][2]));
                channel.setChannelId((int)TRACK_CHANNELS[i][0]);
                channel.addParameter(gmChannel1Param);
                channel.addParameter(gmChannel2Param);
                song.addChannel(channel);
            }
            for (i = 0; i < this.trackCount; ++i) {
                TGTrack track = this.getFactory().newTrack();
                track.setNumber(i + 1);
                track.setChannelId((int)TRACK_CHANNELS[i][0]);
                track.getColor().copyFrom(TGColor.RED);
                int strings = this.getVersion().getVersionCode() > 1 ? this.readInt() : 6;
                for (int j = 0; j < strings; ++j) {
                    TGString string = this.getFactory().newString();
                    string.setNumber(j + 1);
                    string.setValue(this.readInt());
                    track.getStrings().add(string);
                }
                song.addTrack(track);
            }
            int measureCount = this.readInt();
            for (int i2 = 0; i2 < this.trackCount; ++i2) {
                this.readTrack(song.getTrack(i2), song.getChannel(i2));
            }
            if (this.getVersion().getVersionCode() > 2) {
                this.skip(10);
            }
            TGMeasureHeader previous = null;
            long[] lastReadedStarts = new long[this.trackCount];
            for (int i3 = 0; i3 < measureCount; ++i3) {
                TGMeasureHeader header = this.getFactory().newHeader();
                header.setStart(previous == null ? 960L : previous.getStart() + previous.getLength());
                header.setNumber(previous == null ? 1 : previous.getNumber() + 1);
                header.getTempo().setValue(previous == null ? tempo : previous.getTempo().getValue());
                header.setTripletFeel(tripletFeel);
                this.readTrackMeasures(song, header, lastReadedStarts);
                previous = header;
            }
            TGSongManager tgSongManager = new TGSongManager(this.getFactory());
            tgSongManager.autoCompleteSilences(song);
            this.updateChannelNames(tgSongManager, song);
            this.close();
            return song;
        }
        catch (GTPFormatException gtpFormatException) {
            throw gtpFormatException;
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
    }

    private void readInfo(TGSong song) throws IOException {
        song.setName(this.readStringByteSizeOfByte());
        song.setAuthor(this.readStringByteSizeOfByte());
        this.readStringByteSizeOfByte();
    }

    private TGDuration readDuration() throws IOException {
        TGDuration duration = this.getFactory().newDuration();
        duration.setValue((int)(Math.pow(2.0, this.readByte() + 4) / 4.0));
        return duration;
    }

    private void readTrackMeasures(TGSong song, TGMeasureHeader header, long[] lastReadedStarts) throws IOException {
        this.readTimeSignature(header.getTimeSignature());
        this.skip(6);
        int[] beats = new int[this.trackCount];
        for (int i = 0; i < this.trackCount; ++i) {
            this.readUnsignedByte();
            this.readUnsignedByte();
            beats[i] = this.readUnsignedByte();
            if (beats[i] > 127) {
                beats[i] = 0;
            }
            this.skip(9);
        }
        this.skip(2);
        int flags = this.readUnsignedByte();
        header.setRepeatOpen((flags & 1) != 0);
        if ((flags & 2) != 0) {
            header.setRepeatClose(this.readUnsignedByte());
        }
        if ((flags & 4) != 0) {
            header.setRepeatAlternative(this.parseRepeatAlternative(song, header.getNumber(), this.readUnsignedByte()));
        }
        song.addMeasureHeader(header);
        for (int i = 0; i < this.trackCount; ++i) {
            TGTrack track = song.getTrack(i);
            TGMeasure measure = this.getFactory().newMeasure(header);
            long start = measure.getStart();
            for (int j = 0; j < beats[i]; ++j) {
                long length = this.readBeat(track, measure, start, lastReadedStarts[i]);
                lastReadedStarts[i] = start;
                start += length;
            }
            measure.setClef(this.getClef(track));
            track.addMeasure(measure);
        }
    }

    private void readTimeSignature(TGTimeSignature timeSignature) throws IOException {
        timeSignature.setNumerator(this.readUnsignedByte());
        timeSignature.getDenominator().setValue(this.readUnsignedByte());
    }

    private long readBeat(TGTrack track, TGMeasure measure, long start, long lastReadedStart) throws IOException {
        this.readInt();
        TGBeat beat = this.getFactory().newBeat();
        TGVoice voice = beat.getVoice(0);
        TGDuration duration = this.readDuration();
        TGNoteEffect effect = this.getFactory().newEffect();
        int flags = this.readUnsignedByte();
        duration.setDotted((flags & 0x10) != 0);
        if ((flags & 0x20) != 0) {
            duration.getDivision().setEnters(3);
            duration.getDivision().setTimes(2);
            this.skip(1);
        }
        if ((flags & 4) != 0) {
            this.readBeatEffects(effect);
        }
        if ((flags & 2) != 0) {
            this.readChord(track.stringCount(), beat);
        }
        if ((flags & 1) != 0) {
            this.readText(beat);
        }
        if ((flags & 0x40) != 0) {
            TGBeat previousBeat;
            if (lastReadedStart < start && (previousBeat = this.getBeat(track, measure, lastReadedStart)) != null) {
                TGVoice previousVoice = previousBeat.getVoice(0);
                for (TGNote previous : previousVoice.getNotes()) {
                    TGNote note = this.getFactory().newNote();
                    note.setValue(previous.getValue());
                    note.setString(previous.getString());
                    note.setVelocity(previous.getVelocity());
                    note.setTiedNote(true);
                    voice.addNote(note);
                }
            }
        } else if ((flags & 8) == 0) {
            int stringsFlags = this.readUnsignedByte();
            int effectsFlags = this.readUnsignedByte();
            for (int i = 5; i >= 0; --i) {
                if ((stringsFlags & 1 << i) == 0) continue;
                TGNote note = this.getFactory().newNote();
                int fret = this.readUnsignedByte();
                if ((effectsFlags & 1 << i) != 0) {
                    this.readNoteEffects(effect);
                }
                note.setValue(fret >= 0 && fret < 100 ? fret : 0);
                note.setVelocity(95);
                note.setString(track.stringCount() - i);
                note.setEffect(effect.clone(this.getFactory()));
                note.getEffect().setDeadNote(fret < 0 || fret >= 100);
                voice.addNote(note);
            }
        }
        beat.setStart(start);
        voice.setEmpty(false);
        voice.getDuration().copyFrom(duration);
        measure.addBeat(beat);
        return duration.getTime();
    }

    private void readText(TGBeat beat) throws IOException {
        TGText text = this.getFactory().newText();
        text.setValue(this.readStringByte(0));
        beat.setText(text);
    }

    private void readBeatEffects(TGNoteEffect effect) throws IOException {
        int flags = this.readUnsignedByte();
        effect.setVibrato(flags == 1 || flags == 2);
        effect.setFadeIn(flags == 4);
        effect.setTapping(flags == 5);
        effect.setSlapping(flags == 6);
        effect.setPopping(flags == 7);
        if (flags == 3) {
            this.readBend(effect);
        } else if (flags == 8 || flags == 9) {
            TGEffectHarmonic harmonic = this.getFactory().newEffectHarmonic();
            harmonic.setType(flags == 8 ? 1 : 2);
            harmonic.setData(0);
            effect.setHarmonic(harmonic);
        }
    }

    private void readNoteEffects(TGNoteEffect effect) throws IOException {
        int flags = this.readUnsignedByte();
        effect.setHammer(flags == 1 || flags == 2);
        effect.setSlide(flags == 3 || flags == 4);
        if (flags == 5 || flags == 6) {
            this.readBend(effect);
        }
    }

    private void readBend(TGNoteEffect effect) throws IOException {
        this.skip(6);
        float value = Math.max((float)this.readUnsignedByte() / 8.0f - 26.0f, 1.0f);
        TGEffectBend bend = this.getFactory().newEffectBend();
        bend.addPoint(0, 0);
        bend.addPoint(Math.round(6.0f), Math.round(value * 1.0f));
        bend.addPoint(Math.round(12.0f), Math.round(value * 1.0f));
        effect.setBend(bend);
        this.skip(1);
    }

    private void readTrack(TGTrack track, TGChannel channel) throws IOException {
        track.setName("Track 1");
        channel.setProgram((short)this.readInt());
        if (this.getVersion().getVersionCode() > 2) {
            this.readInt();
            track.setName(this.readStringByteSizeOfByte());
            track.setSolo(this.readBoolean());
            channel.setVolume((short)this.readInt());
            channel.setBalance((short)this.readInt());
            channel.setChorus((short)this.readInt());
            channel.setReverb((short)this.readInt());
            track.setOffset(this.readInt());
        }
    }

    private void readChord(int strings, TGBeat beat) throws IOException {
        if (this.getVersion().getVersionCode() > 3) {
            TGChord chord = this.getFactory().newChord(strings);
            chord.setName(this.readStringByte(0));
            this.skip(1);
            if (this.readInt() < 12) {
                this.skip(32);
            }
            chord.setFirstFret(this.readInt());
            if (chord.getFirstFret() != 0) {
                for (int i = 0; i < 6; ++i) {
                    int fret = this.readInt();
                    if (i >= chord.countStrings()) continue;
                    chord.addFretValue(i, fret);
                }
            }
            if (chord.countNotes() > 0) {
                beat.setChord(chord);
            }
        } else {
            this.readStringByteSizeOfByte();
        }
    }

    private int parseRepeatAlternative(TGSong song, int measure, int value) {
        TGMeasureHeader header;
        int repeatAlternative = 0;
        int existentAlternatives = 0;
        Iterator it = song.getMeasureHeaders();
        while (it.hasNext() && (header = (TGMeasureHeader)it.next()).getNumber() != measure) {
            if (header.isRepeatOpen()) {
                existentAlternatives = 0;
            }
            existentAlternatives |= header.getRepeatAlternative();
        }
        for (int i = 0; i < 8; ++i) {
            if (value <= i || (existentAlternatives & 1 << i) != 0) continue;
            repeatAlternative |= 1 << i;
        }
        return repeatAlternative;
    }

    private int getClef(TGTrack track) {
        if (!this.isPercussionChannel(track.getSong(), track.getChannelId())) {
            for (TGString string : track.getStrings()) {
                if (string.getValue() > 34) continue;
                return 2;
            }
        }
        return 1;
    }

    private TGBeat getBeat(TGTrack track, TGMeasure measure, long start) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat == null) {
            for (int i = track.countMeasures() - 1; i >= 0 && (beat = this.getBeat(track.getMeasure(i), start)) == null; --i) {
            }
        }
        return beat;
    }

    private TGBeat getBeat(TGMeasure measure, long start) {
        if (start >= measure.getStart() && start < measure.getStart() + measure.getLength()) {
            for (TGBeat beat : measure.getBeats()) {
                if (beat.getStart() != start) continue;
                return beat;
            }
        }
        return null;
    }

    private void updateChannelNames(TGSongManager songManager, TGSong song) {
        Iterator it = song.getChannels();
        while (it.hasNext()) {
            TGChannel tgChannel = (TGChannel)it.next();
            tgChannel.setName(songManager.createChannelNameFromProgram(song, tgChannel));
        }
    }

    private boolean isPercussionChannel(TGSong song, int channelId) {
        Iterator it = song.getChannels();
        while (it.hasNext()) {
            TGChannel channel = (TGChannel)it.next();
            if (channel.getChannelId() != channelId) continue;
            return channel.isPercussionChannel();
        }
        return false;
    }
}

