/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.graphics.control;

public class TGDrumMap {
    private static final int MAX_NOTES = 90;
    private static final int MAP_POSITION = 0;
    private static final int MAP_KIND = 1;
    private static final int MAP_LEN = 2;
    public static final int KIND_CYMBAL = 1;
    public static final int KIND_NOTE = 2;
    public static final int KIND_SLANTED_DIAMOND = 16;
    public static final int KIND_TRIANGLE = 32;
    public static final int KIND_EFFECT_CYMBAL = 64;
    public static final int KIND_OPEN = 4;
    public static final int KIND_CLOSED = 8;
    public static final int KIND_CIRCLE_AROUND = 128;
    public static final int DEFAULT_KIND = 2;
    public static final int DEFAULT_POSITION = -1;
    private int[][] mapping;

    public TGDrumMap() {
        this.createDefaultMapping();
    }

    private void createDefaultMapping() {
        this.mapping = new int[90][2];
        for (int i = 0; i < this.mapping.length; ++i) {
            this.map(i, -1, 2);
        }
        this.map(35, 7, 2);
        this.map(36, 6, 2);
        this.map(37, 2, 130);
        this.map(38, 2, 2);
        this.map(40, 2, 2);
        this.map(42, -2, 9);
        this.map(46, -2, 5);
        this.map(44, 8, 1);
        this.map(49, -3, 64);
        this.map(57, -4, 64);
        this.map(55, -5, 64);
        this.map(52, -5, 192);
        this.map(51, -1, 1);
        this.map(59, 1, 1);
        this.map(53, -1, 16);
        this.map(41, 5, 2);
        this.map(43, 4, 2);
        this.map(45, 3, 2);
        this.map(47, 1, 2);
        this.map(48, 0, 2);
        this.map(50, -1, 2);
        this.map(54, 3, 32);
        this.map(56, 0, 32);
        this.map(31, 3, 1);
        this.map(77, 2, 32);
        this.map(76, 1, 32);
        this.map(81, -3, 32);
        this.map(80, -3, 40);
    }

    private void map(int key, int position, int kind) {
        this.mapping[key][0] = position;
        this.mapping[key][1] = kind;
    }

    public int getPosition(int value) {
        if (value >= 0 && value < this.mapping.length) {
            return this.mapping[value][0];
        }
        return -1;
    }

    public int getRenderType(int value) {
        if (value >= 0 && value < this.mapping.length) {
            return this.mapping[value][1];
        }
        return 2;
    }
}

