/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.cocoa.toolbar;

import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSToolbar;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.cocoa.TGCocoa;
import org.herac.tuxguitar.cocoa.toolbar.MacToolbarAction;
import org.herac.tuxguitar.cocoa.toolbar.MacToolbarDelegate;

public class MacToolbar {
    private static final byte[] SWT_OBJECT = new byte[]{83, 87, 84, 95, 79, 66, 74, 69, 67, 84, 0};
    private static final long NSWindowToolbarButton = 3L;
    private static final long sel_toolbarButtonClicked_ = TGCocoa.sel_registerName("toolbarButtonClicked:");
    private boolean enabled;
    private long delegateRef;
    private MacToolbarDelegate delegate;

    public void init(Shell shell) throws Throwable {
        Callback callback = TGCocoa.newCallback(this, "callbackProc64", "callbackProc32", 3);
        long callbackProc = TGCocoa.getCallbackAddress(callback);
        if (callbackProc != 0L) {
            String classname = "MacToolbarDelegate";
            if (TGCocoa.objc_lookUpClass(classname) == 0L) {
                long cls = TGCocoa.objc_allocateClassPair(classname, 0L);
                TGCocoa.class_addIvar(cls, SWT_OBJECT, C.PTR_SIZEOF, (byte)(C.PTR_SIZEOF == 4 ? 2 : 3), new byte[]{42, 0});
                TGCocoa.class_addMethod(cls, sel_toolbarButtonClicked_, callbackProc, "@:@");
                TGCocoa.objc_registerClassPair(cls);
            }
            this.delegate = TGCocoa.newMacToolbarDelegate();
            this.delegate.alloc().init();
            this.delegateRef = TGCocoa.NewGlobalRef(this);
            TGCocoa.object_setInstanceVariable(MacToolbarDelegate.class.getField("id").get((Object)this.delegate), SWT_OBJECT, this.delegateRef);
            NSToolbar dummyBar = new NSToolbar();
            dummyBar.alloc();
            dummyBar.initWithIdentifier(NSString.stringWith((String)"SWTToolbar"));
            dummyBar.setVisible(false);
            NSWindow nsWindow = shell.view.window();
            nsWindow.setToolbar(dummyBar);
            dummyBar.release();
            nsWindow.setShowsToolbarButton(true);
            NSButton toolbarButton = TGCocoa.getStandardWindowButton(nsWindow, 3L);
            if (toolbarButton != null) {
                toolbarButton.setTarget((id)this.delegate);
                TGCocoa.setControlAction((NSControl)toolbarButton, sel_toolbarButtonClicked_);
            }
        }
    }

    public void finalize() throws Throwable {
        if (this.delegateRef != 0L) {
            TGCocoa.DeleteGlobalRef(this.delegateRef);
            this.delegateRef = 0L;
        }
    }

    public long callbackProc(long id2, long sel, long arg0) {
        if (this.isEnabled() && sel == sel_toolbarButtonClicked_) {
            return this.handleToogleToolbarCommand();
        }
        return 0L;
    }

    public long callbackProc64(long id2, long sel, long arg0) {
        return this.callbackProc(id2, sel, arg0);
    }

    public int callbackProc32(int id2, int sel, int arg0) {
        return (int)this.callbackProc(id2, sel, arg0);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public long handleToogleToolbarCommand() {
        MacToolbarAction.toogleToolbar();
        return 0L;
    }
}

