/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.swt.widget;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.swt.event.SWTSelectionListenerManager;
import org.herac.tuxguitar.ui.swt.widget.SWTContainer;
import org.herac.tuxguitar.ui.swt.widget.SWTControl;
import org.herac.tuxguitar.ui.widget.UIKnob;

public class SWTScaleKnob
extends SWTControl<Button>
implements UIKnob {
    private int maximum;
    private int minimum;
    private int increment;
    private int type;
    private int value = -1;
    private String toolTipText;
    private boolean inverted = true;
    private Shell shell;
    private Composite composite;
    private Scale scale;
    private SWTSelectionListenerManager selectionListener;

    public SWTScaleKnob(SWTContainer<? extends Composite> parent) {
        super(new Button(parent.getControl(), 2), parent);
        ((Button)this.getControl()).addDisposeListener(this.createItemDisposeListener());
        ((Button)this.getControl()).addSelectionListener(this.createItemSelectionListener());
        ((Button)this.getControl()).getShell().addListener(10, this.createMoveShellListener());
        this.selectionListener = new SWTSelectionListenerManager(this);
    }

    public int getType() {
        return this.type;
    }

    public int getValue() {
        if (this.value < 0) {
            this.getValueFromScale();
        }
        return this.value;
    }

    public void setValue(int value) {
        if (value != this.value) {
            this.value = value;
            this.setValueToScale();
            this.updateToolTipValue();
        }
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
        this.setMaximumToScale();
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
        this.setMinimumToScale();
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
        this.setIncrementToScale();
    }

    public void getValueFromScale() {
        if (!this.isShellDisposed()) {
            this.setValue(this.inverted ? 127 - this.scale.getSelection() : this.scale.getSelection());
        }
    }

    public void setValueToScale() {
        if (!this.isShellDisposed()) {
            this.scale.setSelection(this.inverted ? 127 - this.value : this.value);
        }
    }

    public void setIncrementToScale() {
        if (!this.isShellDisposed()) {
            this.scale.setIncrement(this.increment);
        }
    }

    public void setMaximumToScale() {
        if (!this.isShellDisposed()) {
            this.scale.setMaximum(this.maximum);
        }
    }

    public void setMinimumToScale() {
        if (!this.isShellDisposed()) {
            this.scale.setMinimum(this.minimum);
        }
    }

    public void updateToolTipValue() {
        if (this.getToolTipText() != null) {
            ((Button)this.getControl()).setToolTipText(this.getToolTipText() + ": " + this.getValue());
            if (!this.isShellDisposed()) {
                this.scale.setToolTipText(this.getToolTipText() + ": " + this.getValue());
            }
        }
    }

    @Override
    public void setToolTipText(String text) {
        this.toolTipText = text;
        if (this.getToolTipText() != null && this.getToolTipText().length() > 0) {
            ((Button)this.getControl()).setText(this.getToolTipText().substring(0, 1));
        }
        this.updateToolTipValue();
    }

    @Override
    public String getToolTipText() {
        return this.toolTipText;
    }

    private GridLayout getGridLayout() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginHeight = 0;
        return layout;
    }

    private GridData getScaleLayoutData() {
        GridData data = new GridData(0x1000000, 4, false, true);
        data.heightHint = 65;
        return data;
    }

    public void showShell() {
        if (this.isShellDisposed()) {
            this.shell = new Shell(((Button)this.getControl()).getShell(), 8);
            this.shell.setVisible(false);
            this.shell.setLayout((Layout)this.getGridLayout());
            this.composite = new Composite((Composite)this.shell, 2048);
            this.composite.setLayout((Layout)this.getGridLayout());
            this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.scale = new Scale(this.composite, 512);
            this.scale.setMaximum(this.maximum);
            this.scale.setMinimum(this.minimum);
            this.scale.setIncrement(this.increment);
            this.scale.setPageIncrement(this.increment * 3);
            this.scale.setLayoutData((Object)this.getScaleLayoutData());
            this.setValueToScale();
            this.scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    SWTScaleKnob.this.getValueFromScale();
                    SWTScaleKnob.this.selectionListener.widgetSelected(event);
                }
            });
            this.shell.pack();
            this.moveShell();
            this.shell.setVisible(true);
        }
    }

    public void hideShell() {
        if (!this.isShellDisposed()) {
            this.shell.dispose();
            this.shell = null;
        }
    }

    public void showHideShell() {
        if (((Button)this.getControl()).getSelection()) {
            this.showShell();
        } else {
            this.hideShell();
        }
    }

    public void moveShell() {
        if (!this.isShellDisposed()) {
            Rectangle bounds = ((Button)this.getControl()).getBounds();
            Point location = ((Button)this.getControl()).getParent().toDisplay(new Point(bounds.x, bounds.y));
            this.shell.setLocation(location.x + bounds.width / 2 - this.shell.getSize().x / 2, location.y + bounds.height);
        }
    }

    public boolean isShellDisposed() {
        return this.shell == null || this.shell.isDisposed();
    }

    private DisposeListener createItemDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTScaleKnob.this.hideShell();
            }
        };
    }

    private SelectionListener createItemSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTScaleKnob.this.showHideShell();
            }
        };
    }

    private Listener createMoveShellListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                SWTScaleKnob.this.moveShell();
            }
        };
    }

    public void addSelectionListener(UISelectionListener listener) {
        this.selectionListener.addListener(listener);
    }

    public void removeSelectionListener(UISelectionListener listener) {
        this.selectionListener.removeListener(listener);
    }
}

