/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.gpx.score;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.io.gpx.score.GPXAutomation;
import org.herac.tuxguitar.io.gpx.score.GPXBar;
import org.herac.tuxguitar.io.gpx.score.GPXBeat;
import org.herac.tuxguitar.io.gpx.score.GPXChord;
import org.herac.tuxguitar.io.gpx.score.GPXMasterBar;
import org.herac.tuxguitar.io.gpx.score.GPXNote;
import org.herac.tuxguitar.io.gpx.score.GPXRhythm;
import org.herac.tuxguitar.io.gpx.score.GPXScore;
import org.herac.tuxguitar.io.gpx.score.GPXTrack;
import org.herac.tuxguitar.io.gpx.score.GPXVoice;

public class GPXDocument {
    private GPXScore score = new GPXScore();
    private List<GPXTrack> tracks = new ArrayList<GPXTrack>();
    private List<GPXMasterBar> masterBars = new ArrayList<GPXMasterBar>();
    private List<GPXBar> bars = new ArrayList<GPXBar>();
    private List<GPXVoice> voices = new ArrayList<GPXVoice>();
    private List<GPXBeat> beats = new ArrayList<GPXBeat>();
    private List<GPXNote> notes = new ArrayList<GPXNote>();
    private List<GPXChord> chords = new ArrayList<GPXChord>();
    private List<GPXRhythm> rhythms = new ArrayList<GPXRhythm>();
    private List<GPXAutomation> automations = new ArrayList<GPXAutomation>();

    public GPXScore getScore() {
        return this.score;
    }

    public List<GPXTrack> getTracks() {
        return this.tracks;
    }

    public List<GPXMasterBar> getMasterBars() {
        return this.masterBars;
    }

    public List<GPXBar> getBars() {
        return this.bars;
    }

    public List<GPXVoice> getVoices() {
        return this.voices;
    }

    public List<GPXBeat> getBeats() {
        return this.beats;
    }

    public List<GPXNote> getNotes() {
        return this.notes;
    }

    public List<GPXChord> getChords() {
        return this.chords;
    }

    public List<GPXRhythm> getRhythms() {
        return this.rhythms;
    }

    public List<GPXAutomation> getAutomations() {
        return this.automations;
    }

    public GPXBar getBar(int id) {
        for (GPXBar bar : this.bars) {
            if (bar.getId() != id) continue;
            return bar;
        }
        return null;
    }

    public GPXVoice getVoice(int id) {
        for (GPXVoice voice : this.voices) {
            if (voice.getId() != id) continue;
            return voice;
        }
        return null;
    }

    public GPXBeat getBeat(int id) {
        for (GPXBeat beat : this.beats) {
            if (beat.getId() != id) continue;
            return beat;
        }
        return null;
    }

    public GPXNote getNote(int id) {
        for (GPXNote note : this.notes) {
            if (note.getId() != id) continue;
            return note;
        }
        return null;
    }

    public GPXChord getChord(int id) {
        for (GPXChord chord : this.chords) {
            if (chord.getId() != id) continue;
            return chord;
        }
        return null;
    }

    public GPXRhythm getRhythm(int id) {
        for (GPXRhythm rhythm : this.rhythms) {
            if (rhythm.getId() != id) continue;
            return rhythm;
        }
        return null;
    }

    public GPXAutomation getAutomation(String type, int untilBarId) {
        GPXAutomation result = null;
        for (GPXAutomation automation : this.automations) {
            if (automation.getType() == null || !automation.getType().equals(type) || automation.getBarId() > untilBarId || result != null && automation.getBarId() <= result.getBarId()) continue;
            result = automation;
        }
        return result;
    }
}

