/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.layout;

import java.util.HashMap;
import java.util.Map;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UILayoutAttributes;
import org.herac.tuxguitar.ui.resource.UISize;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;

public abstract class UIAbstractLayout
implements UILayout {
    public static final String PACKED_WIDTH = "packed_width";
    public static final String PACKED_HEIGHT = "packed_height";
    public static final String MINIMUM_PACKED_WIDTH = "minimum_packed_width";
    public static final String MINIMUM_PACKED_HEIGHT = "minimum_packed_height";
    public static final String MAXIMUM_PACKED_WIDTH = "maximum_packed_width";
    public static final String MAXIMUM_PACKED_HEIGHT = "maximum_packed_height";
    private UILayoutAttributes attributes = new UILayoutAttributes();
    private Map<UIControl, UILayoutAttributes> controlAttributes = new HashMap<UIControl, UILayoutAttributes>();

    public UILayoutAttributes getAttributes() {
        return this.attributes;
    }

    public UILayoutAttributes getControlAttributes(UIControl control) {
        if (this.controlAttributes.containsKey(control)) {
            return this.controlAttributes.get(control);
        }
        this.controlAttributes.put(control, new UILayoutAttributes());
        return this.getControlAttributes(control);
    }

    @Override
    public <T> void set(String key, T value) {
        this.getAttributes().set(key, value);
    }

    @Override
    public <T> void set(UIControl control, String key, T value) {
        this.getControlAttributes(control).set(key, value);
    }

    @Override
    public <T> T get(String key) {
        return this.getAttributes().get(key);
    }

    @Override
    public <T> T get(UIControl control, String key) {
        return this.getControlAttributes(control).get(key);
    }

    public <T> T get(String key, T defaultValue) {
        T value = this.get(key);
        return value != null ? value : defaultValue;
    }

    public <T> T get(UIControl control, String key, T defaultValue) {
        T value = this.get(control, key);
        return value != null ? value : defaultValue;
    }

    public UISize getPreferredControlSize(UIControl control) {
        Float packedWidth = (Float)this.get(control, PACKED_WIDTH);
        Float packedHeight = (Float)this.get(control, PACKED_HEIGHT);
        Float minimumPackedWidth = (Float)this.get(control, MINIMUM_PACKED_WIDTH);
        Float minimumPackedHeight = (Float)this.get(control, MINIMUM_PACKED_HEIGHT);
        Float maximumPackedWidth = (Float)this.get(control, MAXIMUM_PACKED_WIDTH);
        Float maximumPackedHeight = (Float)this.get(control, MAXIMUM_PACKED_HEIGHT);
        UISize packedSize = control.getPackedSize();
        UISize preferredSize = new UISize(packedSize.getWidth(), packedSize.getHeight());
        if (packedWidth != null) {
            preferredSize.setWidth(packedWidth.floatValue());
        }
        if (packedHeight != null) {
            preferredSize.setHeight(packedHeight.floatValue());
        }
        if (minimumPackedWidth != null && minimumPackedWidth.floatValue() > preferredSize.getWidth()) {
            preferredSize.setWidth(minimumPackedWidth.floatValue());
        }
        if (minimumPackedHeight != null && minimumPackedHeight.floatValue() > preferredSize.getHeight()) {
            preferredSize.setHeight(minimumPackedHeight.floatValue());
        }
        if (maximumPackedWidth != null && maximumPackedWidth.floatValue() < preferredSize.getWidth()) {
            preferredSize.setWidth(maximumPackedWidth.floatValue());
        }
        if (maximumPackedHeight != null && maximumPackedHeight.floatValue() < preferredSize.getHeight()) {
            preferredSize.setHeight(maximumPackedHeight.floatValue());
        }
        return preferredSize;
    }

    public void computeChildPackedSize(UIControl control) {
        Float fixedWidth = (Float)this.get(control, PACKED_WIDTH);
        Float fixedHeight = (Float)this.get(control, PACKED_HEIGHT);
        control.computePackedSize(fixedWidth, fixedHeight);
        int tries = 1;
        boolean done = false;
        while (!done && tries < 3) {
            boolean expectedHeight;
            UISize packedSize = control.getPackedSize();
            UISize preferredSize = this.getPreferredControlSize(control);
            boolean expectedWidth = packedSize.getWidth() == preferredSize.getWidth();
            boolean bl = expectedHeight = packedSize.getHeight() == preferredSize.getHeight();
            if (!(tries++ <= 1 || expectedWidth && expectedHeight)) {
                control.computePackedSize(Float.valueOf(preferredSize.getWidth()), Float.valueOf(preferredSize.getHeight()));
                continue;
            }
            if (!expectedWidth && !expectedHeight) {
                control.computePackedSize(Float.valueOf(preferredSize.getWidth()), Float.valueOf(preferredSize.getHeight()));
                continue;
            }
            if (!expectedWidth && expectedHeight) {
                control.computePackedSize(Float.valueOf(preferredSize.getWidth()), null);
                continue;
            }
            if (expectedWidth && !expectedHeight) {
                control.computePackedSize(null, Float.valueOf(preferredSize.getHeight()));
                continue;
            }
            done = true;
        }
    }

    public void computeChildrenPackedSize(UILayoutContainer container) {
        for (UIControl control : container.getChildren()) {
            this.computeChildPackedSize(control);
        }
    }

    @Override
    public UISize computePackedSize(UILayoutContainer container) {
        this.computeChildrenPackedSize(container);
        return this.getComputedPackedSize(container);
    }

    public abstract UISize getComputedPackedSize(UILayoutContainer var1);
}

