/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.audiounit;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gm.port.GMReceiver;
import org.herac.tuxguitar.player.base.MidiOutputPort;
import org.herac.tuxguitar.player.impl.midiport.audiounit.MidiPortImpl;
import org.herac.tuxguitar.player.impl.midiport.audiounit.MidiReceiverJNI;

public class MidiReceiverImpl
extends MidiReceiverJNI
implements GMReceiver {
    private boolean open;
    private boolean connected = false;
    private List<MidiOutputPort> ports = new ArrayList<MidiOutputPort>();

    @Override
    public void open() {
        super.open();
        this.open = true;
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            this.disconnect();
            super.close();
            this.open = false;
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isConnected() {
        return this.isOpen() && this.connected;
    }

    public void connect() {
        if (this.isOpen() && !this.isConnected()) {
            this.connected = true;
            this.openDevice();
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            this.closeDevice();
            this.connected = false;
        }
    }

    public List<MidiOutputPort> listPorts() {
        if (this.isOpen()) {
            this.ports.clear();
            this.ports.add((MidiOutputPort)new MidiPortImpl(this, "AudioUnit graph midi playback", "audiounit"));
            return this.ports;
        }
        return new ArrayList<MidiOutputPort>();
    }

    public void sendSystemReset() {
        if (this.isOpen()) {
            // empty if block
        }
    }

    public void sendAllNotesOff() {
        for (int i = 0; i < 16; ++i) {
            this.sendControlChange(i, 123, 0);
        }
    }

    public void sendControlChange(int channel, int controller, int value) {
        if (this.isOpen()) {
            super.controlChange(channel, controller, value);
        }
    }

    public void sendNoteOff(int channel, int key, int velocity) {
        if (this.isOpen()) {
            super.noteOff(channel, key, velocity);
        }
    }

    public void sendNoteOn(int channel, int key, int velocity) {
        if (this.isOpen()) {
            super.noteOn(channel, key, velocity);
        }
    }

    public void sendPitchBend(int channel, int value) {
        if (this.isOpen()) {
            super.pitchBend(channel, value);
        }
    }

    public void sendProgramChange(int channel, int value) {
        if (this.isOpen()) {
            super.programChange(channel, value);
        }
    }
}

