/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.toolbar.model;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.toolbar.model.TGToolBarSection;
import org.herac.tuxguitar.app.view.util.TGSyncProcessLocked;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.util.TGContext;

public abstract class TGToolBarModel
implements TGEventListener {
    private TGContext context;
    private List<TGToolBarSection> sections;
    private TGSyncProcessLocked loadIconsProcess;
    private TGSyncProcessLocked loadPropertiesProcess;
    private TGSyncProcessLocked updateItemsProcess;

    public TGToolBarModel(TGContext context) {
        this.context = context;
        this.sections = new ArrayList<TGToolBarSection>();
        this.createSyncProcesses();
        this.appendListeners();
    }

    public void appendListeners() {
        TuxGuitar.getInstance().getSkinManager().addLoader(this);
        TuxGuitar.getInstance().getLanguageManager().addLoader(this);
        TuxGuitar.getInstance().getEditorManager().addUpdateListener((TGEventListener)this);
    }

    public void createSyncProcesses() {
        this.updateItemsProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGToolBarModel.this.updateItems();
            }
        });
        this.loadIconsProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGToolBarModel.this.loadIcons();
            }
        });
        this.loadPropertiesProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGToolBarModel.this.loadProperties();
            }
        });
    }

    public void updateItems() {
        if (!this.isDisposed()) {
            for (TGToolBarSection section : this.sections) {
                section.updateItems();
            }
        }
    }

    public void loadIcons() {
        if (!this.isDisposed()) {
            for (TGToolBarSection section : this.sections) {
                section.loadIcons();
            }
        }
    }

    public void loadProperties() {
        if (!this.isDisposed()) {
            for (TGToolBarSection section : this.sections) {
                section.loadProperties();
            }
        }
    }

    public void updateVisibility(boolean visible) {
        if (!this.isDisposed() && this.isVisible() != visible) {
            this.getControl().setVisible(visible);
            TGWindow.getInstance(this.context).getWindow().layout();
        }
    }

    public void toogleVisibility() {
        this.updateVisibility(!this.isVisible());
    }

    public boolean isVisible() {
        return !this.isDisposed() && this.getControl().isVisible();
    }

    public boolean isDisposed() {
        return this.getControl() == null || this.getControl().isDisposed();
    }

    public void clearSections() {
        this.sections.clear();
    }

    public void addSection(TGToolBarSection section) {
        this.sections.add(section);
    }

    public List<TGToolBarSection> getSections() {
        return this.sections;
    }

    public TGContext getContext() {
        return this.context;
    }

    public void processUpdateEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("updateMode");
        if (type == 1) {
            this.updateItemsProcess.process();
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        } else if ("ui-skin".equals(event.getEventType())) {
            this.loadIconsProcess.process();
        } else if ("language".equals(event.getEventType())) {
            this.loadPropertiesProcess.process();
        }
    }

    public abstract UIControl getControl();
}

