/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.view.component.tab.Tablature;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.dialog.transport.TGTransportDialog;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.app.view.toolbar.edit.TGEditToolBar;
import org.herac.tuxguitar.app.view.toolbar.main.TGMainToolBar;
import org.herac.tuxguitar.graphics.control.TGLayoutHorizontal;
import org.herac.tuxguitar.graphics.control.TGLayoutVertical;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.menu.UIMenu;
import org.herac.tuxguitar.ui.menu.UIMenuActionItem;
import org.herac.tuxguitar.ui.menu.UIMenuCheckableItem;
import org.herac.tuxguitar.ui.menu.UIMenuItem;
import org.herac.tuxguitar.ui.menu.UIMenuSubMenuItem;

public class ViewMenuItem
extends TGMenuItem {
    private UIMenuSubMenuItem layoutMenuItem;
    private UIMenuCheckableItem showMainToolbar;
    private UIMenuCheckableItem showEditToolbar;
    private UIMenuCheckableItem showInstruments;
    private UIMenuCheckableItem showTransport;
    private UIMenuCheckableItem showFretBoard;
    private UIMenuCheckableItem showPiano;
    private UIMenuCheckableItem showMatrix;
    private UIMenuCheckableItem pageLayout;
    private UIMenuCheckableItem linearLayout;
    private UIMenuCheckableItem multitrack;
    private UIMenuCheckableItem scoreEnabled;
    private UIMenuCheckableItem tablatureEnabled;
    private UIMenuCheckableItem compact;
    private UIMenuActionItem zoomIn;
    private UIMenuActionItem zoomOut;
    private UIMenuActionItem zoomReset;
    private UIMenuSubMenuItem chordMenuItem;
    private UIMenuCheckableItem chordName;
    private UIMenuCheckableItem chordDiagram;

    public ViewMenuItem(UIMenu parent) {
        this.layoutMenuItem = parent.createSubMenuItem();
    }

    @Override
    public void showItems() {
        this.showMainToolbar = this.layoutMenuItem.getMenu().createCheckItem();
        this.showMainToolbar.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-main-toolbar"));
        this.showEditToolbar = this.layoutMenuItem.getMenu().createCheckItem();
        this.showEditToolbar.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-edit-toolbar"));
        this.showInstruments = this.layoutMenuItem.getMenu().createCheckItem();
        this.showInstruments.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-channels-dialog"));
        this.showTransport = this.layoutMenuItem.getMenu().createCheckItem();
        this.showTransport.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-transport-dialog"));
        this.showFretBoard = this.layoutMenuItem.getMenu().createCheckItem();
        this.showFretBoard.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-fretboard-editor"));
        this.showPiano = this.layoutMenuItem.getMenu().createCheckItem();
        this.showPiano.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-piano-editor"));
        this.showMatrix = this.layoutMenuItem.getMenu().createCheckItem();
        this.showMatrix.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.toggle-matrix-editor"));
        this.layoutMenuItem.getMenu().createSeparator();
        this.pageLayout = this.layoutMenuItem.getMenu().createRadioItem();
        this.pageLayout.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-page"));
        this.linearLayout = this.layoutMenuItem.getMenu().createRadioItem();
        this.linearLayout.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-linear"));
        this.multitrack = this.layoutMenuItem.getMenu().createCheckItem();
        this.multitrack.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-multitrack"));
        this.scoreEnabled = this.layoutMenuItem.getMenu().createCheckItem();
        this.scoreEnabled.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-score-enabled"));
        this.tablatureEnabled = this.layoutMenuItem.getMenu().createCheckItem();
        this.tablatureEnabled.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-tablature-enabled"));
        this.compact = this.layoutMenuItem.getMenu().createCheckItem();
        this.compact.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-compact"));
        this.layoutMenuItem.getMenu().createSeparator();
        this.chordMenuItem = this.layoutMenuItem.getMenu().createSubMenuItem();
        this.chordName = this.chordMenuItem.getMenu().createCheckItem();
        this.chordName.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-chord-name-enabled"));
        this.chordDiagram = this.chordMenuItem.getMenu().createCheckItem();
        this.chordDiagram.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-chord-diagram-enabled"));
        this.layoutMenuItem.getMenu().createSeparator();
        this.zoomIn = this.layoutMenuItem.getMenu().createActionItem();
        this.zoomIn.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-increment-scale"));
        this.zoomOut = this.layoutMenuItem.getMenu().createActionItem();
        this.zoomOut.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-decrement-scale"));
        this.zoomReset = this.layoutMenuItem.getMenu().createActionItem();
        this.zoomReset.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-reset-scale"));
        this.loadIcons();
        this.loadProperties();
    }

    @Override
    public void update() {
        Tablature tablature = TablatureEditor.getInstance(this.findContext()).getTablature();
        int style = tablature.getViewLayout().getStyle();
        this.showMainToolbar.setChecked(TGMainToolBar.getInstance(this.findContext()).isVisible());
        this.showEditToolbar.setChecked(TGEditToolBar.getInstance(this.findContext()).isVisible());
        this.showInstruments.setChecked(!TuxGuitar.getInstance().getChannelManager().isDisposed());
        this.showTransport.setChecked(!TGTransportDialog.getInstance(this.findContext()).isDisposed());
        this.showFretBoard.setChecked(TuxGuitar.getInstance().getFretBoardEditor().isVisible());
        this.showPiano.setChecked(!TuxGuitar.getInstance().getPianoEditor().isDisposed());
        this.showMatrix.setChecked(!TuxGuitar.getInstance().getMatrixEditor().isDisposed());
        this.pageLayout.setChecked(tablature.getViewLayout() instanceof TGLayoutVertical);
        this.linearLayout.setChecked(tablature.getViewLayout() instanceof TGLayoutHorizontal);
        this.multitrack.setChecked((style & 2) != 0);
        this.scoreEnabled.setChecked((style & 4) != 0);
        this.tablatureEnabled.setChecked((style & 8) != 0);
        this.compact.setChecked((style & 1) != 0);
        this.compact.setEnabled((style & 2) == 0 || tablature.getViewLayout().getSong().countTracks() == 1);
        this.chordName.setChecked((style & 0x10) != 0);
        this.chordDiagram.setChecked((style & 0x20) != 0);
        this.zoomReset.setEnabled(!Tablature.DEFAULT_SCALE.equals(tablature.getScale()));
    }

    @Override
    public void loadProperties() {
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.layoutMenuItem, "view", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.showMainToolbar, "view.show-main-toolbar", "action.gui.toggle-main-toolbar");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.showEditToolbar, "view.show-edit-toolbar", "action.gui.toggle-main-toolbar");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.showInstruments, "view.show-instruments", "action.gui.toggle-channels-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.showTransport, "view.show-transport", "action.gui.toggle-transport-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.showFretBoard, "view.show-fretboard", "action.gui.toggle-fretboard-editor");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.showPiano, "view.show-piano", "action.gui.toggle-piano-editor");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.showMatrix, "view.show-matrix", "action.gui.toggle-matrix-editor");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.pageLayout, "view.layout.page", "action.view.layout-set-page");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.linearLayout, "view.layout.linear", "action.view.layout-set-linear");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.multitrack, "view.layout.multitrack", "action.view.layout-set-multitrack");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.scoreEnabled, "view.layout.score-enabled", "action.view.layout-set-score-enabled");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.tablatureEnabled, "view.layout.tablature-enabled", "action.view.layout-set-tablature-enabled");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.compact, "view.layout.compact", "action.view.layout-set-compact");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.chordMenuItem, "view.layout.chord-style", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.chordName, "view.layout.chord-name", "action.view.layout-set-chord-name-enabled");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.chordDiagram, "view.layout.chord-diagram", "action.view.layout-set-chord-diagram-enabled");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.zoomIn, "view.zoom.in", "action.view.layout-increment-scale");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.zoomOut, "view.zoom.out", "action.view.layout-decrement-scale");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.zoomReset, "view.zoom.reset", "action.view.layout-reset-scale");
    }

    public void loadIcons() {
    }
}

