/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.menu.impl;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.TGActionProcessorListener;
import org.herac.tuxguitar.app.view.menu.TGMenuItem;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.menu.UIMenu;
import org.herac.tuxguitar.ui.menu.UIMenuCheckableItem;
import org.herac.tuxguitar.ui.menu.UIMenuSubMenuItem;

public class DynamicMenuItem
extends TGMenuItem {
    private UIMenuSubMenuItem dynamicMenuItem;
    private UIMenuCheckableItem pianoPianissimo;
    private UIMenuCheckableItem pianissimo;
    private UIMenuCheckableItem piano;
    private UIMenuCheckableItem mezzoPiano;
    private UIMenuCheckableItem mezzoForte;
    private UIMenuCheckableItem forte;
    private UIMenuCheckableItem fortissimo;
    private UIMenuCheckableItem forteFortissimo;

    public DynamicMenuItem(UIMenuSubMenuItem dynamicMenuItem) {
        this.dynamicMenuItem = dynamicMenuItem;
    }

    public DynamicMenuItem(UIMenu parent) {
        this(parent.createSubMenuItem());
    }

    @Override
    public void showItems() {
        this.pianoPianissimo = this.dynamicMenuItem.getMenu().createCheckItem();
        this.pianoPianissimo.addSelectionListener((UISelectionListener)this.createChangeVelocityAction(15));
        this.pianissimo = this.dynamicMenuItem.getMenu().createCheckItem();
        this.pianissimo.addSelectionListener((UISelectionListener)this.createChangeVelocityAction(31));
        this.piano = this.dynamicMenuItem.getMenu().createCheckItem();
        this.piano.addSelectionListener((UISelectionListener)this.createChangeVelocityAction(47));
        this.mezzoPiano = this.dynamicMenuItem.getMenu().createCheckItem();
        this.mezzoPiano.addSelectionListener((UISelectionListener)this.createChangeVelocityAction(63));
        this.mezzoForte = this.dynamicMenuItem.getMenu().createCheckItem();
        this.mezzoForte.addSelectionListener((UISelectionListener)this.createChangeVelocityAction(79));
        this.forte = this.dynamicMenuItem.getMenu().createCheckItem();
        this.forte.addSelectionListener((UISelectionListener)this.createChangeVelocityAction(95));
        this.fortissimo = this.dynamicMenuItem.getMenu().createCheckItem();
        this.fortissimo.addSelectionListener((UISelectionListener)this.createChangeVelocityAction(111));
        this.forteFortissimo = this.dynamicMenuItem.getMenu().createCheckItem();
        this.forteFortissimo.addSelectionListener((UISelectionListener)this.createChangeVelocityAction(127));
        this.loadIcons();
        this.loadProperties();
    }

    @Override
    public void update() {
        TGNote note = TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getSelectedNote();
        int velocity = note != null ? note.getVelocity() : TuxGuitar.getInstance().getTablatureEditor().getTablature().getCaret().getVelocity();
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        this.pianoPianissimo.setChecked(velocity == 15);
        this.pianoPianissimo.setEnabled(!running);
        this.pianissimo.setChecked(velocity == 31);
        this.pianissimo.setEnabled(!running);
        this.piano.setChecked(velocity == 47);
        this.piano.setEnabled(!running);
        this.mezzoPiano.setChecked(velocity == 63);
        this.mezzoPiano.setEnabled(!running);
        this.mezzoForte.setChecked(velocity == 79);
        this.mezzoForte.setEnabled(!running);
        this.forte.setChecked(velocity == 95);
        this.forte.setEnabled(!running);
        this.fortissimo.setChecked(velocity == 111);
        this.fortissimo.setEnabled(!running);
        this.forteFortissimo.setChecked(velocity == 127);
        this.forteFortissimo.setEnabled(!running);
    }

    @Override
    public void loadProperties() {
        this.dynamicMenuItem.setText(TuxGuitar.getProperty("dynamic"));
        this.pianoPianissimo.setText(TuxGuitar.getProperty("dynamic.piano-pianissimo"));
        this.pianissimo.setText(TuxGuitar.getProperty("dynamic.pianissimo"));
        this.piano.setText(TuxGuitar.getProperty("dynamic.piano"));
        this.mezzoPiano.setText(TuxGuitar.getProperty("dynamic.mezzo-piano"));
        this.mezzoForte.setText(TuxGuitar.getProperty("dynamic.mezzo-forte"));
        this.forte.setText(TuxGuitar.getProperty("dynamic.forte"));
        this.fortissimo.setText(TuxGuitar.getProperty("dynamic.fortissimo"));
        this.forteFortissimo.setText(TuxGuitar.getProperty("dynamic.forte-fortissimo"));
    }

    public void loadIcons() {
    }

    public TGActionProcessorListener createChangeVelocityAction(Integer velocity) {
        TGActionProcessorListener tgActionProcessor = this.createActionProcessor("action.note.general.velocity");
        tgActionProcessor.setAttribute("velocity", velocity);
        return tgActionProcessor;
    }
}

