/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.main;

import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.resource.UISize;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILayoutContainer;

public class TGWindowLayout
extends UITableLayout {
    private UIControl top;
    private UIControl topContainer;
    private UIControl divider;
    private UIControl bottomContainer;
    private UIControl bottom;

    public TGWindowLayout(UIControl top, UIControl topContainer, UIControl divider, UIControl bottomContainer, UIControl bottom) {
        this.top = top;
        this.topContainer = topContainer;
        this.divider = divider;
        this.bottomContainer = bottomContainer;
        this.bottom = bottom;
        this.configure();
    }

    public UISize computePackedSize(UILayoutContainer container) {
        return this.computePackedSize(container, true);
    }

    public UISize computePackedSize(UILayoutContainer container, boolean resetTableHeight) {
        if (resetTableHeight) {
            this.set(this.bottomContainer, "maximum_packed_height", null);
        }
        return super.computePackedSize(container);
    }

    public void setBounds(UILayoutContainer container, UIRectangle bounds) {
        UISize packedContentSize = container.getPackedContentSize();
        if (packedContentSize.getHeight() > bounds.getHeight()) {
            UISize preferredSize = this.getPreferredControlSize(this.bottomContainer);
            this.set(this.bottomContainer, "maximum_packed_height", Float.valueOf(preferredSize.getHeight() - (packedContentSize.getHeight() - bounds.getHeight())));
            this.computePackedSize(container, false);
        }
        super.setBounds(container, bounds);
    }

    public void configure() {
        this.set("margin_top", Float.valueOf(0.0f));
        this.set("ignore_invisible", true);
        this.set(this.top, 1, 1, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, true, false, 1, 1, null, null, Float.valueOf(0.0f));
        this.set(this.topContainer, 2, 1, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, true, true, 1, 1, null, null, Float.valueOf(0.0f));
        this.set(this.topContainer, "packed_height", Float.valueOf(0.0f));
        this.set(this.divider, 3, 1, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, false, false, 1, 1, null, null, Float.valueOf(0.0f));
        this.set(this.divider, "packed_height", Float.valueOf(4.0f));
        this.set(this.divider, "margin", Float.valueOf(0.0f));
        this.set(this.bottomContainer, 4, 1, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, true, false, 1, 1, null, null, Float.valueOf(0.0f));
        this.set(this.bottom, 5, 1, UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, true, false, 1, 1, null, null, Float.valueOf(0.0f));
    }
}

