/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.track;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.TGMessageDialogUtil;
import org.herac.tuxguitar.app.view.dialog.track.TGTrackTuningChooserHandler;
import org.herac.tuxguitar.app.view.dialog.track.TGTrackTuningDialog;
import org.herac.tuxguitar.app.view.dialog.track.TGTrackTuningModel;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIReadOnlyTextField;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UIWindow;

public class TGTrackTuningChooserDialog {
    private TGTrackTuningDialog tuningDialog;

    public TGTrackTuningChooserDialog(TGTrackTuningDialog tuningDialog) {
        this.tuningDialog = tuningDialog;
    }

    public void select(TGTrackTuningChooserHandler handler) {
        this.select(handler, null);
    }

    public void select(final TGTrackTuningChooserHandler handler, TGTrackTuningModel model) {
        UIFactory uiFactory = this.tuningDialog.getUIFactory();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(this.tuningDialog.getDialog(), true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty("tuning"));
        UITableLayout panelLayout = new UITableLayout();
        UILegendPanel panel = uiFactory.createLegendPanel((UIContainer)dialog);
        panel.setLayout((UILayout)panelLayout);
        panel.setText(TuxGuitar.getProperty("tuning"));
        dialogLayout.set((UIControl)panel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel tuningValueLabel = uiFactory.createLabel((UIContainer)panel);
        tuningValueLabel.setText(TuxGuitar.getProperty("tuning.value"));
        panelLayout.set((UIControl)tuningValueLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UIDropDownSelect tuningValueControl = uiFactory.createDropDownSelect((UIContainer)panel);
        tuningValueControl.addItem(new UISelectItem(TuxGuitar.getProperty("tuning.value.select")));
        String[] tuningTexts = this.getValueLabels();
        for (int value = 0; value < tuningTexts.length; ++value) {
            tuningValueControl.addItem(new UISelectItem(tuningTexts[value], (Object)value));
        }
        for (int i = 1; i <= 32; ++i) {
            tuningValueControl.addItem(new UISelectItem(Integer.toString(i), (Object)i));
        }
        tuningValueControl.setSelectedValue((Object)(model != null ? model.getValue() : null));
        panelLayout.set((UIControl)tuningValueControl, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(150.0f), null, null);
        UILabel tuningLabelLabel = uiFactory.createLabel((UIContainer)panel);
        tuningLabelLabel.setText(TuxGuitar.getProperty("tuning.label"));
        panelLayout.set((UIControl)tuningLabelLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UIReadOnlyTextField tuningLabelControl = uiFactory.createReadOnlyTextField((UIContainer)panel);
        if (model != null) {
            tuningLabelControl.setText(this.getValueLabel(model.getValue()));
        }
        panelLayout.set((UIControl)tuningLabelControl, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(150.0f), null, null);
        tuningValueControl.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                tuningLabelControl.setText(TGTrackTuningChooserDialog.this.getValueLabel((Integer)tuningValueControl.getSelectedValue()));
            }
        });
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                if (TGTrackTuningChooserDialog.this.handleSelection(handler, dialog, (UIDropDownSelect<Integer>)tuningValueControl)) {
                    dialog.dispose();
                }
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(dialog, 5);
    }

    public boolean handleSelection(TGTrackTuningChooserHandler handler, UIWindow dialog, UIDropDownSelect<Integer> value) {
        TGTrackTuningModel model = new TGTrackTuningModel();
        model.setValue((Integer)value.getSelectedValue());
        if (model.getValue() == null) {
            TGMessageDialogUtil.errorMessage(this.tuningDialog.getContext().getContext(), dialog, TuxGuitar.getProperty("tuning.value.empty-error"));
            return false;
        }
        handler.handleSelection(model);
        return true;
    }

    private String[] getValueLabels() {
        return this.tuningDialog.getValueLabels();
    }

    private String getValueLabel(Integer value) {
        return this.tuningDialog.getValueLabel(value);
    }
}

