/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.grace;

import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.action.effect.TGChangeGraceNoteAction;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UICheckBox;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIRadioButton;
import org.herac.tuxguitar.ui.widget.UISpinner;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;

public class TGGraceDialog {
    private UISpinner fretSpinner;
    private UICheckBox deadButton;
    private UIRadioButton beforeBeatButton;
    private UIRadioButton onBeatButton;
    private UIRadioButton durationButton1;
    private UIRadioButton durationButton2;
    private UIRadioButton durationButton3;
    private UIRadioButton pppButton;
    private UIRadioButton ppButton;
    private UIRadioButton pButton;
    private UIRadioButton mpButton;
    private UIRadioButton mfButton;
    private UIRadioButton fButton;
    private UIRadioButton ffButton;
    private UIRadioButton fffButton;
    private UIRadioButton noneButton;
    private UIRadioButton slideButton;
    private UIRadioButton bendButton;
    private UIRadioButton hammerButton;

    public void show(final TGViewContext context) {
        final TGMeasure measure = (TGMeasure)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE);
        final TGBeat beat = (TGBeat)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT);
        final TGString string = (TGString)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING);
        TGNote note = (TGNote)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_NOTE);
        if (measure != null && beat != null && note != null && string != null) {
            UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
            UIWindow uiParent = (UIWindow)context.getAttribute("parent");
            UITableLayout dialogLayout = new UITableLayout();
            final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
            dialog.setLayout((UILayout)dialogLayout);
            dialog.setText(TuxGuitar.getProperty("effects.grace-editor"));
            boolean dead = false;
            boolean onBeat = false;
            int fret = note.getValue();
            int duration = 1;
            int dynamic = 95;
            int transition = 0;
            if (note.getEffect().isGrace()) {
                dead = note.getEffect().getGrace().isDead();
                fret = note.getEffect().getGrace().getFret();
                onBeat = note.getEffect().getGrace().isOnBeat();
                duration = note.getEffect().getGrace().getDuration();
                dynamic = note.getEffect().getGrace().getDynamic();
                transition = note.getEffect().getGrace().getTransition();
            }
            UITableLayout noteLayout = new UITableLayout();
            UILegendPanel noteGroup = uiFactory.createLegendPanel((UIContainer)dialog);
            noteGroup.setLayout((UILayout)noteLayout);
            noteGroup.setText(TuxGuitar.getProperty("note"));
            dialogLayout.set((UIControl)noteGroup, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(2), Float.valueOf(350.0f), null, null);
            UILabel fretLabel = uiFactory.createLabel((UIContainer)noteGroup);
            fretLabel.setText(TuxGuitar.getProperty("fret") + ": ");
            noteLayout.set((UIControl)fretLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
            this.fretSpinner = uiFactory.createSpinner((UIContainer)noteGroup);
            this.fretSpinner.setValue(fret);
            noteLayout.set((UIControl)this.fretSpinner, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.deadButton = uiFactory.createCheckBox((UIContainer)noteGroup);
            this.deadButton.setText(TuxGuitar.getProperty("note.deadnote"));
            this.deadButton.setSelected(dead);
            noteLayout.set((UIControl)this.deadButton, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(2));
            UITableLayout positionLayout = new UITableLayout();
            UILegendPanel positionGroup = uiFactory.createLegendPanel((UIContainer)dialog);
            positionGroup.setLayout((UILayout)positionLayout);
            positionGroup.setText(TuxGuitar.getProperty("position"));
            dialogLayout.set((UIControl)positionGroup, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(2));
            this.beforeBeatButton = uiFactory.createRadioButton((UIContainer)positionGroup);
            this.beforeBeatButton.setText(TuxGuitar.getProperty("effects.grace.before-beat"));
            this.beforeBeatButton.setSelected(!onBeat);
            positionLayout.set((UIControl)this.beforeBeatButton, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.onBeatButton = uiFactory.createRadioButton((UIContainer)positionGroup);
            this.onBeatButton.setText(TuxGuitar.getProperty("effects.grace.on-beat"));
            this.onBeatButton.setSelected(onBeat);
            positionLayout.set((UIControl)this.onBeatButton, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            UITableLayout durationLayout = new UITableLayout();
            UILegendPanel durationGroup = uiFactory.createLegendPanel((UIContainer)dialog);
            durationGroup.setLayout((UILayout)durationLayout);
            durationGroup.setText(TuxGuitar.getProperty("duration"));
            dialogLayout.set((UIControl)durationGroup, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(2));
            this.durationButton1 = uiFactory.createRadioButton((UIContainer)durationGroup);
            this.durationButton1.setImage(TuxGuitar.getInstance().getIconManager().getDuration(64));
            this.durationButton1.setSelected(duration == 1);
            durationLayout.set((UIControl)this.durationButton1, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.durationButton2 = uiFactory.createRadioButton((UIContainer)durationGroup);
            this.durationButton2.setImage(TuxGuitar.getInstance().getIconManager().getDuration(32));
            this.durationButton2.setSelected(duration == 2);
            durationLayout.set((UIControl)this.durationButton2, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.durationButton3 = uiFactory.createRadioButton((UIContainer)durationGroup);
            this.durationButton3.setImage(TuxGuitar.getInstance().getIconManager().getDuration(16));
            this.durationButton3.setSelected(duration == 3);
            durationLayout.set((UIControl)this.durationButton3, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            UITableLayout dynamicLayout = new UITableLayout();
            UILegendPanel dynamicGroup = uiFactory.createLegendPanel((UIContainer)dialog);
            dynamicGroup.setLayout((UILayout)dynamicLayout);
            dynamicGroup.setText(TuxGuitar.getProperty("dynamic"));
            dialogLayout.set((UIControl)dynamicGroup, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.pppButton = uiFactory.createRadioButton((UIContainer)dynamicGroup);
            this.pppButton.setImage(TuxGuitar.getInstance().getIconManager().getDynamicPPP());
            this.pppButton.setSelected(dynamic == 15);
            dynamicLayout.set((UIControl)this.pppButton, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.mfButton = uiFactory.createRadioButton((UIContainer)dynamicGroup);
            this.mfButton.setImage(TuxGuitar.getInstance().getIconManager().getDynamicMF());
            this.mfButton.setSelected(dynamic == 79);
            dynamicLayout.set((UIControl)this.mfButton, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.ppButton = uiFactory.createRadioButton((UIContainer)dynamicGroup);
            this.ppButton.setImage(TuxGuitar.getInstance().getIconManager().getDynamicPP());
            this.ppButton.setSelected(dynamic == 31);
            dynamicLayout.set((UIControl)this.ppButton, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.fButton = uiFactory.createRadioButton((UIContainer)dynamicGroup);
            this.fButton.setImage(TuxGuitar.getInstance().getIconManager().getDynamicF());
            this.fButton.setSelected(dynamic == 95);
            dynamicLayout.set((UIControl)this.fButton, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.pButton = uiFactory.createRadioButton((UIContainer)dynamicGroup);
            this.pButton.setImage(TuxGuitar.getInstance().getIconManager().getDynamicP());
            this.pButton.setSelected(dynamic == 47);
            dynamicLayout.set((UIControl)this.pButton, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.ffButton = uiFactory.createRadioButton((UIContainer)dynamicGroup);
            this.ffButton.setImage(TuxGuitar.getInstance().getIconManager().getDynamicFF());
            this.ffButton.setSelected(dynamic == 111);
            dynamicLayout.set((UIControl)this.ffButton, Integer.valueOf(3), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.mpButton = uiFactory.createRadioButton((UIContainer)dynamicGroup);
            this.mpButton.setImage(TuxGuitar.getInstance().getIconManager().getDynamicMP());
            this.mpButton.setSelected(dynamic == 63);
            dynamicLayout.set((UIControl)this.mpButton, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.fffButton = uiFactory.createRadioButton((UIContainer)dynamicGroup);
            this.fffButton.setImage(TuxGuitar.getInstance().getIconManager().getDynamicFFF());
            this.fffButton.setSelected(dynamic == 127);
            dynamicLayout.set((UIControl)this.fffButton, Integer.valueOf(4), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            UITableLayout transitionLayout = new UITableLayout();
            UILegendPanel transitionGroup = uiFactory.createLegendPanel((UIContainer)dialog);
            transitionGroup.setLayout((UILayout)transitionLayout);
            transitionGroup.setText(TuxGuitar.getProperty("effects.grace.transition"));
            dialogLayout.set((UIControl)transitionGroup, Integer.valueOf(4), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.noneButton = uiFactory.createRadioButton((UIContainer)transitionGroup);
            this.noneButton.setText(TuxGuitar.getProperty("effects.grace.transition-none"));
            this.noneButton.setSelected(transition == 0);
            transitionLayout.set((UIControl)this.noneButton, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.bendButton = uiFactory.createRadioButton((UIContainer)transitionGroup);
            this.bendButton.setText(TuxGuitar.getProperty("effects.grace.transition-bend"));
            this.bendButton.setSelected(transition == 2);
            transitionLayout.set((UIControl)this.bendButton, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.slideButton = uiFactory.createRadioButton((UIContainer)transitionGroup);
            this.slideButton.setText(TuxGuitar.getProperty("effects.grace.transition-slide"));
            this.slideButton.setSelected(transition == 1);
            transitionLayout.set((UIControl)this.slideButton, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.hammerButton = uiFactory.createRadioButton((UIContainer)transitionGroup);
            this.hammerButton.setText(TuxGuitar.getProperty("effects.grace.transition-hammer"));
            this.hammerButton.setSelected(transition == 3);
            transitionLayout.set((UIControl)this.hammerButton, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
            UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
            buttons.setLayout((UILayout)buttonsLayout);
            dialogLayout.set((UIControl)buttons, Integer.valueOf(5), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(2));
            UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
            buttonOK.setText(TuxGuitar.getProperty("ok"));
            buttonOK.setDefaultButton();
            buttonOK.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    TGGraceDialog.this.changeGrace(context.getContext(), measure, beat, string, TGGraceDialog.this.getGrace());
                    dialog.dispose();
                }
            });
            buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            UIButton buttonClean = uiFactory.createButton((UIContainer)buttons);
            buttonClean.setText(TuxGuitar.getProperty("clean"));
            buttonClean.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    TGGraceDialog.this.changeGrace(context.getContext(), measure, beat, string, null);
                    dialog.dispose();
                }
            });
            buttonsLayout.set((UIControl)buttonClean, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    dialog.dispose();
                }
            });
            buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
            TGDialogUtil.openDialog(dialog, 5);
        }
    }

    public TGEffectGrace getGrace() {
        TGEffectGrace effect = TuxGuitar.getInstance().getSongManager().getFactory().newEffectGrace();
        effect.setFret(this.fretSpinner.getValue());
        effect.setDead(this.deadButton.isSelected());
        effect.setOnBeat(this.onBeatButton.isSelected());
        if (this.durationButton1.isSelected()) {
            effect.setDuration(1);
        } else if (this.durationButton2.isSelected()) {
            effect.setDuration(2);
        } else if (this.durationButton3.isSelected()) {
            effect.setDuration(3);
        }
        if (this.pppButton.isSelected()) {
            effect.setDynamic(15);
        } else if (this.ppButton.isSelected()) {
            effect.setDynamic(31);
        } else if (this.pButton.isSelected()) {
            effect.setDynamic(47);
        } else if (this.mpButton.isSelected()) {
            effect.setDynamic(63);
        } else if (this.mfButton.isSelected()) {
            effect.setDynamic(79);
        } else if (this.fButton.isSelected()) {
            effect.setDynamic(95);
        } else if (this.ffButton.isSelected()) {
            effect.setDynamic(111);
        } else if (this.fffButton.isSelected()) {
            effect.setDynamic(127);
        }
        if (this.noneButton.isSelected()) {
            effect.setTransition(0);
        } else if (this.slideButton.isSelected()) {
            effect.setTransition(1);
        } else if (this.bendButton.isSelected()) {
            effect.setTransition(2);
        } else if (this.hammerButton.isSelected()) {
            effect.setTransition(3);
        }
        return effect;
    }

    public void changeGrace(TGContext context, TGMeasure measure, TGBeat beat, TGString string, TGEffectGrace effect) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.note.effect.change-grace");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)string);
        tgActionProcessor.setAttribute(TGChangeGraceNoteAction.ATTRIBUTE_EFFECT, (Object)effect);
        tgActionProcessor.process();
    }
}

