/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.chord;

import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.icons.TGColorManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordCustomList;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordEditor;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordList;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordRecognizer;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordSelector;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordStyleAdapter;
import org.herac.tuxguitar.app.view.util.TGCursorController;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UIDisposeEvent;
import org.herac.tuxguitar.ui.event.UIDisposeListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UIColor;
import org.herac.tuxguitar.ui.resource.UICursor;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIWindow;

public class TGChordDialog {
    private UIWindow dialog;
    private TGViewContext context;
    private TGChordEditor editor;
    private TGChordSelector selector;
    private TGChordList list;
    private TGChordRecognizer recognizer;
    private TGCursorController cursorController;

    public TGChordDialog(TGViewContext context) {
        this.context = context;
    }

    public void show() {
        final TGTrack track = (TGTrack)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
        final TGMeasure measure = (TGMeasure)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE);
        final TGBeat beat = (TGBeat)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT);
        final TGVoice voice = (TGVoice)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_VOICE);
        UIFactory uiFactory = this.getUIFactory();
        UIWindow uiParent = (UIWindow)this.context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        TGChordStyleAdapter.appendColors(this.context.getContext());
        this.dialog = uiFactory.createWindow(uiParent, true, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.setText(TuxGuitar.getProperty("chord.editor"));
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TuxGuitar.getInstance().getCustomChordManager().write();
            }
        });
        UITableLayout topLayout = new UITableLayout();
        UIPanel topComposite = uiFactory.createPanel((UIContainer)this.dialog, false);
        topComposite.setLayout((UILayout)topLayout);
        dialogLayout.set((UIControl)topComposite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout bottomLayout = new UITableLayout();
        UIPanel bottomComposite = uiFactory.createPanel((UIContainer)this.dialog, false);
        bottomComposite.setLayout((UILayout)bottomLayout);
        dialogLayout.set((UIControl)bottomComposite, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        int[] tuning = this.findCurrentTuning(measure.getTrack());
        this.selector = new TGChordSelector(this, (UIContainer)topComposite, tuning);
        topLayout.set((UIControl)this.selector.getControl(), Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.editor = new TGChordEditor(this, (UIContainer)topComposite, (short)tuning.length);
        this.editor.setCurrentTrack(measure.getTrack());
        topLayout.set((UIControl)this.editor.getControl(), Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.recognizer = new TGChordRecognizer(this, (UIContainer)topComposite);
        topLayout.set((UIControl)this.recognizer.getControl(), Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(180.0f), null, null);
        TGChordCustomList customList = new TGChordCustomList(this, (UIContainer)topComposite);
        topLayout.set((UIControl)customList.getControl(), Integer.valueOf(1), Integer.valueOf(4), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.list = new TGChordList(this, (UIContainer)bottomComposite, beat);
        bottomLayout.set((UIControl)this.list.getControl(), Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout buttonsLayout = new UITableLayout();
        UIPanel buttons = uiFactory.createPanel((UIContainer)this.dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChordDialog.this.insertChord(track, measure, beat, voice, TGChordDialog.this.getEditor().getChord());
                TGChordDialog.this.getWindow().dispose();
            }
        });
        UIButton buttonClean = uiFactory.createButton((UIContainer)buttons);
        buttonClean.setText(TuxGuitar.getProperty("clean"));
        buttonClean.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChordDialog.this.removeChord(measure, beat);
                TGChordDialog.this.getWindow().dispose();
            }
        });
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChordDialog.this.getWindow().dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonClean, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        this.editor.setChord(this.findCurrentChord(measure, beat.getStart()));
        TGDialogUtil.openDialog(this.dialog, 5);
    }

    public TGChordEditor getEditor() {
        return this.editor;
    }

    public TGChordSelector getSelector() {
        return this.selector;
    }

    public TGChordList getList() {
        return this.list;
    }

    public TGChordRecognizer getRecognizer() {
        return this.recognizer;
    }

    public boolean isDisposed() {
        return this.dialog.isDisposed();
    }

    public UIWindow getWindow() {
        return this.dialog;
    }

    public void loadCursor(UICursor cursor) {
        if (!this.dialog.isDisposed()) {
            if (this.cursorController == null || !this.cursorController.isControlling((UIControl)this.dialog)) {
                this.cursorController = new TGCursorController(this.getContext().getContext(), (UIControl)this.dialog);
            }
            this.cursorController.loadCursor(cursor);
        }
    }

    public UIColor getColor(String colorId) {
        return TGColorManager.getInstance(this.context.getContext()).getColor(colorId);
    }

    private int[] findCurrentTuning(TGTrack track) {
        int[] tuning = new int[track.stringCount()];
        for (TGString string : track.getStrings()) {
            tuning[tuning.length - string.getNumber()] = string.getValue();
        }
        return tuning;
    }

    protected TGChord findCurrentChord(TGMeasure measure, long start) {
        TGSongManager manager = TuxGuitar.getInstance().getSongManager();
        TGChord chord = manager.getMeasureManager().getChord(measure, start);
        if (chord == null) {
            chord = manager.getFactory().newChord(measure.getTrack().stringCount());
            chord.setFirstFret(1);
            List notes = manager.getMeasureManager().getNotes(measure, start);
            if (!notes.isEmpty()) {
                int maxValue = -1;
                int minValue = -1;
                for (TGNote note : notes) {
                    if (maxValue < 0 || maxValue < note.getValue()) {
                        maxValue = note.getValue();
                    }
                    if (note.getValue() <= 0 || minValue >= 0 && minValue <= note.getValue()) continue;
                    minValue = note.getValue();
                }
                if (maxValue > 6 && minValue > 0) {
                    chord.setFirstFret((int)((short)minValue));
                }
                for (TGNote note : notes) {
                    chord.addFretValue(note.getString() - 1, note.getValue());
                }
            }
        }
        return chord;
    }

    public void insertChord(TGTrack track, TGMeasure measure, TGBeat beat, TGVoice voice, TGChord chord) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.beat.general.insert-chord");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_VOICE, (Object)voice);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_CHORD, (Object)chord);
        tgActionProcessor.processOnNewThread();
    }

    public void removeChord(TGMeasure measure, TGBeat beat) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.beat.general.remove-chord");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
        tgActionProcessor.processOnNewThread();
    }

    public UIFactory getUIFactory() {
        return TGApplication.getInstance(this.context.getContext()).getFactory();
    }

    public TGViewContext getContext() {
        return this.context;
    }
}

