/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.system.keybindings;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.keybindings.KeyBindingAction;
import org.herac.tuxguitar.app.system.keybindings.KeyBindingActionDefaults;
import org.herac.tuxguitar.app.system.keybindings.KeyBindingListener;
import org.herac.tuxguitar.app.system.keybindings.xml.KeyBindingReader;
import org.herac.tuxguitar.app.system.keybindings.xml.KeyBindingWriter;
import org.herac.tuxguitar.app.util.TGFileUtils;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.ui.event.UIKeyPressedListener;
import org.herac.tuxguitar.ui.resource.UIKeyCombination;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class KeyBindingActionManager {
    private TGContext context;
    private List<KeyBindingAction> keyBindingsActions;
    private KeyBindingListener listener;

    private KeyBindingActionManager(TGContext context) {
        this.context = context;
        this.keyBindingsActions = new ArrayList<KeyBindingAction>();
        this.init();
    }

    public void init() {
        List<KeyBindingAction> enabled = KeyBindingReader.getKeyBindings(this.getUserFileName());
        this.keyBindingsActions.addAll(enabled != null ? enabled : KeyBindingActionDefaults.getDefaultKeyBindings(this.context));
        this.listener = new KeyBindingListener(this);
    }

    private String getUserFileName() {
        return TGFileUtils.PATH_USER_CONFIG + File.separator + "shortcuts.xml";
    }

    public String getActionForKeyBinding(UIKeyCombination kb) {
        for (KeyBindingAction keyBindingAction : this.keyBindingsActions) {
            if (keyBindingAction.getCombination() == null || !kb.equals((Object)keyBindingAction.getCombination()) || !this.isKeyBindingAvailable(keyBindingAction)) continue;
            return keyBindingAction.getAction();
        }
        return null;
    }

    public UIKeyCombination getKeyBindingForAction(String action) {
        for (KeyBindingAction keyBindingAction : this.keyBindingsActions) {
            if (!action.equals(keyBindingAction.getAction()) || !this.isKeyBindingAvailable(keyBindingAction)) continue;
            return keyBindingAction.getCombination();
        }
        return null;
    }

    public boolean isKeyBindingAvailable(KeyBindingAction keyBindingAction) {
        String actionId = keyBindingAction.getAction();
        if (actionId != null) {
            return TuxGuitar.getInstance().getActionAdapterManager().getKeyBindingActionIds().hasActionId(actionId);
        }
        return false;
    }

    public void reset(List<KeyBindingAction> keyBindings) {
        this.keyBindingsActions.clear();
        this.keyBindingsActions.addAll(keyBindings);
    }

    public List<KeyBindingAction> getKeyBindingActions() {
        return this.keyBindingsActions;
    }

    public void saveKeyBindings() {
        KeyBindingWriter.setBindings(this.getKeyBindingActions(), this.getUserFileName());
    }

    public void appendListenersTo(UIControl control) {
        control.addKeyPressedListener((UIKeyPressedListener)this.listener);
    }

    public void processKeyBinding(UIKeyCombination kb) {
        String actionId = this.getActionForKeyBinding(kb);
        if (actionId != null) {
            new TGActionProcessor(this.context, actionId).process();
        }
    }

    public static KeyBindingActionManager getInstance(TGContext context) {
        return (KeyBindingActionManager)TGSingletonUtil.getInstance((TGContext)context, (String)KeyBindingActionManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<KeyBindingActionManager>(){

            public KeyBindingActionManager createInstance(TGContext context) {
                return new KeyBindingActionManager(context);
            }
        });
    }
}

