/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.action.impl.system;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.app.system.icons.TGSkinManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.component.table.TGTableViewer;
import org.herac.tuxguitar.app.view.dialog.fretboard.TGFretBoardEditor;
import org.herac.tuxguitar.app.view.dialog.marker.TGMarkerList;
import org.herac.tuxguitar.app.view.dialog.transport.TGTransportDialog;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.toolbar.edit.TGEditToolBar;
import org.herac.tuxguitar.app.view.toolbar.main.TGMainToolBar;
import org.herac.tuxguitar.editor.action.TGActionBase;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.thread.TGThreadManager;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.plugin.TGPluginManager;

public class TGDisposeAction
extends TGActionBase {
    public static final String NAME = "action.system.dispose";

    public TGDisposeAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(TGActionContext context) {
        this.closeModules();
        this.saveConfig();
        this.dispose();
    }

    protected void saveConfig() {
        TGWindow tgWindow = TGWindow.getInstance(this.getContext());
        TGConfigManager config = TuxGuitar.getInstance().getConfig();
        config.setValue("layout.mode", TablatureEditor.getInstance(this.getContext()).getTablature().getViewLayout().getMode());
        config.setValue("layout.style", TablatureEditor.getInstance(this.getContext()).getTablature().getViewLayout().getStyle());
        config.setValue("show.piano", !TuxGuitar.getInstance().getPianoEditor().isDisposed());
        config.setValue("show.matrix", !TuxGuitar.getInstance().getMatrixEditor().isDisposed());
        config.setValue("show.fretboard", TuxGuitar.getInstance().getFretBoardEditor().isVisible());
        config.setValue("show.instruments", !TuxGuitar.getInstance().getChannelManager().isDisposed());
        config.setValue("show.transport", !TGTransportDialog.getInstance(this.getContext()).isDisposed());
        config.setValue("show.markers", !TGMarkerList.getInstance(this.getContext()).isDisposed());
        config.setValue("show.main-toolbar", TGMainToolBar.getInstance(this.getContext()).isVisible());
        config.setValue("show.edit-toolbar", TGEditToolBar.getInstance(this.getContext()).isVisible());
        config.setValue("window.maximized", tgWindow.getWindow().isMaximized());
        config.setValue("window.width", tgWindow.getWindow().getBounds().getWidth());
        config.setValue("window.height", tgWindow.getWindow().getBounds().getHeight());
        config.setValue("editor.mouse.mode", TablatureEditor.getInstance(this.getContext()).getTablature().getEditorKit().getMouseMode());
        config.setValue("matrix.grids", TuxGuitar.getInstance().getMatrixEditor().getGrids());
        TuxGuitar.getInstance().getConfig().save();
    }

    protected void closeModules() {
        MidiPlayer.getInstance((TGContext)this.getContext()).close();
        TGPluginManager.getInstance((TGContext)this.getContext()).disconnectAll();
    }

    protected void dispose() {
        TGTableViewer.getInstance(this.getContext()).dispose();
        TGFretBoardEditor.getInstance(this.getContext()).dispose();
        TablatureEditor.getInstance(this.getContext()).getTablature().dispose();
        TGWindow.getInstance(this.getContext()).getWindow().dispose();
        TGSkinManager.getInstance(this.getContext()).dispose();
        TGApplication.getInstance(this.getContext()).dispose();
        TGThreadManager.getInstance((TGContext)this.getContext()).dispose();
    }
}

