/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSOutlineView;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableHeaderCell;
import org.eclipse.swt.internal.cocoa.NSTableHeaderView;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TypedListener;

public class TreeColumn
extends Item {
    NSTableColumn nsColumn;
    Tree parent;
    String toolTipText;
    String displayText;
    boolean movable;
    static final int MARGIN = 2;

    public TreeColumn(Tree tree, int n) {
        super(tree, TreeColumn.checkStyle(n));
        this.parent = tree;
        tree.createItem(this, tree.columnCount);
    }

    public TreeColumn(Tree tree, int n, int n2) {
        super(tree, TreeColumn.checkStyle(n));
        this.parent = tree;
        tree.createItem(this, n2);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return TreeColumn.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.nsColumn.headerCell());
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    @Override
    void drawInteriorWithFrame_inView(long l, long l2, NSRect nSRect, long l3) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        double d;
        int n = this.parent.indexOf(this.nsColumn);
        NSRect nSRect2 = this.parent.headerView.headerRectOfColumn(n);
        double d2 = d = this.parent.hasBorder() ? 0.5 : 0.0;
        if (nSRect2.x != nSRect.x || nSRect2.width != nSRect.width) {
            if (this.parent.headerBackground != null) {
                NSGraphicsContext nSGraphicsContext = NSGraphicsContext.currentContext();
                nSGraphicsContext.saveGraphicsState();
                double[] dArray = this.parent.headerBackground;
                NSColor nSColor = NSColor.colorWithDeviceRed(dArray[0], dArray[1], dArray[2], 1.0);
                nSColor.setFill();
                NSRect nSRect3 = new NSRect();
                nSRect3.x = nSRect.x;
                nSRect3.y = nSRect2.y + d;
                nSRect3.width = nSRect.width;
                nSRect3.height = nSRect2.height - d - 0.5;
                NSBezierPath.fillRect(nSRect3);
                nSGraphicsContext.restoreGraphicsState();
            }
            return;
        }
        NSGraphicsContext nSGraphicsContext = NSGraphicsContext.currentContext();
        nSGraphicsContext.saveGraphicsState();
        int n2 = 0;
        NSSize nSSize = null;
        NSSize nSSize2 = null;
        NSAttributedString nSAttributedString = null;
        NSTableHeaderCell nSTableHeaderCell = this.nsColumn.headerCell();
        if (this.displayText != null) {
            object4 = Font.cocoa_new(this.display, nSTableHeaderCell.font());
            nSAttributedString = this.parent.createString(this.displayText, (Font)object4, this.parent.headerForeground, 16384, false, (this.parent.state & 8) == 0, false);
            nSSize = nSAttributedString.size();
            n2 = (int)((double)n2 + Math.ceil(nSSize.width));
            if (this.image != null) {
                n2 += 2;
            }
        }
        if (this.parent.headerBackground != null) {
            nSGraphicsContext.saveGraphicsState();
            object4 = this.parent.headerBackground;
            object3 = NSColor.colorWithDeviceRed((double)object4[0], (double)object4[1], (double)object4[2], 1.0);
            ((NSColor)object3).setFill();
            object2 = new NSRect();
            ((NSRect)object2).x = nSRect2.x;
            ((NSRect)object2).y = nSRect2.y + d;
            ((NSRect)object2).width = nSRect2.width;
            ((NSRect)object2).height = nSRect2.height - d - 0.5;
            NSBezierPath.fillRect((NSRect)object2);
            if (this.parent.headerForeground != null) {
                object4 = this.parent.headerForeground;
                object = NSColor.colorWithDeviceRed((double)object4[0], (double)object4[1], (double)object4[2], 0.6f);
                ((NSColor)object).setStroke();
            }
            object = NSBezierPath.bezierPath();
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = nSRect.x + nSRect.width - 0.5;
            nSPoint.y = nSRect.y + 2.0;
            ((NSBezierPath)object).moveToPoint(nSPoint);
            nSPoint.y += nSRect.y + nSRect.height - 4.0;
            ((NSBezierPath)object).lineToPoint(nSPoint);
            ((NSBezierPath)object).stroke();
            nSGraphicsContext.restoreGraphicsState();
        }
        if (this.image != null) {
            nSSize2 = this.image.handle.size();
            n2 = (int)((double)n2 + Math.ceil(nSSize2.width));
        }
        if (this.parent.sortColumn == this && this.parent.sortDirection != 0) {
            boolean bl;
            boolean bl2 = bl = this.parent.sortDirection == 128;
            if (this.parent.headerBackground != null || this.parent.headerForeground != null) {
                object3 = nSTableHeaderCell.sortIndicatorRectForBounds(nSRect);
                nSGraphicsContext.saveGraphicsState();
                if (this.parent.headerForeground != null) {
                    object2 = this.parent.headerForeground;
                    object = NSColor.colorWithDeviceRed((double)object2[0], (double)object2[1], (double)object2[2], 0.9f);
                    ((NSColor)object).setStroke();
                }
                object2 = NSBezierPath.bezierPath();
                ((NSBezierPath)object2).setLineWidth(1.5);
                object = new NSPoint();
                double d3 = ((NSRect)object3).y + ((NSRect)object3).height / 2.0 - 1.5;
                double d4 = ((NSRect)object3).y + ((NSRect)object3).height / 2.0 + 1.5;
                double d5 = ((NSRect)object3).x;
                double d6 = ((NSRect)object3).x + 3.0;
                double d7 = ((NSRect)object3).x + 6.0;
                if (bl) {
                    ((NSPoint)object).x = d5;
                    ((NSPoint)object).y = d4;
                    ((NSBezierPath)object2).moveToPoint((NSPoint)object);
                    ((NSPoint)object).x = d6;
                    ((NSPoint)object).y = d3;
                    ((NSBezierPath)object2).lineToPoint((NSPoint)object);
                    ((NSPoint)object).x = d7;
                    ((NSPoint)object).y = d4;
                    ((NSBezierPath)object2).lineToPoint((NSPoint)object);
                } else {
                    ((NSPoint)object).x = d5;
                    ((NSPoint)object).y = d3;
                    ((NSBezierPath)object2).moveToPoint((NSPoint)object);
                    ((NSPoint)object).x = d6;
                    ((NSPoint)object).y = d4;
                    ((NSBezierPath)object2).lineToPoint((NSPoint)object);
                    ((NSPoint)object).x = d7;
                    ((NSPoint)object).y = d3;
                    ((NSBezierPath)object2).lineToPoint((NSPoint)object);
                }
                ((NSBezierPath)object2).stroke();
                nSGraphicsContext.restoreGraphicsState();
            } else {
                nSTableHeaderCell.drawSortIndicatorWithFrame(nSRect, new NSView(l3), bl, 0L);
            }
            object3 = nSTableHeaderCell.sortIndicatorRectForBounds(nSRect);
            nSRect.width = Math.max(0.0, ((NSRect)object3).x - nSRect.x);
        }
        int n3 = 0;
        n3 = (this.style & 0x1000000) != 0 ? (int)(nSRect.x + Math.max(2.0, (nSRect.width - (double)n2) / 2.0)) : ((this.style & 0x20000) != 0 ? (int)(nSRect.x + Math.max(2.0, nSRect.width - (double)n2 - 2.0)) : (int)nSRect.x + 2);
        if (this.image != null) {
            object3 = new NSRect();
            ((NSRect)object3).x = n3;
            ((NSRect)object3).y = nSRect.y;
            ((NSRect)object3).width = Math.min(nSSize2.width, nSRect.width - 4.0);
            ((NSRect)object3).height = Math.min(nSSize2.height, nSRect.height);
            boolean bl = new NSView(l3).isFlipped();
            if (bl) {
                nSGraphicsContext.saveGraphicsState();
                object = NSAffineTransform.transform();
                ((NSAffineTransform)object).scaleXBy(1.0, -1.0);
                ((NSAffineTransform)object).translateXBy(0.0, -(((NSRect)object3).height + 2.0 * ((NSRect)object3).y));
                ((NSAffineTransform)object).concat();
            }
            object = new NSRect();
            ((NSRect)object).width = ((NSRect)object3).width;
            ((NSRect)object).height = ((NSRect)object3).height;
            this.image.handle.drawInRect((NSRect)object3, (NSRect)object, 2L, 1.0);
            if (bl) {
                nSGraphicsContext.restoreGraphicsState();
            }
            n3 = (int)((double)n3 + ((NSRect)object3).width);
        }
        if (this.displayText != null && this.displayText.length() > 0) {
            if (this.image != null) {
                n3 += 2;
            }
            object3 = new NSRect();
            ((NSRect)object3).x = n3;
            ((NSRect)object3).y = nSRect.y;
            ((NSRect)object3).width = Math.min(nSSize.width, nSRect.x + nSRect.width - 2.0 - (double)n3);
            ((NSRect)object3).height = Math.min(nSSize.height, nSRect.height);
            nSAttributedString.drawInRect((NSRect)object3);
        }
        if (nSAttributedString != null) {
            nSAttributedString.release();
        }
        nSGraphicsContext.restoreGraphicsState();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.movable;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.nsColumn.resizingMask() != 0L;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        int n = (int)this.nsColumn.width();
        if (n > 0) {
            ++n;
        }
        return n;
    }

    public void pack() {
        Object object;
        this.checkWidget();
        int n = 0;
        NSTableHeaderCell nSTableHeaderCell = this.nsColumn.headerCell();
        NSSize nSSize = nSTableHeaderCell.cellSize();
        n = (int)((double)n + Math.ceil(nSSize.width));
        if (this.image != null) {
            object = this.image.handle.size();
            n = (int)((double)n + (Math.ceil(((NSSize)object).width) + 2.0));
        }
        if (this.parent.sortColumn == this && this.parent.sortDirection != 0) {
            object = nSTableHeaderCell.sortIndicatorRectForBounds(new NSRect());
            n = (int)((double)n + Math.ceil(((NSRect)object).width + 4.0));
        }
        object = new GC(this.parent);
        n = Math.max(n, this.parent.calculateWidth(this.parent.items, this.parent.indexOf(this), (GC)object, true));
        ((Resource)object).dispose();
        this.setWidth(n);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.nsColumn != null) {
            this.nsColumn.headerCell().release();
            this.nsColumn.release();
        }
        this.nsColumn = null;
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.parent.sortColumn == this) {
            this.parent.sortColumn = null;
        }
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((n & 0x1024000) == 0) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1 || n2 == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        NSOutlineView nSOutlineView = (NSOutlineView)this.parent.view;
        NSTableHeaderView nSTableHeaderView = nSOutlineView.headerView();
        if (nSTableHeaderView == null) {
            return;
        }
        n2 = this.parent.indexOf(this.nsColumn);
        NSRect nSRect = nSTableHeaderView.headerRectOfColumn(n2);
        nSTableHeaderView.setNeedsDisplayInRect(nSRect);
        nSRect = nSOutlineView.rectOfColumn(n2);
        this.parent.view.setNeedsDisplayInRect(nSRect);
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        NSTableHeaderView nSTableHeaderView = ((NSOutlineView)this.parent.view).headerView();
        if (nSTableHeaderView == null) {
            return;
        }
        int n = this.parent.indexOf(this.nsColumn);
        NSRect nSRect = nSTableHeaderView.headerRectOfColumn(n);
        nSTableHeaderView.setNeedsDisplayInRect(nSRect);
    }

    public void setMoveable(boolean bl) {
        this.checkWidget();
        this.movable = bl;
    }

    public void setResizable(boolean bl) {
        this.checkWidget();
        this.nsColumn.setResizingMask(bl ? 2L : 0L);
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] cArray = new char[this.text.length()];
        this.text.getChars(0, cArray.length, cArray, 0);
        int n = this.fixMnemonic(cArray);
        this.displayText = new String(cArray, 0, n);
        NSString nSString = NSString.stringWith(this.displayText);
        this.nsColumn.headerCell().setTitle(nSString);
        NSTableHeaderView nSTableHeaderView = ((NSOutlineView)this.parent.view).headerView();
        if (nSTableHeaderView == null) {
            return;
        }
        int n2 = this.parent.indexOf(this.nsColumn);
        NSRect nSRect = nSTableHeaderView.headerRectOfColumn(n2);
        nSTableHeaderView.setNeedsDisplayInRect(nSRect);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this.parent.checkToolTip(this);
    }

    public void setWidth(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        n = Math.max(0, n - 1);
        this.nsColumn.setWidth(n);
    }

    @Override
    String tooltipText() {
        return this.toolTipText;
    }
}

