/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSIndexSet;
import org.eclipse.swt.internal.cocoa.NSMutableIndexSet;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTTableView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    NSTableColumn column;
    String[] items;
    int itemCount;
    boolean ignoreSelect;
    boolean didSelect;
    boolean rowsChanged;
    boolean mouseIsDown;
    static int NEXT_ID;
    static final int CELL_GAP = 1;

    public List(Composite composite, int n) {
        super(composite, List.checkStyle(n));
    }

    @Override
    long accessibilityAttributeValue(long l, long l2, long l3) {
        return super.accessibilityAttributeValue(l, l2, l3);
    }

    @Override
    boolean acceptsFirstResponder(long l, long l2) {
        return true;
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.itemCount == this.items.length) {
            String[] stringArray = new String[this.itemCount + 4];
            System.arraycopy(this.items, 0, stringArray, 0, this.items.length);
            this.items = stringArray;
        }
        this.items[this.itemCount++] = string;
        this.updateRowCount();
        this.setScrollWidth(string);
    }

    public void add(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > n || n > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            String[] stringArray = new String[this.itemCount + 4];
            System.arraycopy(this.items, 0, stringArray, 0, this.items.length);
            this.items = stringArray;
        }
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = string;
        this.updateRowCount();
        if (n != this.itemCount) {
            this.fixSelection(n, true);
        }
        this.setScrollWidth(string);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return List.checkBits(n, 4, 2, 0, 0, 0, 0);
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        if (n == -1) {
            NSCell nSCell = this.column.dataCell();
            Font font = this.font != null ? this.font : this.defaultFont();
            nSCell.setFont(font.handle);
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null) continue;
                nSCell.setTitle(NSString.stringWith(this.items[i]));
                NSSize nSSize = nSCell.cellSize();
                n3 = Math.max(n3, (int)Math.ceil(nSSize.width));
            }
            ++n3;
        } else {
            n3 = n;
        }
        if (n3 <= 0) {
            n3 = 64;
        }
        int n4 = 0;
        if (n2 == -1) {
            int n5 = this.getItemHeight() + 1;
            n4 = this.itemCount * n5;
        } else {
            n4 = n2;
        }
        if (n4 <= 0) {
            n4 = 64;
        }
        Rectangle rectangle = this.computeTrim(0, 0, n3, n4);
        return new Point(rectangle.width, rectangle.height);
    }

    @Override
    void createHandle() {
        NSScrollView nSScrollView = (NSScrollView)new SWTScrollView().alloc();
        nSScrollView.init();
        if ((this.style & 0x100) != 0) {
            nSScrollView.setHasHorizontalScroller(true);
        }
        if ((this.style & 0x200) != 0) {
            nSScrollView.setHasVerticalScroller(true);
        }
        nSScrollView.setAutohidesScrollers(true);
        nSScrollView.setBorderType((this.style & 0x800) != 0 ? 2L : 0L);
        NSTableView nSTableView = (NSTableView)new SWTTableView().alloc();
        nSTableView.init();
        nSTableView.setAllowsMultipleSelection((this.style & 2) != 0);
        nSTableView.setDataSource(nSTableView);
        nSTableView.setHeaderView(null);
        nSTableView.setDelegate(nSTableView);
        if ((this.style & 0x100) != 0) {
            nSTableView.setColumnAutoresizingStyle(0L);
        }
        NSSize nSSize = new NSSize();
        nSSize.height = 1.0;
        nSSize.width = 1.0;
        nSTableView.setIntercellSpacing(nSSize);
        nSTableView.setDoubleAction(OS.sel_sendDoubleSelection);
        if (!this.hasBorder()) {
            nSTableView.setFocusRingType(1L);
        }
        this.column = (NSTableColumn)new NSTableColumn().alloc();
        this.column = this.column.initWithIdentifier(NSString.stringWith(String.valueOf(++NEXT_ID)));
        this.column.setWidth(0.0);
        nSTableView.addTableColumn(this.column);
        this.scrollView = nSScrollView;
        this.view = nSTableView;
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.items = new String[4];
    }

    @Override
    Color defaultBackground() {
        return this.display.getWidgetColor(25);
    }

    @Override
    NSFont defaultNSFont() {
        return this.display.tableViewFont;
    }

    @Override
    Color defaultForeground() {
        return this.display.getWidgetColor(24);
    }

    public void deselect(int n) {
        this.checkWidget();
        if (0 <= n && n < this.itemCount) {
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.deselectRow(n);
            this.ignoreSelect = false;
        }
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (n2 < 0 || n >= this.itemCount) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(this.itemCount - 1, n2);
        if (n == 0 && n2 == this.itemCount - 1) {
            this.deselectAll();
        } else {
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            for (int i = n; i <= n2; ++i) {
                nSTableView.deselectRow(i);
            }
            this.ignoreSelect = false;
        }
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        for (int i = 0; i < nArray.length; ++i) {
            nSTableView.deselectRow(nArray[i]);
        }
        this.ignoreSelect = false;
    }

    public void deselectAll() {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        nSTableView.deselectAll(null);
        this.ignoreSelect = false;
    }

    @Override
    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        NSTableView nSTableView = (NSTableView)this.view;
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = n;
        nSPoint.y = n2;
        long l = nSTableView.rowAtPoint(nSPoint);
        if (l == -1L) {
            return false;
        }
        boolean bl2 = super.dragDetect(n, n2, bl, blArray);
        if (bl2 && !nSTableView.isRowSelected(l)) {
            NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet = nSIndexSet.initWithIndex(l);
            nSTableView.selectRowIndexes(nSIndexSet, false);
            nSIndexSet.release();
        }
        blArray[0] = bl2;
        return bl2;
    }

    @Override
    void drawBackgroundInClipRect(long l, long l2, NSRect nSRect) {
        super.drawViewBackgroundInRect(l, l2, nSRect);
        if (l != this.view.id) {
            return;
        }
        this.fillBackground(this.view, NSGraphicsContext.currentContext(), nSRect, -1);
    }

    void fixSelection(int n, boolean bl) {
        int[] nArray = this.getSelectionIndices();
        if (nArray.length == 0) {
            return;
        }
        int n2 = 0;
        boolean bl2 = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (!bl && nArray[i] == n) {
                bl2 = true;
                continue;
            }
            int n3 = n2++;
            nArray[n3] = nArray[i];
            if (nArray[n3] < n) continue;
            int n4 = n3;
            nArray[n4] = nArray[n4] + (bl ? 1 : -1);
            bl2 = true;
        }
        if (bl2) {
            this.select(nArray, n2, true);
        }
    }

    public int getFocusIndex() {
        this.checkWidget();
        return (int)((NSTableView)this.view).selectedRow();
    }

    public String getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        return (int)((NSTableView)this.view).rowHeight();
    }

    public String[] getItems() {
        this.checkWidget();
        String[] stringArray = new String[this.itemCount];
        System.arraycopy(this.items, 0, stringArray, 0, this.itemCount);
        return stringArray;
    }

    public String[] getSelection() {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        if (nSTableView.numberOfSelectedRows() == 0L) {
            return new String[0];
        }
        NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
        int n = (int)nSIndexSet.count();
        long[] lArray = new long[n];
        nSIndexSet.getIndexes(lArray, n, 0L);
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.items[(int)lArray[i]];
        }
        return stringArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return (int)((NSTableView)this.view).numberOfSelectedRows();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        if (nSTableView.numberOfSelectedRows() == 0L) {
            return -1;
        }
        NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
        int n = (int)nSIndexSet.count();
        long[] lArray = new long[n];
        nSIndexSet.getIndexes(lArray, n, 0L);
        return (int)lArray[0];
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        if (nSTableView.numberOfSelectedRows() == 0L) {
            return new int[0];
        }
        NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
        int n = (int)nSIndexSet.count();
        long[] lArray = new long[n];
        nSIndexSet.getIndexes(lArray, n, 0L);
        int[] nArray = new int[n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)lArray[i];
        }
        return nArray;
    }

    public int getTopIndex() {
        this.checkWidget();
        NSRect nSRect = this.scrollView.documentVisibleRect();
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = nSRect.x;
        nSPoint.y = nSRect.y;
        int n = (int)((NSTableView)this.view).rowAtPoint(nSPoint);
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    public int indexOf(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        for (int i = 0; i < this.itemCount; ++i) {
            if (!this.items[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        for (int i = n; i < this.itemCount; ++i) {
            if (!this.items[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            return false;
        }
        return ((NSTableView)this.view).isRowSelected(n);
    }

    @Override
    long menuForEvent(long l, long l2, long l3) {
        NSPoint nSPoint;
        long l4;
        NSEvent nSEvent = new NSEvent(l3);
        NSTableView nSTableView = (NSTableView)this.view;
        NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
        if (!nSIndexSet.containsIndex(l4 = nSTableView.rowAtPoint(nSPoint = this.view.convertPoint_fromView_(nSEvent.locationInWindow(), null)))) {
            NSIndexSet nSIndexSet2 = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet2 = nSIndexSet2.initWithIndex(l4);
            nSTableView.selectRowIndexes(nSIndexSet2, false);
            nSIndexSet2.release();
        }
        return super.menuForEvent(l, l2, l3);
    }

    @Override
    void mouseDownSuper(long l, long l2, long l3) {
        this.ignoreSelect = false;
        NSTableView nSTableView = (NSTableView)this.view;
        NSEvent nSEvent = new NSEvent(l3);
        NSPoint nSPoint = this.view.convertPoint_fromView_(nSEvent.locationInWindow(), null);
        int n = (int)nSTableView.rowAtPoint(nSPoint);
        if (n != -1 && (nSEvent.modifierFlags() & 0xFFFF0000L) == 0L && nSEvent.clickCount() == 1L && nSTableView.isRowSelected(n) && nSTableView.selectedRowIndexes().count() == 1L && 0 <= n && n < this.itemCount) {
            this.sendSelection();
        }
        this.didSelect = false;
        super.mouseDownSuper(l, l2, l3);
        this.didSelect = false;
    }

    @Override
    boolean needsPanelToBecomeKey(long l, long l2) {
        return false;
    }

    @Override
    long numberOfRowsInTableView(long l, long l2, long l3) {
        return this.itemCount;
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.column != null) {
            this.column.release();
        }
        this.column = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.items = null;
    }

    public void remove(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            this.error(6);
        }
        this.remove(n, true);
    }

    void remove(int n, boolean bl) {
        if (n != this.itemCount - 1) {
            this.fixSelection(n, false);
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        this.updateRowCount();
        if (bl) {
            this.setScrollWidth();
        }
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (0 > n || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        int n3 = n2 - n + 1;
        for (int i = 0; i < n3; ++i) {
            this.remove(n, false);
        }
        this.setScrollWidth();
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n = nArray2[nArray2.length - 1];
        int n2 = nArray2[0];
        int n3 = this.getItemCount();
        if (0 > n || n > n2 || n2 >= n3) {
            this.error(6);
        }
        int n4 = -1;
        for (int i = 0; i < nArray2.length; ++i) {
            int n5 = nArray2[i];
            if (n5 == n4) continue;
            this.remove(n5, false);
            n4 = n5;
        }
        this.setScrollWidth();
    }

    public void removeAll() {
        this.checkWidget();
        this.items = new String[4];
        this.itemCount = 0;
        this.updateRowCount();
        this.setScrollWidth();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int n) {
        this.checkWidget();
        if (0 <= n && n < this.itemCount) {
            NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet = nSIndexSet.initWithIndex(n);
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.selectRowIndexes(nSIndexSet, (this.style & 2) != 0);
            this.ignoreSelect = false;
            nSIndexSet.release();
        }
    }

    public void select(int n, int n2) {
        this.checkWidget();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        if (n == 0 && n2 == this.itemCount - 1) {
            this.selectAll();
        } else {
            n = Math.max(0, n);
            n2 = Math.min(n2, this.itemCount - 1);
            NSRange nSRange = new NSRange();
            nSRange.location = n;
            nSRange.length = n2 - n + 1;
            NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet = nSIndexSet.initWithIndexesInRange(nSRange);
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.selectRowIndexes(nSIndexSet, (this.style & 2) != 0);
            this.ignoreSelect = false;
            nSIndexSet.release();
        }
    }

    public void select(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n = nArray.length) == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        int n2 = 0;
        NSMutableIndexSet nSMutableIndexSet = (NSMutableIndexSet)new NSMutableIndexSet().alloc().init();
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            if (n3 < 0 || n3 >= this.itemCount) continue;
            nSMutableIndexSet.addIndex(nArray[i]);
            ++n2;
        }
        if (n2 > 0) {
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.selectRowIndexes(nSMutableIndexSet, (this.style & 2) != 0);
            this.ignoreSelect = false;
        }
        nSMutableIndexSet.release();
    }

    void select(int[] nArray, int n, boolean bl) {
        NSMutableIndexSet nSMutableIndexSet = (NSMutableIndexSet)new NSMutableIndexSet().alloc().init();
        for (int i = 0; i < n; ++i) {
            nSMutableIndexSet.addIndex(nArray[i]);
        }
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        nSTableView.selectRowIndexes(nSMutableIndexSet, !bl);
        this.ignoreSelect = false;
        nSMutableIndexSet.release();
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        nSTableView.selectAll(null);
        this.ignoreSelect = false;
    }

    @Override
    void sendDoubleSelection() {
        if (((NSTableView)this.view).clickedRow() != -1L) {
            this.sendSelectionEvent(14);
        }
    }

    @Override
    boolean sendKeyEvent(NSEvent nSEvent, int n) {
        boolean bl = super.sendKeyEvent(nSEvent, n);
        if (!bl) {
            return bl;
        }
        if (n != 1) {
            return bl;
        }
        short s = nSEvent.keyCode();
        switch (s) {
            case 36: 
            case 76: {
                this.sendSelectionEvent(14);
            }
        }
        return bl;
    }

    @Override
    boolean sendMouseEvent(NSEvent nSEvent, int n, boolean bl) {
        boolean bl2 = true;
        if (nSEvent != null) {
            long l = nSEvent.type();
            boolean bl3 = bl2 = l == 1L || l == 2L;
        }
        if (bl2) {
            if (n == 3) {
                this.mouseIsDown = true;
            } else if (n == 4 || n == 29) {
                this.mouseIsDown = false;
                if (this.rowsChanged) {
                    this.rowsChanged = false;
                    ((NSTableView)this.view).noteNumberOfRowsChanged();
                }
            }
        }
        return super.sendMouseEvent(nSEvent, n, bl);
    }

    @Override
    void sendSelection() {
        if (this.ignoreSelect) {
            return;
        }
        this.sendSelectionEvent(13);
    }

    @Override
    void setBackgroundColor(NSColor nSColor) {
        ((NSTableView)this.view).setBackgroundColor(nSColor);
    }

    @Override
    void setFont(NSFont nSFont) {
        super.setFont(nSFont);
        double d = nSFont.ascender();
        double d2 = -nSFont.descender() + nSFont.leading();
        ((NSTableView)this.view).setRowHeight((int)Math.ceil(d + d2) + 1);
        this.setScrollWidth();
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > n || n >= this.itemCount) {
            this.error(6);
        }
        this.items[n] = string;
        NSTableView nSTableView = (NSTableView)this.view;
        NSRect nSRect = nSTableView.rectOfRow(n);
        nSTableView.setNeedsDisplayInRect(nSRect);
        this.setScrollWidth(string);
    }

    public void setItems(String ... stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) continue;
            this.error(5);
        }
        this.items = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.items, 0, stringArray.length);
        this.itemCount = stringArray.length;
        ((NSTableView)this.view).reloadData();
        this.setScrollWidth();
    }

    boolean setScrollWidth(String string) {
        if ((this.style & 0x100) == 0) {
            return false;
        }
        NSCell nSCell = this.column.dataCell();
        Font font = this.font != null ? this.font : this.defaultFont();
        nSCell.setFont(font.handle);
        nSCell.setTitle(NSString.stringWith(string));
        NSSize nSSize = nSCell.cellSize();
        double d = this.column.width();
        if (d < nSSize.width) {
            this.column.setWidth(nSSize.width);
            return true;
        }
        return false;
    }

    boolean setScrollWidth() {
        if ((this.style & 0x100) == 0) {
            return false;
        }
        if (this.items == null) {
            return false;
        }
        NSCell nSCell = this.column.dataCell();
        Font font = this.font != null ? this.font : this.defaultFont();
        nSCell.setFont(font.handle);
        double d = 0.0;
        for (int i = 0; i < this.itemCount; ++i) {
            nSCell.setTitle(NSString.stringWith(this.items[i]));
            NSSize nSSize = nSCell.cellSize();
            d = Math.max(d, nSSize.width);
        }
        this.column.setWidth(d);
        return true;
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.deselectAll();
        if (0 <= n && n < this.itemCount) {
            NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet = nSIndexSet.initWithIndex(n);
            NSTableView nSTableView = (NSTableView)this.view;
            this.ignoreSelect = true;
            nSTableView.selectRowIndexes(nSIndexSet, false);
            this.ignoreSelect = false;
            nSIndexSet.release();
            this.showIndex(n);
        }
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.deselectAll();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, this.itemCount - 1);
        NSRange nSRange = new NSRange();
        nSRange.location = n;
        nSRange.length = n2 - n + 1;
        NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
        nSIndexSet = nSIndexSet.initWithIndexesInRange(nSRange);
        NSTableView nSTableView = (NSTableView)this.view;
        this.ignoreSelect = true;
        nSTableView.selectRowIndexes(nSIndexSet, false);
        this.ignoreSelect = false;
        nSIndexSet.release();
        this.showIndex(n2);
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = nArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        int[] nArray2 = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[n - i - 1];
            if (n3 < 0 || n3 >= this.itemCount) continue;
            nArray2[n2++] = n3;
        }
        if (n2 > 0) {
            this.select(nArray2, n2, true);
            this.showIndex(nArray2[0]);
        }
    }

    public void setSelection(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = stringArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        int n2 = 0;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n3;
            String string = stringArray[n - i - 1];
            if ((this.style & 4) != 0) {
                n3 = this.indexOf(string, 0);
                if (n3 == -1) continue;
                n2 = 1;
                nArray = new int[]{n3};
                continue;
            }
            n3 = 0;
            while ((n3 = this.indexOf(string, n3)) != -1) {
                if (n2 == nArray.length) {
                    int[] nArray2 = new int[nArray.length + 4];
                    System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                    nArray = nArray2;
                }
                nArray[n2++] = n3++;
            }
        }
        if (n2 > 0) {
            this.select(nArray, n2, true);
            this.showIndex(nArray[0]);
        }
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        NSTableView nSTableView = (NSTableView)this.view;
        int n2 = Math.max(0, Math.min(n, this.itemCount));
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = this.scrollView.contentView().bounds().x;
        nSPoint.y = nSTableView.frameOfCellAtColumn((long)0L, (long)((long)n2)).y;
        this.view.scrollPoint(nSPoint);
    }

    void showIndex(int n) {
        if (0 <= n && n < this.itemCount) {
            ((NSTableView)this.view).scrollRowToVisible(n);
        }
    }

    public void showSelection() {
        this.checkWidget();
        int n = this.getSelectionIndex();
        if (n >= 0) {
            this.showIndex(n);
        }
    }

    @Override
    void tableViewSelectionDidChange(long l, long l2, long l3) {
        if (this.didSelect) {
            return;
        }
        this.sendSelection();
    }

    @Override
    void tableViewSelectionIsChanging(long l, long l2, long l3) {
        this.didSelect = true;
        this.sendSelection();
    }

    @Override
    long tableView_objectValueForTableColumn_row(long l, long l2, long l3, long l4, long l5) {
        double[] dArray = ((NSTableView)this.view).isRowSelected(l5) ? null : this.foreground;
        NSAttributedString nSAttributedString = this.createString(this.items[(int)l5], null, dArray, 16384, false, this.getEnabled(), false);
        nSAttributedString.autorelease();
        return nSAttributedString.id;
    }

    long tableView_selectionIndexesForProposedSelection(long l, long l2, long l3, long l4) {
        if ((this.style & 4) != 0) {
            NSIndexSet nSIndexSet = new NSIndexSet(l4);
            NSTableView nSTableView = new NSTableView(l3);
            if (nSIndexSet.count() != 1L && nSTableView.selectedRow() != -1L) {
                NSIndexSet nSIndexSet2 = (NSIndexSet)new NSIndexSet().alloc();
                nSIndexSet2 = nSIndexSet2.initWithIndex(nSTableView.selectedRow());
                nSIndexSet2.autorelease();
                return nSIndexSet2.id;
            }
        }
        return l4;
    }

    void updateRowCount() {
        if (this.mouseIsDown) {
            this.rowsChanged = true;
        } else {
            NSTableView nSTableView = (NSTableView)this.view;
            this.setRedraw(false);
            this.ignoreSelect = true;
            nSTableView.noteNumberOfRowsChanged();
            this.ignoreSelect = false;
            nSTableView.tile();
            this.setRedraw(true);
        }
    }
}

