/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.custom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGContext;

public class TGUndoableKeySignature
extends TGUndoableEditBase {
    private int doAction;
    private long position;
    private int redoableKeySignature;
    private int undoableKeySignature;
    private List<Object> nextKeySignaturePositions;
    private boolean toEnd;
    private TGTrack track;

    private TGUndoableKeySignature(TGContext context) {
        super(context);
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.changeKeySignature(actionContext, this.track, this.getMeasureAt(this.track, this.position), this.redoableKeySignature, this.toEnd);
        this.doAction = 1;
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.changeKeySignature(actionContext, this.track, this.getMeasureAt(this.track, this.position), this.undoableKeySignature, this.toEnd);
        if (this.toEnd) {
            for (KeySignaturePosition keySignaturePosition : this.nextKeySignaturePositions) {
                this.changeKeySignature(actionContext, this.track, this.getMeasureAt(this.track, keySignaturePosition.getPosition()), keySignaturePosition.getKeySignature(), true);
            }
        }
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableKeySignature startUndo(TGContext context, TGTrack track, TGMeasure measure) {
        TGUndoableKeySignature undoable = new TGUndoableKeySignature(context);
        undoable.doAction = 1;
        undoable.position = measure.getStart();
        undoable.undoableKeySignature = measure.getKeySignature();
        undoable.track = track;
        undoable.nextKeySignaturePositions = new ArrayList<Object>();
        int prevKeySignature = undoable.undoableKeySignature;
        Iterator it = track.getMeasures();
        while (it.hasNext()) {
            TGMeasure nextMeasure = (TGMeasure)it.next();
            if (nextMeasure.getStart() <= undoable.position) continue;
            int currKeySignature = nextMeasure.getKeySignature();
            if (prevKeySignature != currKeySignature) {
                KeySignaturePosition tsp = new KeySignaturePosition(nextMeasure.getStart(), currKeySignature);
                undoable.nextKeySignaturePositions.add(tsp);
            }
            prevKeySignature = currKeySignature;
        }
        return undoable;
    }

    public TGUndoableKeySignature endUndo(int keySignature, boolean toEnd) {
        this.redoableKeySignature = keySignature;
        this.toEnd = toEnd;
        return this;
    }

    public TGMeasure getMeasureAt(TGTrack track, Long start) {
        return this.getSongManager().getTrackManager().getMeasureAt(track, start.longValue());
    }

    public void changeKeySignature(TGActionContext context, TGTrack track, TGMeasure measure, Integer keySignature, Boolean applyToEnd) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.composition.change-key-signature");
        tgActionProcessor.setAttribute("keySignature", keySignature);
        tgActionProcessor.setAttribute("applyToEnd", applyToEnd);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, measure);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }

    private static class KeySignaturePosition {
        private long position;
        private int keySignature;

        public KeySignaturePosition(long position, int keySignature) {
            this.position = position;
            this.keySignature = keySignature;
        }

        public long getPosition() {
            return this.position;
        }

        public int getKeySignature() {
            return this.keySignature;
        }
    }
}

